require_relative 'boot'

require "rails"
# Pick the frameworks you want:
require "active_model/railtie"
require "active_job/railtie"
require "active_record/railtie"
require "active_storage/engine"
require "action_controller/railtie"
require "action_mailer/railtie"
require "action_mailbox/engine"
require "action_text/engine"
require "action_view/railtie"
require "action_cable/engine"
# require "sprockets/railtie"
require "rails/test_unit/railtie"

# Require the gems listed in Gemfile, including any gems
# you've limited to :test, :development, or :production.
Bundler.require(*Rails.groups)

module App
  class Application < Rails::Application
    # Initialize configuration defaults for originally generated Rails version.
    config.load_defaults 6.0
    
    # Settings in config/environments/* take precedence over those specified here.
    # Application configuration can go into files in config/initializers
    # -- all .rb files in that directory are automatically loaded after loading
    # the framework and any gems in your application.
    
    # Only loads a smaller set of middleware suitable for API only apps.
    # Middleware like session, flash, cookies can be added back manually.
    # Skip views, helpers and assets when generating a new resource.
    
    # config.action_dispatch.default_headers = {
    #   'Access-Control-Allow-Credentials' => 'true',
    #   'Access-Control-Allow-Origin' => '*',
    #   'Access-Control-Request-Method' => '*'
    # }
    
    # rack-corsここから
    config.middleware.insert_before 0, Rack::Cors do
      allow do
        # 許可するドメイン
        # origins "localhost:3000", "example.com"
        origins "*"
        # 許可するヘッダとメソッドの種類
        resource "*",
                 headers: :any,
                 expose: ['access-token', 'uid', 'client'],
                 methods: [:get, :post, :patch, :delete, :head, :options]
      end
    end
    # ここまでrack-cors
    config.api_only = true
  end
end
