/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.model.PAPX;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.sprm.CharacterSprmCompressor;
import org.apache.poi.hwpf.sprm.ParagraphSprmCompressor;
import org.apache.poi.hwpf.sprm.SprmBuffer;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.ListEntry;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.hwpf.usermodel.Section;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableProperties;
import org.apache.poi.util.LittleEndian;

public class Range {
    public static final int TYPE_PARAGRAPH = 0;
    public static final int TYPE_CHARACTER = 1;
    public static final int TYPE_SECTION = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_LISTENTRY = 4;
    public static final int TYPE_TABLE = 5;
    public static final int TYPE_UNDEFINED = 6;
    private WeakReference _parent;
    protected int _start;
    protected int _end;
    protected HWPFDocument _doc;
    boolean _sectionRangeFound;
    protected List _sections;
    protected int _sectionStart;
    protected int _sectionEnd;
    protected boolean _parRangeFound;
    protected List _paragraphs;
    protected int _parStart;
    protected int _parEnd;
    protected boolean _charRangeFound;
    protected List _characters;
    protected int _charStart;
    protected int _charEnd;
    protected boolean _textRangeFound;
    protected List _text;
    protected int _textStart;
    protected int _textEnd;

    public Range(int start, int end, HWPFDocument doc) {
        this._start = start;
        this._end = end;
        this._doc = doc;
        this._sections = this._doc.getSectionTable().getSections();
        this._paragraphs = this._doc.getParagraphTable().getParagraphs();
        this._characters = this._doc.getCharacterTable().getTextRuns();
        this._text = this._doc.getTextTable().getTextPieces();
        this._parent = new WeakReference<Object>(null);
    }

    protected Range(int start, int end, Range parent) {
        this._start = start;
        this._end = end;
        this._doc = parent._doc;
        this._sections = parent._sections;
        this._paragraphs = parent._paragraphs;
        this._characters = parent._characters;
        this._text = parent._text;
        this._parent = new WeakReference<Range>(parent);
    }

    protected Range(int startIdx, int endIdx, int idxType, Range parent) {
        this._doc = parent._doc;
        this._sections = parent._sections;
        this._paragraphs = parent._paragraphs;
        this._characters = parent._characters;
        this._text = parent._text;
        this._parent = new WeakReference<Range>(parent);
        switch (idxType) {
            case 0: {
                this._parStart = parent._parStart + startIdx;
                this._parEnd = parent._parStart + endIdx;
                this._start = ((PropertyNode)this._paragraphs.get(this._parStart)).getStart();
                this._end = ((PropertyNode)this._paragraphs.get(this._parEnd)).getEnd();
                this._parRangeFound = true;
                break;
            }
            case 1: {
                this._charStart = parent._charStart + startIdx;
                this._charEnd = parent._charStart + endIdx;
                this._start = ((PropertyNode)this._characters.get(this._charStart)).getStart();
                this._end = ((PropertyNode)this._characters.get(this._charEnd)).getEnd();
                this._charRangeFound = true;
                break;
            }
            case 2: {
                this._sectionStart = parent._sectionStart + startIdx;
                this._sectionEnd = parent._sectionStart + endIdx;
                this._start = ((PropertyNode)this._sections.get(this._sectionStart)).getStart();
                this._end = ((PropertyNode)this._sections.get(this._sectionEnd)).getEnd();
                this._sectionRangeFound = true;
                break;
            }
            case 3: {
                this._textStart = parent._textStart + startIdx;
                this._textEnd = parent._textStart + endIdx;
                this._start = ((PropertyNode)this._text.get(this._textStart)).getStart();
                this._end = ((PropertyNode)this._text.get(this._textEnd)).getEnd();
                this._textRangeFound = true;
            }
        }
    }

    public String text() {
        this.initText();
        StringBuffer sb = new StringBuffer();
        for (int x = this._textStart; x < this._textEnd; ++x) {
            int end;
            TextPiece piece = (TextPiece)this._text.get(x);
            int start = this._start > piece.getStart() ? this._start - piece.getStart() : 0;
            int n = end = this._end <= piece.getEnd() ? this._end - piece.getStart() : piece.getEnd() - piece.getStart();
            if (piece.usesUnicode()) {
                start /= 2;
                end /= 2;
            }
            sb.append(piece.getStringBuffer().substring(start, end));
        }
        return sb.toString();
    }

    public int numSections() {
        this.initSections();
        return this._sectionEnd - this._sectionStart;
    }

    public int numParagraphs() {
        this.initParagraphs();
        return this._parEnd - this._parStart;
    }

    public int numCharacterRuns() {
        this.initCharacterRuns();
        return this._charEnd - this._charStart;
    }

    public CharacterRun insertBefore(String text) {
        this.initAll();
        TextPiece tp = (TextPiece)this._text.get(this._textStart);
        StringBuffer sb = tp.getStringBuffer();
        int insertIndex = this._start - tp.getStart();
        sb.insert(insertIndex, text);
        int adjustedLength = this._doc.getTextTable().adjustForInsert(this._textStart, text.length());
        this._doc.getCharacterTable().adjustForInsert(this._charStart, adjustedLength);
        this._doc.getParagraphTable().adjustForInsert(this._parStart, adjustedLength);
        this._doc.getSectionTable().adjustForInsert(this._sectionStart, adjustedLength);
        this.adjustForInsert(text.length());
        return this.getCharacterRun(0);
    }

    public CharacterRun insertAfter(String text) {
        this.initAll();
        int listIndex = this._textEnd - 1;
        TextPiece tp = (TextPiece)this._text.get(listIndex);
        StringBuffer sb = tp.getStringBuffer();
        int insertIndex = this._end - tp.getStart();
        if (tp.getStringBuffer().charAt(this._end - 1) == '\r' && text.charAt(0) != '\u0007') {
            --insertIndex;
        }
        sb.insert(insertIndex, text);
        int adjustedLength = this._doc.getTextTable().adjustForInsert(listIndex, text.length());
        this._doc.getCharacterTable().adjustForInsert(this._charEnd - 1, adjustedLength);
        this._doc.getParagraphTable().adjustForInsert(this._parEnd - 1, adjustedLength);
        this._doc.getSectionTable().adjustForInsert(this._sectionEnd - 1, adjustedLength);
        this.adjustForInsert(text.length());
        return this.getCharacterRun(this.numCharacterRuns() - 1);
    }

    public CharacterRun insertBefore(String text, CharacterProperties props) {
        this.initAll();
        PAPX papx = (PAPX)this._paragraphs.get(this._parStart);
        short istd = papx.getIstd();
        StyleSheet ss = this._doc.getStyleSheet();
        CharacterProperties baseStyle = ss.getCharacterStyle(istd);
        byte[] grpprl = CharacterSprmCompressor.compressCharacterProperty(props, baseStyle);
        SprmBuffer buf = new SprmBuffer(grpprl);
        this._doc.getCharacterTable().insert(this._charStart, this._start, buf);
        return this.insertBefore(text);
    }

    public CharacterRun insertAfter(String text, CharacterProperties props) {
        this.initAll();
        PAPX papx = (PAPX)this._paragraphs.get(this._parEnd - 1);
        short istd = papx.getIstd();
        StyleSheet ss = this._doc.getStyleSheet();
        CharacterProperties baseStyle = ss.getCharacterStyle(istd);
        byte[] grpprl = CharacterSprmCompressor.compressCharacterProperty(props, baseStyle);
        SprmBuffer buf = new SprmBuffer(grpprl);
        this._doc.getCharacterTable().insert(this._charEnd, this._end, buf);
        ++this._charEnd;
        return this.insertAfter(text);
    }

    public Paragraph insertBefore(ParagraphProperties props, int styleIndex) {
        return this.insertBefore(props, styleIndex, "\r");
    }

    protected Paragraph insertBefore(ParagraphProperties props, int styleIndex, String text) {
        this.initAll();
        StyleSheet ss = this._doc.getStyleSheet();
        ParagraphProperties baseStyle = ss.getParagraphStyle(styleIndex);
        CharacterProperties baseChp = ss.getCharacterStyle(styleIndex);
        byte[] grpprl = ParagraphSprmCompressor.compressParagraphProperty(props, baseStyle);
        byte[] withIndex = new byte[grpprl.length + 2];
        LittleEndian.putShort(withIndex, (short)styleIndex);
        System.arraycopy(grpprl, 0, withIndex, 2, grpprl.length);
        SprmBuffer buf = new SprmBuffer(withIndex);
        this._doc.getParagraphTable().insert(this._parStart, this._start, buf);
        this.insertBefore(text, baseChp);
        return this.getParagraph(0);
    }

    public Paragraph insertAfter(ParagraphProperties props, int styleIndex) {
        return this.insertAfter(props, styleIndex, "\r");
    }

    protected Paragraph insertAfter(ParagraphProperties props, int styleIndex, String text) {
        this.initAll();
        StyleSheet ss = this._doc.getStyleSheet();
        ParagraphProperties baseStyle = ss.getParagraphStyle(styleIndex);
        CharacterProperties baseChp = ss.getCharacterStyle(styleIndex);
        byte[] grpprl = ParagraphSprmCompressor.compressParagraphProperty(props, baseStyle);
        byte[] withIndex = new byte[grpprl.length + 2];
        LittleEndian.putShort(withIndex, (short)styleIndex);
        System.arraycopy(grpprl, 0, withIndex, 2, grpprl.length);
        SprmBuffer buf = new SprmBuffer(withIndex);
        this._doc.getParagraphTable().insert(this._parEnd, this._end, buf);
        ++this._parEnd;
        this.insertAfter(text, baseChp);
        return this.getParagraph(this.numParagraphs() - 1);
    }

    public void delete() {
        int x;
        this.initAll();
        int numSections = this._sections.size();
        int numRuns = this._characters.size();
        int numParagraphs = this._paragraphs.size();
        for (x = this._charStart; x < numRuns; ++x) {
            CHPX chpx = (CHPX)this._characters.get(x);
            chpx.adjustForDelete(this._start, this._end - this._start);
        }
        for (x = this._parStart; x < numParagraphs; ++x) {
            PAPX papx = (PAPX)this._paragraphs.get(x);
            papx.adjustForDelete(this._start, this._end - this._start);
        }
        for (x = this._sectionStart; x < numSections; ++x) {
            SEPX sepx = (SEPX)this._sections.get(x);
            sepx.adjustForDelete(this._start, this._end - this._start);
        }
    }

    public Table insertBefore(TableProperties props, int rows) {
        ParagraphProperties parProps = new ParagraphProperties();
        parProps.setFInTable((byte)1);
        parProps.setTableLevel((byte)1);
        int columns = props.getItcMac();
        for (int x = 0; x < rows; ++x) {
            Paragraph cell = this.insertBefore(parProps, 4095);
            cell.insertAfter(String.valueOf('\u0007'));
            for (int y = 1; y < columns; ++y) {
                cell = cell.insertAfter(parProps, 4095);
                cell.insertAfter(String.valueOf('\u0007'));
            }
            cell = cell.insertAfter(parProps, 4095, String.valueOf('\u0007'));
            cell.setTableRowEnd(props);
        }
        return new Table(this._start, this._start + rows * (columns + 1), this, 1);
    }

    public ListEntry insertBefore(ParagraphProperties props, int listID, int level, int styleIndex) {
        ListTables lt = this._doc.getListTables();
        if (lt.getLevel(listID, level) == null) {
            throw new NoSuchElementException("The specified list and level do not exist");
        }
        int ilfo = lt.getOverrideIndexFromListID(listID);
        props.setIlfo(ilfo);
        props.setIlvl((byte)level);
        return (ListEntry)this.insertBefore(props, styleIndex);
    }

    public ListEntry insertAfter(ParagraphProperties props, int listID, int level, int styleIndex) {
        ListTables lt = this._doc.getListTables();
        if (lt.getLevel(listID, level) == null) {
            throw new NoSuchElementException("The specified list and level do not exist");
        }
        int ilfo = lt.getOverrideIndexFromListID(listID);
        props.setIlfo(ilfo);
        props.setIlvl((byte)level);
        return (ListEntry)this.insertAfter(props, styleIndex);
    }

    public CharacterRun getCharacterRun(int index) {
        this.initCharacterRuns();
        CHPX chpx = (CHPX)this._characters.get(index + this._charStart);
        int[] point = this.findRange(this._paragraphs, this._parStart, Math.max(chpx.getStart(), this._start), chpx.getEnd());
        PAPX papx = (PAPX)this._paragraphs.get(point[0]);
        short istd = papx.getIstd();
        CharacterRun chp = new CharacterRun(chpx, this._doc.getStyleSheet(), istd, this);
        return chp;
    }

    public Section getSection(int index) {
        this.initSections();
        SEPX sepx = (SEPX)this._sections.get(index + this._sectionStart);
        Section sep = new Section(sepx, this);
        return sep;
    }

    public Paragraph getParagraph(int index) {
        this.initParagraphs();
        PAPX papx = (PAPX)this._paragraphs.get(index + this._parStart);
        ParagraphProperties props = papx.getParagraphProperties(this._doc.getStyleSheet());
        Paragraph pap = null;
        pap = props.getIlfo() > 0 ? new ListEntry(papx, this, this._doc.getListTables()) : new Paragraph(papx, this);
        return pap;
    }

    public int type() {
        return 6;
    }

    public Table getTable(Paragraph paragraph) {
        int tableEnd;
        if (!paragraph.isInTable()) {
            throw new IllegalArgumentException("This paragraph doesn't belong to a table");
        }
        Paragraph r = paragraph;
        if (r._parent.get() != this) {
            throw new IllegalArgumentException("This paragraph is not a child of this range");
        }
        r.initAll();
        if (r._parStart != 0 && this.getParagraph(r._parStart - 1).isInTable() && this.getParagraph((int)(r._parStart - 1))._sectionEnd >= r._sectionStart) {
            throw new IllegalArgumentException("This paragraph is not the first one in the table");
        }
        int limit = this._paragraphs.size();
        for (tableEnd = r._parEnd; tableEnd < limit && this.getParagraph(tableEnd).isInTable(); ++tableEnd) {
        }
        this.initAll();
        if (tableEnd > this._parEnd) {
            throw new ArrayIndexOutOfBoundsException("The table's bounds fall outside of this Range");
        }
        return new Table(r._parStart, tableEnd, r._doc.getRange(), paragraph.getTableLevel());
    }

    protected void initAll() {
        this.initText();
        this.initCharacterRuns();
        this.initParagraphs();
        this.initSections();
    }

    private void initParagraphs() {
        if (!this._parRangeFound) {
            int[] point = this.findRange(this._paragraphs, this._parStart, this._start, this._end);
            this._parStart = point[0];
            this._parEnd = point[1];
            this._parRangeFound = true;
        }
    }

    private void initCharacterRuns() {
        if (!this._charRangeFound) {
            int[] point = this.findRange(this._characters, this._charStart, this._start, this._end);
            this._charStart = point[0];
            this._charEnd = point[1];
            this._charRangeFound = true;
        }
    }

    private void initText() {
        if (!this._textRangeFound) {
            int[] point = this.findRange(this._text, this._textStart, this._start, this._end);
            this._textStart = point[0];
            this._textEnd = point[1];
            this._textRangeFound = true;
        }
    }

    private void initSections() {
        if (!this._sectionRangeFound) {
            int[] point = this.findRange(this._sections, this._sectionStart, this._start, this._end);
            this._sectionStart = point[0];
            this._sectionEnd = point[1];
            this._sectionRangeFound = true;
        }
    }

    private int[] findRange(List rpl, int min, int start, int end) {
        int x = min;
        PropertyNode node = (PropertyNode)rpl.get(x);
        while (node.getEnd() <= start && x < rpl.size() - 1) {
            node = (PropertyNode)rpl.get(++x);
        }
        int y = x;
        node = (PropertyNode)rpl.get(y);
        while (node.getEnd() < end && y < rpl.size() - 1) {
            node = (PropertyNode)rpl.get(++y);
        }
        return new int[]{x, y + 1};
    }

    private void reset() {
        this._textRangeFound = false;
        this._charRangeFound = false;
        this._parRangeFound = false;
        this._sectionRangeFound = false;
    }

    private void adjustForInsert(int length) {
        this._end += length;
        this.reset();
        Range parent = (Range)this._parent.get();
        if (parent != null) {
            parent.adjustForInsert(length);
        }
    }
}

