/*
 * Decompiled with CFR 0.152.
 */
package bufferselector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.Log;

public class BufferSelector
extends JPanel
implements EBComponent {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    private static Hashtable bufferSelectors = new Hashtable();
    private static final Insets MARGIN = new Insets(0, 0, 0, 0);
    private static boolean defaultEnabled;
    private static int location;
    private static int minWidth;
    private static int maxWidth;
    private static int hgap;
    private static int vgap;
    private View view;
    private Docker topDocker;
    private Docker bottomDocker;
    private ComponentListener viewResizeHandler;
    private FocusListener textAreaFocusHandler;
    private ActionListener actionHandler;

    private BufferSelector(View view) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), BorderFactory.createLoweredBevelBorder()), BorderFactory.createEmptyBorder(2, 2, 1, 2)));
        this.topDocker = new ViewDocker(0, 50);
        this.bottomDocker = new ViewDocker(1, -150);
        this.view = view;
        this.viewResizeHandler = new ViewResizeHandler();
        this.textAreaFocusHandler = new TextAreaFocusHandler();
        this.actionHandler = new ActionHandler();
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof BufferUpdate) {
            BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
            if (bufferUpdate.getWhat() == BufferUpdate.CREATED || bufferUpdate.getWhat() == BufferUpdate.CLOSED || bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED) {
                this.update();
                this.view.invalidate();
                this.view.validate();
                this.view.repaint();
            }
        } else if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            View view = ((EditPane)editPaneUpdate.getSource()).getView();
            Log.log((int)1, (Object)this, (Object)("***** EditPaneUpdate " + view));
            if (view == this.view) {
                if (editPaneUpdate.getWhat() == EditPaneUpdate.CREATED) {
                    editPaneUpdate.getEditPane().getTextArea().addFocusListener(this.textAreaFocusHandler);
                    this.view.repaint();
                } else if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
                    editPaneUpdate.getEditPane().getTextArea().removeFocusListener(this.textAreaFocusHandler);
                    this.view.repaint();
                } else if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
                    this.bufferChanged();
                    this.update();
                    this.view.invalidate();
                    this.view.validate();
                    this.view.repaint();
                } else if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFERSET_CHANGED) {
                    this.update();
                    this.view.invalidate();
                    this.view.validate();
                    this.view.repaint();
                }
            }
        }
    }

    public void update() {
        int n;
        int n2;
        Buffer[] bufferArray = this.view.getEditPane().getBufferSet().getAllBuffers();
        int n3 = bufferArray.length;
        int n4 = this.view.getSize().width / maxWidth;
        if (n4 == 0) {
            n4 = 1;
        }
        if ((n2 = this.view.getSize().width / minWidth) == 0) {
            n2 = 1;
        }
        if (this.getLayout() == null || !(this.getLayout() instanceof GridLayout)) {
            this.setLayout(new GridLayout(0, n4, hgap, vgap));
        }
        GridLayout gridLayout = (GridLayout)this.getLayout();
        gridLayout.setRows(0);
        if (n3 < n4) {
            gridLayout.setColumns(n4);
        } else if (n3 >= n4 && n3 <= n2) {
            gridLayout.setColumns(n3);
        } else if (n3 > n2) {
            n = n3 / n2 + (n3 % n2 == 0 ? 0 : 1);
            int n5 = n3 / n + (n3 % n == 0 ? 0 : 1);
            if (n5 < n4) {
                n5 = n4;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            gridLayout.setColumns(n5);
        }
        gridLayout.setHgap(hgap);
        gridLayout.setVgap(vgap);
        n = Integer.parseInt(jEdit.getProperty((String)"buffer-selector.font-size"));
        this.removeAllButtons();
        ButtonGroup buttonGroup = new ButtonGroup();
        Font font = null;
        for (int i = 0; i < n3; ++i) {
            Object object;
            Buffer buffer = bufferArray[i];
            String string = buffer.getName();
            JToggleButton jToggleButton = new JToggleButton(string){

                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    if (location == 0) {
                        return new Point(0, this.getHeight() + 1);
                    }
                    JToolTip jToolTip = this.createToolTip();
                    jToolTip.setTipText(this.getToolTipText());
                    int n = jToolTip.getPreferredSize().height;
                    return new Point(0, -n - 1);
                }
            };
            jToggleButton.setMargin(MARGIN);
            jToggleButton.setHorizontalAlignment(2);
            if (font == null) {
                object = jToggleButton.getFont();
                font = new Font(((Font)object).getName(), 0, n);
            }
            jToggleButton.setFont(font);
            if (buffer.isReadOnly()) {
                jToggleButton.setForeground(Color.gray);
            }
            object = buffer.getPath();
            jToggleButton.setToolTipText((String)object);
            Icon icon = buffer.getIcon();
            jToggleButton.setIcon(icon);
            if (this.view.getBuffer() == buffer) {
                jToggleButton.setSelected(true);
                jToggleButton.setFont(new Font(font.getName(), 1, n));
            }
            buttonGroup.add(jToggleButton);
            jToggleButton.setActionCommand(buffer.getPath());
            jToggleButton.addActionListener(this.actionHandler);
            this.add(jToggleButton);
        }
    }

    public void bufferChanged() {
        this.bufferChanged(this.view.getBuffer());
    }

    public void bufferChanged(Buffer buffer) {
        Component[] componentArray = this.getComponents();
        Font font = null;
        int n = Integer.parseInt(jEdit.getProperty((String)"buffer-selector.font-size"));
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)componentArray[i];
            if (font == null) {
                Font font2 = abstractButton.getFont();
                font = new Font(font2.getName(), 0, n);
            }
            if (abstractButton.getActionCommand().equals(buffer.getPath())) {
                abstractButton.setSelected(true);
                abstractButton.setFont(new Font(font.getName(), 1, n));
                continue;
            }
            abstractButton.setFont(font);
        }
    }

    private void removeAllButtons() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            ((AbstractButton)componentArray[i]).removeActionListener(this.actionHandler);
        }
        this.removeAll();
    }

    private void addHandlers() {
        this.view.addComponentListener(this.viewResizeHandler);
        EditPane[] editPaneArray = this.view.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            editPaneArray[i].getTextArea().addFocusListener(this.textAreaFocusHandler);
        }
    }

    private void removeHandlers() {
        this.view.removeComponentListener(this.viewResizeHandler);
        EditPane[] editPaneArray = this.view.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            editPaneArray[i].getTextArea().removeFocusListener(this.textAreaFocusHandler);
        }
    }

    public static boolean isEnabledFor(View view) {
        return bufferSelectors.get(view) != null;
    }

    public static void addTo(View view) {
        BufferSelector bufferSelector = new BufferSelector(view);
        bufferSelector.removeHandlers();
        bufferSelector.addHandlers();
        EditBus.addToBus((EBComponent)bufferSelector);
        bufferSelectors.put(view, bufferSelector);
        if (location == 0) {
            bufferSelector.topDocker.add();
        } else {
            bufferSelector.bottomDocker.add();
        }
        bufferSelector.update();
        view.invalidate();
        view.validate();
        view.repaint();
    }

    public static void removeFrom(View view) {
        BufferSelector bufferSelector = (BufferSelector)bufferSelectors.get(view);
        if (bufferSelector != null) {
            Container container = view.getContentPane();
            if (bufferSelector.bottomDocker.isVisible()) {
                bufferSelector.bottomDocker.remove();
            }
            if (bufferSelector.topDocker.isVisible()) {
                bufferSelector.topDocker.remove();
            }
            bufferSelector.removeHandlers();
            EditBus.removeFromBus((EBComponent)bufferSelector);
            bufferSelectors.remove(view);
            view.invalidate();
            view.validate();
            view.repaint();
        }
    }

    public static void toggleFor(View view) {
        if (BufferSelector.isEnabledFor(view)) {
            BufferSelector.removeFrom(view);
        } else {
            BufferSelector.addTo(view);
        }
    }

    public static void propertiesChanged() {
        int n = location;
        BufferSelector.getProperties();
        View[] viewArray = jEdit.getViews();
        for (int i = 0; i < viewArray.length; ++i) {
            if (BufferSelector.isEnabledFor(viewArray[i])) {
                if (!defaultEnabled) {
                    BufferSelector.removeFrom(viewArray[i]);
                    continue;
                }
                if (n == location) continue;
                BufferSelector.removeFrom(viewArray[i]);
                BufferSelector.addTo(viewArray[i]);
                continue;
            }
            if (!defaultEnabled) continue;
            BufferSelector.addTo(viewArray[i]);
        }
        Enumeration enumeration = bufferSelectors.elements();
        while (enumeration.hasMoreElements()) {
            BufferSelector bufferSelector = (BufferSelector)enumeration.nextElement();
            bufferSelector.update();
        }
    }

    private static void getProperties() {
        defaultEnabled = jEdit.getBooleanProperty((String)"buffer-selector.default-enabled", (boolean)false);
        location = jEdit.getIntegerProperty((String)"buffer-selector.location", (int)1);
        minWidth = Integer.parseInt(jEdit.getProperty((String)"buffer-selector.min-width"));
        maxWidth = Integer.parseInt(jEdit.getProperty((String)"buffer-selector.max-width"));
        hgap = Integer.parseInt(jEdit.getProperty((String)"button.hgap"));
        vgap = Integer.parseInt(jEdit.getProperty((String)"button.vgap"));
    }

    static {
        BufferSelector.getProperties();
    }

    private class ViewDocker
    implements Docker {
        private boolean visible = false;
        private int group = 1;
        private int layer = -150;

        public ViewDocker(int n, int n2) {
            this.group = n;
            this.layer = n2;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void add() {
            this.visible = true;
            BufferSelector.this.view.addToolBar(this.group, this.layer, (Component)BufferSelector.this);
        }

        public void remove() {
            BufferSelector.this.view.removeToolBar((Component)BufferSelector.this);
            this.visible = false;
        }
    }

    private static interface Docker {
        public boolean isVisible();

        public void add();

        public void remove();
    }

    private class TextAreaFocusHandler
    extends FocusAdapter {
        private TextAreaFocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = (Component)focusEvent.getSource();
            while (!(component instanceof EditPane)) {
                if (component == null) {
                    return;
                }
                component = component.getParent();
            }
            BufferSelector.this.update();
            BufferSelector.this.bufferChanged(((EditPane)component).getBuffer());
            BufferSelector.this.view.invalidate();
            BufferSelector.this.view.validate();
            BufferSelector.this.view.repaint();
        }
    }

    private class ViewResizeHandler
    extends ComponentAdapter {
        private ViewResizeHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            BufferSelector.this.update();
            BufferSelector.this.view.invalidate();
            BufferSelector.this.view.validate();
            BufferSelector.this.view.repaint();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BufferSelector.this.view.setBuffer(jEdit.getBuffer((String)actionEvent.getActionCommand()));
        }
    }
}

