/*
 * Decompiled with CFR 0.152.
 */
package com.bitart.codebrowser;

import com.bitart.codebrowser.CBType;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.tree.TreeNode;

public class CBLeaf
implements TreeNode,
Comparable {
    CBType parent;
    String name;
    String pattern;
    String toolTipText;
    String desc;

    public CBLeaf(CBType cBType, Hashtable hashtable) {
        this.parent = cBType;
        this.name = (String)hashtable.get("cb_tag_cb");
        this.toolTipText = this.pattern = (String)hashtable.get("cb_pattern_cb");
        this.pattern = this.escape(this.pattern.substring(1, this.pattern.length() - 1));
        if (this.pattern.charAt(0) == '^') {
            this.pattern = this.pattern.substring(1);
        }
        if (this.pattern.charAt(this.pattern.length() - 1) == '$') {
            this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
        }
        this.pattern = this.pattern.trim();
        this.toolTipText = this.toolTipText.substring(1, this.toolTipText.length() - 1);
        if (this.toolTipText.startsWith("^")) {
            this.toolTipText = this.toolTipText.substring(1);
        }
        if (this.toolTipText.endsWith("$")) {
            this.toolTipText = this.toolTipText.substring(0, this.toolTipText.length() - 1);
        }
        this.toolTipText = this.toolTipText.trim();
        this.desc = this.name;
        String string = (String)hashtable.get("signature");
        if (string != null && string.length() > 0) {
            this.desc = this.name + string;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.desc;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(i == 0 && c == '^' || i == n - 1 && c == '$' || c == ' ' || c == ';' || c == '_' || c == '\\' || c == '/' || c == '<' || c == '>' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((CBLeaf)object).getName());
    }

    public Enumeration children() {
        return null;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public int getIndex(TreeNode treeNode) {
        return 0;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return true;
    }
}

