/*
 * Decompiled with CFR 0.152.
 */
package com.bitart.codebrowser;

import com.bitart.codebrowser.CBLeaf;
import com.bitart.codebrowser.CBListCellRenderer;
import com.bitart.codebrowser.CBRoot;
import com.bitart.codebrowser.CBType;
import com.bitart.codebrowser.ParserHistory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.UserKey;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.CaretChanging;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class CodeBrowser
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    public static boolean DEBUG = false;
    View currentView;
    Buffer currentBuffer;
    JEditTextArea currentTextArea;
    static Font cellFont = null;
    static Font leafFont = null;
    JTree tree = null;
    CBRoot root = null;
    Object previousNode = null;
    JList bufferList = null;
    JSplitPane splitPane;
    private JButton parseManualButton;
    private JCheckBoxMenuItem autoParseMenuItem;
    private boolean chkThread = false;
    private int repeatCount = 0;

    public CodeBrowser(View view, Buffer buffer, String string) {
        this.currentView = view;
        this.currentBuffer = buffer;
        this.buildTree();
        this.buildBufferList();
        JScrollPane jScrollPane = new JScrollPane(this.bufferList);
        Dimension dimension = new Dimension(20, 0);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.tree), "Center");
        this.parseManualButton = new JButton("Parse");
        this.parseManualButton.setMargin(new Insets(2, 2, 2, 2));
        if (OperatingSystem.isMacOSLF()) {
            this.parseManualButton.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.parseManualButton.setToolTipText("manual parse: parse current buffer once");
        this.parseManualButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeBrowser.this.doParse(CodeBrowser.this.currentView.getBuffer(), true);
                CodeBrowser.this.currentTextArea.grabFocus();
            }
        });
        this.parseManualButton.setEnabled(!jEdit.getBooleanProperty((String)"codebrowser.parse_automatic"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(0, 0, 2, 0));
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.parseManualButton, "West");
        jPanel2.add((Component)new OptionsMenuButton(), "East");
        jPanel.add((Component)jPanel2, "North");
        this.splitPane = new JSplitPane(0, jScrollPane, jPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(jEdit.getIntegerProperty((String)"codebrowser.divider_location", (int)150));
        this.splitPane.setLastDividerLocation(jEdit.getIntegerProperty((String)"codebrowser.last_divider_location", (int)150));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                CodeBrowser.this.doParse(CodeBrowser.this.currentBuffer);
            }

            public void componentShown(ComponentEvent componentEvent) {
                CodeBrowser.this.doParse(CodeBrowser.this.currentBuffer);
            }
        });
        this.doParse(buffer, true);
        this.currentTextArea = view.getTextArea();
    }

    void buildTree() {
        if (this.tree != null) {
            return;
        }
        this.tree = new JTree();
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (cellFont == null) {
                    Font font = component.getFont();
                    if (font == null) {
                        font = jTree.getFont();
                    }
                    cellFont = font.deriveFont(3);
                }
                component.setFont(bl3 ? leafFont : cellFont);
                if (object instanceof CBLeaf) {
                    this.setToolTipText(((CBLeaf)object).getToolTipText());
                }
                return component;
            }
        };
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        this.tree.setRootVisible(false);
        this.tree.setScrollsOnExpand(true);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseHandler());
        this.tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ClassLoader.getSystemResource("org/gjt/sp/jedit/gui/UserKey.class") != null) {
                    UserKey.consume((KeyEvent)keyEvent, (int)0, (int)0, (int)0, (int)0, (boolean)true);
                    if (keyEvent.isConsumed()) {
                        return;
                    }
                }
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        CodeBrowser.this.selectTree();
                        if (!keyEvent.isAltDown()) {
                            CodeBrowser.this.currentTextArea.grabFocus();
                        }
                        keyEvent.consume();
                    }
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = CodeBrowser.this.tree.getLastSelectedPathComponent();
                if (object instanceof CBLeaf) {
                    CodeBrowser.this.currentView.getStatus().setMessage(((CBLeaf)object).toString());
                }
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                this.remember(treeExpansionEvent, true);
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                this.remember(treeExpansionEvent, false);
            }

            void remember(TreeExpansionEvent treeExpansionEvent, boolean bl) {
                Object object = treeExpansionEvent.getPath().getLastPathComponent();
                if (object instanceof CBType) {
                    ((CBType)object).setState(bl);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    void buildBufferList() {
        if (this.bufferList != null) {
            return;
        }
        this.bufferList = new JList(){

            public String getToolTipText(MouseEvent mouseEvent) {
                Buffer buffer;
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (n >= 0 && (buffer = (Buffer)this.getModel().getElementAt(n)) != null) {
                    return buffer.getPath();
                }
                return null;
            }
        };
        this.bufferList.setCellRenderer(new CBListCellRenderer());
        this.bufferList.setFont(this.tree.getFont());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Buffer buffer;
                int n = CodeBrowser.this.bufferList.locationToIndex(mouseEvent.getPoint());
                if (n >= 0 && (buffer = (Buffer)CodeBrowser.this.bufferList.getModel().getElementAt(n)) != null) {
                    if (mouseEvent.isControlDown()) {
                        if (DEBUG) {
                            System.err.println("Closing buffer " + buffer);
                        }
                        jEdit.closeBuffer((View)CodeBrowser.this.currentView, (Buffer)buffer);
                    } else {
                        CodeBrowser.this.currentView.setBuffer(buffer);
                    }
                }
                mouseEvent.consume();
            }
        };
        this.bufferList.addMouseListener(mouseAdapter);
        ToolTipManager.sharedInstance().registerComponent(this.bufferList);
        Dimension dimension = new Dimension(20, 0);
        this.bufferList.setMinimumSize(dimension);
    }

    public void focusOnDefaultComponent() {
        this.tree.requestFocus();
    }

    void doParse(Buffer buffer) {
        if (!jEdit.getBooleanProperty((String)"codebrowser.parse_automatic", (boolean)true)) {
            return;
        }
        this.doParse(buffer, false);
    }

    void doParse(final Buffer buffer, boolean bl) {
        if (buffer == null) {
            return;
        }
        if (buffer.getMode() == null) {
            return;
        }
        if (this.isVisibleInDock() || bl) {
            if (this.chkThread) {
                this.currentView.getStatus().setMessage("CodeBrowser : Cancel");
                return;
            }
            this.currentTextArea = this.currentView.getTextArea();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        CodeBrowser.this.chkThread = true;
                        int n = CodeBrowser.this.tree.getRowForPath(CodeBrowser.this.tree.getSelectionPath());
                        CodeBrowser.this.currentBuffer = buffer;
                        String string = buffer.getMode().getName();
                        String string2 = buffer.getPath();
                        CodeBrowser.this.root = ParserHistory.getEntry(string2, string);
                        if (CodeBrowser.this.root != null) {
                            CodeBrowser.this.tree.setModel(new DefaultTreeModel(CodeBrowser.this.root));
                        } else {
                            String string3;
                            boolean bl = false;
                            File file = null;
                            if (!(buffer.getVFS() instanceof FileVFS)) {
                                string3 = buffer.getName();
                                String string4 = null;
                                int n2 = string3.indexOf(".");
                                if (n2 > 0) {
                                    string4 = string3.substring(n2);
                                    string3 = string3.substring(0, n2);
                                }
                                try {
                                    int n3;
                                    file = File.createTempFile(string3, string4);
                                    FileWriter fileWriter = new FileWriter(file);
                                    int n4 = 0;
                                    for (int i = buffer.getLength(); i > 0; i -= n3) {
                                        n3 = 16384;
                                        if (n3 > i) {
                                            n3 = i;
                                        }
                                        fileWriter.write(buffer.getText(n4, n3));
                                        n4 += n3;
                                    }
                                    fileWriter.close();
                                    bl = true;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (bl) {
                                    string2 = file.getAbsolutePath();
                                }
                            }
                            string3 = buffer.getStringProperty("encoding");
                            CodeBrowser.this.root = new CBRoot(string2, string, string3);
                            CodeBrowser.this.tree.setModel(new DefaultTreeModel(CodeBrowser.this.root));
                            ParserHistory.setEntry(buffer.getPath(), string, CodeBrowser.this.root);
                            if (bl) {
                                file.delete();
                            }
                        }
                        CodeBrowser.this.root.setSorted(jEdit.getBooleanProperty((String)"codebrowser.do_sort", (boolean)true), null);
                        CodeBrowser.this.root.expandPaths(CodeBrowser.this.tree);
                        CodeBrowser.this.tree.setSelectionRow(n);
                        CodeBrowser.this.updateBuffers();
                        CodeBrowser.this.currentView.getStatus().setMessage("CodeBrowser : Finished Parse");
                    }
                    finally {
                        CodeBrowser.this.chkThread = false;
                    }
                }
            }.start();
        }
    }

    void updateBuffers() {
        this.bufferList.setFont(this.tree.getFont());
        this.bufferList.setListData(jEdit.getBuffers());
        this.bufferList.setSelectedValue(this.currentBuffer, true);
    }

    boolean isDocked() {
        return this.currentView.getDockableWindowManager().isDockableWindowDocked("codebrowser");
    }

    boolean isVisibleInDock() {
        return this.currentView.getDockableWindowManager().isDockableWindowVisible("codebrowser");
    }

    public void addNotify() {
        if (DEBUG) {
            System.err.println("addNotify!");
        }
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
        this.doParse(this.currentBuffer);
    }

    public void removeNotify() {
        if (DEBUG) {
            System.err.println("removeNotify!");
        }
        jEdit.setIntegerProperty((String)"codebrowser.divider_location", (int)this.splitPane.getDividerLocation());
        jEdit.setIntegerProperty((String)"codebrowser.last_divider_location", (int)this.splitPane.getLastDividerLocation());
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            EditPane editPane = editPaneUpdate.getEditPane();
            JEditTextArea jEditTextArea = editPane.getTextArea();
            if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
                if (this.isDocked()) {
                    if (this.currentView != editPane.getView()) return;
                }
                this.currentView = editPane.getView();
                this.currentTextArea = jEditTextArea;
                this.currentBuffer = this.currentView.getBuffer();
                this.bufferList.setSelectedValue(this.currentBuffer, true);
                this.doParse(this.currentBuffer);
                return;
            }
            if (editPaneUpdate.getWhat() != EditPaneUpdate.CREATED) return;
            return;
        } else {
            if (eBMessage instanceof BufferUpdate) {
                BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
                if (bufferUpdate.getWhat() == BufferUpdate.SAVED || bufferUpdate.getWhat() == BufferUpdate.PROPERTIES_CHANGED || bufferUpdate.getWhat() == BufferUpdate.LOADED) {
                    Buffer buffer = bufferUpdate.getBuffer();
                    ParserHistory.removeEntry(buffer.getPath(), buffer.getMode().getName());
                    if (buffer != this.currentBuffer) return;
                    this.doParse(buffer);
                    return;
                }
                if (bufferUpdate.getWhat() != BufferUpdate.CLOSED && bufferUpdate.getWhat() != BufferUpdate.CREATED && bufferUpdate.getWhat() != BufferUpdate.DIRTY_CHANGED) {
                    if (bufferUpdate.getWhat() != BufferUpdate.PROPERTIES_CHANGED) return;
                }
                this.updateBuffers();
                return;
            }
            if (!(eBMessage instanceof ViewUpdate)) return;
            ViewUpdate viewUpdate = (ViewUpdate)eBMessage;
            if (viewUpdate.getWhat() != ViewUpdate.EDIT_PANE_CHANGED) return;
            View view = (View)viewUpdate.getSource();
            if (this.isDocked()) {
                if (this.currentView != view) return;
            }
            this.currentBuffer = view.getBuffer();
            this.bufferList.setSelectedValue(this.currentBuffer, true);
            this.doParse(this.currentBuffer);
        }
    }

    private void selectTree() {
        this.selectTree(null);
    }

    private void selectTree(Object object) {
        Object object2 = object == null ? this.tree.getLastSelectedPathComponent() : object;
        this.repeatCount = object2 != this.previousNode ? 0 : ++this.repeatCount;
        this.previousNode = object2;
        if (object2 instanceof CBLeaf) {
            EditPane editPane = this.currentView.getEditPane();
            EditBus.send((EBMessage)new CaretChanging(this.currentView.getTextArea()));
            CBLeaf cBLeaf = (CBLeaf)object2;
            String string = cBLeaf.getPattern();
            String string2 = SearchAndReplace.getSearchString();
            boolean bl = SearchAndReplace.getIgnoreCase();
            boolean bl2 = SearchAndReplace.getRegexp();
            boolean bl3 = SearchAndReplace.getReverseSearch();
            boolean bl4 = SearchAndReplace.getBeanShellReplace();
            boolean bl5 = SearchAndReplace.getAutoWrapAround();
            SearchAndReplace.setSearchString((String)string);
            SearchAndReplace.setIgnoreCase((boolean)false);
            SearchAndReplace.setRegexp((boolean)true);
            SearchAndReplace.setReverseSearch((boolean)false);
            SearchAndReplace.setBeanShellReplace((boolean)false);
            SearchAndReplace.setAutoWrapAround((boolean)true);
            SearchAndReplace.setSearchFileSet((SearchFileSet)new CurrentBufferSet());
            if (DEBUG) {
                System.err.println("Searching for: " + string);
            }
            try {
                SearchAndReplace.find((View)this.currentView, (Buffer)this.currentBuffer, (int)0);
                for (int i = 0; i < this.repeatCount; ++i) {
                    SearchAndReplace.find((View)this.currentView);
                }
                TreeNode treeNode = cBLeaf.getParent();
                int n = treeNode.getIndex(cBLeaf);
                for (int i = 0; i < n; ++i) {
                    if (!string.equals(((CBLeaf)treeNode.getChildAt(i)).getPattern())) continue;
                    SearchAndReplace.find((View)this.currentView);
                }
                this.currentTextArea.selectNone();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            SearchAndReplace.setSearchString((String)string2);
            SearchAndReplace.setIgnoreCase((boolean)bl);
            SearchAndReplace.setRegexp((boolean)bl2);
            SearchAndReplace.setReverseSearch((boolean)bl3);
            SearchAndReplace.setBeanShellReplace((boolean)bl4);
            SearchAndReplace.setAutoWrapAround((boolean)bl5);
        }
    }

    public void setAutomaticParse(boolean bl) {
        this.autoParseMenuItem.setState(bl);
        jEdit.setBooleanProperty((String)"codebrowser.parse_automatic", (boolean)bl);
        this.parseManualButton.setEnabled(!bl);
        if (bl) {
            this.doParse(this.currentView.getBuffer());
        }
    }

    public boolean isAutomaticParse() {
        return this.autoParseMenuItem.getState();
    }

    public void findString(Buffer buffer, String string, boolean bl, boolean bl2, int n) {
        this.doParse(buffer, true);
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.findNode(this.tree.getModel().getRoot(), string, bl, bl2);
    }

    boolean findNode(Object object, String string, boolean bl, boolean bl2) {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel.isLeaf(object)) {
            if ((bl && object.toString().startsWith(string) || !bl && object.toString().equals(string)) && object instanceof TreeNode && treeModel instanceof DefaultTreeModel) {
                if (bl2) {
                    Object[] objectArray = ((DefaultTreeModel)treeModel).getPathToRoot((TreeNode)object);
                    TreePath treePath = new TreePath(objectArray);
                    this.tree.scrollPathToVisible(treePath);
                    this.tree.setSelectionPath(treePath);
                    this.selectTree();
                } else {
                    Object[] objectArray = ((DefaultTreeModel)treeModel).getPathToRoot((TreeNode)object);
                    TreePath treePath = new TreePath(objectArray);
                    this.selectTree(treePath.getLastPathComponent());
                }
                return true;
            }
        } else {
            int n = this.tree.getModel().getChildCount(object);
            for (int i = 0; i < n; ++i) {
                if (!this.findNode(this.tree.getModel().getChild(object, i), string, bl, bl2)) continue;
                return true;
            }
        }
        return false;
    }

    class OptionsMenuButton
    extends JButton {
        OptionsMenu popup;

        OptionsMenuButton() {
            this.setText(jEdit.getProperty((String)"codebrowser.optionsmenu.label"));
            this.setIcon(GUIUtilities.loadIcon((String)"ToolbarMenu.gif"));
            this.setHorizontalTextPosition(10);
            this.popup = new OptionsMenu();
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(3, 3, 3, 3));
            this.addMouseListener(new OptionsMouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        class OptionsMenu
        extends JPopupMenu {
            OptionsMenu() {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
                jCheckBoxMenuItem.setState(jEdit.getBooleanProperty((String)"codebrowser.parse_automatic", (boolean)true));
                jCheckBoxMenuItem.setAction(new AutoParseAction());
                this.add(jCheckBoxMenuItem);
                CodeBrowser.this.autoParseMenuItem = jCheckBoxMenuItem;
                jCheckBoxMenuItem = new JCheckBoxMenuItem();
                jCheckBoxMenuItem.setState(jEdit.getBooleanProperty((String)"codebrowser.do_sort", (boolean)true));
                jCheckBoxMenuItem.setAction(new SortAction());
                this.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem = new JCheckBoxMenuItem();
                jCheckBoxMenuItem.setState(jEdit.getBooleanProperty((String)"codebrowser.do_unfold", (boolean)true));
                jCheckBoxMenuItem.setAction(new AutoUnfoldAction());
                this.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem = new JCheckBoxMenuItem();
                jCheckBoxMenuItem.setState(jEdit.getBooleanProperty((String)"codebrowser.autodockclose", (boolean)false));
                jCheckBoxMenuItem.setAction(new AutoCloseDockAction());
                this.add(jCheckBoxMenuItem);
            }
        }

        class OptionsMouseHandler
        extends MouseAdapter {
            OptionsMouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!OptionsMenuButton.this.popup.isVisible()) {
                    GUIUtilities.showPopupMenu((JPopupMenu)OptionsMenuButton.this.popup, (Component)OptionsMenuButton.this, (int)0, (int)OptionsMenuButton.this.getHeight(), (boolean)false);
                } else {
                    OptionsMenuButton.this.popup.setVisible(false);
                }
            }
        }
    }

    class HyperSearchAction
    extends AbstractAction {
        public HyperSearchAction() {
            super(jEdit.getProperty((String)"codebrowser.action.hypersearch"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = CodeBrowser.this.tree.getLastSelectedPathComponent();
            if (object instanceof CBLeaf) {
                SearchAndReplace.setSearchString((String)((CBLeaf)object).getName());
                SearchAndReplace.setSearchFileSet((SearchFileSet)new CurrentBufferSet());
                SearchAndReplace.hyperSearch((View)CodeBrowser.this.currentView, (boolean)false);
            }
        }
    }

    class CopyAppendAction
    extends AbstractAction {
        public CopyAppendAction() {
            super(jEdit.getProperty((String)"codebrowser.action.copy-append"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = CodeBrowser.this.tree.getLastSelectedPathComponent();
            if (object instanceof CBLeaf) {
                String string;
                char c = '$';
                String string2 = "\n";
                String string3 = ((CBLeaf)object).getName();
                Registers.Register register = Registers.getRegister((char)c);
                if (register != null && (string = register.toString()) != null) {
                    string3 = string.endsWith(string2) ? string + string3 : string + string2 + string3;
                }
                Registers.setRegister((char)c, (String)string3);
                HistoryModel.getModel((String)"clipboard").addItem(string3);
            }
        }
    }

    class InsertAction
    extends AbstractAction {
        public InsertAction() {
            super(jEdit.getProperty((String)"codebrowser.action.insert"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = CodeBrowser.this.tree.getLastSelectedPathComponent();
            if (object instanceof CBLeaf) {
                CodeBrowser.this.currentTextArea.setSelectedText(((CBLeaf)object).getName());
            }
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(jEdit.getProperty((String)"codebrowser.action.copy"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = CodeBrowser.this.tree.getLastSelectedPathComponent();
            if (object instanceof CBLeaf) {
                Registers.setRegister((char)'$', (String)((CBLeaf)object).getName());
            }
        }
    }

    class AutoCloseDockAction
    extends AbstractAction {
        public AutoCloseDockAction() {
            super(jEdit.getProperty((String)"codebrowser.optionsmenu.autodockclose"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            boolean bl = jCheckBoxMenuItem.getState();
            jEdit.setBooleanProperty((String)"codebrowser.autodockclose", (boolean)bl);
        }
    }

    class AutoUnfoldAction
    extends AbstractAction {
        public AutoUnfoldAction() {
            super(jEdit.getProperty((String)"codebrowser.optionsmenu.autounfold"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            boolean bl = jCheckBoxMenuItem.getState();
            jEdit.setBooleanProperty((String)"codebrowser.do_unfold", (boolean)bl);
        }
    }

    class SortAction
    extends AbstractAction {
        public SortAction() {
            super(jEdit.getProperty((String)"codebrowser.optionsmenu.sort"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            boolean bl = jCheckBoxMenuItem.getState();
            jEdit.setBooleanProperty((String)"codebrowser.do_sort", (boolean)bl);
            CodeBrowser.this.root.setSorted(bl, CodeBrowser.this.tree);
        }
    }

    class AutoParseAction
    extends AbstractAction {
        public AutoParseAction() {
            super(jEdit.getProperty((String)"codebrowser.optionsmenu.autoparse"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            boolean bl = jCheckBoxMenuItem.getState();
            jEdit.setBooleanProperty((String)"codebrowser.parse_automatic", (boolean)bl);
            CodeBrowser.this.parseManualButton.setEnabled(!bl);
            if (bl) {
                CodeBrowser.this.doParse(CodeBrowser.this.currentView.getBuffer());
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = CodeBrowser.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            CodeBrowser.this.tree.setSelectionPath(treePath);
            if (GUIUtilities.isPopupTrigger((MouseEvent)mouseEvent)) {
                this.showPopupMenu(mouseEvent);
            } else {
                CodeBrowser.this.selectTree();
                CodeBrowser.this.tree.clearSelection();
                if (CodeBrowser.this.isVisibleInDock() && jEdit.getBooleanProperty((String)"codebrowser.autodockclose", (boolean)false)) {
                    CodeBrowser.this.currentView.getDockableWindowManager().closeCurrentArea();
                }
                CodeBrowser.this.currentTextArea.grabFocus();
                if (jEdit.getBooleanProperty((String)"codebrowser.do_unfold", (boolean)true)) {
                    CodeBrowser.this.currentTextArea.expandFold(true);
                    Selection[] selectionArray = CodeBrowser.this.currentTextArea.getSelection();
                    int n = CodeBrowser.this.currentTextArea.getCaretPosition();
                    CodeBrowser.this.currentTextArea.goToNextLine(true);
                    CodeBrowser.this.currentTextArea.expandFold(true);
                    CodeBrowser.this.currentTextArea.setCaretPosition(n);
                    CodeBrowser.this.currentTextArea.setSelection(selectionArray);
                }
            }
        }

        private void showPopupMenu(MouseEvent mouseEvent) {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
                this.popupMenu.add(new InsertAction());
                this.popupMenu.add(new HyperSearchAction());
                this.popupMenu.add(new CopyAction());
                this.popupMenu.add(new CopyAppendAction());
            }
            GUIUtilities.showPopupMenu((JPopupMenu)this.popupMenu, (Component)mouseEvent.getComponent(), (int)mouseEvent.getX(), (int)mouseEvent.getY());
            mouseEvent.consume();
        }
    }
}

