/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.ButtonCellEditor;
import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightCellEditor;
import gatchan.highlight.HighlightCellRenderer;
import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;

public final class HighlightList
extends JPanel
implements HighlightChangeListener {
    private JPopupMenu popupMenu;
    private JMenuItem remove;
    private final JTable table;
    private final HighlightManagerTableModel tableModel;
    private RemoveAction removeAction;
    private final JCheckBox enableHighlights = new JCheckBox("enable");
    private JCheckBoxMenuItem permanentScope;
    private JCheckBoxMenuItem sessionScope;
    private JCheckBoxMenuItem bufferScope;
    private MyActionListener actionListener;

    public HighlightList() {
        super(new BorderLayout());
        this.tableModel = HighlightManagerTableModel.getInstance();
        this.table = new JTable(this.tableModel);
        this.table.setDragEnabled(false);
        HighlightCellRenderer highlightCellRenderer = new HighlightCellRenderer();
        this.table.setRowHeight(highlightCellRenderer.getPreferredSize().height);
        this.table.setDefaultRenderer(Highlight.class, highlightCellRenderer);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(2).setCellEditor(new ButtonCellEditor(this.tableModel));
        tableColumnModel.getColumn(3).setCellEditor(new ButtonCellEditor(this.tableModel));
        this.table.setSelectionMode(0);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(26);
        tableColumn.setMinWidth(26);
        tableColumn.setMaxWidth(26);
        tableColumn.setResizable(false);
        TableColumn tableColumn2 = tableColumnModel.getColumn(2);
        tableColumn2.setPreferredWidth(26);
        tableColumn2.setMinWidth(26);
        tableColumn2.setMaxWidth(26);
        tableColumn2.setResizable(false);
        TableColumn tableColumn3 = tableColumnModel.getColumn(3);
        tableColumn3.setPreferredWidth(26);
        tableColumn3.setMinWidth(26);
        tableColumn3.setMaxWidth(26);
        tableColumn3.setResizable(false);
        this.table.setDefaultEditor(Highlight.class, new HighlightCellEditor());
        this.table.setDefaultEditor(Boolean.class, this.table.getDefaultEditor(Boolean.class));
        this.table.setTableHeader(null);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = HighlightList.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                if (GUIUtilities.isRightButton((int)mouseEvent.getModifiers())) {
                    HighlightList.this.showPopupMenu(mouseEvent, n);
                }
            }
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JButton jButton = new JButton(GUIUtilities.loadIcon((String)"New.png"));
        jButton.setToolTipText("Add an highlight");
        JButton jButton2 = new JButton(GUIUtilities.loadIcon((String)"Clear.png"));
        jButton2.setToolTipText("Remove all highlights");
        this.enableHighlights.setSelected(true);
        this.enableHighlights.setToolTipText("Enable / disable highlights");
        this.actionListener = new MyActionListener(jButton, jButton2);
        jButton.addActionListener(this.actionListener);
        jButton2.addActionListener(this.actionListener);
        this.enableHighlights.addActionListener(this.actionListener);
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.add(this.enableHighlights);
        this.add((Component)jToolBar, "North");
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add(jScrollPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPopupMenu(MouseEvent mouseEvent, int n) {
        Highlight highlight;
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.removeAction = new RemoveAction(this.tableModel);
            this.remove = this.popupMenu.add(this.removeAction);
            this.permanentScope = new JCheckBoxMenuItem("permanent");
            this.sessionScope = new JCheckBoxMenuItem("session");
            this.bufferScope = new JCheckBoxMenuItem("buffer");
            this.popupMenu.add(this.permanentScope);
            this.popupMenu.add(this.sessionScope);
            this.popupMenu.add(this.bufferScope);
            this.permanentScope.addActionListener(this.actionListener);
            this.sessionScope.addActionListener(this.actionListener);
            this.bufferScope.addActionListener(this.actionListener);
        }
        try {
            this.tableModel.getReadLock();
            highlight = this.tableModel.getHighlight(n);
        }
        finally {
            this.tableModel.releaseLock();
        }
        this.actionListener.setHighlight(highlight, n);
        int n2 = highlight.getScope();
        this.permanentScope.setSelected(n2 == 0);
        this.sessionScope.setSelected(n2 == 1);
        this.bufferScope.setSelected(n2 == 2);
        this.remove.setEnabled(this.tableModel.getRowCount() > 0);
        this.removeAction.setRow(n);
        GUIUtilities.showPopupMenu((JPopupMenu)this.popupMenu, (Component)mouseEvent.getComponent(), (int)mouseEvent.getX(), (int)mouseEvent.getY());
        mouseEvent.consume();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        HighlightManagerTableModel.getManager().addHighlightChangeListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        HighlightManager highlightManager = HighlightManagerTableModel.getManager();
        if (highlightManager != null) {
            highlightManager.removeHighlightChangeListener(this);
        }
    }

    @Override
    public void highlightUpdated(boolean bl) {
        this.enableHighlights.setSelected(bl);
    }

    private final class MyActionListener
    implements ActionListener {
        private final JButton newButton;
        private final JButton clear;
        private Highlight highlight;
        private int row;

        MyActionListener(JButton jButton, JButton jButton2) {
            this.newButton = jButton;
            this.clear = jButton2;
        }

        private void setHighlight(Highlight highlight, int n) {
            this.highlight = highlight;
            this.row = n;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (this.clear == object) {
                HighlightList.this.tableModel.removeAll();
            } else if (this.newButton == object) {
                View view = jEdit.getActiveView();
                HighlightPlugin.highlightDialog(view, (TextArea)view.getTextArea());
            } else if (HighlightList.this.enableHighlights == object) {
                HighlightList.this.tableModel.setHighlightEnable(HighlightList.this.enableHighlights.isSelected());
            } else if (object == HighlightList.this.permanentScope) {
                this.highlight.setScope(0);
                this.highlight.setBuffer(null);
                HighlightList.this.tableModel.fireTableRowsUpdated(this.row, this.row);
            } else if (object == HighlightList.this.sessionScope) {
                this.highlight.setScope(1);
                this.highlight.setBuffer(null);
                HighlightList.this.tableModel.fireTableRowsUpdated(this.row, this.row);
            } else if (object == HighlightList.this.bufferScope) {
                this.highlight.setScope(2);
                this.highlight.setBuffer((JEditBuffer)jEdit.getActiveView().getBuffer());
                HighlightList.this.tableModel.fireTableRowsUpdated(this.row, this.row);
            }
        }
    }

    private static final class RemoveAction
    extends AbstractAction {
        private int row;
        private final HighlightManagerTableModel tableModel;

        RemoveAction(HighlightManagerTableModel highlightManagerTableModel) {
            super("remove");
            this.tableModel = highlightManagerTableModel;
        }

        private void setRow(int n) {
            this.row = n;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            this.tableModel.removeRow(this.row);
        }
    }
}

