/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManagerTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.IntegerArray;

public class HighlightOverview
extends JPanel
implements HighlightChangeListener {
    private final IntegerArray items;
    private final JEditTextArea textArea;
    private static final int ITEM_HEIGHT = 4;
    private static final int OVERVIEW_WIDTH = 12;
    private static final int ITEM_BORDER = 2;
    private static final int ITEM_WIDTH = 8;
    private static final int Y_OFFSET = 16;
    private static final Dimension preferredSize = new Dimension(12, 0);
    private Color color;

    public HighlightOverview(final JEditTextArea jEditTextArea) {
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), 1, 8);
        this.setFont(font2);
        this.textArea = jEditTextArea;
        this.items = new IntegerArray(32);
        this.setRequestFocusEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = jEditTextArea.getLineCount();
                int n2 = HighlightOverview.this.yToLine(mouseEvent.getY(), n);
                jEditTextArea.setFirstLine(Math.max(n2 - jEditTextArea.getVisibleLines() / 2, 0));
            }
        });
    }

    @Override
    public void highlightUpdated(boolean bl) {
        int n;
        int n2;
        this.items.clear();
        if (!bl || !HighlightManagerTableModel.currentWordHighlight.isEnabled() && !HighlightManagerTableModel.selectionHighlight.isEnabled()) {
            this.repaint();
            return;
        }
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        boolean bl2 = jEditBuffer.getLineEndOffset(jEditBuffer.getLineOfOffset(n2 = jEditBuffer.getLength())) - 1 == n2;
        SearchMatcher searchMatcher = HighlightManagerTableModel.selectionHighlight.isEnabled() ? HighlightManagerTableModel.selectionHighlight.getSearchMatcher() : HighlightManagerTableModel.currentWordHighlight.getSearchMatcher();
        try {
            int n3 = 0;
            int n4 = -1;
            n = 0;
            while (true) {
                boolean bl3 = jEditBuffer.getLineStartOffset(jEditBuffer.getLineOfOffset(n3)) == n3;
                SearchMatcher.Match match = searchMatcher.nextMatch(jEditBuffer.getSegment(n3, n2 - n3), bl3, bl2, n == 0, false);
                if (match != null) {
                    int n5;
                    int n6 = jEditBuffer.getLineOfOffset(n3 + match.start);
                    if (n4 != n6) {
                        this.items.add(n6);
                        n4 = n6;
                    }
                    if ((n5 = n6 + 1) < jEditBuffer.getLineCount()) {
                        n3 = jEditBuffer.getLineStartOffset(n5);
                        ++n;
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        View view = this.textArea.getView();
        if (view.isActive() && view.getTextArea() == this.textArea) {
            view.getStatus().setMessage(n + " lines contains the current word");
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.items.getSize() == 0) {
            return;
        }
        int n = this.textArea.getLineCount();
        if (this.color != null) {
            graphics.setColor(this.color);
        } else if (HighlightManagerTableModel.selectionHighlight.isEnabled()) {
            graphics.setColor(HighlightManagerTableModel.selectionHighlight.getColor());
        } else {
            graphics.setColor(HighlightManagerTableModel.currentWordHighlight.getColor());
        }
        for (int i = 0; i < this.items.getSize(); ++i) {
            int n2 = this.lineToY(this.items.get(i), n);
            graphics.fillRect(2, n2, 8, 4);
        }
    }

    private int lineToY(int n, int n2) {
        return 16 + (this.getHeight() - 32) * n / n2 - 2;
    }

    private int yToLine(int n, int n2) {
        return (n + 2 - 16) * n2 / (this.getHeight() - 32);
    }

    @Override
    public Dimension getPreferredSize() {
        return preferredSize;
    }

    public void setOverviewColor(Color color) {
        this.color = color;
    }
}

