/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;

class Highlighter
extends TextAreaExtension
implements HighlightChangeListener {
    private final JEditTextArea textArea;
    private final Point point = new Point();
    private final HighlightManager highlightManager;
    private AlphaComposite blend;
    private float alpha = (float)jEdit.getIntegerProperty((String)"gatchan.highlight.alpha", (int)50) / 100.0f;
    public static boolean square;
    public static Color squareColor;
    public static final int MAX_LINE_LENGTH = 10000;
    private boolean roundcorner;
    private final TextAreaPainter painter;

    Highlighter(JEditTextArea jEditTextArea) {
        this.blend = AlphaComposite.getInstance(3, this.alpha);
        this.highlightManager = HighlightManagerTableModel.getManager();
        this.textArea = jEditTextArea;
        this.painter = jEditTextArea.getPainter();
    }

    public void setAlphaComposite(float f) {
        if (this.alpha != f) {
            this.alpha = f;
            this.blend = AlphaComposite.getInstance(3, f);
        }
    }

    public void setRoundcorner(boolean bl) {
        this.roundcorner = bl;
    }

    public void paintScreenLineRange(Graphics2D graphics2D, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4) {
        if (this.highlightManager.isHighlightEnable() && this.highlightManager.countHighlights() != 0 || HighlightManagerTableModel.currentWordHighlight.isEnabled() || HighlightManagerTableModel.selectionHighlight.isEnabled()) {
            super.paintScreenLineRange(graphics2D, n, n2, nArray, nArray2, nArray3, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        CharSequence charSequence;
        int n6;
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        int n7 = jEditBuffer.getLineStartOffset(n2);
        int n8 = jEditBuffer.getLineEndOffset(n2);
        int n9 = jEditBuffer.getLineLength(n2);
        int n10 = n9 - (n6 = n3 - n7) - n8 + n4;
        if (n10 > 10000) {
            n10 = 10000;
        }
        if ((charSequence = jEditBuffer.getSegment(n7 + n6, n10)).length() == 0) {
            return;
        }
        CharSequence charSequence2 = charSequence;
        try {
            this.highlightManager.getReadLock();
            for (int i = 0; i < this.highlightManager.countHighlights(); ++i) {
                Highlight highlight = this.highlightManager.getHighlight(i);
                this.highlight(highlight, jEditBuffer, graphics2D, n2, n5, n6, charSequence2);
                charSequence2 = charSequence;
            }
        }
        finally {
            this.highlightManager.releaseLock();
        }
        charSequence2 = charSequence;
        if (this.textArea.getSelectionCount() == 0) {
            this.highlight(HighlightManagerTableModel.currentWordHighlight, jEditBuffer, graphics2D, n2, n5, n6, charSequence2);
        } else {
            this.highlight(HighlightManagerTableModel.selectionHighlight, jEditBuffer, graphics2D, n2, n5, n6, charSequence2);
        }
    }

    private void highlight(Highlight highlight, JEditBuffer jEditBuffer, Graphics2D graphics2D, int n, int n2, int n3, CharSequence charSequence) {
        if (!highlight.isEnabled() || !highlight.isValid() || highlight.getScope() == 2 && highlight.getBuffer() != jEditBuffer) {
            return;
        }
        SearchMatcher searchMatcher = highlight.getSearchMatcher();
        try {
            int n4 = 0;
            SearchMatcher.Match match = null;
            while ((match = searchMatcher.nextMatch(charSequence, n4 == 0, true, match == null, false)) != null && match.end != match.start) {
                int n5;
                int n6 = match.start + n4 + n3 + this.textArea.getLineStartOffset(n);
                Selection selection = this.textArea.getSelectionAtOffset(n6);
                if (selection == null) {
                    n5 = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(this.textArea.getCaretLine());
                    int n7 = match.end + n4 + n3;
                    int n8 = match.start + n4 + n3;
                    if (highlight != HighlightManagerTableModel.currentWordHighlight || this.textArea.getCaretLine() != n || n5 < n8 || n5 > n7) {
                        this._highlight(highlight.getColor(), graphics2D, n, n8, n7, n2, true);
                    } else {
                        this._highlight(highlight.getColor(), graphics2D, n, n8, n7, n2, false);
                    }
                }
                highlight.updateLastSeen();
                n4 += match.end;
                n5 = charSequence.length() - match.end;
                if (n5 > 0) {
                    charSequence = charSequence.subSequence(match.end, n5 + match.end);
                    continue;
                }
                break;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            highlight.setValid(false);
        }
        catch (InterruptedException interruptedException) {
            highlight.setValid(false);
        }
    }

    private void _highlight(Color color, Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        Point point = this.textArea.offsetToXY(n, n2, this.point);
        if (point == null) {
            return;
        }
        int n5 = point.x;
        point = this.textArea.offsetToXY(n, n3, this.point);
        if (point == null) {
            return;
        }
        int n6 = point.x;
        Color color2 = graphics2D.getColor();
        Composite composite = graphics2D.getComposite();
        graphics2D.setColor(color);
        graphics2D.setComposite(this.blend);
        if (bl) {
            int n7 = this.painter.getLineHeight();
            int n8 = this.painter.getFontHeight();
            int n9 = n7 - n8;
            if (this.roundcorner) {
                graphics2D.fillRoundRect(n5, n4 + n9, n6 - n5, n8 - 1, 5, 5);
            } else {
                graphics2D.fillRect(n5, n4 + n9, n6 - n5, n8 - 1);
            }
        }
        if (square) {
            graphics2D.setColor(squareColor);
            this.drawRect(graphics2D, n4, n5, n6);
        } else if (!bl) {
            this.drawRect(graphics2D, n4, n5, n6);
        }
        graphics2D.setColor(color2);
        graphics2D.setComposite(composite);
    }

    private void drawRect(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = this.painter.getLineHeight();
        int n5 = this.painter.getFontHeight();
        int n6 = n4 - n5;
        if (this.roundcorner) {
            graphics2D.drawRoundRect(n2, n + n6, n3 - n2, n5 - 1, 5, 5);
        } else {
            graphics2D.drawRect(n2, n + n6, n3 - n2, n5 - 1);
        }
    }

    @Override
    public void highlightUpdated(boolean bl) {
        int n = this.textArea.getFirstPhysicalLine();
        int n2 = this.textArea.getLastPhysicalLine();
        this.textArea.invalidateLineRange(n, n2);
    }
}

