/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight.color;

import gatchan.highlight.color.ColorToken;
import gatchan.highlight.color.FlexColorScanner;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class FlexColorPainter
extends TextAreaExtension {
    public static final int MAX_LINE_LENGTH = 10000;
    private final TextArea textArea;
    private final Point point = new Point();
    private final Segment seg;
    private FlexColorScanner flexColor;

    public FlexColorPainter(TextArea textArea) {
        this.textArea = textArea;
        this.seg = new Segment();
        this.flexColor = new FlexColorScanner(new StringReader(""));
    }

    public void paintScreenLineRange(Graphics2D graphics2D, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4) {
        if (jEdit.getBooleanProperty((String)"gatchan.highlight.colorsenabled")) {
            super.paintScreenLineRange(graphics2D, n, n2, nArray, nArray2, nArray3, n3, n4);
        }
    }

    public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        int n6 = jEditBuffer.getLineStartOffset(n2);
        int n7 = jEditBuffer.getLineEndOffset(n2);
        int n8 = Math.min(n7 - n6 - 1, 10000);
        if (n8 == 0) {
            return;
        }
        jEditBuffer.getText(n3, n8, this.seg);
        this.flexColor.yyreset(new CharArrayReader(this.seg.array, this.seg.offset, this.seg.count));
        try {
            ColorToken colorToken = this.flexColor.yylex();
            while (colorToken != null) {
                this.paint(colorToken, graphics2D, n2, n3, n5);
                try {
                    colorToken = this.flexColor.yylex();
                }
                catch (IOException iOException) {
                    Log.log((int)9, (Object)((Object)this), (Object)iOException);
                }
            }
        }
        catch (IOException iOException) {
            Log.log((int)9, (Object)((Object)this), (Object)iOException);
        }
        this.seg.array = null;
    }

    private void paint(ColorToken colorToken, Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = this.textArea.getLineStartOffset(n);
        int n5 = n2 + colorToken.getStart();
        int n6 = n2 + colorToken.getEnd();
        Point point = this.textArea.offsetToXY(n, n5 - n4, this.point);
        if (point == null) {
            return;
        }
        int n7 = point.x;
        point = this.textArea.offsetToXY(n, n6 - n4, this.point);
        if (point == null) {
            return;
        }
        int n8 = point.x;
        Color color = graphics2D.getColor();
        Composite composite = graphics2D.getComposite();
        graphics2D.setColor(colorToken.getColor());
        FontMetrics fontMetrics = this.textArea.getPainter().getFontMetrics();
        int n9 = n3 + fontMetrics.getHeight() - 2;
        int n10 = n3 + fontMetrics.getHeight() - 1;
        graphics2D.drawLine(n7, n9, n8, n9);
        graphics2D.drawLine(n7, n10, n8, n10);
        graphics2D.setColor(color);
        graphics2D.setComposite(composite);
    }
}

