/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util.patch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class PatchUtils {
    public static final int NORMAL = 0;
    public static final int EDIT = 1;
    public static final int CONTEXT = 2;
    public static final int UNIFIED = 3;

    public static int getPatchType(String patch) throws Exception {
        BufferedReader reader = new BufferedReader(new StringReader(patch));
        String firstLine = reader.readLine();
        if (firstLine.startsWith("---")) {
            return 3;
        }
        if (firstLine.startsWith("***")) {
            return 2;
        }
        while (firstLine != null) {
            if (firstLine.length() == 0) {
                return 1;
            }
            char firstChar = firstLine.charAt(0);
            if (firstChar == '-' || firstChar == '<' || firstChar == '>' || Character.isDigit(firstChar)) {
                firstLine = reader.readLine();
                continue;
            }
            return 1;
        }
        return 0;
    }

    public static String loadPatchFile(String filename) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        StringWriter writer = new StringWriter();
        PatchUtils.copyToWriter(reader, writer);
        return writer.toString();
    }

    public static void copyToWriter(Reader from, Writer to) throws Exception {
        int chars_read;
        char[] buffer = new char[8192];
        while ((chars_read = from.read(buffer)) != -1) {
            to.write(buffer, 0, chars_read);
        }
        to.flush();
        from.close();
    }

    public static void main(String[] args) {
        try {
            String filename = "/home/danson/src/plugins/JDiffPlugin/test/unified_diff.diff";
            String patch = PatchUtils.loadPatchFile(filename);
            int type = PatchUtils.getPatchType(patch);
            System.out.println("Unified diff identification passed? " + (3 == type));
            filename = "/home/danson/src/plugins/JDiffPlugin/test/context_diff.diff";
            patch = PatchUtils.loadPatchFile(filename);
            type = PatchUtils.getPatchType(patch);
            System.out.println("Context diff identification passed? " + (2 == type));
            filename = "/home/danson/src/plugins/JDiffPlugin/test/normal_diff.diff";
            patch = PatchUtils.loadPatchFile(filename);
            type = PatchUtils.getPatchType(patch);
            System.out.println("Normal diff identification passed? " + (0 == type));
            filename = "/home/danson/src/plugins/JDiffPlugin/test/edit_diff.diff";
            patch = PatchUtils.loadPatchFile(filename);
            type = PatchUtils.getPatchType(patch);
            System.out.println("Edit diff identification passed? " + (1 == type));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

