/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util.patch.unified;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import jdiff.util.patch.unified.UnifiedChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patch {
    public static String LINE_SEPARATOR = "\n";

    public static String patchUnified(String patchText, String targetText) {
        List<String> patchSrc = Patch.getLines(patchText, true);
        List<String> targetSrc = Patch.getLines(targetText, false);
        List<UnifiedChunk> chunks = Patch.getUnifiedChunks(patchSrc);
        return Patch.applyUnifiedChunks(targetSrc, chunks);
    }

    private static List<String> getLines(String s, boolean pad) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new StringReader(s));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 && pad) {
                    line = " ";
                }
                lines.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines;
    }

    private static List<UnifiedChunk> getUnifiedChunks(List<String> patchSrc) {
        int numChunks = 0;
        for (String line : patchSrc) {
            if (!line.startsWith("@@")) continue;
            ++numChunks;
        }
        int[] chunkOffsets = new int[numChunks + 1];
        int index = 0;
        for (int i = 0; i < patchSrc.size(); ++i) {
            String line = patchSrc.get(i);
            if (!line.startsWith("@@")) continue;
            chunkOffsets[index] = i;
            ++index;
        }
        chunkOffsets[chunkOffsets.length - 1] = patchSrc.size();
        ArrayList chunkLines = new ArrayList();
        for (int i = 0; i < chunkOffsets.length - 1; ++i) {
            int start = chunkOffsets[i];
            int n = chunkOffsets[i + 1];
            ArrayList<String> lines = new ArrayList<String>();
            for (int j = start; j < n; ++j) {
                lines.add(patchSrc.get(j));
            }
            if (lines.size() <= 0) continue;
            chunkLines.add(lines);
        }
        ArrayList<UnifiedChunk> unifiedChunks = new ArrayList<UnifiedChunk>();
        for (List list : chunkLines) {
            if (list.size() == 0) continue;
            String rangeLine = (String)list.get(0);
            rangeLine = rangeLine.replaceAll("@", "");
            String[] ranges = (rangeLine = rangeLine.trim()).split("[ ]");
            if (ranges.length != 2) continue;
            String[] oldParts = ranges[0].split("[,]");
            int oldStartLine = Integer.parseInt(oldParts[0].substring(1)) - 1;
            int oldRange = 1;
            if (oldParts.length == 2) {
                oldRange = Integer.parseInt(oldParts[1]);
            }
            String[] newParts = ranges[1].split("[,]");
            int newStartLine = Integer.parseInt(newParts[0].substring(1)) - 1;
            int newRange = 1;
            if (newParts.length == 2) {
                newRange = Integer.parseInt(newParts[1]);
            }
            int minus_lines = 0;
            int plus_lines = 0;
            int space_lines = 0;
            ArrayList<String> insertLines = new ArrayList<String>();
            for (int i = 1; i < list.size(); ++i) {
                String line = (String)list.get(i);
                if (line.startsWith("-")) {
                    ++minus_lines;
                    continue;
                }
                if (line.startsWith("+")) {
                    ++plus_lines;
                    insertLines.add(line.substring(1));
                    continue;
                }
                if (!line.startsWith(" ")) continue;
                ++space_lines;
                insertLines.add(line.substring(1));
            }
            if (oldRange != minus_lines + space_lines || newRange != plus_lines + space_lines) continue;
            UnifiedChunk unifiedChunk = new UnifiedChunk();
            unifiedChunk.oldStartLine = oldStartLine;
            unifiedChunk.oldRange = oldRange;
            unifiedChunk.newStartLine = newStartLine;
            unifiedChunk.newRange = newRange;
            unifiedChunk.lines = insertLines;
            unifiedChunks.add(unifiedChunk);
        }
        return unifiedChunks;
    }

    private static String applyUnifiedChunks(List<String> lines, List<UnifiedChunk> chunks) {
        ArrayList<String> newLines = new ArrayList<String>();
        int line_number = 0;
        for (UnifiedChunk chunk : chunks) {
            int i;
            if (line_number >= chunk.oldStartLine) {
                int to_remove = line_number - chunk.oldStartLine;
                line_number = chunk.oldStartLine;
                for (int i2 = 0; i2 < to_remove; ++i2) {
                    newLines.remove(newLines.size() - 1);
                }
            }
            for (i = line_number; i < chunk.oldStartLine; ++i) {
                newLines.add(lines.get(line_number));
                ++line_number;
            }
            for (i = 0; i < chunk.lines.size(); ++i) {
                newLines.add(chunk.lines.get(i));
            }
            line_number += chunk.oldRange;
        }
        for (int i = line_number; i < lines.size(); ++i) {
            newLines.add(lines.get(i));
        }
        StringBuffer sb = new StringBuffer();
        for (String line : newLines) {
            sb.append(line).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

