/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jdiff.DualDiff;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;

public class DualDiffDialog
extends JDialog {
    private View view;
    private HistoryTextField baseFileField;
    private HistoryTextField newFileField;

    public DualDiffDialog(View view) {
        super((Frame)view, jEdit.getProperty((String)"jdiff.dual-diff-dialog.label"), true);
        this.view = view;
        JPanel content = new JPanel(new GridLayout(5, 1, 0, 0));
        content.setPreferredSize(new Dimension(390, 180));
        content.setBorder(new EmptyBorder(0, 10, 5, 10));
        this.setContentPane(content);
        JLabel baseLabel = new JLabel(jEdit.getProperty((String)"jdiff.base-file.label"));
        baseLabel.setForeground(Color.black);
        content.add(baseLabel);
        JPanel baseFilePanel = new JPanel(new BorderLayout(5, 5));
        baseFilePanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.baseFileField = new HistoryTextField("user.showDualDiff.basefile");
        this.baseFileField.setText(view.getBuffer().getName());
        baseFilePanel.add((Component)this.baseFileField, "Center");
        JButton baseChooseButton = new JButton(jEdit.getProperty((String)"jdiff.choose.label"));
        baseFilePanel.add((Component)baseChooseButton, "East");
        content.add(baseFilePanel);
        JLabel newLabel = new JLabel(jEdit.getProperty((String)"jdiff.new-file.label"));
        newLabel.setForeground(Color.black);
        content.add(newLabel);
        JPanel newFilePanel = new JPanel(new BorderLayout(5, 5));
        newFilePanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.newFileField = new HistoryTextField("user.showDualDiff.newfile");
        newFilePanel.add((Component)this.newFileField, "Center");
        JButton newChooseButton = new JButton(jEdit.getProperty((String)"jdiff.choose.label"));
        newFilePanel.add((Component)newChooseButton, "East");
        content.add(newFilePanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 20, 0));
        buttonPanel.setBorder(new EmptyBorder(5, 50, 0, 50));
        JButton ok = new JButton(jEdit.getProperty((String)"jdiff.ok.label"));
        JButton cancel = new JButton(jEdit.getProperty((String)"jdiff.cancel.label"));
        ok.setPreferredSize(cancel.getPreferredSize());
        this.getRootPane().setDefaultButton(ok);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        content.add(buttonPanel);
        baseChooseButton.addActionListener(new FieldHandler(this.baseFileField));
        newChooseButton.addActionListener(new FieldHandler(this.newFileField));
        ok.addActionListener(new OkActionHandler());
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DualDiffDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyHandler());
        this.pack();
        this.setLocationRelativeTo((Component)this.view);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private class KeyHandler
    implements KeyListener {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent ke) {
            if ('\u001b' == ke.getKeyChar()) {
                ke.consume();
                DualDiffDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent ke) {
        }

        public void keyTyped(KeyEvent ke) {
        }
    }

    private class FieldHandler
    implements ActionListener {
        private HistoryTextField field;

        public FieldHandler(HistoryTextField field) {
            this.field = field;
        }

        public void actionPerformed(ActionEvent ae) {
            String[] result;
            String fieldText = this.field.getText();
            String path = null;
            if (fieldText.length() != 0) {
                VFS fieldVFS = VFSManager.getVFSForPath((String)fieldText);
                VFSFile fieldEntry = null;
                try {
                    fieldEntry = fieldVFS._getFile(null, fieldText, null);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (fieldEntry == null && !MiscUtilities.isURL((String)fieldText)) {
                    VFS vfs = DualDiffDialog.this.view.getBuffer().getVFS();
                    String currentDir = vfs.getParentOfPath(DualDiffDialog.this.view.getBuffer().getPath());
                    fieldText = vfs.constructPath(currentDir, fieldText);
                    try {
                        fieldEntry = vfs._getFile(null, fieldText, null);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (fieldEntry != null) {
                    path = fieldText;
                }
            }
            if ((result = GUIUtilities.showVFSFileDialog((View)DualDiffDialog.this.view, path, (int)0, (boolean)false)) != null) {
                this.field.setText(result[0]);
            }
        }
    }

    private class OkActionHandler
    implements ActionListener {
        private OkActionHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            String basePath = DualDiffDialog.this.baseFileField.getText();
            String newPath = DualDiffDialog.this.newFileField.getText();
            if (basePath.length() == 0 || newPath.length() == 0) {
                GUIUtilities.message((Component)DualDiffDialog.this, (String)"jdiff.two-files-needed", null);
                return;
            }
            VFS vfs = DualDiffDialog.this.view.getBuffer().getVFS();
            String currentDir = vfs.getParentOfPath(DualDiffDialog.this.view.getBuffer().getPath());
            VFS baseVFS = VFSManager.getVFSForPath((String)basePath);
            VFSFile baseEntry = null;
            try {
                baseEntry = baseVFS._getFile(null, basePath, null);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (!(baseEntry != null && baseEntry.getType() == 0 || MiscUtilities.isURL((String)basePath))) {
                basePath = vfs.constructPath(currentDir, basePath);
                try {
                    baseEntry = vfs._getFile(null, basePath, null);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            VFS newVFS = VFSManager.getVFSForPath((String)newPath);
            VFSFile newEntry = null;
            try {
                newEntry = newVFS._getFile(null, newPath, null);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (!(newEntry != null && newEntry.getType() == 0 || MiscUtilities.isURL((String)newPath))) {
                newPath = vfs.constructPath(currentDir, newPath);
                try {
                    newEntry = vfs._getFile(null, newPath, null);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            int errCount = 0;
            if (baseEntry == null || baseEntry.getType() != 0) {
                errCount |= 1;
            }
            if (newEntry == null || newEntry.getType() != 0) {
                errCount |= 2;
            }
            if (errCount > 0) {
                GUIUtilities.error((Component)DualDiffDialog.this.view, (String)"jdiff.file-not-found", (Object[])new Object[]{new Integer(errCount)});
                return;
            }
            DualDiffDialog.this.baseFileField.getModel().addItem(basePath);
            DualDiffDialog.this.newFileField.getModel().addItem(newPath);
            DualDiffDialog.this.dispose();
            Buffer baseBuffer = jEdit.openFile((View)DualDiffDialog.this.view, (String)basePath);
            Buffer newBuffer = jEdit.openFile((View)DualDiffDialog.this.view, (String)newPath);
            if (baseBuffer == null) {
                GUIUtilities.error((Component)DualDiffDialog.this.view, (String)"jdiff.file-not-opened", (Object[])new Object[]{new Integer(0)});
                return;
            }
            if (newBuffer == null) {
                GUIUtilities.error((Component)DualDiffDialog.this.view, (String)"jdiff.file-not-opened", (Object[])new Object[]{new Integer(1)});
                return;
            }
            EditPane[] editPanes = DualDiffDialog.this.view.getEditPanes();
            if (editPanes.length != 2) {
                if (editPanes.length > 2) {
                    DualDiffDialog.this.view.unsplit();
                }
                DualDiffDialog.this.view.splitVertically();
                editPanes = DualDiffDialog.this.view.getEditPanes();
            }
            editPanes[0].setBuffer(baseBuffer);
            editPanes[1].setBuffer(newBuffer);
            if (!DualDiff.isEnabledFor(DualDiffDialog.this.view)) {
                DualDiff.toggleFor(DualDiffDialog.this.view);
            }
        }
    }
}

