/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.util.HashSet;
import java.util.Set;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdiff.DualDiff;
import jdiff.component.DiffOverview;
import jdiff.component.ui.BasicDiffLocalOverviewUI;
import jdiff.component.ui.DiffLocalOverviewUI;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class DiffLocalOverview
extends DiffOverview {
    private static final String uiClassID = "DiffLocalOverviewUI";
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();

    public DiffLocalOverview(DualDiff dualDiff) {
        super(dualDiff);
        this.updateUI();
    }

    public void setUI(DiffLocalOverviewUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((DiffLocalOverviewUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicDiffLocalOverviewUI());
        }
    }

    public DiffLocalOverviewUI getUI() {
        return (DiffLocalOverviewUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void caretUpdate(CaretEvent e) {
        if (e.getSource() instanceof JEditTextArea) {
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.remove(cl);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener cl : this.changeListeners) {
                cl.stateChanged(event);
            }
        }
    }

    public void moveRight(int line_number) {
        this.getUI().moveRight(line_number);
    }

    public void moveLeft(int line_number) {
        this.getUI().moveLeft(line_number);
    }
}

