/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util;

import java.io.IOException;
import jdiff.util.Diff;
import jdiff.util.DiffOutput;

public class DiffNormalOutput
extends DiffOutput {
    public DiffNormalOutput(Object[] a, Object[] b) {
        super(a, b);
    }

    public void writeScript(Diff.Change script) throws IOException {
        Diff.Change hunk = script;
        while (hunk != null) {
            this.writeHunk(hunk);
            hunk = hunk.link;
        }
        this.out.flush();
    }

    protected void writeHunk(Diff.Change hunk) throws IOException {
        int i;
        int deletes = hunk.deleted;
        int inserts = hunk.inserted;
        if (deletes == 0 && inserts == 0) {
            return;
        }
        int first0 = hunk.line0;
        int first1 = hunk.line1;
        int last0 = hunk.line0 + hunk.deleted - 1;
        int last1 = hunk.line1 + hunk.inserted - 1;
        this.writeNumberRange(',', first0, last0);
        this.out.write(DiffOutput.changeLetter(inserts, deletes));
        this.writeNumberRange(',', first1, last1);
        this.out.write(this.lineSeparator);
        if (deletes != 0) {
            for (i = first0; i <= last0; ++i) {
                this.writeLine("< ", this.file0[i]);
            }
        }
        if (inserts != 0 && deletes != 0) {
            this.out.write("---" + this.lineSeparator);
        }
        if (inserts != 0) {
            for (i = first1; i <= last1; ++i) {
                this.writeLine("> ", this.file1[i]);
            }
        }
    }
}

