/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusListener;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jdiff.DiffHighlight;
import jdiff.DiffMessage;
import jdiff.DualDiffManager;
import jdiff.component.DiffGlobalPhysicalOverview;
import jdiff.component.DiffLineOverview;
import jdiff.component.DiffLocalOverview;
import jdiff.component.DiffOverview;
import jdiff.component.DiffTextAreaModel;
import jdiff.util.Diff;
import jdiff.util.DualDiffUtil;
import jdiff.util.JDiffDiff;
import jdiff.util.ScrollHandler;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class DualDiff
implements EBComponent {
    private boolean ignoreCase;
    private boolean trimWhitespace;
    private boolean ignoreAmountOfWhitespace;
    private boolean ignoreAllWhitespace;
    private Diff.Change edits;
    private View view;
    private EditPane editPane0;
    private EditPane editPane1;
    private JEditTextArea textArea0;
    private JEditTextArea textArea1;
    private DiffOverview diffOverview0;
    private DiffOverview diffOverview1;
    private DiffLineOverview diffLineOverview;
    private ScrollHandler scrollHandler;

    protected DualDiff(View view) {
        this(view, DualDiffUtil.ignoreCaseDefault, DualDiffUtil.trimWhitespaceDefault, DualDiffUtil.ignoreAmountOfWhitespaceDefault, DualDiffUtil.ignoreAllWhitespaceDefault);
    }

    protected DualDiff(View view, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.ignoreCase = bl;
        this.trimWhitespace = bl2;
        this.ignoreAmountOfWhitespace = bl3;
        this.ignoreAllWhitespace = bl4;
        this.view = view;
        EditPane[] editPaneArray = this.view.getEditPanes();
        this.editPane0 = editPaneArray[0];
        this.editPane1 = editPaneArray[1];
        this.textArea0 = this.editPane0.getTextArea();
        this.textArea1 = this.editPane1.getTextArea();
        this.scrollHandler = new ScrollHandler(this);
        this.refresh();
    }

    public EditPane getEditPane0() {
        return this.editPane0;
    }

    public EditPane getEditPane1() {
        return this.editPane1;
    }

    public TextArea getTextArea0() {
        return this.textArea0;
    }

    public TextArea getTextArea1() {
        return this.textArea1;
    }

    public DiffOverview getDiffOverview0() {
        return this.diffOverview0;
    }

    public DiffOverview getDiffOverview1() {
        return this.diffOverview1;
    }

    public DiffLineOverview getDiffLineOverview() {
        return this.diffLineOverview;
    }

    public View getView() {
        return this.view;
    }

    public Diff.Change getEdits() {
        return this.edits;
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof BufferUpdate) {
            BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
            Buffer buffer = (Buffer)this.textArea0.getBuffer();
            Buffer buffer2 = (Buffer)this.textArea1.getBuffer();
            if (!buffer.equals(bufferUpdate.getBuffer()) && !buffer2.equals(bufferUpdate.getBuffer())) {
                return;
            }
            if (bufferUpdate.getWhat() == BufferUpdate.LOADED || bufferUpdate.getWhat() == BufferUpdate.SAVED || bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED) {
                this.refresh();
            }
        } else if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            EditPane editPane = editPaneUpdate.getEditPane();
            if (!this.view.equals(editPane.getView())) {
                return;
            }
            if (editPaneUpdate.getWhat() == EditPaneUpdate.CREATED || editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
                this.remove(true);
            } else if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
                this.refresh();
            }
        } else if (eBMessage instanceof DiffMessage) {
            DiffMessage diffMessage = (DiffMessage)eBMessage;
            if (!this.view.equals(diffMessage.getView())) {
                return;
            }
            if (DiffMessage.OFF.equals(diffMessage.getWhat())) {
                this.remove(false);
            }
        } else if (eBMessage instanceof PropertiesChanged) {
            this.setIgnoreCase(jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false));
            this.setTrimWhitespace(jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false));
            this.setIgnoreAmountOfWhitespace(jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false));
            this.setIgnoreAllWhitespace(jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false));
            this.refresh();
        }
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void toggleIgnoreCase() {
        this.ignoreCase = !this.ignoreCase;
    }

    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean bl) {
        this.trimWhitespace = bl;
    }

    public void toggleTrimWhitespace() {
        this.trimWhitespace = !this.trimWhitespace;
    }

    public boolean getIgnoreAmountOfWhitespace() {
        return this.ignoreAmountOfWhitespace;
    }

    public void setIgnoreAmountOfWhitespace(boolean bl) {
        this.ignoreAmountOfWhitespace = bl;
    }

    public void toggleIgnoreAmountOfWhitespace() {
        this.ignoreAmountOfWhitespace = !this.ignoreAmountOfWhitespace;
    }

    public boolean getIgnoreAllWhitespace() {
        return this.ignoreAllWhitespace;
    }

    public void setIgnoreAllWhitespace(boolean bl) {
        this.ignoreAllWhitespace = bl;
    }

    public void toggleIgnoreAllWhitespace() {
        this.ignoreAllWhitespace = !this.ignoreAllWhitespace;
    }

    protected void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JSplitPane jSplitPane;
                EditBus.removeFromBus((EBComponent)DualDiff.this);
                DualDiff.this.removeHandlers();
                DualDiff.this.removeHighlighters();
                DualDiff.this.removeOverviews();
                DualDiff.this.installOverviews();
                DualDiff.this.installHighlighters();
                DualDiff.this.installHandlers();
                DualDiff.this.diffLineOverview.clear();
                DiffTextAreaModel diffTextAreaModel = new DiffTextAreaModel(DualDiff.this);
                DualDiff.this.diffOverview0.setModel(diffTextAreaModel);
                DualDiff.this.diffOverview0.synchroScrollRight();
                DualDiff.this.diffOverview1.setModel(diffTextAreaModel);
                DualDiff.this.diffOverview1.repaint();
                EditBus.addToBus((EBComponent)DualDiff.this);
                DockableWindowManager dockableWindowManager = DualDiff.this.view.getDockableWindowManager();
                if (!dockableWindowManager.isDockableWindowVisible("jdiff-lines") && jEdit.getBooleanProperty((String)"jdiff.auto-show-dockable")) {
                    if (dockableWindowManager.getDockableWindow("jdiff-lines") == null) {
                        dockableWindowManager.addDockableWindow("jdiff-lines");
                    }
                    dockableWindowManager.showDockableWindow("jdiff-lines");
                }
                if ((jSplitPane = DualDiff.this.view.getSplitPane()) != null) {
                    jSplitPane.setDividerLocation(0.5);
                }
                DualDiff.this.view.invalidate();
                DualDiff.this.view.validate();
            }
        });
    }

    private void remove(boolean bl) {
        EditBus.removeFromBus((EBComponent)this);
        this.removeOverviews();
        this.removeHighlighters();
        this.removeHandlers();
        this.view.getDockableWindowManager().hideDockableWindow("jdiff-lines");
        this.diffLineOverview.setModel(null);
        if (bl) {
            DualDiffManager.removeFrom(this.view);
        }
    }

    private void installOverviews() {
        Buffer buffer = this.editPane0.getBuffer();
        Buffer buffer2 = this.editPane1.getBuffer();
        if (!buffer.isLoaded() || !buffer2.isLoaded()) {
            this.edits = null;
            this.diffOverview0 = new DiffLocalOverview(this);
            this.diffOverview1 = new DiffGlobalPhysicalOverview(this);
        } else {
            Object[] objectArray = DualDiffUtil.getFileLines(this, buffer);
            Object[] objectArray2 = DualDiffUtil.getFileLines(this, buffer2);
            JDiffDiff jDiffDiff = new JDiffDiff(objectArray, objectArray2);
            this.edits = jDiffDiff.diff_2();
            this.diffOverview0 = new DiffLocalOverview(this);
            this.diffOverview1 = new DiffGlobalPhysicalOverview(this);
            this.diffLineOverview = new DiffLineOverview(this, this.view);
        }
        this.textArea0.addLeftOfScrollBar((Component)this.diffOverview0);
        this.textArea1.addLeftOfScrollBar((Component)this.diffOverview1);
    }

    private void removeOverviews() {
        if (this.textArea0 != null && this.diffOverview0 != null) {
            this.textArea0.removeLeftOfScrollBar((Component)this.diffOverview0);
        }
        if (this.textArea1 != null && this.diffOverview1 != null) {
            this.textArea1.removeLeftOfScrollBar((Component)this.diffOverview1);
        }
    }

    private void installHighlighters() {
        DiffHighlight diffHighlight = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane0);
        if (diffHighlight == null) {
            diffHighlight = (DiffHighlight)DiffHighlight.addHighlightTo(this.editPane0, this.edits, DiffHighlight.LEFT);
            this.textArea0.getPainter().addExtension(-40, (TextAreaExtension)diffHighlight);
        } else {
            diffHighlight.setEdits(this.edits);
            diffHighlight.setPosition(DiffHighlight.LEFT);
        }
        diffHighlight.setEnabled(true);
        diffHighlight.updateTextArea();
        DiffHighlight diffHighlight2 = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane1);
        if (diffHighlight2 == null) {
            diffHighlight2 = (DiffHighlight)DiffHighlight.addHighlightTo(this.editPane1, this.edits, DiffHighlight.RIGHT);
            this.textArea1.getPainter().addExtension(-40, (TextAreaExtension)diffHighlight2);
        } else {
            diffHighlight2.setEdits(this.edits);
            diffHighlight2.setPosition(DiffHighlight.RIGHT);
        }
        diffHighlight2.setEnabled(true);
        diffHighlight2.updateTextArea();
    }

    private void removeHighlighters() {
        DiffHighlight diffHighlight;
        DiffHighlight diffHighlight2 = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane0);
        if (diffHighlight2 != null) {
            diffHighlight2.setEnabled(false);
            diffHighlight2.updateTextArea();
            DiffHighlight.removeHighlightFrom(this.editPane0);
        }
        if ((diffHighlight = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane1)) != null) {
            diffHighlight.setEnabled(false);
            diffHighlight.updateTextArea();
            DiffHighlight.removeHighlightFrom(this.editPane1);
        }
    }

    private void installHandlers() {
        this.textArea0.addScrollListener((ScrollListener)this.scrollHandler);
        this.textArea0.addFocusListener((FocusListener)this.scrollHandler);
        this.textArea1.addScrollListener((ScrollListener)this.scrollHandler);
        this.textArea1.addFocusListener((FocusListener)this.scrollHandler);
    }

    private void removeHandlers() {
        this.textArea0.removeScrollListener((ScrollListener)this.scrollHandler);
        this.textArea0.removeFocusListener((FocusListener)this.scrollHandler);
        this.textArea1.removeScrollListener((ScrollListener)this.scrollHandler);
        this.textArea1.removeFocusListener((FocusListener)this.scrollHandler);
    }

    public Font getFont() {
        return this.textArea0.getPainter().getFont();
    }

    public Color getBackground() {
        return this.textArea0.getPainter().getBackground();
    }

    protected void nextDiff0() {
        Diff.Change change = this.edits;
        int n = this.textArea0.getCaretLine();
        while (change != null) {
            if (change.first0 > n + (change.lines0 == 0 ? 1 : 0)) {
                int n2 = change.first0;
                int n3 = this.textArea0.getLineStartOffset(n2);
                this.textArea0.setCaretPosition(n3, false);
                int n4 = this.textArea0.getVisibleLines();
                int n5 = this.textArea0.getLineCount();
                int n6 = 1;
                if (n2 > n5 - n4) {
                    this.textArea0.setFirstPhysicalLine(n5 - n4);
                    n6 = n2 - (n5 - n4);
                } else {
                    this.textArea0.setFirstPhysicalLine(n2 - 1);
                }
                n3 = this.textArea1.getLineStartOffset(change.first1);
                this.textArea1.setCaretPosition(n3, false);
                this.textArea1.setFirstPhysicalLine(change.first1 - n6);
                if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
                    DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
                    if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                        this.textArea0.selectWord();
                        this.textArea1.selectWord();
                    }
                }
                if (this.textArea0.getFirstLine() != n2 && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea0.getToolkit().beep();
                }
                return;
            }
            change = change.next;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    protected void nextDiff1() {
        Diff.Change change = this.edits;
        int n = this.textArea1.getCaretLine();
        while (change != null) {
            if (change.first1 > n + (change.lines1 == 0 ? 1 : 0)) {
                int n2 = change.first1;
                int n3 = this.textArea1.getLineStartOffset(n2);
                this.textArea1.setCaretPosition(n3, false);
                int n4 = this.textArea1.getVisibleLines();
                int n5 = this.textArea1.getLineCount();
                int n6 = 1;
                if (n2 > n5 - n4) {
                    this.textArea1.setFirstPhysicalLine(n5 - n4);
                    n6 = n2 - (n5 - n4);
                } else {
                    this.textArea1.setFirstPhysicalLine(n2 - 1);
                }
                n3 = this.textArea0.getLineStartOffset(change.first0);
                this.textArea0.setCaretPosition(n3, false);
                this.textArea0.setFirstPhysicalLine(change.first0 - n6);
                if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
                    DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
                    if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                        this.textArea0.selectWord();
                        this.textArea1.selectWord();
                    }
                }
                if (this.textArea1.getFirstLine() != n2 && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea1.getToolkit().beep();
                }
                return;
            }
            change = change.next;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    protected void prevDiff0() {
        Diff.Change change = this.edits;
        int n = this.textArea0.getCaretLine();
        while (change != null) {
            if (change.first0 < n && (change.first0 + change.lines0 > n || change.next == null || change.next.first0 >= n)) {
                int n2 = change.first0;
                int n3 = this.textArea0.getLineStartOffset(n2);
                this.textArea0.setCaretPosition(n3, false);
                int n4 = this.textArea0.getVisibleLines();
                int n5 = this.textArea0.getLineCount();
                int n6 = 1;
                if (n2 > n5 - n4) {
                    this.textArea0.setFirstPhysicalLine(n5 - n4);
                    n6 = n2 - (n5 - n4);
                } else {
                    this.textArea0.setFirstPhysicalLine(n2 - 1);
                }
                n3 = this.textArea1.getLineStartOffset(change.first1);
                this.textArea1.setCaretPosition(n3, false);
                this.textArea1.setFirstPhysicalLine(change.first1 - n6);
                if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
                    DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
                    if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                        this.textArea0.selectWord();
                        this.textArea1.selectWord();
                    }
                }
                if (this.textArea0.getFirstLine() != n2 && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea0.getToolkit().beep();
                }
                return;
            }
            change = change.next;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea0.getToolkit().beep();
        }
    }

    protected void prevDiff1() {
        Diff.Change change = this.edits;
        int n = this.textArea1.getCaretLine();
        while (change != null) {
            if (change.first1 < n && (change.first1 + change.lines1 > n || change.next == null || change.next.first1 >= n)) {
                int n2 = change.first1;
                int n3 = this.textArea1.getLineStartOffset(n2);
                this.textArea1.setCaretPosition(n3, false);
                int n4 = this.textArea1.getVisibleLines();
                int n5 = this.textArea1.getLineCount();
                int n6 = 1;
                if (n2 > n5 - n4) {
                    this.textArea1.setFirstPhysicalLine(n5 - n4);
                    n6 = n2 - (n5 - n4);
                } else {
                    this.textArea1.setFirstPhysicalLine(n2 - 1);
                }
                n3 = this.textArea0.getLineStartOffset(change.first0);
                this.textArea0.setCaretPosition(n3, false);
                this.textArea0.setFirstPhysicalLine(change.first0 - n6);
                if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
                    DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
                    if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                        this.textArea0.selectWord();
                        this.textArea1.selectWord();
                    }
                }
                if (this.textArea1.getFirstLine() != n2 && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea1.getToolkit().beep();
                }
                return;
            }
            change = change.next;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    protected void moveRight(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        if (editPane.equals(this.editPane0)) {
            this.diffOverview0.moveRight(editPane.getTextArea().getCaretLine());
        } else {
            Diff.Change change = this.edits;
            int n = editPane.getTextArea().getCaretLine();
            while (change != null) {
                if (change.first1 <= n && n <= change.last1) {
                    this.diffOverview0.moveRight(change.first0);
                    return;
                }
                change = change.next;
            }
        }
    }

    protected void moveLeft(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        if (editPane.equals(this.editPane1)) {
            this.diffOverview0.moveLeft(editPane.getTextArea().getCaretLine());
        } else {
            Diff.Change change = this.edits;
            int n = editPane.getTextArea().getCaretLine();
            while (change != null) {
                if (change.first0 <= n && n <= change.last0) {
                    this.diffOverview0.moveLeft(change.first1);
                    return;
                }
                change = change.next;
            }
        }
    }

    protected void moveMultipleRight(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        Diff.Change change = this.edits;
        while (change.next != null) {
            change = change.next;
        }
        while (change != null) {
            if (change.lines1 == 0) {
                this.diffOverview0.moveRight(change.first0);
            }
            change = change.prev;
        }
    }

    protected void moveMultipleLeft(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        Diff.Change change = this.edits;
        while (change.next != null) {
            change = change.next;
        }
        while (change != null) {
            if (change.lines0 == 0) {
                this.diffOverview0.moveLeft(change.first1);
            }
            change = change.prev;
        }
    }
}

