/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.util.HashMap;
import jdiff.DualDiff;
import jdiff.DualDiffManager;
import jdiff.text.FileLine;
import jdiff.util.Diff;
import jdiff.util.DualDiffUtil;
import jdiff.util.JDiffDiff;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffTextAreaModel {
    private DualDiff dualDiff;
    private Diff.Change edits = null;
    private HashMap<Integer, Diff.Change> leftHunkMap = null;
    private HashMap<Integer, Diff.Change> rightHunkMap = null;
    private int leftLineCount;
    private int rightLineCount;
    private JEditTextArea leftTextArea;
    private JEditTextArea rightTextArea;

    public DiffTextAreaModel(DualDiff dualDiff) {
        this.dualDiff = dualDiff;
        this.prepData();
    }

    public Diff.Change getEdits() {
        return this.edits;
    }

    public int getLeftLineCount() {
        return this.leftLineCount;
    }

    public int getRightLineCount() {
        return this.rightLineCount;
    }

    public JEditTextArea getLeftTextArea() {
        return this.leftTextArea;
    }

    public JEditTextArea getRightTextArea() {
        return this.rightTextArea;
    }

    public HashMap<Integer, Diff.Change> getLeftHunkMap() {
        return this.leftHunkMap;
    }

    public HashMap<Integer, Diff.Change> getRightHunkMap() {
        return this.rightHunkMap;
    }

    private void prepData() {
        EditPane editPane0 = this.dualDiff.getEditPane0();
        EditPane editPane1 = this.dualDiff.getEditPane1();
        Buffer buf0 = editPane0.getBuffer();
        Buffer buf1 = editPane1.getBuffer();
        this.leftTextArea = editPane0.getTextArea();
        this.rightTextArea = editPane1.getTextArea();
        if (!buf0.isLoaded() || !buf1.isLoaded()) {
            this.edits = null;
            this.leftLineCount = buf0.isLoaded() ? buf0.getLineCount() : 1;
            this.rightLineCount = buf1.isLoaded() ? buf1.getLineCount() : 1;
        } else {
            Object[] fileLines0 = this.getFileLines(buf0);
            Object[] fileLines1 = this.getFileLines(buf1);
            JDiffDiff d = new JDiffDiff(fileLines0, fileLines1);
            this.edits = d.diff_2();
            this.leftHunkMap = new HashMap();
            this.rightHunkMap = new HashMap();
            Diff.Change hunk = this.edits;
            while (hunk != null) {
                int i;
                for (i = 0; i < Math.max(1, hunk.lines0); ++i) {
                    this.leftHunkMap.put(hunk.first0 + i, hunk);
                }
                for (i = 0; i < Math.max(1, hunk.lines1); ++i) {
                    this.rightHunkMap.put(hunk.first1 + i, hunk);
                }
                hunk = hunk.next;
            }
            this.leftLineCount = fileLines0.length;
            this.rightLineCount = fileLines1.length;
        }
    }

    private FileLine[] getFileLines(Buffer buffer) {
        FileLine[] lines = new FileLine[buffer.getLineCount()];
        for (int i = buffer.getLineCount() - 1; i >= 0; --i) {
            int start = buffer.getLineStartOffset(i);
            int end = buffer.getLineEndOffset(i);
            int len = end - 1 - start;
            if (len == 0) {
                lines[i] = new FileLine("", "");
                continue;
            }
            String text = "";
            String canonical = "";
            canonical = text = buffer.getText(start, len);
            if (DualDiffManager.getIgnoreCaseFor(this.dualDiff.getView())) {
                canonical = canonical.toUpperCase();
            }
            if (DualDiffManager.getTrimWhitespaceFor(this.dualDiff.getView()) && !DualDiffManager.getIgnoreAllWhitespaceFor(this.dualDiff.getView())) {
                canonical = DualDiffUtil.trimWhitespaces(canonical);
            }
            if (DualDiffManager.getIgnoreAmountOfWhitespaceFor(this.dualDiff.getView()) && !DualDiffManager.getIgnoreAllWhitespaceFor(this.dualDiff.getView())) {
                canonical = DualDiffUtil.squeezeRepeatedWhitespaces(canonical);
            }
            if (DualDiffManager.getIgnoreAllWhitespaceFor(this.dualDiff.getView())) {
                canonical = DualDiffUtil.removeWhitespaces(canonical);
            }
            lines[i] = new FileLine(text, canonical);
        }
        return lines;
    }
}

