/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.awt.Color;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdiff.DualDiff;
import jdiff.DualDiffManager;
import jdiff.component.DiffLineModel;
import jdiff.component.ui.BasicLineRendererPaneUI;
import jdiff.component.ui.LineRendererPaneUI;
import jdiff.util.Diff;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class LineRendererPane
extends JComponent
implements EBComponent,
CaretListener {
    private static final String uiClassID = "LineRendererPaneUI";
    private View view = null;
    private DiffLineModel diffLineModel = null;
    private LineProcessorRunner runner = new LineProcessorRunner();
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();

    public LineRendererPane(View view) {
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        this.view = view;
        this.updateUI();
        EditBus.addToBus((EBComponent)this);
    }

    public void setUI(LineRendererPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((LineRendererPaneUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicLineRendererPaneUI());
        }
        this.fireStateChanged();
    }

    public LineRendererPaneUI getUI() {
        return (LineRendererPaneUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void addChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.remove(cl);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener cl : this.changeListeners) {
                cl.stateChanged(event);
            }
        }
    }

    public View getView() {
        return this.view;
    }

    public void setModel(DiffLineModel model) {
        this.diffLineModel = model;
        this.fireStateChanged();
    }

    public DiffLineModel getModel() {
        return this.diffLineModel;
    }

    public Color getBackground() {
        return this.view.getEditPane().getTextArea().getPainter().getBackground();
    }

    public Font getFont() {
        return this.view.getEditPane().getTextArea().getPainter().getFont();
    }

    public void clear() {
        this.setModel(null);
    }

    public void reset() {
        this.fireStateChanged();
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)message;
            if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
                this.fireStateChanged();
            }
        } else if (message instanceof ViewUpdate) {
            this.fireStateChanged();
        }
        this.maybeAddCaretListeners();
    }

    private void maybeAddCaretListeners() {
        if (this.view == null) {
            return;
        }
        for (EditPane ep : this.view.getEditPanes()) {
            ep.getTextArea().removeCaretListener((CaretListener)this);
        }
        if (this.view.getEditPanes().length == 2) {
            this.view.getEditPanes()[0].getTextArea().addCaretListener((CaretListener)this);
            this.view.getEditPanes()[1].getTextArea().addCaretListener((CaretListener)this);
        }
    }

    public void caretUpdate(CaretEvent e) {
        if (e.getSource() instanceof JEditTextArea) {
            JEditTextArea source = (JEditTextArea)e.getSource();
            this.runner.setSource(source);
            SwingUtilities.invokeLater(this.runner);
        }
    }

    class LineProcessorRunner
    implements Runnable {
        JEditTextArea source = null;

        LineProcessorRunner() {
        }

        public void setSource(JEditTextArea source) {
            this.source = source;
        }

        public void run() {
            if (this.source == null) {
                LineRendererPane.this.setModel(null);
                return;
            }
            DualDiff dualDiff = DualDiffManager.getDualDiffFor(LineRendererPane.this.view);
            if (dualDiff == null) {
                LineRendererPane.this.setModel(null);
                return;
            }
            Diff.Change hunk = dualDiff.getEdits();
            if (hunk == null) {
                LineRendererPane.this.setModel(null);
                return;
            }
            JEditTextArea textArea0 = LineRendererPane.this.view.getEditPanes()[0].getTextArea();
            JEditTextArea textArea1 = LineRendererPane.this.view.getEditPanes()[1].getTextArea();
            String leftLine = "";
            String rightLine = "";
            if (this.source == textArea0) {
                int caretLine = textArea0.getCaretLine();
                while (hunk != null) {
                    if (caretLine >= hunk.first0 && caretLine < hunk.first0 + hunk.lines0) {
                        leftLine = hunk.lines0 == 0 && hunk.first0 > 0 ? "" : textArea0.getLineText(caretLine);
                        int offset = caretLine - hunk.first0;
                        rightLine = offset < hunk.lines1 ? textArea1.getLineText(hunk.first1 + offset) : "";
                        break;
                    }
                    hunk = hunk.next;
                }
            } else {
                int caretLine = textArea1.getCaretLine();
                while (hunk != null) {
                    if (caretLine >= hunk.first1 && caretLine < hunk.first1 + hunk.lines1) {
                        rightLine = hunk.lines1 == 0 && hunk.first1 > 0 ? "" : textArea1.getLineText(caretLine);
                        int offset = caretLine - hunk.first1;
                        leftLine = offset < hunk.lines0 ? textArea0.getLineText(hunk.first0 + offset) : "";
                        break;
                    }
                    hunk = hunk.next;
                }
            }
            if (leftLine.equals("") && rightLine.equals("") || leftLine.equals(rightLine)) {
                LineRendererPane.this.setModel(null);
            } else {
                LineRendererPane.this.setModel(new DiffLineModel(leftLine, rightLine));
            }
        }
    }
}

