/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import jdiff.component.DiffLineModel;
import jdiff.component.LineRendererPane;
import jdiff.component.ui.DiffLineOverviewUI;
import org.gjt.sp.jedit.jEdit;

public class BasicLineRendererPaneUI
extends DiffLineOverviewUI
implements ChangeListener {
    private LineRendererPane lineRendererPane = null;
    private JScrollPane scrollPane = null;
    private DiffLineModel model;
    private LineRenderer lineRenderer = null;
    private Color fgColor = jEdit.getColorProperty((String)"view.fgColor", (Color)Color.BLACK);

    public static ComponentUI createUI(JComponent c) {
        return new BasicLineRendererPaneUI();
    }

    public void installUI(JComponent c) {
        this.lineRendererPane = (LineRendererPane)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void installDefaults() {
        this.lineRendererPane.setLayout(this.createLayoutManager());
        this.lineRendererPane.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    public void installComponents() {
        this.lineRenderer = new LineRenderer();
        this.scrollPane = new JScrollPane(this.lineRenderer);
        this.lineRendererPane.add((Component)this.scrollPane, "Center");
    }

    public void installListeners() {
        this.lineRendererPane.addChangeListener(this);
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.lineRendererPane = null;
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
        this.lineRenderer = null;
    }

    public void uninstallListeners() {
        this.lineRendererPane.removeChangeListener(this);
    }

    public void stateChanged(ChangeEvent event) {
        this.lineRenderer.repaint();
        if (this.lineRendererPane.getModel() != null) {
            String leftLine = this.lineRendererPane.getModel().getLeftLine();
            String rightLine = this.lineRendererPane.getModel().getRightLine();
            String longLine = leftLine.length() > rightLine.length() ? leftLine : rightLine;
            String shortLine = leftLine.length() <= rightLine.length() ? leftLine : rightLine;
            int offset = shortLine.length();
            for (int i = 0; i < shortLine.length(); ++i) {
                if (shortLine.charAt(i) == longLine.charAt(i)) continue;
                offset = i;
                break;
            }
            int max_length = longLine.length();
            float percent = (float)offset / (float)max_length;
            int vp_offset = (int)((float)this.scrollPane.getViewport().getViewRect().width * percent);
            Point p = this.scrollPane.getViewport().getViewPosition();
            p.x = vp_offset;
            this.scrollPane.getViewport().setViewPosition(p);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public class LineRenderer
    extends JPanel {
        private int leftMargin = 6;
        private int preferredWidth = 600;
        private int preferredHeight = 100;
        private Dimension minimumSize = new Dimension(600, 100);

        public LineRenderer() {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }

        public Dimension getMinimumSize() {
            return this.minimumSize;
        }

        private boolean isSplit() {
            if (BasicLineRendererPaneUI.this.lineRendererPane.getView() == null) {
                return false;
            }
            return BasicLineRendererPaneUI.this.lineRendererPane.getView().getEditPanes().length == 2;
        }

        public void paintComponent(Graphics gfx) {
            Color color;
            if (!"none".equals(jEdit.getProperty((String)"view.antiAlias"))) {
                ((Graphics2D)gfx).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            super.paintComponent(gfx);
            Rectangle all = this.getBounds();
            gfx.setColor(BasicLineRendererPaneUI.this.lineRendererPane.getBackground());
            gfx.fillRect(0, 0, all.width, all.height);
            if (!this.isSplit()) {
                return;
            }
            BasicLineRendererPaneUI.this.model = BasicLineRendererPaneUI.this.lineRendererPane.getModel();
            if (BasicLineRendererPaneUI.this.model == null) {
                return;
            }
            String leftLine = BasicLineRendererPaneUI.this.model.getLeftLine();
            String rightLine = BasicLineRendererPaneUI.this.model.getRightLine();
            Font font = BasicLineRendererPaneUI.this.lineRendererPane.getFont();
            gfx.setFont(font);
            FontMetrics fm = gfx.getFontMetrics();
            this.preferredHeight = 8 * fm.getHeight();
            int x = this.leftMargin;
            gfx.setColor(BasicLineRendererPaneUI.this.fgColor);
            gfx.drawString("Left", x, fm.getHeight());
            int left_width = fm.stringWidth(leftLine);
            int tick_height = fm.getHeight() / 2;
            int y = fm.getHeight() + tick_height;
            gfx.drawLine(x, y, x + left_width, y);
            gfx.drawLine(x, y, x, y + tick_height);
            gfx.drawLine(x + left_width, y, x + left_width, y + tick_height);
            this.preferredWidth = Math.max(this.minimumSize.width, x + left_width + this.leftMargin);
            x = this.leftMargin;
            int y0 = 3 * fm.getHeight();
            int y1 = y0 + fm.getHeight() + 3;
            List<Character> leftChars = BasicLineRendererPaneUI.this.model.getLeftCharacters();
            List<Color> leftColors = BasicLineRendererPaneUI.this.model.getLeftColors();
            for (int i = 0; i < leftChars.size(); ++i) {
                char c = leftChars.get(i).charValue();
                color = leftColors.get(i);
                gfx.setColor(color);
                gfx.fillRect(x, y0 - fm.getHeight() + fm.getDescent(), fm.charWidth(c), fm.getHeight());
                gfx.setColor(BasicLineRendererPaneUI.this.fgColor);
                gfx.drawString(String.valueOf(c), x, y0);
                x += fm.charWidth(c);
            }
            x = this.leftMargin;
            List<Character> rightChars = BasicLineRendererPaneUI.this.model.getRightCharacters();
            List<Color> rightColors = BasicLineRendererPaneUI.this.model.getRightColors();
            for (int i = 0; i < rightChars.size(); ++i) {
                char c = rightChars.get(i).charValue();
                color = rightColors.get(i);
                gfx.setColor(color);
                gfx.fillRect(x, y1 - fm.getHeight() + fm.getDescent(), fm.charWidth(c), fm.getHeight());
                gfx.setColor(BasicLineRendererPaneUI.this.fgColor);
                gfx.drawString(String.valueOf(c), x, y1);
                x += fm.charWidth(c);
            }
            x = this.leftMargin;
            gfx.setColor(BasicLineRendererPaneUI.this.fgColor);
            gfx.setFont(font);
            gfx.drawString("Right", x, 6 * fm.getHeight());
            int right_width = fm.stringWidth(rightLine);
            y = y1 + fm.getHeight() / 2;
            gfx.drawLine(x, y, x + right_width, y);
            gfx.drawLine(x, y, x, y - tick_height);
            gfx.drawLine(x + right_width, y, x + right_width, y - tick_height);
            this.preferredWidth = Math.max(this.preferredWidth, x + right_width + this.leftMargin);
            BasicLineRendererPaneUI.this.scrollPane.revalidate();
        }
    }
}

