/*
 * Decompiled with CFR 0.152.
 */
package jdiff.options;

import ise.java.awt.KappaLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.jEdit;

public class JDiffOptionPane
implements OptionPane {
    private JPanel panel = null;
    private JCheckBox ignoreCase;
    private JCheckBox trimWhitespace;
    private JCheckBox ignoreAmountOfWhitespace;
    private JCheckBox ignoreAllWhitespace;
    private JCheckBox heuristic;
    private JCheckBox no_discards;
    private JCheckBox autoShowDockable;
    private JCheckBox beepOnError;
    private JCheckBox showLineDiff;
    private JCheckBox restoreView;
    private JCheckBox restoreCaret;
    private JCheckBox synchroScroll;
    private JCheckBox horizScroll;
    private JCheckBox selectWord;
    private JRadioButton horizontal;
    private JRadioButton vertical;
    private JRadioButton compact;

    public String getName() {
        return jEdit.getProperty((String)"jdiff.general");
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.createPanel();
        }
        return this.panel;
    }

    public void init() {
        if (this.panel == null) {
            this.createPanel();
        }
        this.ignoreCase.setSelected(jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false));
        this.trimWhitespace.setSelected(jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false));
        this.ignoreAmountOfWhitespace.setSelected(jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false));
        this.ignoreAllWhitespace.setSelected(jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false));
        this.heuristic.setSelected(jEdit.getBooleanProperty((String)"jdiff.heuristic", (boolean)false));
        this.no_discards.setSelected(jEdit.getBooleanProperty((String)"jdiff.no_discards", (boolean)false));
        this.autoShowDockable.setSelected(jEdit.getBooleanProperty((String)"jdiff.auto-show-dockable", (boolean)false));
        this.showLineDiff.setSelected(jEdit.getBooleanProperty((String)"jdiff.show-line-diff", (boolean)true));
        this.synchroScroll.setSelected(jEdit.getBooleanProperty((String)"jdiff.synchroscroll-on", (boolean)true));
        this.horizScroll.setSelected(jEdit.getBooleanProperty((String)"jdiff.horiz-scroll", (boolean)false));
        this.selectWord.setSelected(jEdit.getBooleanProperty((String)"jdiff.select-word", (boolean)false));
        this.selectWord.setEnabled(this.horizScroll.isSelected());
        this.beepOnError.setSelected(jEdit.getBooleanProperty((String)"jdiff.beep-on-error", (boolean)true));
        this.restoreView.setSelected(jEdit.getBooleanProperty((String)"jdiff.restore-view", (boolean)true));
        this.restoreCaret.setSelected(jEdit.getBooleanProperty((String)"jdiff.restore-caret", (boolean)true));
        int orientation = jEdit.getIntegerProperty((String)"jdiff.toolbar-orientation", (int)1);
        switch (orientation) {
            case 2: {
                this.horizontal.setSelected(false);
                this.vertical.setSelected(true);
                this.compact.setSelected(false);
                break;
            }
            case 3: {
                this.horizontal.setSelected(false);
                this.vertical.setSelected(false);
                this.compact.setSelected(true);
                break;
            }
            default: {
                this.horizontal.setSelected(true);
                this.vertical.setSelected(false);
                this.compact.setSelected(false);
            }
        }
    }

    private void createPanel() {
        JLabel diff_options_label = new JLabel(jEdit.getProperty((String)"options.diff-options.label", (String)"Diff Options:"));
        this.ignoreCase = this.createCheckBox("jdiff.ignore-case", false);
        this.trimWhitespace = this.createCheckBox("jdiff.trim-whitespace", false);
        this.ignoreAmountOfWhitespace = this.createCheckBox("jdiff.ignore-amount-whitespace", false);
        this.ignoreAllWhitespace = this.createCheckBox("jdiff.ignore-all-whitespace", false);
        this.heuristic = this.createCheckBox("jdiff.heuristic", false);
        this.no_discards = this.createCheckBox("jdiff.no_discards", false);
        JLabel ui_options_label = new JLabel(jEdit.getProperty((String)"options.ui-options.label", (String)"UI Options:"));
        this.autoShowDockable = this.createCheckBox("jdiff.auto-show-dockable", false);
        this.showLineDiff = this.createCheckBox("jdiff.show-line-diff", true);
        this.synchroScroll = this.createCheckBox("jdiff.synchroscroll-on", true);
        this.horizScroll = this.createCheckBox("jdiff.horiz-scroll", false);
        this.selectWord = this.createCheckBox("jdiff.select-word", false);
        this.selectWord.setEnabled(this.horizScroll.isSelected());
        this.beepOnError = this.createCheckBox("jdiff.beep-on-error", true);
        this.restoreView = this.createCheckBox("jdiff.restore-view", true);
        this.restoreCaret = this.createCheckBox("jdiff.restore-caret", true);
        this.horizScroll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                boolean selected = ((JCheckBox)ae.getSource()).isSelected();
                JDiffOptionPane.this.selectWord.setEnabled(selected);
                JDiffOptionPane.this.selectWord.setSelected(selected);
            }
        });
        int orientation = jEdit.getIntegerProperty((String)"jdiff.toolbar-orientation", (int)1);
        this.horizontal = new JRadioButton(jEdit.getProperty((String)"options.jdiff.toolbar-horizontal"));
        this.vertical = new JRadioButton(jEdit.getProperty((String)"options.jdiff.toolbar-vertical"));
        this.compact = new JRadioButton(jEdit.getProperty((String)"options.jdiff.toolbar-compact"));
        ButtonGroup button_group = new ButtonGroup();
        button_group.add(this.horizontal);
        button_group.add(this.vertical);
        button_group.add(this.compact);
        switch (orientation) {
            case 2: {
                this.horizontal.setSelected(false);
                this.vertical.setSelected(true);
                this.compact.setSelected(false);
                break;
            }
            case 3: {
                this.horizontal.setSelected(false);
                this.vertical.setSelected(false);
                this.compact.setSelected(true);
                break;
            }
            default: {
                this.horizontal.setSelected(true);
                this.vertical.setSelected(false);
                this.compact.setSelected(false);
            }
        }
        JLabel orientation_label = new JLabel(jEdit.getProperty((String)"options.toolbar-orientation.label", (String)"Merge Toolbar Orientation:"));
        this.panel = new JPanel();
        this.panel.setLayout((LayoutManager)new KappaLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(12, 11, 11, 12));
        this.panel.add("0,  0, 2, 1, W, 0, 2", diff_options_label);
        this.panel.add("0,  1, 2, 1, W, 0, 2", this.ignoreCase);
        this.panel.add("0,  2, 2, 1, W, 0, 2", this.trimWhitespace);
        this.panel.add("0,  3, 2, 1, W, 0, 2", this.ignoreAmountOfWhitespace);
        this.panel.add("0,  4, 2, 1, W, 0, 2", this.ignoreAllWhitespace);
        this.panel.add("0,  5, 2, 1, W, 0, 2", this.heuristic);
        this.panel.add("0,  6, 2, 1, W, 0, 2", this.no_discards);
        this.panel.add("0,  7, 2, 1, W, 0, 2", KappaLayout.createVerticalStrut((int)11));
        this.panel.add("0,  8, 2, 1, W, 0, 2", ui_options_label);
        this.panel.add("0,  9, 2, 1, W, 0, 2", this.autoShowDockable);
        this.panel.add("0, 10, 2, 1, W, 0, 2", this.showLineDiff);
        this.panel.add("0, 11, 2, 1, W, 0, 2", this.synchroScroll);
        this.panel.add("0, 12, 2, 1, W, 0, 2", this.horizScroll);
        this.panel.add("0, 13, 1, 1, W, 0, 2", KappaLayout.createHorizontalStrut((int)16, (boolean)true));
        this.panel.add("1, 14, 1, 1, W, 0, 2", this.selectWord);
        this.panel.add("0, 15, 2, 1, W, 0, 2", this.beepOnError);
        this.panel.add("0, 16, 2, 1, W, 0, 2", this.restoreView);
        this.panel.add("0, 17, 2, 1, W, 0, 2", this.restoreCaret);
        this.panel.add("0, 18, 2, 1, W, 0, 2", KappaLayout.createVerticalStrut((int)11));
        this.panel.add("0, 19, 2, 1, W, 0, 2", orientation_label);
        this.panel.add("0, 20, 2, 1, W, 0, 2", this.horizontal);
        this.panel.add("0, 21, 2, 1, W, 0, 2", this.vertical);
        this.panel.add("0, 22, 2, 1, W, 0, 2", this.compact);
    }

    public void save() {
        if (this.vertical.isSelected()) {
            jEdit.setIntegerProperty((String)"jdiff.toolbar-orientation", (int)2);
        } else if (this.compact.isSelected()) {
            jEdit.setIntegerProperty((String)"jdiff.toolbar-orientation", (int)3);
        } else {
            jEdit.setIntegerProperty((String)"jdiff.toolbar-orientation", (int)1);
        }
        jEdit.setBooleanProperty((String)"jdiff.ignore-case", (boolean)this.ignoreCase.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.trim-whitespace", (boolean)this.trimWhitespace.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)this.ignoreAmountOfWhitespace.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)this.ignoreAllWhitespace.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.heuristic", (boolean)this.heuristic.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.no_discards", (boolean)this.no_discards.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.auto-show-dockable", (boolean)this.autoShowDockable.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.show-line-diff", (boolean)this.showLineDiff.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.synchroscroll-on", (boolean)this.synchroScroll.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.horiz-scroll", (boolean)this.horizScroll.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.select-word", (boolean)this.selectWord.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.beep-on-error", (boolean)this.beepOnError.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.restore-view", (boolean)this.restoreView.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.restore-caret", (boolean)this.restoreCaret.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.global-virtual-overview", (boolean)false);
    }

    private JCheckBox createCheckBox(String property, boolean defaultValue) {
        JCheckBox cb = new JCheckBox(jEdit.getProperty((String)("options." + property)));
        cb.setSelected(jEdit.getBooleanProperty((String)property, (boolean)defaultValue));
        return cb;
    }
}

