/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.awt.Color;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdiff.DualDiff;
import jdiff.component.DiffLineModel;
import jdiff.component.LineProcessor;
import jdiff.component.ui.BasicDiffLineOverviewUI;
import jdiff.component.ui.DiffLineOverviewUI;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.msg.PropertiesChanged;

public class DiffLineOverview
extends JComponent
implements LineProcessor,
EBComponent {
    private static final String uiClassID = "DiffLineOverviewUI";
    private DualDiff dualDiff = null;
    private View view = null;
    private DiffLineModel diffLineModel = null;
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();

    public DiffLineOverview(DualDiff dualDiff, View view) {
        this.dualDiff = dualDiff;
        this.view = view;
        this.updateUI();
        EditBus.addToBus((EBComponent)this);
    }

    public DiffLineOverview(View view) {
        this.view = view;
        this.updateUI();
        EditBus.addToBus((EBComponent)this);
    }

    public void processLines(String leftLine, String rightLine) {
        if (leftLine == null || rightLine == null) {
            return;
        }
        this.setModel(new DiffLineModel(leftLine, rightLine));
    }

    public void setUI(DiffLineOverviewUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((DiffLineOverviewUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicDiffLineOverviewUI());
        }
        this.fireStateChanged();
    }

    public DiffLineOverviewUI getUI() {
        return (DiffLineOverviewUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void addChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.remove(cl);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener cl : this.changeListeners) {
                cl.stateChanged(event);
            }
        }
    }

    public DualDiff getDualDiff() {
        return this.dualDiff;
    }

    public View getView() {
        return this.view;
    }

    public void setModel(DiffLineModel model) {
        this.diffLineModel = model;
        this.fireStateChanged();
    }

    public DiffLineModel getModel() {
        return this.diffLineModel;
    }

    public Color getBackground() {
        if (this.dualDiff != null) {
            return this.dualDiff.getBackground();
        }
        return this.view.getEditPane().getTextArea().getPainter().getBackground();
    }

    public Font getFont() {
        if (this.dualDiff != null) {
            return this.dualDiff.getFont();
        }
        return this.view.getEditPane().getTextArea().getPainter().getFont();
    }

    public void clear() {
        this.setModel(null);
    }

    public void reset() {
        this.fireStateChanged();
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof PropertiesChanged) {
            this.fireStateChanged();
        }
    }
}

