/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import jdiff.DualDiffManager;
import jdiff.JDiffPlugin;
import jdiff.component.DiffLocalOverview;
import jdiff.component.DiffTextAreaModel;
import jdiff.component.ui.DiffLocalOverviewUI;
import jdiff.util.Diff;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class BasicDiffLocalOverviewUI
extends DiffLocalOverviewUI
implements MouseListener,
ChangeListener,
CaretListener {
    private DiffLocalOverview diffLocalOverview;
    private LocalRendererPane localRendererPane;
    private Rectangle leftBorder;
    private Rectangle rightBorder;
    private int pixelsPerLine = 1;
    private int leftVisibleLineCount;
    private int rightVisibleLineCount;
    private Rectangle leftRectangle;
    private Rectangle rightRectangle;
    private Rectangle centerRectangle;
    private HashMap<Diff.Change, Point> leftConnectors = new HashMap();
    private HashMap<Diff.Change, Point> rightConnectors = new HashMap();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDiffLocalOverviewUI();
    }

    public void installUI(JComponent jComponent) {
        this.diffLocalOverview = (DiffLocalOverview)jComponent;
        this.diffLocalOverview.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.diffLocalOverview = null;
    }

    public void installDefaults() {
    }

    public void installComponents() {
        this.localRendererPane = new LocalRendererPane();
        this.diffLocalOverview.add((Component)this.localRendererPane, "Center");
    }

    public void installListeners() {
        this.diffLocalOverview.addMouseListener(this);
        this.diffLocalOverview.addChangeListener(this);
        this.diffLocalOverview.getModel().getLeftTextArea().addCaretListener((CaretListener)this);
        this.diffLocalOverview.getModel().getRightTextArea().addCaretListener((CaretListener)this);
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
        this.diffLocalOverview.remove(this.localRendererPane);
        this.diffLocalOverview = null;
    }

    public void uninstallListeners() {
        this.diffLocalOverview.removeMouseListener(this);
        this.diffLocalOverview.removeChangeListener(this);
        this.diffLocalOverview.getModel().getLeftTextArea().removeCaretListener((CaretListener)this);
        this.diffLocalOverview.getModel().getRightTextArea().removeCaretListener((CaretListener)this);
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.localRendererPane.repaint();
    }

    private void fillLeft(Graphics graphics, DiffTextAreaModel diffTextAreaModel) {
        int n = diffTextAreaModel.getLeftTextArea().getFirstPhysicalLine();
        int n2 = diffTextAreaModel.getLeftTextArea().getLastPhysicalLine();
        HashMap<Integer, Diff.Change> hashMap = diffTextAreaModel.getLeftHunkMap();
        if (hashMap != null) {
            Diff.Change change;
            int n3;
            for (n3 = n; n3 <= n2; ++n3) {
                int n4;
                int n5;
                Color color;
                change = hashMap.get(n3);
                boolean bl = false;
                int n6 = 0;
                if (change == null) continue;
                if (change.lines0 == 0) {
                    color = JDiffPlugin.overviewInvalidColor;
                    this.leftRectangle.height = 1;
                    this.leftRectangle.y = this.centerRectangle.y + diffTextAreaModel.getLeftTextArea().getScreenLineOfOffset(diffTextAreaModel.getLeftTextArea().getLineStartOffset(change.first0)) * this.pixelsPerLine;
                } else {
                    color = change.lines1 == 0 ? JDiffPlugin.overviewDeletedColor : JDiffPlugin.overviewChangedColor;
                    n5 = diffTextAreaModel.getLeftTextArea().getLineStartOffset(change.first0);
                    n4 = diffTextAreaModel.getLeftTextArea().getLineStartOffset(change.last0) + diffTextAreaModel.getLeftTextArea().getLineText(change.last0).length();
                    int n7 = diffTextAreaModel.getLeftTextArea().getScreenLineOfOffset(n5);
                    int n8 = diffTextAreaModel.getLeftTextArea().getScreenLineOfOffset(n4);
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (n8 < 0) {
                        n8 = diffTextAreaModel.getLeftTextArea().getLastScreenLine();
                    }
                    this.leftRectangle.height = (n8 - n7 + 1) * this.pixelsPerLine;
                    this.leftRectangle.y = this.centerRectangle.y + n7 * this.pixelsPerLine;
                }
                graphics.setColor(color);
                graphics.fillRect(this.leftRectangle.x, this.leftRectangle.y, this.leftRectangle.width, this.leftRectangle.height);
                this.leftConnectors.put(change, new Point(this.leftRectangle.x + this.leftRectangle.width + 1, this.leftRectangle.y));
                if (change.lines0 > 0) {
                    graphics.setColor(Color.BLACK);
                    n5 = (this.pixelsPerLine - 2) % 2 == 0 ? this.pixelsPerLine - 3 : this.pixelsPerLine - 2;
                    for (n4 = 0; n4 < 6; ++n4) {
                        graphics.drawLine(this.leftRectangle.x + 2 + n4, this.leftRectangle.y + 1 + n4, this.leftRectangle.x + 2 + n4, this.leftRectangle.y + n4 + n5 - 2 * n4);
                    }
                }
                n3 += n6;
            }
            n3 = diffTextAreaModel.getLeftTextArea().getCaretLine();
            change = hashMap.get(n3);
            if (change != null && diffTextAreaModel.getLeftTextArea().getView().getEditPane().getTextArea().equals(diffTextAreaModel.getLeftTextArea())) {
                this.paintCurrentHunkCursor(graphics, change);
            }
        }
    }

    private void fillRight(Graphics graphics, DiffTextAreaModel diffTextAreaModel) {
        int n = diffTextAreaModel.getRightTextArea().getFirstPhysicalLine();
        int n2 = diffTextAreaModel.getRightTextArea().getLastPhysicalLine();
        HashMap<Integer, Diff.Change> hashMap = diffTextAreaModel.getRightHunkMap();
        if (hashMap != null) {
            Diff.Change change;
            int n3;
            for (n3 = n; n3 <= n2; ++n3) {
                int n4;
                int n5;
                int n6;
                Color color;
                change = hashMap.get(n3);
                boolean bl = false;
                int n7 = 0;
                if (change == null) continue;
                if (change.lines1 == 0) {
                    color = JDiffPlugin.overviewInvalidColor;
                    this.rightRectangle.height = 1;
                    this.rightRectangle.y = this.centerRectangle.y + diffTextAreaModel.getRightTextArea().getScreenLineOfOffset(diffTextAreaModel.getRightTextArea().getLineStartOffset(change.first1)) * this.pixelsPerLine;
                } else {
                    color = change.lines0 == 0 ? JDiffPlugin.overviewInsertedColor : JDiffPlugin.overviewChangedColor;
                    n6 = diffTextAreaModel.getRightTextArea().getLineStartOffset(change.first1);
                    n5 = diffTextAreaModel.getRightTextArea().getLineStartOffset(change.last1) + diffTextAreaModel.getRightTextArea().getLineText(change.last1).length();
                    n4 = diffTextAreaModel.getRightTextArea().getScreenLineOfOffset(n6);
                    int n8 = diffTextAreaModel.getRightTextArea().getScreenLineOfOffset(n5);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n8 < 0) {
                        n8 = diffTextAreaModel.getRightTextArea().getLastScreenLine();
                    }
                    this.rightRectangle.height = (n8 - n4 + 1) * this.pixelsPerLine;
                    this.rightRectangle.y = this.centerRectangle.y + n4 * this.pixelsPerLine;
                }
                graphics.setColor(color);
                graphics.fillRect(this.rightRectangle.x, this.rightRectangle.y, this.rightRectangle.width, this.rightRectangle.height);
                this.rightConnectors.put(change, new Point(this.rightRectangle.x - 1, this.rightRectangle.y));
                if (change.lines1 > 0) {
                    graphics.setColor(Color.BLACK);
                    n6 = (this.pixelsPerLine - 2) % 2 == 0 ? this.pixelsPerLine - 3 : this.pixelsPerLine - 2;
                    n5 = n6 / 2 + 1;
                    for (n4 = 0; n4 < 6; ++n4) {
                        graphics.drawLine(this.rightRectangle.x + 1 + n4, this.rightRectangle.y + n5 - n4, this.rightRectangle.x + 1 + n4, this.rightRectangle.y + n5 + n4);
                    }
                }
                n3 += n7;
            }
            n3 = diffTextAreaModel.getRightTextArea().getCaretLine();
            change = hashMap.get(n3);
            if (change != null && diffTextAreaModel.getRightTextArea().getView().getEditPane().getTextArea().equals(diffTextAreaModel.getRightTextArea())) {
                this.paintCurrentHunkCursor(graphics, change);
            }
        }
    }

    private void fillCenter(Graphics graphics, DiffTextAreaModel diffTextAreaModel) {
        int n = diffTextAreaModel.getLeftTextArea().getFirstPhysicalLine();
        int n2 = diffTextAreaModel.getLeftTextArea().getLastPhysicalLine();
        HashMap<Integer, Diff.Change> hashMap = diffTextAreaModel.getLeftHunkMap();
        int n3 = diffTextAreaModel.getRightTextArea().getFirstPhysicalLine();
        int n4 = diffTextAreaModel.getRightTextArea().getLastPhysicalLine();
        if (hashMap != null) {
            graphics.setColor(Color.BLACK);
            for (int i = n; i <= n2; ++i) {
                Diff.Change change = hashMap.get(i);
                if (change == null || change.first0 != i || change.first1 < n3 || change.first1 >= n4) continue;
                Point point = this.leftConnectors.get(change);
                Point point2 = this.rightConnectors.get(change);
                if (point == null || point2 == null) continue;
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DiffTextAreaModel diffTextAreaModel = this.diffLocalOverview.getModel();
        if (diffTextAreaModel == null) {
            return;
        }
        if (this.leftBorder.contains(mouseEvent.getX(), mouseEvent.getY())) {
            int n = mouseEvent.getY() / this.pixelsPerLine + diffTextAreaModel.getLeftTextArea().getFirstPhysicalLine();
            this.moveRight(n);
        } else if (this.rightBorder.contains(mouseEvent.getX(), mouseEvent.getY())) {
            int n = mouseEvent.getY() / this.pixelsPerLine + diffTextAreaModel.getRightTextArea().getFirstPhysicalLine();
            this.moveLeft(n);
        }
    }

    public void moveRight(int n) {
        DiffTextAreaModel diffTextAreaModel = this.diffLocalOverview.getModel();
        if (diffTextAreaModel == null) {
            return;
        }
        JEditTextArea jEditTextArea = diffTextAreaModel.getLeftTextArea();
        JEditTextArea jEditTextArea2 = diffTextAreaModel.getRightTextArea();
        Diff.Change change = diffTextAreaModel.getEdits();
        while (change != null) {
            if (change.first0 + Math.max(0, change.lines0 - 1) >= n) {
                if (change.first0 > n) {
                    if (!jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) break;
                    jEditTextArea.getToolkit().beep();
                    break;
                }
                jEditTextArea.selectNone();
                int n2 = jEditTextArea.getLineCount();
                int n3 = jEditTextArea.getLineStartOffset(change.first0);
                int n4 = change.first0 + change.lines0 >= n2 - 1 ? jEditTextArea.getBufferLength() : jEditTextArea.getLineStartOffset(change.first0 + change.lines0);
                jEditTextArea.setCaretPosition(n3);
                Selection.Range range = change.lines0 == 0 ? new Selection.Range(n3, n3) : new Selection.Range(n3, n4);
                String string = jEditTextArea.getSelectedText((Selection)range);
                jEditTextArea2.selectNone();
                n2 = jEditTextArea2.getLineCount();
                if (change.first1 >= n2 - 1) {
                    String string2 = jEditTextArea2.getBuffer().getStringProperty("lineSeparator");
                    if (jEditTextArea2.getText().endsWith(string2)) {
                        string2 = "";
                    }
                    jEditTextArea2.setText(jEditTextArea2.getText() + string2 + string);
                    jEditTextArea2.goToBufferEnd(false);
                } else {
                    n3 = jEditTextArea2.getLineStartOffset(change.first1);
                    n4 = jEditTextArea2.getLineStartOffset(change.first1 + change.lines1);
                    jEditTextArea2.setCaretPosition(n3);
                    Selection.Range range2 = change.lines1 == 0 ? new Selection.Range(n3, n3) : new Selection.Range(n3, n4);
                    jEditTextArea2.setSelectedText((Selection)range2, string);
                }
                jEditTextArea2.selectNone();
                DualDiffManager.refreshFor(jEditTextArea2.getView());
                break;
            }
            change = change.next;
        }
    }

    public void moveLeft(int n) {
        DiffTextAreaModel diffTextAreaModel = this.diffLocalOverview.getModel();
        if (diffTextAreaModel == null) {
            return;
        }
        JEditTextArea jEditTextArea = diffTextAreaModel.getLeftTextArea();
        JEditTextArea jEditTextArea2 = diffTextAreaModel.getRightTextArea();
        Diff.Change change = diffTextAreaModel.getEdits();
        while (change != null) {
            if (change.first1 + Math.max(0, change.lines1 - 1) >= n) {
                if (change.first1 > n) {
                    if (!jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) break;
                    jEditTextArea2.getToolkit().beep();
                    break;
                }
                jEditTextArea2.selectNone();
                int n2 = jEditTextArea2.getLineCount();
                int n3 = jEditTextArea2.getLineStartOffset(change.first1);
                int n4 = change.first1 + change.lines1 >= n2 - 1 ? jEditTextArea2.getBufferLength() : jEditTextArea2.getLineStartOffset(change.first1 + change.lines1);
                jEditTextArea2.setCaretPosition(n3);
                Selection.Range range = change.lines1 == 0 ? new Selection.Range(n3, n3) : new Selection.Range(n3, n4);
                String string = jEditTextArea2.getSelectedText((Selection)range);
                jEditTextArea.selectNone();
                n2 = jEditTextArea.getLineCount();
                if (change.first0 >= n2 - 1) {
                    String string2 = jEditTextArea.getBuffer().getStringProperty("lineSeparator");
                    if (jEditTextArea.getText().endsWith(string2)) {
                        string2 = "";
                    }
                    jEditTextArea.setText(jEditTextArea.getText() + string2 + string);
                } else {
                    n3 = jEditTextArea.getLineStartOffset(change.first0);
                    n4 = jEditTextArea.getLineStartOffset(change.first0 + change.lines0);
                    jEditTextArea.setCaretPosition(n3);
                    Selection.Range range2 = change.lines0 == 0 ? new Selection.Range(n3, n3) : new Selection.Range(n3, n4);
                    jEditTextArea.setSelectedText((Selection)range2, string);
                }
                jEditTextArea.selectNone();
                DualDiffManager.refreshFor(jEditTextArea.getView());
                break;
            }
            change = change.next;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource().equals(this.diffLocalOverview.getModel().getLeftTextArea())) {
            this.paintCurrentHunkCursor(null, this.inLeftHunk());
        } else if (caretEvent.getSource().equals(this.diffLocalOverview.getModel().getRightTextArea())) {
            this.paintCurrentHunkCursor(null, this.inRightHunk());
        }
    }

    private Diff.Change inLeftHunk() {
        int n;
        DiffTextAreaModel diffTextAreaModel = this.diffLocalOverview.getModel();
        HashMap<Integer, Diff.Change> hashMap = diffTextAreaModel.getLeftHunkMap();
        if (hashMap != null && hashMap.get(n = diffTextAreaModel.getLeftTextArea().getCaretLine()) != null && n >= diffTextAreaModel.getLeftTextArea().getFirstPhysicalLine() && n <= diffTextAreaModel.getLeftTextArea().getLastPhysicalLine()) {
            return hashMap.get(n);
        }
        return null;
    }

    private Diff.Change inRightHunk() {
        int n;
        DiffTextAreaModel diffTextAreaModel = this.diffLocalOverview.getModel();
        HashMap<Integer, Diff.Change> hashMap = diffTextAreaModel.getRightHunkMap();
        if (hashMap != null && hashMap.get(n = diffTextAreaModel.getRightTextArea().getCaretLine()) != null && n >= diffTextAreaModel.getRightTextArea().getFirstPhysicalLine() && n <= diffTextAreaModel.getRightTextArea().getLastPhysicalLine()) {
            return hashMap.get(n);
        }
        return null;
    }

    private void paintCurrentHunkCursor(Graphics graphics, Diff.Change change) {
        HashMap<Integer, Diff.Change> hashMap;
        int n;
        int n2;
        int n3;
        if (graphics == null) {
            graphics = this.diffLocalOverview.getGraphics();
        }
        if (graphics == null) {
            return;
        }
        if (this.leftRectangle == null || this.rightRectangle == null) {
            return;
        }
        DiffTextAreaModel diffTextAreaModel = this.diffLocalOverview.getModel();
        int n4 = diffTextAreaModel.getLeftTextArea().getFirstPhysicalLine();
        int n5 = diffTextAreaModel.getLeftTextArea().getLastPhysicalLine();
        graphics.setColor(this.localRendererPane.getBackground());
        graphics.drawRect(this.leftRectangle.x - 3, 0, 1, (n5 - n4) * this.pixelsPerLine);
        int n6 = diffTextAreaModel.getRightTextArea().getFirstPhysicalLine();
        int n7 = diffTextAreaModel.getRightTextArea().getLastPhysicalLine();
        graphics.setColor(this.localRendererPane.getBackground());
        graphics.drawRect(this.rightRectangle.x + this.rightRectangle.width + 1, 0, 1, (n7 - n6) * this.pixelsPerLine);
        if (change == null) {
            return;
        }
        HashMap<Integer, Diff.Change> hashMap2 = diffTextAreaModel.getLeftHunkMap();
        if (hashMap2 != null) {
            for (int i = n4; i <= n5; ++i) {
                Diff.Change change2 = hashMap2.get(i);
                if (change2 == null || !change2.equals(change)) continue;
                if (change2.lines0 == 0) {
                    this.leftRectangle.height = 1;
                    this.leftRectangle.y = this.centerRectangle.y + diffTextAreaModel.getLeftTextArea().getScreenLineOfOffset(diffTextAreaModel.getLeftTextArea().getLineStartOffset(change2.first0)) * this.pixelsPerLine;
                } else {
                    int n8 = diffTextAreaModel.getLeftTextArea().getLineStartOffset(change2.first0);
                    n3 = diffTextAreaModel.getLeftTextArea().getLineStartOffset(change2.last0) + diffTextAreaModel.getLeftTextArea().getLineText(change2.last0).length();
                    n2 = diffTextAreaModel.getLeftTextArea().getScreenLineOfOffset(n8);
                    n = diffTextAreaModel.getLeftTextArea().getScreenLineOfOffset(n3);
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n < 0) {
                        n = diffTextAreaModel.getLeftTextArea().getLastScreenLine();
                    }
                    this.leftRectangle.height = (n - n2 + 1) * this.pixelsPerLine;
                    this.leftRectangle.y = this.centerRectangle.y + n2 * this.pixelsPerLine;
                }
                graphics.setColor(JDiffPlugin.leftCursorColor);
                graphics.drawRect(this.leftRectangle.x - 3, this.leftRectangle.y, 1, this.leftRectangle.height - 1);
                break;
            }
        }
        if ((hashMap = diffTextAreaModel.getRightHunkMap()) != null) {
            for (int i = n6; i <= n7; ++i) {
                Diff.Change change3 = hashMap.get(i);
                if (change3 == null || !change3.equals(change)) continue;
                if (change3.lines1 == 0) {
                    this.rightRectangle.height = 1;
                    this.rightRectangle.y = this.centerRectangle.y + diffTextAreaModel.getRightTextArea().getScreenLineOfOffset(diffTextAreaModel.getRightTextArea().getLineStartOffset(change3.first1)) * this.pixelsPerLine;
                } else {
                    n3 = diffTextAreaModel.getRightTextArea().getLineStartOffset(change3.first1);
                    n2 = diffTextAreaModel.getRightTextArea().getLineStartOffset(change3.last1) + diffTextAreaModel.getRightTextArea().getLineText(change3.last1).length();
                    n = diffTextAreaModel.getRightTextArea().getScreenLineOfOffset(n3);
                    int n9 = diffTextAreaModel.getRightTextArea().getScreenLineOfOffset(n2);
                    if (n < 0) {
                        n = 0;
                    }
                    if (n9 < 0) {
                        n9 = diffTextAreaModel.getRightTextArea().getLastScreenLine();
                    }
                    this.rightRectangle.height = (n9 - n + 1) * this.pixelsPerLine;
                    this.rightRectangle.y = this.centerRectangle.y + n * this.pixelsPerLine;
                }
                graphics.setColor(JDiffPlugin.rightCursorColor);
                graphics.drawRect(this.rightRectangle.x + this.rightRectangle.width + 1, this.rightRectangle.y, 1, this.rightRectangle.height - 1);
                break;
            }
        }
    }

    public class LocalRendererPane
    extends JPanel {
        public LocalRendererPane() {
            Dimension dimension = this.getPreferredSize();
            dimension.width = 36;
            this.setPreferredSize(dimension);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            DiffTextAreaModel diffTextAreaModel = BasicDiffLocalOverviewUI.this.diffLocalOverview.getModel();
            if (diffTextAreaModel == null) {
                return;
            }
            BasicDiffLocalOverviewUI.this.leftVisibleLineCount = diffTextAreaModel.getLeftTextArea().getVisibleLines();
            BasicDiffLocalOverviewUI.this.rightVisibleLineCount = diffTextAreaModel.getRightTextArea().getVisibleLines();
            BasicDiffLocalOverviewUI.this.pixelsPerLine = diffTextAreaModel.getLeftTextArea().getPainter().getFontMetrics().getHeight();
            Rectangle rectangle = this.getBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            BasicDiffLocalOverviewUI.this.centerRectangle = new Rectangle(4, 0, rectangle.width - 8, rectangle.height);
            BasicDiffLocalOverviewUI.this.leftRectangle = new Rectangle(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.x, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.width / 3, Math.max(1, BasicDiffLocalOverviewUI.this.pixelsPerLine * BasicDiffLocalOverviewUI.this.leftVisibleLineCount));
            BasicDiffLocalOverviewUI.this.rightRectangle = new Rectangle(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.x + (((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.width - ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.width / 3), ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.width / 3, Math.max(1, BasicDiffLocalOverviewUI.this.pixelsPerLine * BasicDiffLocalOverviewUI.this.rightVisibleLineCount));
            BasicDiffLocalOverviewUI.this.leftBorder = new Rectangle(BasicDiffLocalOverviewUI.this.leftRectangle);
            BasicDiffLocalOverviewUI.this.rightBorder = new Rectangle(BasicDiffLocalOverviewUI.this.rightRectangle);
            graphics.setColor(jEdit.getColorProperty((String)"view.bgColor", (Color)Color.WHITE));
            graphics.fillRect(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftRectangle.x, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftRectangle.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftRectangle.width, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftRectangle.height);
            graphics.fillRect(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightRectangle.x, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightRectangle.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightRectangle.width, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightRectangle.height);
            BasicDiffLocalOverviewUI.this.paintCurrentHunkCursor(graphics, null);
            BasicDiffLocalOverviewUI.this.fillLeft(graphics, diffTextAreaModel);
            BasicDiffLocalOverviewUI.this.fillRight(graphics, diffTextAreaModel);
            BasicDiffLocalOverviewUI.this.fillCenter(graphics, diffTextAreaModel);
            graphics.setColor(Color.black);
            graphics.drawRect(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftBorder.x - 1, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftBorder.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftBorder.width + 1, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftBorder.height - 1);
            graphics.drawRect(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightBorder.x - 1, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightBorder.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightBorder.width + 1, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightBorder.height - 1);
        }
    }
}

