/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import jdiff.DualDiff;
import jdiff.text.FileLine;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;

public class DualDiffUtil {
    public static boolean ignoreCaseDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false);
    public static boolean trimWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false);
    public static boolean ignoreAmountOfWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false);
    public static boolean ignoreAllWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false);

    public static void propertiesChanged() {
        boolean newIgnoreCaseDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false);
        boolean newTrimWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false);
        boolean newIgnoreAmountOfWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false);
        boolean newIgnoreAllWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false);
        if (newIgnoreCaseDefault != ignoreCaseDefault || newTrimWhitespaceDefault != trimWhitespaceDefault || newIgnoreAmountOfWhitespaceDefault != ignoreAmountOfWhitespaceDefault || newIgnoreAllWhitespaceDefault != ignoreAllWhitespaceDefault) {
            ignoreCaseDefault = newIgnoreCaseDefault;
            trimWhitespaceDefault = newTrimWhitespaceDefault;
            ignoreAmountOfWhitespaceDefault = newIgnoreAmountOfWhitespaceDefault;
            ignoreAllWhitespaceDefault = newIgnoreAllWhitespaceDefault;
        }
    }

    public static String getCurrentLineText(TextArea ta) {
        if (ta == null) {
            return "";
        }
        int caretPosition = ta.getCaretPosition();
        int lineOffset = ta.getLineOfOffset(caretPosition);
        return ta.getLineText(lineOffset);
    }

    public static void alignCaretLeft(TextArea ta) {
        int caretPhysOffset = ta.getCaretPosition();
        int caretPhysLine = ta.getLineOfOffset(caretPhysOffset);
        int caretPhysLineStartOffset = ta.getLineStartOffset(caretPhysLine);
        int caretRelOffset = caretPhysOffset - caretPhysLineStartOffset;
        Point caretLocation = ta.offsetToXY(caretPhysLine, caretRelOffset);
        ta.setHorizontalOffset(-1 * (Math.abs(ta.getHorizontalOffset()) + caretLocation.x));
    }

    public static int firstNoMatch(String left, String right) {
        int i;
        if (left == null || right == null) {
            return 0;
        }
        boolean ignoreCase = jEdit.getBooleanProperty((String)"jdiff.ignore-case");
        if (ignoreCase ? left == right || left.equalsIgnoreCase(right) : left == right || left.equals(right)) {
            return -1;
        }
        if (left.charAt(0) != right.charAt(0)) {
            return 0;
        }
        int minLength = Math.min(left.length(), right.length());
        if (ignoreCase) {
            left = left.toLowerCase();
            right = right.toLowerCase();
        }
        for (i = 0; i < minLength && left.charAt(i) == right.charAt(i); ++i) {
        }
        return i;
    }

    public static void centerOnDiff(TextArea leftTextArea, TextArea rightTextArea) {
        if (leftTextArea == null || rightTextArea == null) {
            return;
        }
        String leftLine = DualDiffUtil.getCurrentLineText(leftTextArea);
        String rightLine = DualDiffUtil.getCurrentLineText(rightTextArea);
        int diffOffset = DualDiffUtil.firstNoMatch(leftLine, rightLine);
        leftTextArea.setCaretPosition(leftTextArea.getCaretPosition() + diffOffset, false);
        rightTextArea.setCaretPosition(rightTextArea.getCaretPosition() + diffOffset, false);
        DualDiffUtil.alignCaretLeft(leftTextArea);
        DualDiffUtil.alignCaretLeft(rightTextArea);
    }

    public static void center(Component me, Component you) {
        int y;
        Rectangle my = me.getBounds();
        Dimension your = you.getSize();
        int x = my.x + (my.width - your.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = my.y + (my.height - your.height) / 2) < 0) {
            y = 0;
        }
        you.setLocation(x, y);
    }

    public static FileLine[] getFileLines(DualDiff dualDiff, Buffer buffer) {
        buffer.readLock();
        FileLine[] lines = new FileLine[buffer.getLineCount()];
        for (int i = buffer.getLineCount() - 1; i >= 0; --i) {
            int start = buffer.getLineStartOffset(i);
            int end = buffer.getLineEndOffset(i);
            int len = end - 1 - start;
            if (len == 0) {
                lines[i] = new FileLine("", "");
                continue;
            }
            String text = "";
            String canonical = "";
            canonical = text = buffer.getText(start, len);
            if (dualDiff.getIgnoreCase()) {
                canonical = canonical.toUpperCase();
            }
            if (dualDiff.getTrimWhitespace() && !dualDiff.getIgnoreAllWhitespace()) {
                canonical = DualDiffUtil.trimWhitespaces(canonical);
            }
            if (dualDiff.getIgnoreAmountOfWhitespace() & !dualDiff.getIgnoreAllWhitespace()) {
                canonical = DualDiffUtil.squeezeRepeatedWhitespaces(canonical);
            }
            if (dualDiff.getIgnoreAllWhitespace()) {
                canonical = DualDiffUtil.removeWhitespaces(canonical);
            }
            lines[i] = new FileLine(text, canonical);
        }
        buffer.readUnlock();
        return lines;
    }

    public static String squeezeRepeatedWhitespaces(String str) {
        int idx;
        int inLen = str.length();
        int outLen = 0;
        char[] inStr = new char[inLen];
        char[] outStr = new char[inLen];
        str.getChars(0, inLen, inStr, 0);
        boolean space = false;
        for (idx = 0; idx < inLen && Character.isWhitespace(inStr[idx]); ++idx) {
        }
        while (idx < inLen) {
            if (Character.isWhitespace(inStr[idx])) {
                space = true;
            } else {
                if (space) {
                    outStr[outLen++] = 32;
                    space = false;
                }
                outStr[outLen++] = inStr[idx];
            }
            ++idx;
        }
        return new String(outStr, 0, outLen);
    }

    public static String removeWhitespaces(String str) {
        int inLen = str.length();
        int outLen = 0;
        char[] inStr = new char[inLen];
        char[] outStr = new char[inLen];
        str.getChars(0, inLen, inStr, 0);
        for (int i = 0; i < inLen; ++i) {
            if (Character.isWhitespace(inStr[i])) continue;
            outStr[outLen] = inStr[i];
            ++outLen;
        }
        return new String(outStr, 0, outLen);
    }

    public static String trimWhitespaces(String str) {
        int endIdx;
        int startIdx;
        int inLen = str.length();
        char[] inStr = new char[inLen];
        str.getChars(0, inLen, inStr, 0);
        for (startIdx = 0; startIdx < inLen && Character.isWhitespace(inStr[startIdx]); ++startIdx) {
        }
        for (endIdx = inLen - 1; endIdx >= startIdx && Character.isWhitespace(inStr[endIdx]); --endIdx) {
        }
        if (startIdx > 0 || endIdx < inLen - 1) {
            return new String(inStr, startIdx, endIdx - startIdx + 1);
        }
        return str;
    }
}

