/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import jdiff.JDiffPlugin;
import jdiff.util.Diff;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;

public class DiffHighlight
extends TextAreaExtension {
    public static final Position LEFT = new Position();
    public static final Position RIGHT = new Position();
    private static HashMap<EditPane, TextAreaExtension> highlights = new HashMap();
    private JEditTextArea textArea;
    private boolean enabled = false;
    private Diff.Change edits;
    private Position position;

    private DiffHighlight(JEditTextArea textArea, Diff.Change edits, Position position) {
        this.textArea = textArea;
        this.edits = edits;
        this.position = position;
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        block11: {
            if (!this.isEnabled()) break block11;
            if (this.textArea.getLineStartOffset(physicalLine) == -1 || this.textArea.getLineEndOffset(physicalLine) == -1) {
                return;
            }
            Diff.Change hunk = this.edits;
            if (this.position == LEFT) {
                while (hunk != null) {
                    if (hunk.first0 <= physicalLine && physicalLine <= hunk.last0) {
                        Color color;
                        int height;
                        TextAreaPainter painter = this.textArea.getPainter();
                        int n = height = hunk.lines0 == 0 ? y : painter.getLineHeight();
                        if (hunk.lines0 != 0) {
                            color = hunk.lines1 == 0 ? JDiffPlugin.highlightDeletedColor : JDiffPlugin.highlightChangedColor;
                            gfx.setColor(color);
                            gfx.fillRect(0, y, painter.getWidth(), height);
                            break;
                        }
                        if (hunk.first0 == physicalLine) {
                            color = JDiffPlugin.highlightInvalidColor;
                            gfx.setColor(color);
                            gfx.drawLine(0, y, painter.getWidth() - 1, height);
                        }
                    }
                    hunk = hunk.next;
                }
            } else {
                while (hunk != null) {
                    if (hunk.first1 <= physicalLine && physicalLine <= hunk.last1) {
                        Color color;
                        int height;
                        TextAreaPainter painter = this.textArea.getPainter();
                        int n = height = hunk.lines1 == 0 ? y : painter.getLineHeight();
                        if (hunk.lines1 != 0) {
                            color = hunk.lines0 == 0 ? JDiffPlugin.highlightInsertedColor : JDiffPlugin.highlightChangedColor;
                            gfx.setColor(color);
                            gfx.fillRect(0, y, painter.getWidth(), height);
                            break;
                        }
                        if (hunk.first1 == physicalLine) {
                            color = JDiffPlugin.highlightInvalidColor;
                            gfx.setColor(color);
                            gfx.drawLine(0, y, painter.getWidth() - 1, height);
                        }
                    }
                    hunk = hunk.next;
                }
            }
        }
    }

    public void paintInvalidLine(Graphics2D gfx, int screenLine, int y) {
        block6: {
            if (screenLine != this.textArea.getLineCount()) break block6;
            Diff.Change hunk = this.edits;
            if (this.position == LEFT) {
                while (hunk != null) {
                    if (hunk.first0 <= screenLine && screenLine <= hunk.last0) {
                        TextAreaPainter painter = this.textArea.getPainter();
                        Color color = JDiffPlugin.overviewInvalidColor;
                        gfx.setColor(color);
                        gfx.drawLine(0, y, painter.getWidth() - 1, y);
                        break;
                    }
                    hunk = hunk.next;
                }
            } else {
                while (hunk != null) {
                    if (hunk.first1 <= screenLine && screenLine <= hunk.last1) {
                        TextAreaPainter painter = this.textArea.getPainter();
                        Color color = JDiffPlugin.overviewInvalidColor;
                        gfx.setColor(color);
                        gfx.drawLine(0, y, painter.getWidth() - 1, y);
                        break;
                    }
                    hunk = hunk.next;
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
    }

    public Diff.Change getEdits() {
        return this.edits;
    }

    public void setEdits(Diff.Change edits) {
        this.edits = edits;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void updateTextArea() {
        if (this.textArea == null) {
            return;
        }
        int first = this.textArea.getFirstPhysicalLine();
        int last = first + this.textArea.getVisibleLines();
        this.textArea.invalidateLineRange(first, last);
    }

    public static boolean isDiffHighlightEnabledFor(EditPane editPane) {
        DiffHighlight highlight = (DiffHighlight)highlights.get(editPane);
        if (highlight != null) {
            return highlight.isEnabled();
        }
        return false;
    }

    public static void setDiffHighlightFor(EditPane editPane, boolean enabled) {
        DiffHighlight highlight = (DiffHighlight)highlights.get(editPane);
        if (highlight != null) {
            highlight.setEnabled(enabled);
            highlight.updateTextArea();
        }
    }

    public static void enableDiffHighlightFor(EditPane editPane) {
        DiffHighlight.setDiffHighlightFor(editPane, true);
    }

    public static void disableDiffHighlightFor(EditPane editPane) {
        DiffHighlight.setDiffHighlightFor(editPane, false);
    }

    public static TextAreaExtension getHighlightFor(EditPane editPane) {
        return highlights.get(editPane);
    }

    public static TextAreaExtension addHighlightTo(EditPane editPane, Diff.Change edits, Position position) {
        DiffHighlight textAreaHighlight = new DiffHighlight(editPane.getTextArea(), edits, position);
        highlights.put(editPane, textAreaHighlight);
        return textAreaHighlight;
    }

    public static void removeHighlightFrom(EditPane editPane) {
        highlights.remove(editPane);
    }

    public static class Position {
    }
}

