/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import javax.swing.JComponent;
import jdiff.DualDiff;
import jdiff.component.DiffTextAreaModel;
import jdiff.util.Diff;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public abstract class DiffOverview
extends JComponent {
    protected DualDiff dualDiff;
    private DiffTextAreaModel model = null;
    protected Diff.Change edits;
    protected int lineCount0;
    protected int lineCount1;
    protected JEditTextArea textArea0;
    protected JEditTextArea textArea1;

    public DiffOverview() {
        this(null);
    }

    public DiffOverview(DualDiff dualDiff) {
        this.dualDiff = dualDiff;
        this.setModel(new DiffTextAreaModel(dualDiff));
    }

    public void setModel(DiffTextAreaModel model) {
        this.model = model;
        this.edits = model.getEdits();
        this.lineCount0 = model.getLeftLineCount();
        this.lineCount1 = model.getRightLineCount();
        this.textArea0 = model.getLeftTextArea();
        this.textArea1 = model.getRightTextArea();
    }

    public DiffTextAreaModel getModel() {
        return this.model;
    }

    public void synchroScrollRight() {
        if (!jEdit.getBooleanProperty((String)"jdiff.synchroscroll-on", (boolean)true)) {
            return;
        }
        Diff.Change hunk = this.edits;
        int leftFirstLine = this.textArea0.getFirstPhysicalLine();
        int rightFirstLine = this.textArea1.getFirstLine();
        int rightMaxFirstLine = this.textArea1.getLineCount() - this.textArea1.getVisibleLines() + 1;
        if (hunk == null) {
            this.goToLine(this.textArea1, Math.min(leftFirstLine, rightMaxFirstLine));
            return;
        }
        while (hunk != null) {
            if (leftFirstLine < hunk.first0 && hunk.prev == null) {
                this.goToLine(this.textArea1, leftFirstLine);
                return;
            }
            if (leftFirstLine >= hunk.first0 && leftFirstLine < hunk.first0 + hunk.lines0) {
                int distance = 0;
                if (hunk.lines0 == 0 && hunk.lines1 > 0) {
                    distance = rightFirstLine - hunk.first1;
                } else if (hunk.lines0 > 0 && hunk.lines1 == 0) {
                    distance = 0;
                } else if (hunk.lines0 == hunk.lines1) {
                    distance = leftFirstLine - hunk.first0;
                } else if (hunk.lines0 > hunk.lines1) {
                    int left_increment = hunk.lines0 / hunk.lines1;
                    int right_increment = Math.round((float)(hunk.lines1 * left_increment) / (float)hunk.lines0);
                    distance = (leftFirstLine - hunk.first0) / left_increment * right_increment;
                } else if (hunk.lines0 < hunk.lines1) {
                    int right_increment = hunk.lines1 / hunk.lines0;
                    int left_increment = Math.round((float)(hunk.lines0 * right_increment) / (float)hunk.lines1);
                    distance = (leftFirstLine - hunk.first0) / left_increment * right_increment;
                } else {
                    return;
                }
                this.goToLine(this.textArea1, hunk.first1 + distance);
                return;
            }
            if (leftFirstLine > hunk.last0 && hunk.next != null && leftFirstLine < hunk.next.first0) {
                int distance = leftFirstLine - hunk.last0;
                this.goToLine(this.textArea1, hunk.last1 + distance);
                return;
            }
            if (leftFirstLine > hunk.last0 && hunk.next == null) {
                int distance = leftFirstLine - hunk.last0;
                this.goToLine(this.textArea1, hunk.last1 + distance);
                return;
            }
            hunk = hunk.next;
        }
    }

    public void synchroScrollLeft() {
        if (!jEdit.getBooleanProperty((String)"jdiff.synchroscroll-on", (boolean)true)) {
            return;
        }
        Diff.Change hunk = this.edits;
        int leftFirstLine = this.textArea0.getFirstLine();
        int rightFirstLine = this.textArea1.getFirstPhysicalLine();
        int leftMaxFirstLine = this.textArea0.getLineCount() - this.textArea0.getVisibleLines() + 1;
        if (hunk == null) {
            this.goToLine(this.textArea0, Math.min(rightFirstLine, leftMaxFirstLine));
            return;
        }
        while (hunk != null) {
            if (rightFirstLine < hunk.first1 && hunk.prev == null) {
                this.goToLine(this.textArea0, rightFirstLine);
                return;
            }
            if (rightFirstLine >= hunk.first1 && rightFirstLine < hunk.first1 + hunk.lines1) {
                int distance = 0;
                if (hunk.lines1 == 0 && hunk.lines0 > 0) {
                    distance = leftFirstLine - hunk.first0;
                } else if (hunk.lines1 > 0 && hunk.lines0 == 0) {
                    distance = 0;
                } else if (hunk.lines1 == hunk.lines0) {
                    distance = rightFirstLine - hunk.first1;
                } else if (hunk.lines1 > hunk.lines0) {
                    int right_increment = hunk.lines1 / hunk.lines0;
                    int left_increment = Math.round((float)(hunk.lines0 * right_increment) / (float)hunk.lines1);
                    distance = (rightFirstLine - hunk.first1) / right_increment * left_increment;
                } else if (hunk.lines1 < hunk.lines0) {
                    int left_increment = hunk.lines0 / hunk.lines1;
                    int right_increment = Math.round((float)(hunk.lines1 * left_increment) / (float)hunk.lines0);
                    distance = (rightFirstLine - hunk.first1) / right_increment * left_increment;
                } else {
                    return;
                }
                this.goToLine(this.textArea0, hunk.first0 + distance);
                return;
            }
            if (rightFirstLine > hunk.last1 && hunk.next != null && rightFirstLine < hunk.next.first1) {
                int distance = rightFirstLine - hunk.last1;
                this.goToLine(this.textArea0, hunk.last0 + distance);
                return;
            }
            if (rightFirstLine > hunk.last1 && hunk.next == null) {
                int distance = rightFirstLine - hunk.last1;
                this.goToLine(this.textArea0, hunk.last0 + distance);
                return;
            }
            hunk = hunk.next;
        }
    }

    void goToLine(JEditTextArea textArea, int line) {
        int offset;
        if (jEdit.getActiveView().getTextArea().equals(textArea)) {
            return;
        }
        int start = line;
        if (start < 0) {
            start = 0;
        }
        if (start >= textArea.getLineCount()) {
            start = textArea.getLineCount() - 1;
        }
        textArea.setFirstPhysicalLine(start);
        if ((textArea.getWidth() != 0 || textArea.getHeight() != 0 || textArea.getX() != 0 || textArea.getY() != 0) && (offset = textArea.getScreenLineStartOffset(textArea.getVisibleLines() / 2)) != -1) {
            textArea.centerCaret();
        }
    }

    public void moveRight(int line_number) {
    }

    public void moveLeft(int line_number) {
    }
}

