/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdiff.DiffMessage;
import jdiff.component.ui.BasicMergeToolBarUI;
import jdiff.component.ui.MergeToolBarUI;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class MergeToolBar
extends JComponent
implements EBComponent {
    private static final String uiClassID = "MergeToolBarUI";
    private View view = null;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int COMPACT = 3;
    private int orientation = 1;
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();

    public MergeToolBar(View view) {
        this.view = view;
        this.updateUI();
        EditBus.addToBus((EBComponent)this);
    }

    public void setUI(MergeToolBarUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((MergeToolBarUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicMergeToolBarUI());
        }
        this.fireStateChanged();
    }

    public MergeToolBarUI getUI() {
        return (MergeToolBarUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void removeNotify() {
        EditBus.removeFromBus((EBComponent)this);
    }

    public void addChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.remove(cl);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener cl : this.changeListeners) {
                cl.stateChanged(event);
            }
        }
    }

    public View getView() {
        return this.view;
    }

    public void handleMessage(EBMessage message) {
        int orient;
        if (message instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)message;
            if (!this.view.equals(epu.getEditPane().getView())) {
                return;
            }
            if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
                this.fireStateChanged();
            }
        } else if (message instanceof DiffMessage) {
            DiffMessage dm = (DiffMessage)message;
            if (!this.view.equals(dm.getView())) {
                return;
            }
            this.fireStateChanged();
        } else if (message instanceof ViewUpdate) {
            ViewUpdate vu = (ViewUpdate)message;
            if (!this.view.equals(vu.getView())) {
                return;
            }
            this.fireStateChanged();
        } else if (message instanceof PropertiesChanged && (orient = jEdit.getIntegerProperty((String)"jdiff.toolbar-orientation", (int)this.orientation)) != this.orientation) {
            this.orientation = orient;
            this.fireStateChanged();
        }
    }
}

