/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util;

import java.util.HashMap;

public class Diff {
    private int equiv_max = 1;
    public boolean heuristic = false;
    public boolean no_discards = false;
    private int[] xvec;
    private int[] yvec;
    private int[] fdiag;
    private int[] bdiag;
    private int fdiagoff;
    private int bdiagoff;
    private final FileData[] filevec = new FileData[2];
    private int cost;
    private boolean inhibit = false;

    public Diff(Object[] a, Object[] b) {
        HashMap<Object, Integer> h = new HashMap<Object, Integer>(a.length + b.length);
        this.filevec[0] = new FileData(a, h);
        this.filevec[1] = new FileData(b, h);
    }

    private int diag(int xoff, int xlim, int yoff, int ylim) {
        int[] fd = this.fdiag;
        int[] bd = this.bdiag;
        int[] xv = this.xvec;
        int[] yv = this.yvec;
        int dmin = xoff - ylim;
        int dmax = xlim - yoff;
        int fmid = xoff - yoff;
        int bmid = xlim - ylim;
        int fmin = fmid;
        int fmax = fmid;
        int bmin = bmid;
        int bmax = bmid;
        boolean odd = (fmid - bmid & 1) != 0;
        fd[this.fdiagoff + fmid] = xoff;
        bd[this.bdiagoff + bmid] = xlim;
        int c = 1;
        while (true) {
            int y;
            int oldx;
            int x;
            int thi;
            int tlo;
            int d;
            boolean big_snake = false;
            if (fmin > dmin) {
                fd[this.fdiagoff + --fmin - 1] = -1;
            } else {
                ++fmin;
            }
            if (fmax < dmax) {
                fd[this.fdiagoff + ++fmax + 1] = -1;
            } else {
                --fmax;
            }
            for (d = fmax; d >= fmin; d -= 2) {
                tlo = fd[this.fdiagoff + d - 1];
                thi = fd[this.fdiagoff + d + 1];
                x = tlo >= thi ? tlo + 1 : thi;
                oldx = x;
                for (y = x - d; x < xlim && y < ylim && xv[x] == yv[y]; ++x, ++y) {
                }
                if (x - oldx > 20) {
                    big_snake = true;
                }
                fd[this.fdiagoff + d] = x;
                if (!odd || bmin > d || d > bmax || bd[this.bdiagoff + d] > fd[this.fdiagoff + d]) continue;
                this.cost = 2 * c - 1;
                return d;
            }
            if (bmin > dmin) {
                bd[this.bdiagoff + --bmin - 1] = Integer.MAX_VALUE;
            } else {
                ++bmin;
            }
            if (bmax < dmax) {
                bd[this.bdiagoff + ++bmax + 1] = Integer.MAX_VALUE;
            } else {
                --bmax;
            }
            for (d = bmax; d >= bmin; d -= 2) {
                tlo = bd[this.bdiagoff + d - 1];
                thi = bd[this.bdiagoff + d + 1];
                x = tlo < thi ? tlo : thi - 1;
                oldx = x;
                for (y = x - d; x > xoff && y > yoff && xv[x - 1] == yv[y - 1]; --x, --y) {
                }
                if (oldx - x > 20) {
                    big_snake = true;
                }
                bd[this.bdiagoff + d] = x;
                if (odd || fmin > d || d > fmax || bd[this.bdiagoff + d] > fd[this.fdiagoff + d]) continue;
                this.cost = 2 * c;
                return d;
            }
            if (c > 200 && big_snake && this.heuristic) {
                int k;
                int x2;
                int dd;
                int best = 0;
                int bestpos = -1;
                for (d = fmax; d >= fmin; d -= 2) {
                    dd = d - fmid;
                    if ((fd[this.fdiagoff + d] - xoff) * 2 - dd <= 12 * (c + (dd > 0 ? dd : -dd)) || fd[this.fdiagoff + d] * 2 - dd <= best || fd[this.fdiagoff + d] - xoff <= 20 || fd[this.fdiagoff + d] - d - yoff <= 20) continue;
                    x2 = fd[this.fdiagoff + d];
                    for (k = 1; k <= 20 && this.xvec[x2 - k] == this.yvec[x2 - d - k]; ++k) {
                    }
                    if (k != 21) continue;
                    best = fd[this.fdiagoff + d] * 2 - dd;
                    bestpos = d;
                }
                if (best > 0) {
                    this.cost = 2 * c - 1;
                    return bestpos;
                }
                best = 0;
                for (d = bmax; d >= bmin; d -= 2) {
                    dd = d - bmid;
                    if ((xlim - bd[this.bdiagoff + d]) * 2 + dd <= 12 * (c + (dd > 0 ? dd : -dd)) || (xlim - bd[this.bdiagoff + d]) * 2 + dd <= best || xlim - bd[this.bdiagoff + d] <= 20 || ylim - (bd[this.bdiagoff + d] - d) <= 20) continue;
                    x2 = bd[this.bdiagoff + d];
                    for (k = 0; k < 20 && this.xvec[x2 + k] == this.yvec[x2 - d + k]; ++k) {
                    }
                    if (k != 20) continue;
                    best = (xlim - bd[this.bdiagoff + d]) * 2 + dd;
                    bestpos = d;
                }
                if (best > 0) {
                    this.cost = 2 * c - 1;
                    return bestpos;
                }
            }
            ++c;
        }
    }

    private void compareseq(int xoff, int xlim, int yoff, int ylim) {
        while (xoff < xlim && yoff < ylim && this.xvec[xoff] == this.yvec[yoff]) {
            ++xoff;
            ++yoff;
        }
        while (xlim > xoff && ylim > yoff && this.xvec[xlim - 1] == this.yvec[ylim - 1]) {
            --xlim;
            --ylim;
        }
        if (xoff == xlim) {
            while (yoff < ylim) {
                this.filevec[1].changed_flag[1 + this.filevec[1].realindexes[yoff++]] = true;
            }
        } else if (yoff == ylim) {
            while (xoff < xlim) {
                this.filevec[0].changed_flag[1 + this.filevec[0].realindexes[xoff++]] = true;
            }
        } else {
            int d = this.diag(xoff, xlim, yoff, ylim);
            int c = this.cost;
            int b = this.bdiag[this.bdiagoff + d];
            if (c == 1) {
                throw new IllegalArgumentException("Empty subsequence");
            }
            this.compareseq(xoff, b, yoff, b - d);
            this.compareseq(b, xlim, b - d, ylim);
        }
    }

    private void discardConfusingLines() {
        this.filevec[0].discardConfusingLines(this.filevec[1]);
        this.filevec[1].discardConfusingLines(this.filevec[0]);
    }

    private void shiftBoundaries() {
        if (this.inhibit) {
            return;
        }
        this.filevec[0].shiftBoundaries(this.filevec[1]);
        this.filevec[1].shiftBoundaries(this.filevec[0]);
    }

    private Change buildReverseScript() {
        Change script = null;
        boolean[] changed0 = this.filevec[0].changed_flag;
        boolean[] changed1 = this.filevec[1].changed_flag;
        int len0 = this.filevec[0].buffered_lines;
        int len1 = this.filevec[1].buffered_lines;
        int i0 = 0;
        for (int i1 = 0; i0 < len0 || i1 < len1; ++i0, ++i1) {
            if (!changed0[1 + i0] && !changed1[1 + i1]) continue;
            int first0 = i0;
            int first1 = i1;
            while (changed0[1 + i0]) {
                ++i0;
            }
            while (changed1[1 + i1]) {
                ++i1;
            }
            script = new Change(first0, first1, i0 - first0, i1 - first1, script);
        }
        return script;
    }

    private Change buildScript() {
        Change script = null;
        boolean[] changed0 = this.filevec[0].changed_flag;
        boolean[] changed1 = this.filevec[1].changed_flag;
        int len0 = this.filevec[0].buffered_lines;
        int len1 = this.filevec[1].buffered_lines;
        int i0 = len0;
        for (int i1 = len1; i0 >= 0 || i1 >= 0; --i0, --i1) {
            if (!changed0[i0] && !changed1[i1]) continue;
            int first0 = i0;
            int first1 = i1;
            while (changed0[i0]) {
                --i0;
            }
            while (changed1[i1]) {
                --i1;
            }
            script = new Change(i0, i1, first0 - i0, first1 - i1, script);
        }
        return script;
    }

    public Change diff_2() {
        return this.diff_2(false);
    }

    public Change diff_2(boolean reverse) {
        this.discardConfusingLines();
        this.xvec = this.filevec[0].undiscarded;
        this.yvec = this.filevec[1].undiscarded;
        int diags = this.filevec[0].nondiscarded_lines + this.filevec[1].nondiscarded_lines + 3;
        this.fdiag = new int[diags];
        this.fdiagoff = this.filevec[1].nondiscarded_lines + 1;
        this.bdiag = new int[diags];
        this.bdiagoff = this.filevec[1].nondiscarded_lines + 1;
        this.compareseq(0, this.filevec[0].nondiscarded_lines, 0, this.filevec[1].nondiscarded_lines);
        this.fdiag = null;
        this.bdiag = null;
        this.shiftBoundaries();
        if (reverse) {
            return this.buildReverseScript();
        }
        return this.buildScript();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileData {
        final int buffered_lines;
        private final int[] equivs;
        final int[] undiscarded;
        final int[] realindexes;
        int nondiscarded_lines;
        boolean[] changed_flag;

        void clear() {
            this.changed_flag = new boolean[this.buffered_lines + 2];
        }

        int[] equivCount() {
            int[] equiv_count = new int[Diff.this.equiv_max];
            for (int i = 0; i < this.buffered_lines; ++i) {
                int n = this.equivs[i];
                equiv_count[n] = equiv_count[n] + 1;
            }
            return equiv_count;
        }

        void discardConfusingLines(FileData f) {
            this.clear();
            byte[] discarded = this.discardable(f.equivCount());
            this.filterDiscards(discarded);
            this.discard(discarded);
        }

        private byte[] discardable(int[] counts) {
            int end = this.buffered_lines;
            byte[] discards = new byte[end];
            int[] equivs = this.equivs;
            int many = 5;
            int tem = end / 64;
            while ((tem >>= 2) > 0) {
                many *= 2;
            }
            for (int i = 0; i < end; ++i) {
                if (equivs[i] == 0) continue;
                int nmatch = counts[equivs[i]];
                if (nmatch == 0) {
                    discards[i] = 1;
                    continue;
                }
                if (nmatch <= many) continue;
                discards[i] = 2;
            }
            return discards;
        }

        private void filterDiscards(byte[] discards) {
            int end = this.buffered_lines;
            block0: for (int i = 0; i < end; ++i) {
                int j;
                if (discards[i] == 2) {
                    discards[i] = 0;
                    continue;
                }
                if (discards[i] == 0) continue;
                int provisional = 0;
                for (j = i; j < end && discards[j] != 0; ++j) {
                    if (discards[j] != 2) continue;
                    ++provisional;
                }
                while (j > i && discards[j - 1] == 2) {
                    discards[--j] = 0;
                    --provisional;
                }
                int length = j - i;
                if (provisional * 4 > length) {
                    while (j > i) {
                        if (discards[--j] != 2) continue;
                        discards[j] = 0;
                    }
                    continue;
                }
                int minimum = 1;
                int tem = length / 4;
                while ((tem >>= 2) > 0) {
                    minimum *= 2;
                }
                ++minimum;
                int consec = 0;
                for (j = 0; j < length; ++j) {
                    if (discards[i + j] != 2) {
                        consec = 0;
                        continue;
                    }
                    if (minimum == ++consec) {
                        j -= consec;
                        continue;
                    }
                    if (minimum >= consec) continue;
                    discards[i + j] = 0;
                }
                consec = 0;
                for (j = 0; j < length && (j < 8 || discards[i + j] != 1); ++j) {
                    if (discards[i + j] == 2) {
                        consec = 0;
                        discards[i + j] = 0;
                    } else {
                        consec = discards[i + j] == 0 ? 0 : ++consec;
                    }
                    if (consec == 3) break;
                }
                i += length - 1;
                consec = 0;
                for (j = 0; j < length && (j < 8 || discards[i - j] != 1); ++j) {
                    if (discards[i - j] == 2) {
                        consec = 0;
                        discards[i - j] = 0;
                    } else {
                        consec = discards[i - j] == 0 ? 0 : ++consec;
                    }
                    if (consec == 3) continue block0;
                }
            }
        }

        private void discard(byte[] discards) {
            int end = this.buffered_lines;
            int j = 0;
            for (int i = 0; i < end; ++i) {
                if (Diff.this.no_discards || discards[i] == 0) {
                    this.undiscarded[j] = this.equivs[i];
                    this.realindexes[j++] = i;
                    continue;
                }
                this.changed_flag[1 + i] = true;
            }
            this.nondiscarded_lines = j;
        }

        public FileData(Object[] data, HashMap<Object, Integer> h) {
            this.buffered_lines = data.length;
            this.equivs = new int[this.buffered_lines];
            this.undiscarded = new int[this.buffered_lines];
            this.realindexes = new int[this.buffered_lines];
            for (int i = 0; i < data.length; ++i) {
                Integer ir = h.get(data[i]);
                if (ir == null) {
                    this.equivs[i] = Diff.this.equiv_max++;
                    h.put(data[i], new Integer(this.equivs[i]));
                    continue;
                }
                this.equivs[i] = ir;
            }
        }

        void shiftBoundaries(FileData f) {
            boolean[] changed = this.changed_flag;
            boolean[] other_changed = f.changed_flag;
            int i = 0;
            int j = 0;
            int i_end = this.buffered_lines;
            int preceding = -1;
            int other_preceding = -1;
            while (true) {
                if (i < i_end && !changed[1 + i]) {
                    while (other_changed[1 + j++]) {
                        other_preceding = j;
                    }
                    ++i;
                    continue;
                }
                if (i == i_end) break;
                int start = i;
                int other_start = j;
                while (true) {
                    if (i < i_end && changed[1 + i]) {
                        ++i;
                        continue;
                    }
                    int end = i;
                    if (end == i_end || this.equivs[start] != this.equivs[end] || other_changed[1 + j] || end == i_end || preceding >= 0 && start == preceding || other_preceding >= 0 && other_start == other_preceding) break;
                    changed[1 + end++] = true;
                    changed[1 + start++] = false;
                    ++i;
                    ++j;
                }
                preceding = i;
                other_preceding = j;
            }
        }
    }

    public static class Change {
        public Change prev;
        public Change next;
        public final int first0;
        public final int first1;
        public final int lines0;
        public final int lines1;
        public final int last0;
        public final int last1;

        public Change(int first0, int first1, int lines0, int lines1, Change next) {
            this.first0 = first0;
            this.first1 = first1;
            this.lines1 = lines1;
            this.lines0 = lines0;
            this.next = next;
            if (next != null) {
                next.prev = this;
            }
            this.last0 = first0 + (lines0 == 0 ? 0 : lines0 - 1);
            this.last1 = first1 + (lines1 == 0 ? 0 : lines1 - 1);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("Change[first0=").append(this.first0).append(",lines0=").append(this.lines0);
            sb.append(",last0=").append(this.last0);
            sb.append(",first1=").append(this.first1).append(",lines1=").append(this.lines1);
            sb.append(",last1=").append(this.last1).append(']');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Change)) {
                return false;
            }
            Change c = (Change)o;
            return this.first0 == c.first0 && this.first1 == c.first1 && this.lines0 == c.lines0 && this.lines1 == c.lines1;
        }

        public int hashCode() {
            return this.first0 + (this.first1 << 8) + (this.lines0 << 16) + (this.lines1 << 24);
        }
    }
}

