/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util.patch.normal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTools {
    public static String arrayToString(Object[] arr) {
        return StringTools.arrayToString(arr, "\n");
    }

    public static String arrayToString(Object[] arr, String delim) {
        if (arr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i].toString()).append(delim);
        }
        return sb.toString().substring(0, sb.toString().length() - delim.length());
    }

    public static String stringToStringBuilderCode(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append("StringBuilder sb = new StringBuilder();\n");
        String[] lines = StringTools.stringToArray(str, "\n");
        for (int i = 0; i < lines.length; ++i) {
            sb.append("sb.append(\"" + lines[i] + "\\n\");\n");
        }
        return sb.toString();
    }

    public static String firstLetterUpperCaseOfEachWord(String string) {
        String[] nameParts = string.split(" ");
        for (int i = 0; i < nameParts.length; ++i) {
            nameParts[i] = (nameParts[i].charAt(0) + "").toUpperCase() + nameParts[i].substring(1, nameParts[i].length());
            if (i >= nameParts.length - 1) continue;
            int n = i;
            nameParts[n] = nameParts[n] + " ";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nameParts.length; ++i) {
            sb.append(nameParts[i]);
        }
        return sb.toString();
    }

    public static String getFormatedStringOfBytes(byte[] b, String type, int maxLength) {
        String formatedString = StringTools.getFormatedStringOfBytes(b, type);
        if (formatedString.length() > maxLength) {
            formatedString = formatedString.substring(0, maxLength);
        }
        return formatedString;
    }

    public static String getFormatedStringOfBytes(byte[] b, String type) {
        if (type.equals("box")) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < b.length; ++i) {
                if (i > 0 && i % 8 == 0) {
                    sb.append('\n' + StringTools.getStringOfByte(b[i]));
                    continue;
                }
                if (i == 0) {
                    sb.append(StringTools.getStringOfByte(b[i]));
                    continue;
                }
                sb.append(' ' + StringTools.getStringOfByte(b[i]));
            }
            return sb.toString();
        }
        if (type.equals("dotted")) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < b.length - 1; ++i) {
                sb.append(StringTools.getStringOfByte(b[i]) + ":");
            }
            if (b.length > 0) {
                sb.append(StringTools.getStringOfByte(b[b.length - 1]));
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(StringTools.getStringOfByte(b[i]));
        }
        return sb.toString();
    }

    public static String getStringOfByte(byte b) {
        String s;
        int c = b;
        if (c < 0) {
            c += 256;
        }
        if ((s = Integer.toHexString(c).toUpperCase()).length() == 1) {
            s = '0' + s;
        }
        return s;
    }

    public static String lineBreakAfterNchars(String text, int breakAfter) {
        int startMark = 0;
        int endMark = --breakAfter;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (i % breakAfter != 0) continue;
            if (text.length() - endMark < 0) {
                endMark = text.length();
                sb.append(text.substring(startMark, endMark));
            } else {
                sb.append(text.substring(startMark, endMark) + "\n");
            }
            startMark = endMark;
            endMark += breakAfter;
        }
        return sb.toString();
    }

    public static String readFileIntoString(File file) throws IOException {
        String line;
        BufferedReader bw = new BufferedReader(new FileReader(file));
        StringBuilder sb = new StringBuilder();
        while ((line = bw.readLine()) != null) {
            sb.append("\n" + line);
        }
        bw.close();
        return sb.toString().substring(1);
    }

    public static String[] readFileIntoStringArray(String filename) {
        try {
            return StringTools.stringToArray(StringTools.readFileIntoString(new File(filename)));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String[] stringToArray(String msg) {
        return StringTools.stringToArray(msg, "\n");
    }

    public static String[] stringToArray(String msg, String delim) {
        ArrayList<String> al = StringTools.stringToArrayList(msg, delim);
        return al.toArray(new String[al.size()]);
    }

    public static ArrayList<String> stringToArrayList(String msg) {
        return StringTools.stringToArrayList(msg, "\n");
    }

    public static ArrayList<String> stringToArrayList(String msg, String delim) {
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(msg, delim, true);
        boolean lastTokenEmpty = false;
        while (tokens.hasMoreTokens()) {
            String currentToken = tokens.nextToken();
            if (currentToken.equals(delim) && lastTokenEmpty) {
                al.add("");
                lastTokenEmpty = true;
                continue;
            }
            if (currentToken.equals(delim) && !lastTokenEmpty) {
                lastTokenEmpty = true;
                continue;
            }
            al.add(currentToken);
            lastTokenEmpty = false;
        }
        return al;
    }

    public static void writeStringIntoFile(String text, File file) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(text);
        bw.close();
    }

    public static String removeLineBreaks(String text) {
        String replace = text.replace("\n", " ");
        replace = replace.replace("\r\n", " ");
        replace = replace.replace("\n\r", " ");
        replace = replace.replace("\r", " ");
        return replace;
    }

    public static String removeLineBreaks(String text, int maxLength) {
        String ret = StringTools.removeLineBreaks(text);
        if (ret.length() > maxLength) {
            ret = ret.substring(0, maxLength);
        }
        return ret;
    }

    private StringTools() {
    }

    public static void main(String[] args) {
    }
}

