/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusListener;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jdiff.DiffHighlight;
import jdiff.DiffMessage;
import jdiff.DualDiffManager;
import jdiff.component.DiffGlobalPhysicalOverview;
import jdiff.component.DiffLineOverview;
import jdiff.component.DiffLocalOverview;
import jdiff.component.DiffOverview;
import jdiff.component.DiffTextAreaModel;
import jdiff.util.Diff;
import jdiff.util.DualDiffUtil;
import jdiff.util.JDiffDiff;
import jdiff.util.ScrollHandler;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class DualDiff
implements EBComponent {
    private boolean ignoreCase;
    private boolean trimWhitespace;
    private boolean ignoreAmountOfWhitespace;
    private boolean ignoreLineSeparators;
    private boolean ignoreAllWhitespace;
    private Diff.Change edits;
    private View view;
    private EditPane editPane0;
    private EditPane editPane1;
    private JEditTextArea textArea0;
    private JEditTextArea textArea1;
    private DiffOverview diffOverview0;
    private DiffOverview diffOverview1;
    private DiffLineOverview diffLineOverview;
    private ScrollHandler scrollHandler;
    private boolean isRemoved;

    protected DualDiff(View view) {
        this(view, DualDiffUtil.ignoreCaseDefault, DualDiffUtil.trimWhitespaceDefault, DualDiffUtil.ignoreAmountOfWhitespaceDefault, DualDiffUtil.ignoreLineSeparatorsDefault, DualDiffUtil.ignoreAllWhitespaceDefault);
    }

    protected DualDiff(View view, boolean ignoreCase, boolean trimWhitespace, boolean ignoreAmountOfWhiteSpace, boolean ignoreLineSeparators, boolean ignoreAllWhiteSpace) {
        this.ignoreCase = ignoreCase;
        this.trimWhitespace = trimWhitespace;
        this.ignoreAmountOfWhitespace = ignoreAmountOfWhiteSpace;
        this.ignoreLineSeparators = ignoreLineSeparators;
        this.ignoreAllWhitespace = ignoreAllWhiteSpace;
        this.view = view;
        EditPane[] editPanes = this.view.getEditPanes();
        this.editPane0 = editPanes[0];
        this.editPane1 = editPanes[1];
        this.textArea0 = this.editPane0.getTextArea();
        this.textArea1 = this.editPane1.getTextArea();
        this.scrollHandler = new ScrollHandler(this);
        this.isRemoved = false;
        this.refresh();
    }

    public EditPane getEditPane0() {
        return this.editPane0;
    }

    public EditPane getEditPane1() {
        return this.editPane1;
    }

    public TextArea getTextArea0() {
        return this.textArea0;
    }

    public TextArea getTextArea1() {
        return this.textArea1;
    }

    public DiffOverview getDiffOverview0() {
        return this.diffOverview0;
    }

    public DiffOverview getDiffOverview1() {
        return this.diffOverview1;
    }

    public DiffLineOverview getDiffLineOverview() {
        return this.diffLineOverview;
    }

    public View getView() {
        return this.view;
    }

    public Diff.Change getEdits() {
        return this.edits;
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof BufferUpdate) {
            BufferUpdate bu = (BufferUpdate)message;
            Buffer b0 = (Buffer)this.textArea0.getBuffer();
            Buffer b1 = (Buffer)this.textArea1.getBuffer();
            if (!b0.equals(bu.getBuffer()) || !b1.equals(bu.getBuffer())) {
                return;
            }
            this.refresh();
        } else if (message instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)message;
            EditPane editPane = epu.getEditPane();
            if (!this.view.equals(editPane.getView())) {
                return;
            }
            if (epu.getWhat() == EditPaneUpdate.CREATED || epu.getWhat() == EditPaneUpdate.DESTROYED) {
                this.remove(true);
            } else if (epu.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
                this.refresh();
            }
        } else if (message instanceof DiffMessage) {
            DiffMessage dm = (DiffMessage)message;
            if (!this.view.equals(dm.getView())) {
                return;
            }
            if (DiffMessage.OFF.equals(dm.getWhat())) {
                this.remove(false);
            }
        } else if (message instanceof PropertiesChanged) {
            boolean changed = false;
            boolean b = jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false);
            if (b != this.ignoreCase) {
                this.setIgnoreCase(b);
                changed = true;
            }
            if ((b = jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false)) != this.trimWhitespace) {
                this.setTrimWhitespace(b);
                changed = true;
            }
            if ((b = jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false)) != this.ignoreAmountOfWhitespace) {
                this.setIgnoreAmountOfWhitespace(jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false));
                changed = true;
            }
            if ((b = jEdit.getBooleanProperty((String)"jdiff.ignore-line-separators", (boolean)true)) != this.ignoreLineSeparators) {
                this.setIgnoreLineSeparators(b);
                changed = true;
            }
            if ((b = jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false)) != this.ignoreAllWhitespace) {
                this.setIgnoreAllWhitespace(jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false));
                changed = true;
            }
            if (changed) {
                this.refresh();
            }
        }
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void toggleIgnoreCase() {
        this.ignoreCase = !this.ignoreCase;
    }

    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public void toggleTrimWhitespace() {
        this.trimWhitespace = !this.trimWhitespace;
    }

    public boolean getIgnoreAmountOfWhitespace() {
        return this.ignoreAmountOfWhitespace;
    }

    public void setIgnoreAmountOfWhitespace(boolean ignoreAmountOfWhitespace) {
        this.ignoreAmountOfWhitespace = ignoreAmountOfWhitespace;
    }

    public void toggleIgnoreAmountOfWhitespace() {
        this.ignoreAmountOfWhitespace = !this.ignoreAmountOfWhitespace;
    }

    public void toggleIgnoreLineSeparators() {
        this.ignoreLineSeparators = !this.ignoreLineSeparators;
    }

    public boolean getIgnoreLineSeparators() {
        return this.ignoreLineSeparators;
    }

    public void setIgnoreLineSeparators(boolean ignoreLineSeparators) {
        this.ignoreLineSeparators = ignoreLineSeparators;
    }

    public boolean getIgnoreAllWhitespace() {
        return this.ignoreAllWhitespace;
    }

    public void setIgnoreAllWhitespace(boolean ignoreAllWhitespace) {
        this.ignoreAllWhitespace = ignoreAllWhitespace;
    }

    public void toggleIgnoreAllWhitespace() {
        this.ignoreAllWhitespace = !this.ignoreAllWhitespace;
    }

    protected void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DualDiff.this.isRemoved) {
                    return;
                }
                JSplitPane sp = DualDiff.this.view.getSplitPane();
                if (sp != null) {
                    EditBus.removeFromBus((EBComponent)DualDiff.this);
                    DualDiff.this.removeHandlers();
                    DualDiff.this.removeHighlighters();
                    DualDiff.this.removeOverviews();
                    DualDiff.this.installOverviews();
                    DualDiff.this.installHighlighters();
                    DualDiff.this.installHandlers();
                    DualDiff.this.diffLineOverview.clear();
                    DiffTextAreaModel taModel = new DiffTextAreaModel(DualDiff.this);
                    DualDiff.this.diffOverview0.setModel(taModel);
                    DualDiff.this.diffOverview0.synchroScrollRight();
                    DualDiff.this.diffOverview1.setModel(taModel);
                    DualDiff.this.diffOverview1.repaint();
                    EditBus.addToBus((EBComponent)DualDiff.this);
                    DockableWindowManager dwm = DualDiff.this.view.getDockableWindowManager();
                    if (!dwm.isDockableWindowVisible("jdiff-lines") && jEdit.getBooleanProperty((String)"jdiff.auto-show-dockable")) {
                        if (dwm.getDockableWindow("jdiff-lines") == null) {
                            dwm.addDockableWindow("jdiff-lines");
                        }
                        dwm.showDockableWindow("jdiff-lines");
                    }
                    sp.setDividerLocation(0.5);
                    DualDiff.this.view.invalidate();
                    DualDiff.this.view.validate();
                    if (DualDiff.this.diffOverview1.getModel().getEdits() == null) {
                        DualDiff.this.view.getStatus().setMessage(" No have differents ");
                    }
                }
            }
        });
    }

    private void remove(boolean propagate) {
        this.isRemoved = true;
        EditBus.removeFromBus((EBComponent)this);
        this.removeOverviews();
        this.removeHighlighters();
        this.removeHandlers();
        this.view.getDockableWindowManager().hideDockableWindow("jdiff-lines");
        this.diffLineOverview.setModel(null);
        if (propagate) {
            DualDiffManager.removeFrom(this.view);
        }
    }

    private void installOverviews() {
        Buffer buf0 = this.editPane0.getBuffer();
        Buffer buf1 = this.editPane1.getBuffer();
        if (!buf0.isLoaded() || !buf1.isLoaded()) {
            this.edits = null;
            this.diffOverview0 = new DiffLocalOverview(this);
            this.diffOverview1 = new DiffGlobalPhysicalOverview(this);
        } else {
            Object[] fileLines0 = DualDiffUtil.getFileLines(this, buf0);
            Object[] fileLines1 = DualDiffUtil.getFileLines(this, buf1);
            JDiffDiff d = new JDiffDiff(fileLines0, fileLines1);
            this.edits = d.diff_2();
            this.diffOverview0 = new DiffLocalOverview(this);
            this.diffOverview1 = new DiffGlobalPhysicalOverview(this);
            this.diffLineOverview = new DiffLineOverview(this, this.view);
        }
        this.textArea0.addLeftOfScrollBar((Component)this.diffOverview0);
        this.textArea1.addLeftOfScrollBar((Component)this.diffOverview1);
    }

    private void removeOverviews() {
        if (this.textArea0 != null && this.diffOverview0 != null) {
            this.textArea0.removeLeftOfScrollBar((Component)this.diffOverview0);
        }
        if (this.textArea1 != null && this.diffOverview1 != null) {
            this.textArea1.removeLeftOfScrollBar((Component)this.diffOverview1);
        }
    }

    private void installHighlighters() {
        DiffHighlight diffHighlight0 = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane0);
        if (diffHighlight0 == null) {
            diffHighlight0 = (DiffHighlight)DiffHighlight.addHighlightTo(this.editPane0, this.edits, DiffHighlight.LEFT);
            this.textArea0.getPainter().addExtension(-40, (TextAreaExtension)diffHighlight0);
        } else {
            diffHighlight0.setEdits(this.edits);
            diffHighlight0.setPosition(DiffHighlight.LEFT);
        }
        diffHighlight0.setEnabled(true);
        diffHighlight0.updateTextArea();
        DiffHighlight diffHighlight1 = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane1);
        if (diffHighlight1 == null) {
            diffHighlight1 = (DiffHighlight)DiffHighlight.addHighlightTo(this.editPane1, this.edits, DiffHighlight.RIGHT);
            this.textArea1.getPainter().addExtension(-40, (TextAreaExtension)diffHighlight1);
        } else {
            diffHighlight1.setEdits(this.edits);
            diffHighlight1.setPosition(DiffHighlight.RIGHT);
        }
        diffHighlight1.setEnabled(true);
        diffHighlight1.updateTextArea();
    }

    private void removeHighlighters() {
        DiffHighlight diffHighlight1;
        DiffHighlight diffHighlight0 = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane0);
        if (diffHighlight0 != null) {
            diffHighlight0.setEnabled(false);
            diffHighlight0.updateTextArea();
            DiffHighlight.removeHighlightFrom(this.editPane0);
        }
        if ((diffHighlight1 = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane1)) != null) {
            diffHighlight1.setEnabled(false);
            diffHighlight1.updateTextArea();
            DiffHighlight.removeHighlightFrom(this.editPane1);
        }
    }

    private void installHandlers() {
        this.textArea0.addScrollListener((ScrollListener)this.scrollHandler);
        this.textArea0.addFocusListener((FocusListener)this.scrollHandler);
        this.textArea0.getDisplayManager().expandAllFolds();
        this.textArea1.addScrollListener((ScrollListener)this.scrollHandler);
        this.textArea1.addFocusListener((FocusListener)this.scrollHandler);
        this.textArea1.getDisplayManager().expandAllFolds();
    }

    private void removeHandlers() {
        this.textArea0.removeScrollListener((ScrollListener)this.scrollHandler);
        this.textArea0.removeFocusListener((FocusListener)this.scrollHandler);
        this.textArea1.removeScrollListener((ScrollListener)this.scrollHandler);
        this.textArea1.removeFocusListener((FocusListener)this.scrollHandler);
    }

    public Font getFont() {
        return this.textArea0.getPainter().getFont();
    }

    public Color getBackground() {
        return this.textArea0.getPainter().getBackground();
    }

    protected void nextDiff0() {
        Diff.Change hunk = this.edits;
        int caretLine = this.textArea0.getCaretLine();
        while (hunk != null) {
            if (hunk.first0 > caretLine + (hunk.lines0 == 0 ? 1 : 0)) {
                int line = hunk.first0;
                if (line >= this.textArea0.getLineCount()) {
                    line = this.textArea0.getLineCount() - 1;
                }
                int caret_position = this.textArea0.getLineStartOffset(Math.min(line, this.textArea0.getLineCount() - 1));
                this.textArea0.setCaretPosition(caret_position, false);
                int visibleLines = this.textArea0.getVisibleLines();
                int leftLineCount = this.textArea0.getLineCount();
                int distance = 1;
                if (line > leftLineCount - visibleLines) {
                    this.textArea0.setFirstPhysicalLine(leftLineCount - visibleLines);
                    distance = line - (leftLineCount - visibleLines);
                } else {
                    this.textArea0.setFirstPhysicalLine(line - 1);
                }
                caret_position = this.textArea1.getLineStartOffset(Math.min(hunk.first1, this.textArea1.getLineCount() - 1));
                this.textArea1.setCaretPosition(caret_position, false);
                this.textArea1.setFirstPhysicalLine(caret_position - distance);
                if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
                    DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
                    if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                        this.textArea0.selectWord();
                        this.textArea1.selectWord();
                    }
                }
                if (this.textArea0.getFirstLine() != line && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea0.getToolkit().beep();
                }
                return;
            }
            hunk = hunk.next;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    protected void nextDiff1() {
        Diff.Change hunk = this.edits;
        int caretLine = this.textArea1.getCaretLine();
        while (hunk != null) {
            if (hunk.first1 > caretLine + (hunk.lines1 == 0 ? 1 : 0)) {
                int line = hunk.first1;
                if (line > this.textArea1.getLineCount()) {
                    line = this.textArea1.getLineCount() - 1;
                }
                int caret_position = this.textArea1.getLineStartOffset(Math.min(line, this.textArea1.getLineCount() - 1));
                this.textArea1.setCaretPosition(caret_position, false);
                int visibleLines = this.textArea1.getVisibleLines();
                int rightLineCount = this.textArea1.getLineCount();
                int distance = 1;
                if (line > rightLineCount - visibleLines) {
                    this.textArea1.setFirstPhysicalLine(rightLineCount - visibleLines);
                    distance = line - (rightLineCount - visibleLines);
                } else {
                    this.textArea1.setFirstPhysicalLine(line - 1);
                }
                caret_position = this.textArea0.getLineStartOffset(Math.min(hunk.first0, this.textArea0.getLineCount() - 1));
                this.textArea0.setCaretPosition(caret_position, false);
                this.textArea0.setFirstPhysicalLine(caret_position - distance);
                if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
                    DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
                    if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                        this.textArea0.selectWord();
                        this.textArea1.selectWord();
                    }
                }
                if (this.textArea1.getFirstLine() != line && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea1.getToolkit().beep();
                }
                return;
            }
            hunk = hunk.next;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    protected void prevDiff0() {
        Diff.Change hunk = this.edits;
        int caretLine = this.textArea0.getCaretLine();
        while (hunk != null) {
            if (hunk.first0 < caretLine && (hunk.first0 + hunk.lines0 > caretLine || hunk.next == null || hunk.next.first0 >= caretLine)) {
                int line = hunk.first0;
                int caret_position = this.textArea0.getLineStartOffset(Math.min(line, this.textArea0.getLineCount() - 1));
                this.textArea0.setCaretPosition(caret_position, false);
                int visibleLines = this.textArea0.getVisibleLines();
                int leftLineCount = this.textArea0.getLineCount();
                int distance = 1;
                if (line > leftLineCount - visibleLines) {
                    this.textArea0.setFirstPhysicalLine(leftLineCount - visibleLines);
                    distance = line - (leftLineCount - visibleLines);
                } else {
                    this.textArea0.setFirstPhysicalLine(line - 1);
                }
                caret_position = this.textArea1.getLineStartOffset(Math.min(hunk.first1, this.textArea1.getLineCount() - 1));
                this.textArea1.setCaretPosition(caret_position, false);
                this.textArea1.setFirstPhysicalLine(hunk.first1 - distance);
                if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
                    DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
                    if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                        this.textArea0.selectWord();
                        this.textArea1.selectWord();
                    }
                }
                if (this.textArea0.getFirstLine() != line && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea0.getToolkit().beep();
                }
                return;
            }
            hunk = hunk.next;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea0.getToolkit().beep();
        }
    }

    protected void prevDiff1() {
        Diff.Change hunk = this.edits;
        int caretLine = this.textArea1.getCaretLine();
        while (hunk != null) {
            if (hunk.first1 < caretLine && (hunk.first1 + hunk.lines1 > caretLine || hunk.next == null || hunk.next.first1 >= caretLine)) {
                int line = hunk.first1;
                int caret_position = this.textArea1.getLineStartOffset(Math.min(line, this.textArea1.getLineCount() - 1));
                this.textArea1.setCaretPosition(caret_position, false);
                int visibleLines = this.textArea1.getVisibleLines();
                int rightLineCount = this.textArea1.getLineCount();
                int distance = 1;
                if (line > rightLineCount - visibleLines) {
                    this.textArea1.setFirstPhysicalLine(rightLineCount - visibleLines);
                    distance = line - (rightLineCount - visibleLines);
                } else {
                    this.textArea1.setFirstPhysicalLine(line - 1);
                }
                caret_position = this.textArea0.getLineStartOffset(Math.min(hunk.first0, this.textArea0.getLineCount() - 1));
                this.textArea0.setCaretPosition(caret_position, false);
                this.textArea0.setFirstPhysicalLine(hunk.first0 - distance);
                if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
                    DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
                    if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                        this.textArea0.selectWord();
                        this.textArea1.selectWord();
                    }
                }
                if (this.textArea1.getFirstLine() != line && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea1.getToolkit().beep();
                }
                return;
            }
            hunk = hunk.next;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    protected void firstDiff0() {
        Diff.Change hunk = this.edits;
        int line = hunk.first0;
        int caret_position = this.textArea0.getLineStartOffset(Math.min(line, this.textArea0.getLineCount()));
        this.textArea0.setCaretPosition(caret_position, false);
        int visibleLines = this.textArea0.getVisibleLines();
        int leftLineCount = this.textArea0.getLineCount();
        int distance = 1;
        if (line > leftLineCount - visibleLines) {
            this.textArea0.setFirstLine(leftLineCount - visibleLines);
            distance = line - (leftLineCount - visibleLines);
        } else {
            this.textArea0.setFirstLine(line - 1);
        }
        caret_position = this.textArea1.getLineStartOffset(Math.min(hunk.first1, this.textArea1.getLineCount() - 1));
        this.textArea1.setCaretPosition(caret_position, false);
        this.textArea1.setFirstLine(hunk.first1 - distance);
        if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
            DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
            if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                this.textArea0.selectWord();
                this.textArea1.selectWord();
            }
        }
        if (this.textArea0.getFirstLine() != line && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea0.getToolkit().beep();
        }
    }

    protected void firstDiff1() {
        Diff.Change hunk = this.edits;
        int line = hunk.first1;
        int caret_position = this.textArea1.getLineStartOffset(Math.min(line, this.textArea1.getLineCount() - 1));
        this.textArea1.setCaretPosition(caret_position, false);
        int visibleLines = this.textArea1.getVisibleLines();
        int leftLineCount = this.textArea1.getLineCount();
        int distance = 1;
        if (line > leftLineCount - visibleLines) {
            this.textArea1.setFirstLine(leftLineCount - visibleLines);
            distance = line - (leftLineCount - visibleLines);
        } else {
            this.textArea1.setFirstLine(line - 1);
        }
        caret_position = this.textArea0.getLineStartOffset(Math.min(hunk.first0, this.textArea0.getLineCount() - 1));
        this.textArea0.setCaretPosition(caret_position, false);
        this.textArea0.setFirstLine(hunk.first0 - distance);
        if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
            DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
            if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                this.textArea0.selectWord();
                this.textArea1.selectWord();
            }
        }
        if (this.textArea1.getFirstLine() != line && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    protected void lastDiff0() {
        Diff.Change hunk = this.edits;
        while (hunk.next != null) {
            hunk = hunk.next;
        }
        int line = hunk.first0;
        int caret_position = this.textArea0.getLineStartOffset(Math.min(line, this.textArea0.getLineCount() - 1));
        this.textArea0.setCaretPosition(caret_position, false);
        int visibleLines = this.textArea0.getVisibleLines();
        int leftLineCount = this.textArea0.getLineCount();
        int distance = 1;
        if (line > leftLineCount - visibleLines) {
            this.textArea0.setFirstLine(leftLineCount - visibleLines);
            distance = line - (leftLineCount - visibleLines);
        } else {
            this.textArea0.setFirstLine(line - 1);
        }
        caret_position = this.textArea1.getLineStartOffset(Math.min(hunk.first1, this.textArea1.getLineCount() - 1));
        this.textArea1.setCaretPosition(caret_position, false);
        this.textArea1.setFirstLine(hunk.first1 - distance);
        if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
            DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
            if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                this.textArea0.selectWord();
                this.textArea1.selectWord();
            }
        }
        if (this.textArea0.getFirstLine() != line && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea0.getToolkit().beep();
        }
    }

    protected void lastDiff1() {
        Diff.Change hunk = this.edits;
        while (hunk.next != null) {
            hunk = hunk.next;
        }
        int line = hunk.first1;
        int caret_position = this.textArea1.getLineStartOffset(Math.min(line, this.textArea1.getLineCount() - 1));
        this.textArea1.setCaretPosition(caret_position, false);
        int visibleLines = this.textArea1.getVisibleLines();
        int leftLineCount = this.textArea1.getLineCount();
        int distance = 1;
        if (line > leftLineCount - visibleLines) {
            this.textArea1.setFirstLine(leftLineCount - visibleLines);
            distance = line - (leftLineCount - visibleLines);
        } else {
            this.textArea1.setFirstLine(line - 1);
        }
        caret_position = this.textArea0.getLineStartOffset(Math.min(hunk.first0, this.textArea0.getLineCount() - 1));
        this.textArea0.setCaretPosition(caret_position, false);
        this.textArea0.setFirstLine(hunk.first0 - distance);
        if (jEdit.getBooleanProperty((String)"jdiff.horiz-scroll")) {
            DualDiffUtil.centerOnDiff((TextArea)this.textArea0, (TextArea)this.textArea1);
            if (jEdit.getBooleanProperty((String)"jdiff.select-word")) {
                this.textArea0.selectWord();
                this.textArea1.selectWord();
            }
        }
        if (this.textArea1.getFirstLine() != line && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    protected void moveRight(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        if (editPane.equals(this.editPane0)) {
            this.diffOverview0.moveRight(editPane.getTextArea().getCaretLine());
        } else {
            Diff.Change hunk = this.edits;
            int caretLine = editPane.getTextArea().getCaretLine();
            while (hunk != null) {
                if (hunk.first1 <= caretLine && caretLine <= hunk.last1) {
                    this.diffOverview0.moveRight(hunk.first0);
                    return;
                }
                hunk = hunk.next;
            }
        }
    }

    protected void moveLeft(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        if (editPane.equals(this.editPane1)) {
            this.diffOverview0.moveLeft(editPane.getTextArea().getCaretLine());
        } else {
            Diff.Change hunk = this.edits;
            int caretLine = editPane.getTextArea().getCaretLine();
            while (hunk != null) {
                if (hunk.first0 <= caretLine && caretLine <= hunk.last0) {
                    this.diffOverview0.moveLeft(hunk.first1);
                    return;
                }
                hunk = hunk.next;
            }
        }
    }

    protected void moveMultipleRight(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        Diff.Change hunk = this.edits;
        while (hunk.next != null) {
            hunk = hunk.next;
        }
        while (hunk != null) {
            if (hunk.lines1 == 0) {
                this.diffOverview0.moveRight(hunk.first0);
            }
            hunk = hunk.prev;
        }
    }

    protected void moveMultipleLeft(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        Diff.Change hunk = this.edits;
        while (hunk.next != null) {
            hunk = hunk.next;
        }
        while (hunk != null) {
            if (hunk.lines0 == 0) {
                this.diffOverview0.moveLeft(hunk.first1);
            }
            hunk = hunk.prev;
        }
    }
}

