/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jdiff.JDiffPlugin;
import jdiff.text.FileLine;
import jdiff.util.Diff;
import jdiff.util.JDiffDiff;
import org.gjt.sp.jedit.jEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffLineModel {
    private String leftLine;
    private String rightLine;
    private List<Character> leftCharacters;
    private List<Color> leftColors;
    private List<Character> rightCharacters;
    private List<Color> rightColors;

    public DiffLineModel() {
    }

    public DiffLineModel(String leftLine, String rightLine) {
        this.leftLine = leftLine;
        this.rightLine = rightLine;
        this.prepData();
    }

    public String toString() {
        return new StringBuffer().append("DiffLineModel[left[").append(this.leftLine).append("], right[").append(this.rightLine).append("]]").toString();
    }

    public List<Character> getLeftCharacters() {
        return this.leftCharacters;
    }

    public List<Color> getLeftColors() {
        return this.leftColors;
    }

    public List<Character> getRightCharacters() {
        return this.rightCharacters;
    }

    public List<Color> getRightColors() {
        return this.rightColors;
    }

    public void setLeftLine(String line) {
        this.leftLine = line;
        this.prepData();
    }

    public String getLeftLine() {
        return this.leftLine;
    }

    public void setRightLine(String line) {
        this.rightLine = line;
        this.prepData();
    }

    public String getRightLine() {
        return this.rightLine;
    }

    private void prepData() {
        int i;
        String text;
        char c;
        int i2;
        this.leftCharacters = null;
        this.leftColors = null;
        this.rightCharacters = null;
        this.rightColors = null;
        Object[] leftLines = new FileLine[this.leftLine.length()];
        Object[] rightLines = new FileLine[this.rightLine.length()];
        for (i2 = 0; i2 < this.leftLine.length(); ++i2) {
            c = this.leftLine.charAt(i2);
            text = String.valueOf(c);
            leftLines[i2] = new FileLine(text, text);
        }
        for (i2 = 0; i2 < this.rightLine.length(); ++i2) {
            c = this.rightLine.charAt(i2);
            text = String.valueOf(c);
            rightLines[i2] = new FileLine(text, text);
        }
        JDiffDiff d = new JDiffDiff(leftLines, rightLines);
        Diff.Change edits = d.diff_2();
        if (edits == null) {
            return;
        }
        this.leftCharacters = new ArrayList<Character>();
        this.leftColors = new ArrayList<Color>();
        for (i = 0; i < this.leftLine.length(); ++i) {
            this.leftCharacters.add(Character.valueOf(this.leftLine.charAt(i)));
            this.leftColors.add(jEdit.getColorProperty((String)"view.bgColor", (Color)Color.WHITE));
        }
        this.rightCharacters = new ArrayList<Character>();
        this.rightColors = new ArrayList<Color>();
        for (i = 0; i < this.rightLine.length(); ++i) {
            this.rightCharacters.add(Character.valueOf(this.rightLine.charAt(i)));
            this.rightColors.add(jEdit.getColorProperty((String)"view.bgColor", (Color)Color.WHITE));
        }
        Diff.Change hunk = edits;
        while (hunk != null) {
            int i3;
            Color color = hunk.lines0 == 0 ? JDiffPlugin.highlightInvalidColor : (hunk.lines1 == 0 ? JDiffPlugin.highlightDeletedColor : JDiffPlugin.highlightChangedColor);
            for (i3 = 0; i3 < hunk.lines0; ++i3) {
                this.leftColors.set(hunk.first0 + i3, color);
            }
            color = hunk.lines1 == 0 ? JDiffPlugin.highlightInvalidColor : (hunk.lines0 == 0 ? JDiffPlugin.highlightDeletedColor : JDiffPlugin.highlightChangedColor);
            for (i3 = 0; i3 < hunk.lines1; ++i3) {
                this.rightColors.set(hunk.first1 + i3, color);
            }
            hunk = hunk.next;
        }
    }
}

