/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import jdiff.JDiffPlugin;
import jdiff.component.DiffGlobalPhysicalOverview;
import jdiff.component.DiffTextAreaModel;
import jdiff.component.ui.DiffGlobalPhysicalOverviewUI;
import jdiff.util.Diff;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class BasicDiffGlobalPhysicalOverviewUI
extends DiffGlobalPhysicalOverviewUI
implements MouseListener {
    private DiffGlobalPhysicalOverview diffGlobalPhysicalOverview;
    private LocalRendererPane localRendererPane;
    private double pixelsPerLine = 1.0;
    private Rectangle leftRectangle;
    private Rectangle rightRectangle;
    private Image offImage = null;
    private Graphics offGfx = null;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDiffGlobalPhysicalOverviewUI();
    }

    public void installUI(JComponent c) {
        this.diffGlobalPhysicalOverview = (DiffGlobalPhysicalOverview)c;
        this.diffGlobalPhysicalOverview.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.diffGlobalPhysicalOverview = null;
    }

    public void installDefaults() {
    }

    public void installComponents() {
        this.localRendererPane = new LocalRendererPane();
        this.diffGlobalPhysicalOverview.add((Component)this.localRendererPane, "Center");
    }

    public void installListeners() {
        this.diffGlobalPhysicalOverview.addMouseListener(this);
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
    }

    public void uninstallListeners() {
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public void mouseClicked(MouseEvent e) {
        DiffTextAreaModel model = this.diffGlobalPhysicalOverview.getModel();
        if (model == null) {
            return;
        }
        JEditTextArea leftTextArea = model.getLeftTextArea();
        JEditTextArea rightTextArea = model.getRightTextArea();
        int line_number = 0;
        if (this.leftRectangle.contains(e.getX(), e.getY()) || this.rightRectangle.contains(e.getX(), e.getY())) {
            line_number = (int)((double)e.getY() / this.pixelsPerLine);
            leftTextArea.setFirstPhysicalLine(Math.min(line_number, leftTextArea.getLineCount()));
            rightTextArea.setFirstPhysicalLine(Math.min(line_number, rightTextArea.getLineCount()));
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public class LocalRendererPane
    extends JPanel {
        public LocalRendererPane() {
            Dimension dim = this.getPreferredSize();
            dim.width = 36;
            this.setPreferredSize(dim);
        }

        private boolean createImage() {
            if (this.isVisible() && (BasicDiffGlobalPhysicalOverviewUI.this.offGfx == null || this.getWidth() != BasicDiffGlobalPhysicalOverviewUI.this.offImage.getWidth(null) || this.getHeight() != BasicDiffGlobalPhysicalOverviewUI.this.offImage.getHeight(null))) {
                if (BasicDiffGlobalPhysicalOverviewUI.this.offImage != null) {
                    BasicDiffGlobalPhysicalOverviewUI.this.offImage.flush();
                }
                BasicDiffGlobalPhysicalOverviewUI.this.offImage = this.createImage(this.getWidth(), this.getHeight());
                BasicDiffGlobalPhysicalOverviewUI.this.offGfx = BasicDiffGlobalPhysicalOverviewUI.this.offImage.getGraphics();
                this.paintOffImage(BasicDiffGlobalPhysicalOverviewUI.this.offGfx);
            }
            return BasicDiffGlobalPhysicalOverviewUI.this.offGfx != null;
        }

        private void paintOffImage(Graphics gfx) {
            DiffTextAreaModel model = BasicDiffGlobalPhysicalOverviewUI.this.diffGlobalPhysicalOverview.getModel();
            if (model == null) {
                return;
            }
            int leftLineCount = model.getLeftLineCount();
            int rightLineCount = model.getRightLineCount();
            Rectangle size = this.getBounds();
            gfx.setColor(this.getBackground());
            gfx.fillRect(0, 0, size.width, size.height);
            Rectangle inner = new Rectangle(4, 4, size.width - 8, size.height - 8);
            int lines = Math.max(leftLineCount, rightLineCount);
            BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine = (double)inner.height / (double)lines;
            Rectangle left = new Rectangle(inner.x, inner.y, inner.width / 3, Math.max(1, (int)Math.round(BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine * (double)leftLineCount)));
            Rectangle right = new Rectangle(inner.x + (inner.width - left.width), inner.y, left.width, Math.max(1, (int)Math.round(BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine * (double)rightLineCount)));
            BasicDiffGlobalPhysicalOverviewUI.this.leftRectangle = new Rectangle(left);
            BasicDiffGlobalPhysicalOverviewUI.this.rightRectangle = new Rectangle(right);
            Color leftColor = JDiffPlugin.overviewInvalidColor;
            Color rightColor = JDiffPlugin.overviewInvalidColor;
            gfx.setColor(Color.black);
            gfx.drawRect(left.x - 1, left.y - 1, left.width + 1, left.height + 1);
            gfx.drawRect(right.x - 1, right.y - 1, right.width + 1, right.height + 1);
            gfx.setColor(Color.WHITE);
            gfx.fillRect(left.x, left.y, left.width, left.height);
            gfx.fillRect(right.x, right.y, right.width, right.height);
            Diff.Change hunk = model.getEdits();
            int leftOffset = 0;
            int rightOffset = 0;
            while (hunk != null) {
                leftOffset = hunk.first0;
                rightOffset = hunk.first1;
                if (hunk.lines1 == 0 && hunk.lines0 != 0) {
                    leftColor = JDiffPlugin.overviewDeletedColor;
                    rightColor = JDiffPlugin.overviewInvalidColor;
                } else if (hunk.lines1 != 0 && hunk.lines0 == 0) {
                    leftColor = JDiffPlugin.overviewInvalidColor;
                    rightColor = JDiffPlugin.overviewInsertedColor;
                } else {
                    leftColor = JDiffPlugin.overviewChangedColor;
                    rightColor = JDiffPlugin.overviewChangedColor;
                }
                left.y = inner.y + (int)Math.round((double)leftOffset * BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine);
                right.y = inner.y + (int)Math.round((double)rightOffset * BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine);
                left.height = Math.max(1, (int)Math.round((double)hunk.lines0 * BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine));
                right.height = Math.max(1, (int)Math.round((double)hunk.lines1 * BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine));
                gfx.setColor(leftColor);
                gfx.fillRect(left.x, left.y, left.width, left.height);
                gfx.setColor(rightColor);
                gfx.fillRect(right.x, right.y, right.width, right.height);
                gfx.setColor(Color.black);
                gfx.drawLine(left.x + left.width + 1, left.y, right.x - 1, right.y);
                hunk = hunk.next;
            }
        }

        public void paintComponent(Graphics gfx) {
            super.paintComponent(gfx);
            DiffTextAreaModel model = BasicDiffGlobalPhysicalOverviewUI.this.diffGlobalPhysicalOverview.getModel();
            if (model == null) {
                return;
            }
            if (!this.createImage()) {
                return;
            }
            gfx.drawImage(BasicDiffGlobalPhysicalOverviewUI.this.offImage, 0, 0, this);
            this.paintCursor(gfx, model);
        }

        public void paintCursor(Graphics gfx, DiffTextAreaModel model) {
            int leftLineCount = model.getLeftLineCount();
            int rightLineCount = model.getRightLineCount();
            JEditTextArea leftTextArea = model.getLeftTextArea();
            JEditTextArea rightTextArea = model.getRightTextArea();
            Rectangle size = this.getBounds();
            Rectangle inner = new Rectangle(4, 4, size.width - 8, size.height - 8);
            int lines = Math.max(leftLineCount, rightLineCount);
            double pixelsPerLine = (double)inner.height / (double)lines;
            int physicalFirstLine0 = leftTextArea.getFirstPhysicalLine();
            int physicalLastLine0 = leftTextArea.getLastPhysicalLine();
            Rectangle leftCursor = new Rectangle(inner.x, inner.y + (int)Math.round(pixelsPerLine * (double)physicalFirstLine0), inner.width / 3, Math.max(1, (int)Math.round(pixelsPerLine * (double)Math.min(leftLineCount, physicalLastLine0 - physicalFirstLine0 + 1))));
            int physicalFirstLine1 = rightTextArea.getFirstPhysicalLine();
            int physicalLastLine1 = rightTextArea.getLastPhysicalLine();
            Rectangle rightCursor = new Rectangle(inner.x + (inner.width - leftCursor.width), inner.y + (int)Math.round(pixelsPerLine * (double)physicalFirstLine1), leftCursor.width, Math.max(1, (int)Math.round(pixelsPerLine * (double)Math.min(rightLineCount, physicalLastLine1 - physicalFirstLine1 + 1))));
            gfx.setColor(JDiffPlugin.leftCursorColor);
            gfx.drawRect(leftCursor.x, leftCursor.y, leftCursor.width - 1, leftCursor.height - 1);
            gfx.setColor(JDiffPlugin.rightCursorColor);
            gfx.drawRect(rightCursor.x, rightCursor.y, rightCursor.width - 1, rightCursor.height - 1);
        }
    }
}

