/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import jdiff.component.DiffLineOverview;
import jdiff.component.LineRendererPane;
import jdiff.component.MergeToolBar;
import jdiff.component.ui.DiffLineOverviewUI;
import org.gjt.sp.jedit.jEdit;

public class BasicDiffLineOverviewUI
extends DiffLineOverviewUI
implements ChangeListener {
    private DiffLineOverview diffLineOverview = null;
    private MergeToolBar mergeToolBar = null;
    private LineRendererPane lineRendererPane = null;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDiffLineOverviewUI();
    }

    public void installUI(JComponent c) {
        this.diffLineOverview = (DiffLineOverview)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void installDefaults() {
        this.diffLineOverview.setLayout(this.createLayoutManager());
        this.diffLineOverview.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    public void installComponents() {
        this.mergeToolBar = new MergeToolBar(this.diffLineOverview.getView());
        this.lineRendererPane = new LineRendererPane(this.diffLineOverview.getView());
        int orientation = jEdit.getIntegerProperty((String)"jdiff.toolbar-orientation", (int)1);
        boolean show_line_diff = jEdit.getBooleanProperty((String)"jdiff.show-line-diff", (boolean)true);
        switch (orientation) {
            case 2: {
                this.diffLineOverview.add((Component)this.mergeToolBar, "North");
                if (!show_line_diff) break;
                this.diffLineOverview.add((Component)this.lineRendererPane, "Center");
                break;
            }
            case 3: {
                this.diffLineOverview.add((Component)this.mergeToolBar, "West");
                if (!show_line_diff) break;
                this.diffLineOverview.add((Component)this.lineRendererPane, "Center");
                break;
            }
            default: {
                JPanel panel = new JPanel();
                panel.add(this.mergeToolBar);
                this.diffLineOverview.add((Component)panel, "North");
                if (!show_line_diff) break;
                this.diffLineOverview.add((Component)this.lineRendererPane, "Center");
            }
        }
        this.diffLineOverview.repaint();
    }

    public void installListeners() {
        this.diffLineOverview.addChangeListener(this);
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
        this.diffLineOverview.removeAll();
    }

    public void uninstallListeners() {
        this.diffLineOverview.removeChangeListener(this);
    }

    public void stateChanged(ChangeEvent event) {
        this.uninstallUI(this.diffLineOverview);
        this.installUI(this.diffLineOverview);
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }
}

