/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import jdiff.DualDiffManager;
import jdiff.JDiffPlugin;
import jdiff.component.DiffLocalOverview;
import jdiff.component.DiffTextAreaModel;
import jdiff.component.ui.DiffLocalOverviewUI;
import jdiff.util.Diff;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class BasicDiffLocalOverviewUI
extends DiffLocalOverviewUI
implements MouseListener,
ChangeListener,
CaretListener {
    private DiffLocalOverview diffLocalOverview;
    private LocalRendererPane localRendererPane;
    private Rectangle leftBorder;
    private Rectangle rightBorder;
    private int pixelsPerLine = 1;
    private int leftVisibleLineCount;
    private int rightVisibleLineCount;
    private Rectangle leftRectangle;
    private Rectangle rightRectangle;
    private Rectangle centerRectangle;
    private HashMap<Diff.Change, Point> leftConnectors = new HashMap();
    private HashMap<Diff.Change, Point> rightConnectors = new HashMap();

    public static ComponentUI createUI(JComponent c) {
        return new BasicDiffLocalOverviewUI();
    }

    public void installUI(JComponent c) {
        this.diffLocalOverview = (DiffLocalOverview)c;
        this.diffLocalOverview.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.diffLocalOverview = null;
    }

    public void installDefaults() {
    }

    public void installComponents() {
        this.localRendererPane = new LocalRendererPane();
        this.diffLocalOverview.add((Component)this.localRendererPane, "Center");
    }

    public void installListeners() {
        this.diffLocalOverview.addMouseListener(this);
        this.diffLocalOverview.addChangeListener(this);
        this.diffLocalOverview.getModel().getLeftTextArea().addCaretListener((CaretListener)this);
        this.diffLocalOverview.getModel().getRightTextArea().addCaretListener((CaretListener)this);
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
        this.diffLocalOverview.remove(this.localRendererPane);
        this.diffLocalOverview = null;
    }

    public void uninstallListeners() {
        this.diffLocalOverview.removeMouseListener(this);
        this.diffLocalOverview.removeChangeListener(this);
        this.diffLocalOverview.getModel().getLeftTextArea().removeCaretListener((CaretListener)this);
        this.diffLocalOverview.getModel().getRightTextArea().removeCaretListener((CaretListener)this);
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public void stateChanged(ChangeEvent event) {
        this.localRendererPane.repaint();
    }

    private void fillLeft(Graphics gfx, DiffTextAreaModel model) {
        int leftFirstLine = model.getLeftTextArea().getFirstPhysicalLine();
        int leftLastLine = model.getLeftTextArea().getLastPhysicalLine();
        HashMap<Integer, Diff.Change> leftHunkMap = model.getLeftHunkMap();
        if (leftHunkMap != null) {
            Diff.Change hunk;
            for (int i = leftFirstLine; i <= leftLastLine; ++i) {
                Color color;
                hunk = leftHunkMap.get(i);
                boolean first_visible_line = false;
                int visible_lines = 0;
                if (hunk == null) continue;
                int leftLineCount = model.getLeftTextArea().getLineCount();
                int rightLineCount = model.getRightTextArea().getLineCount();
                if (hunk.first0 >= leftLineCount || hunk.last0 >= leftLineCount) continue;
                if (hunk.lines0 == 0) {
                    color = JDiffPlugin.overviewInvalidColor;
                    this.leftRectangle.height = 1;
                    this.leftRectangle.y = this.centerRectangle.y + model.getLeftTextArea().getScreenLineOfOffset(model.getLeftTextArea().getLineStartOffset(hunk.first0)) * this.pixelsPerLine;
                } else {
                    color = hunk.lines1 == 0 ? JDiffPlugin.overviewDeletedColor : JDiffPlugin.overviewChangedColor;
                    int startOffset = model.getLeftTextArea().getLineStartOffset(hunk.first0);
                    int endOffset = model.getLeftTextArea().getLineStartOffset(hunk.last0) + model.getLeftTextArea().getLineText(hunk.last0).length();
                    int startScreenLine = model.getLeftTextArea().getScreenLineOfOffset(startOffset);
                    int endScreenLine = model.getLeftTextArea().getScreenLineOfOffset(endOffset);
                    if (startScreenLine < 0) {
                        startScreenLine = 0;
                    }
                    if (endScreenLine < 0) {
                        endScreenLine = model.getLeftTextArea().getLastScreenLine();
                    }
                    this.leftRectangle.height = (endScreenLine - startScreenLine + 1) * this.pixelsPerLine;
                    this.leftRectangle.y = this.centerRectangle.y + startScreenLine * this.pixelsPerLine;
                }
                gfx.setColor(color);
                gfx.fillRect(this.leftRectangle.x, this.leftRectangle.y, this.leftRectangle.width, this.leftRectangle.height);
                this.leftConnectors.put(hunk, new Point(this.leftRectangle.x + this.leftRectangle.width + 1, this.leftRectangle.y));
                if (hunk.lines0 > 0) {
                    gfx.setColor(Color.BLACK);
                    int arrow_height = (this.pixelsPerLine - 2) % 2 == 0 ? this.pixelsPerLine - 3 : this.pixelsPerLine - 2;
                    for (int j = 0; j < 6; ++j) {
                        gfx.drawLine(this.leftRectangle.x + 2 + j, this.leftRectangle.y + 1 + j, this.leftRectangle.x + 2 + j, this.leftRectangle.y + j + arrow_height - 2 * j);
                    }
                }
                i += visible_lines;
            }
            int caret_line = model.getLeftTextArea().getCaretLine();
            hunk = leftHunkMap.get(caret_line);
            if (hunk != null && model.getLeftTextArea().getView().getEditPane().getTextArea().equals(model.getLeftTextArea())) {
                this.paintCurrentHunkCursor(gfx, hunk);
            }
        }
    }

    private void fillRight(Graphics gfx, DiffTextAreaModel model) {
        int rightFirstLine = model.getRightTextArea().getFirstPhysicalLine();
        int rightLastLine = model.getRightTextArea().getLastPhysicalLine();
        HashMap<Integer, Diff.Change> rightHunkMap = model.getRightHunkMap();
        if (rightHunkMap != null) {
            Diff.Change hunk;
            for (int i = rightFirstLine; i <= rightLastLine; ++i) {
                Color color;
                hunk = rightHunkMap.get(i);
                boolean first_visible_line = false;
                int visible_lines = 0;
                if (hunk == null) continue;
                int leftLineCount = model.getLeftTextArea().getLineCount();
                int rightLineCount = model.getRightTextArea().getLineCount();
                if (hunk.first1 >= rightLineCount || hunk.last1 >= rightLineCount) continue;
                if (hunk.lines1 == 0) {
                    color = JDiffPlugin.overviewInvalidColor;
                    this.rightRectangle.height = 1;
                    this.rightRectangle.y = this.centerRectangle.y + model.getRightTextArea().getScreenLineOfOffset(model.getRightTextArea().getLineStartOffset(hunk.first1)) * this.pixelsPerLine;
                } else {
                    color = hunk.lines0 == 0 ? JDiffPlugin.overviewInsertedColor : JDiffPlugin.overviewChangedColor;
                    int startOffset = model.getRightTextArea().getLineStartOffset(hunk.first1);
                    int endOffset = model.getRightTextArea().getLineStartOffset(hunk.last1) + model.getRightTextArea().getLineText(hunk.last1).length();
                    int startScreenLine = model.getRightTextArea().getScreenLineOfOffset(startOffset);
                    int endScreenLine = model.getRightTextArea().getScreenLineOfOffset(endOffset);
                    if (startScreenLine < 0) {
                        startScreenLine = 0;
                    }
                    if (endScreenLine < 0) {
                        endScreenLine = model.getRightTextArea().getLastScreenLine();
                    }
                    this.rightRectangle.height = (endScreenLine - startScreenLine + 1) * this.pixelsPerLine;
                    this.rightRectangle.y = this.centerRectangle.y + startScreenLine * this.pixelsPerLine;
                }
                gfx.setColor(color);
                gfx.fillRect(this.rightRectangle.x, this.rightRectangle.y, this.rightRectangle.width, this.rightRectangle.height);
                this.rightConnectors.put(hunk, new Point(this.rightRectangle.x - 1, this.rightRectangle.y));
                if (hunk.lines1 > 0) {
                    gfx.setColor(Color.BLACK);
                    int arrow_height = (this.pixelsPerLine - 2) % 2 == 0 ? this.pixelsPerLine - 3 : this.pixelsPerLine - 2;
                    int center = arrow_height / 2 + 1;
                    for (int j = 0; j < 6; ++j) {
                        gfx.drawLine(this.rightRectangle.x + 1 + j, this.rightRectangle.y + center - j, this.rightRectangle.x + 1 + j, this.rightRectangle.y + center + j);
                    }
                }
                i += visible_lines;
            }
            int caret_line = model.getRightTextArea().getCaretLine();
            hunk = rightHunkMap.get(caret_line);
            if (hunk != null && model.getRightTextArea().getView().getEditPane().getTextArea().equals(model.getRightTextArea())) {
                this.paintCurrentHunkCursor(gfx, hunk);
            }
        }
    }

    private void fillCenter(Graphics gfx, DiffTextAreaModel model) {
        int leftFirstLine = model.getLeftTextArea().getFirstPhysicalLine();
        int leftLastLine = model.getLeftTextArea().getLastPhysicalLine();
        HashMap<Integer, Diff.Change> leftHunkMap = model.getLeftHunkMap();
        int rightFirstLine = model.getRightTextArea().getFirstPhysicalLine();
        int rightLastLine = model.getRightTextArea().getLastPhysicalLine();
        if (leftHunkMap != null) {
            gfx.setColor(Color.BLACK);
            for (int leftLine = leftFirstLine; leftLine <= leftLastLine; ++leftLine) {
                Diff.Change leftHunk = leftHunkMap.get(leftLine);
                if (leftHunk == null || leftHunk.first0 != leftLine || leftHunk.first1 < rightFirstLine || leftHunk.first1 >= rightLastLine) continue;
                Point leftPoint = this.leftConnectors.get(leftHunk);
                Point rightPoint = this.rightConnectors.get(leftHunk);
                if (leftPoint == null || rightPoint == null) continue;
                gfx.drawLine(leftPoint.x, leftPoint.y, rightPoint.x, rightPoint.y);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        DiffTextAreaModel model = this.diffLocalOverview.getModel();
        if (model == null) {
            return;
        }
        if (this.leftBorder.contains(e.getX(), e.getY())) {
            this.moveRight(model.getLeftTextArea().getPhysicalLineOfScreenLine(e.getY() / this.pixelsPerLine));
        } else if (this.rightBorder.contains(e.getX(), e.getY())) {
            this.moveLeft(model.getRightTextArea().getPhysicalLineOfScreenLine(e.getY() / this.pixelsPerLine));
        }
    }

    public void moveRight(int line_number) {
        DiffTextAreaModel model = this.diffLocalOverview.getModel();
        if (model == null) {
            return;
        }
        JEditTextArea leftTextArea = model.getLeftTextArea();
        JEditTextArea rightTextArea = model.getRightTextArea();
        Diff.Change hunk = model.getEdits();
        while (hunk != null) {
            if (hunk.first0 + Math.max(0, hunk.lines0 - 1) >= line_number) {
                if (hunk.first0 > line_number) {
                    if (!jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) break;
                    leftTextArea.getToolkit().beep();
                    break;
                }
                leftTextArea.selectNone();
                int line_count = leftTextArea.getLineCount();
                int start_sel = leftTextArea.getLineStartOffset(hunk.first0);
                int end_sel = hunk.first0 + hunk.lines0 >= line_count - 1 ? leftTextArea.getBufferLength() : leftTextArea.getLineStartOffset(hunk.first0 + hunk.lines0);
                leftTextArea.setCaretPosition(start_sel);
                Selection.Range leftSelection = hunk.lines0 == 0 ? new Selection.Range(start_sel, start_sel) : new Selection.Range(start_sel, end_sel);
                String leftText = leftTextArea.getSelectedText((Selection)leftSelection);
                rightTextArea.selectNone();
                line_count = rightTextArea.getLineCount();
                if (hunk.first1 >= line_count - 1) {
                    String rightlinesep = rightTextArea.getBuffer().getStringProperty("lineSeparator");
                    if (rightTextArea.getText().endsWith(rightlinesep)) {
                        rightlinesep = "";
                    }
                    rightTextArea.setText(rightTextArea.getText() + rightlinesep + leftText);
                    rightTextArea.goToBufferEnd(false);
                } else {
                    start_sel = rightTextArea.getLineStartOffset(hunk.first1);
                    end_sel = rightTextArea.getLineStartOffset(hunk.first1 + hunk.lines1);
                    rightTextArea.setCaretPosition(start_sel);
                    Selection.Range selection = hunk.lines1 == 0 ? new Selection.Range(start_sel, start_sel) : new Selection.Range(start_sel, end_sel);
                    rightTextArea.setSelectedText((Selection)selection, leftText);
                }
                rightTextArea.selectNone();
                DualDiffManager.refreshFor(rightTextArea.getView());
                break;
            }
            hunk = hunk.next;
        }
    }

    public void moveLeft(int line_number) {
        DiffTextAreaModel model = this.diffLocalOverview.getModel();
        if (model == null) {
            return;
        }
        JEditTextArea leftTextArea = model.getLeftTextArea();
        JEditTextArea rightTextArea = model.getRightTextArea();
        Diff.Change hunk = model.getEdits();
        while (hunk != null) {
            if (hunk.first1 + Math.max(0, hunk.lines1 - 1) >= line_number) {
                if (hunk.first1 > line_number) {
                    if (!jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) break;
                    rightTextArea.getToolkit().beep();
                    break;
                }
                rightTextArea.selectNone();
                int line_count = rightTextArea.getLineCount();
                int start_sel = rightTextArea.getLineStartOffset(hunk.first1);
                int end_sel = hunk.first1 + hunk.lines1 >= line_count - 1 ? rightTextArea.getBufferLength() : rightTextArea.getLineStartOffset(hunk.first1 + hunk.lines1);
                rightTextArea.setCaretPosition(start_sel);
                Selection.Range rightSelection = hunk.lines1 == 0 ? new Selection.Range(start_sel, start_sel) : new Selection.Range(start_sel, end_sel);
                String rightText = rightTextArea.getSelectedText((Selection)rightSelection);
                leftTextArea.selectNone();
                line_count = leftTextArea.getLineCount();
                if (hunk.first0 >= line_count - 1) {
                    String leftlinesep = leftTextArea.getBuffer().getStringProperty("lineSeparator");
                    if (leftTextArea.getText().endsWith(leftlinesep)) {
                        leftlinesep = "";
                    }
                    leftTextArea.setText(leftTextArea.getText() + leftlinesep + rightText);
                } else {
                    start_sel = leftTextArea.getLineStartOffset(hunk.first0);
                    end_sel = leftTextArea.getLineStartOffset(hunk.first0 + hunk.lines0);
                    leftTextArea.setCaretPosition(start_sel);
                    Selection.Range leftSelection = hunk.lines0 == 0 ? new Selection.Range(start_sel, start_sel) : new Selection.Range(start_sel, end_sel);
                    leftTextArea.setSelectedText((Selection)leftSelection, rightText);
                }
                leftTextArea.selectNone();
                DualDiffManager.refreshFor(leftTextArea.getView());
                break;
            }
            hunk = hunk.next;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void caretUpdate(CaretEvent e) {
        if (e.getSource().equals(this.diffLocalOverview.getModel().getLeftTextArea())) {
            this.paintCurrentHunkCursor(null, this.inLeftHunk());
        } else if (e.getSource().equals(this.diffLocalOverview.getModel().getRightTextArea())) {
            this.paintCurrentHunkCursor(null, this.inRightHunk());
        }
    }

    private Diff.Change inLeftHunk() {
        int caret_line;
        DiffTextAreaModel model = this.diffLocalOverview.getModel();
        HashMap<Integer, Diff.Change> leftHunkMap = model.getLeftHunkMap();
        if (leftHunkMap != null && leftHunkMap.get(caret_line = model.getLeftTextArea().getCaretLine()) != null && caret_line >= model.getLeftTextArea().getFirstPhysicalLine() && caret_line <= model.getLeftTextArea().getLastPhysicalLine()) {
            return leftHunkMap.get(caret_line);
        }
        return null;
    }

    private Diff.Change inRightHunk() {
        int caret_line;
        DiffTextAreaModel model = this.diffLocalOverview.getModel();
        HashMap<Integer, Diff.Change> rightHunkMap = model.getRightHunkMap();
        if (rightHunkMap != null && rightHunkMap.get(caret_line = model.getRightTextArea().getCaretLine()) != null && caret_line >= model.getRightTextArea().getFirstPhysicalLine() && caret_line <= model.getRightTextArea().getLastPhysicalLine()) {
            return rightHunkMap.get(caret_line);
        }
        return null;
    }

    private void paintCurrentHunkCursor(Graphics gfx, Diff.Change currentHunk) {
        HashMap<Integer, Diff.Change> rightHunkMap;
        if (gfx == null) {
            gfx = this.diffLocalOverview.getGraphics();
        }
        if (gfx == null) {
            return;
        }
        if (this.leftRectangle == null || this.rightRectangle == null) {
            return;
        }
        DiffTextAreaModel model = this.diffLocalOverview.getModel();
        int leftFirstLine = model.getLeftTextArea().getFirstPhysicalLine();
        int leftLastLine = model.getLeftTextArea().getLastPhysicalLine();
        gfx.setColor(this.localRendererPane.getBackground());
        gfx.drawRect(this.leftRectangle.x - 3, 0, 1, model.getLeftTextArea().getVisibleLines() * this.pixelsPerLine);
        int rightFirstLine = model.getRightTextArea().getFirstPhysicalLine();
        int rightLastLine = model.getRightTextArea().getLastPhysicalLine();
        gfx.setColor(this.localRendererPane.getBackground());
        gfx.drawRect(this.rightRectangle.x + this.rightRectangle.width + 1, 0, 1, model.getRightTextArea().getVisibleLines() * this.pixelsPerLine);
        if (currentHunk == null) {
            return;
        }
        HashMap<Integer, Diff.Change> leftHunkMap = model.getLeftHunkMap();
        if (leftHunkMap != null) {
            for (int i = leftFirstLine; i <= leftLastLine; ++i) {
                Diff.Change hunk = leftHunkMap.get(i);
                if (hunk == null || !hunk.equals(currentHunk)) continue;
                if (hunk.lines0 == 0) {
                    this.leftRectangle.height = 1;
                    this.leftRectangle.y = this.centerRectangle.y + model.getLeftTextArea().getScreenLineOfOffset(model.getLeftTextArea().getLineStartOffset(hunk.first0)) * this.pixelsPerLine;
                } else {
                    int startOffset = model.getLeftTextArea().getLineStartOffset(hunk.first0);
                    if (hunk.last0 >= model.getLeftTextArea().getLineCount()) {
                        return;
                    }
                    int endOffset = model.getLeftTextArea().getLineStartOffset(hunk.last0) + model.getLeftTextArea().getLineText(hunk.last0).length();
                    int startScreenLine = model.getLeftTextArea().getScreenLineOfOffset(startOffset);
                    int endScreenLine = model.getLeftTextArea().getScreenLineOfOffset(endOffset);
                    if (startScreenLine < 0) {
                        startScreenLine = 0;
                    }
                    if (endScreenLine < 0) {
                        endScreenLine = model.getLeftTextArea().getLastScreenLine();
                    }
                    this.leftRectangle.height = (endScreenLine - startScreenLine + 1) * this.pixelsPerLine;
                    this.leftRectangle.y = this.centerRectangle.y + startScreenLine * this.pixelsPerLine;
                }
                gfx.setColor(JDiffPlugin.leftCursorColor);
                gfx.drawRect(this.leftRectangle.x - 3, this.leftRectangle.y, 1, this.leftRectangle.height - 1);
                break;
            }
        }
        if ((rightHunkMap = model.getRightHunkMap()) != null) {
            for (int i = rightFirstLine; i <= rightLastLine; ++i) {
                Diff.Change hunk = rightHunkMap.get(i);
                if (hunk == null || !hunk.equals(currentHunk)) continue;
                if (hunk.lines1 == 0) {
                    this.rightRectangle.height = 1;
                    this.rightRectangle.y = this.centerRectangle.y + model.getRightTextArea().getScreenLineOfOffset(model.getRightTextArea().getLineStartOffset(hunk.first1)) * this.pixelsPerLine;
                } else {
                    int startOffset = model.getRightTextArea().getLineStartOffset(hunk.first1);
                    if (hunk.last1 >= model.getRightTextArea().getLineCount()) {
                        return;
                    }
                    int endOffset = model.getRightTextArea().getLineStartOffset(hunk.last1) + model.getRightTextArea().getLineText(hunk.last1).length();
                    int startScreenLine = model.getRightTextArea().getScreenLineOfOffset(startOffset);
                    int endScreenLine = model.getRightTextArea().getScreenLineOfOffset(endOffset);
                    if (startScreenLine < 0) {
                        startScreenLine = 0;
                    }
                    if (endScreenLine < 0) {
                        endScreenLine = model.getRightTextArea().getLastScreenLine();
                    }
                    this.rightRectangle.height = (endScreenLine - startScreenLine + 1) * this.pixelsPerLine;
                    this.rightRectangle.y = this.centerRectangle.y + startScreenLine * this.pixelsPerLine;
                }
                gfx.setColor(JDiffPlugin.rightCursorColor);
                gfx.drawRect(this.rightRectangle.x + this.rightRectangle.width + 1, this.rightRectangle.y, 1, this.rightRectangle.height - 1);
                break;
            }
        }
    }

    public class LocalRendererPane
    extends JPanel {
        public LocalRendererPane() {
            Dimension dim = this.getPreferredSize();
            dim.width = 36;
            this.setPreferredSize(dim);
        }

        public void paintComponent(Graphics gfx) {
            super.paintComponent(gfx);
            DiffTextAreaModel model = BasicDiffLocalOverviewUI.this.diffLocalOverview.getModel();
            if (model == null) {
                return;
            }
            BasicDiffLocalOverviewUI.this.leftVisibleLineCount = model.getLeftTextArea().getVisibleLines();
            BasicDiffLocalOverviewUI.this.rightVisibleLineCount = model.getRightTextArea().getVisibleLines();
            BasicDiffLocalOverviewUI.this.pixelsPerLine = model.getLeftTextArea().getPainter().getLineHeight();
            Rectangle size = this.getBounds();
            gfx.setColor(this.getBackground());
            gfx.fillRect(0, 0, size.width, size.height);
            BasicDiffLocalOverviewUI.this.centerRectangle = new Rectangle(4, 0, size.width - 8, size.height);
            BasicDiffLocalOverviewUI.this.leftRectangle = new Rectangle(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.x, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.width / 3, Math.max(1, BasicDiffLocalOverviewUI.this.pixelsPerLine * BasicDiffLocalOverviewUI.this.leftVisibleLineCount));
            BasicDiffLocalOverviewUI.this.rightRectangle = new Rectangle(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.x + (((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.width - ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.width / 3), ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).centerRectangle.width / 3, Math.max(1, BasicDiffLocalOverviewUI.this.pixelsPerLine * BasicDiffLocalOverviewUI.this.rightVisibleLineCount));
            BasicDiffLocalOverviewUI.this.leftBorder = new Rectangle(BasicDiffLocalOverviewUI.this.leftRectangle);
            BasicDiffLocalOverviewUI.this.rightBorder = new Rectangle(BasicDiffLocalOverviewUI.this.rightRectangle);
            gfx.setColor(Color.WHITE);
            gfx.fillRect(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftRectangle.x, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftRectangle.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftRectangle.width, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftRectangle.height);
            gfx.fillRect(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightRectangle.x, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightRectangle.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightRectangle.width, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightRectangle.height);
            BasicDiffLocalOverviewUI.this.paintCurrentHunkCursor(gfx, null);
            BasicDiffLocalOverviewUI.this.fillLeft(gfx, model);
            BasicDiffLocalOverviewUI.this.fillRight(gfx, model);
            BasicDiffLocalOverviewUI.this.fillCenter(gfx, model);
            gfx.setColor(Color.black);
            gfx.drawRect(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftBorder.x - 1, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftBorder.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftBorder.width + 1, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).leftBorder.height - 1);
            gfx.drawRect(((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightBorder.x - 1, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightBorder.y, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightBorder.width + 1, ((BasicDiffLocalOverviewUI)BasicDiffLocalOverviewUI.this).rightBorder.height - 1);
        }
    }
}

