/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util.patch.normal;

import java.util.ArrayList;
import java.util.StringTokenizer;
import jdiff.util.patch.normal.Chunk;
import jdiff.util.patch.normal.StringTools;

public class Patch {
    private static final boolean DEBUG = false;

    public static boolean startWithNumber(String str) {
        char c = str.charAt(0);
        return '0' <= c && c <= '9';
    }

    public static Chunk[] getChunks(String[] patchSrc) {
        int numChunks = 0;
        for (int i = 0; i < patchSrc.length; ++i) {
            if (!Patch.startWithNumber(patchSrc[i])) continue;
            ++numChunks;
        }
        Chunk[] chunks = new Chunk[numChunks];
        numChunks = -1;
        ArrayList<String> fromBuf = new ArrayList<String>();
        ArrayList<String> toBuf = new ArrayList<String>();
        int opBuf = 32;
        int from1buf = -1;
        int from2buf = -1;
        int to1buf = -1;
        int to2buf = -1;
        for (int i = 0; i < patchSrc.length; ++i) {
            String line;
            if (Patch.startWithNumber(patchSrc[i])) {
                StringTokenizer tok1;
                if (numChunks > -1) {
                    chunks[numChunks] = new Chunk((char)opBuf, from1buf, from2buf, to1buf, to2buf, fromBuf.toArray(new String[1]), toBuf.toArray(new String[1]));
                }
                ++numChunks;
                fromBuf = new ArrayList();
                toBuf = new ArrayList();
                if (patchSrc[i].contains("a")) {
                    tok1 = new StringTokenizer(patchSrc[i], "a");
                    opBuf = 97;
                } else if (patchSrc[i].contains("c")) {
                    tok1 = new StringTokenizer(patchSrc[i], "c");
                    opBuf = 99;
                } else if (patchSrc[i].contains("d")) {
                    tok1 = new StringTokenizer(patchSrc[i], "d");
                    opBuf = 100;
                } else {
                    tok1 = new StringTokenizer(patchSrc[i], "a");
                }
                String fromRange = tok1.nextToken();
                String toRange = tok1.nextToken();
                Patch.log("fromRange: " + fromRange);
                Patch.log("toRange: " + toRange);
                StringTokenizer tokFrom = new StringTokenizer(fromRange, ",");
                String from1 = tokFrom.nextToken();
                Patch.log("From1: " + from1);
                String from2 = "0";
                if (tokFrom.hasMoreTokens()) {
                    from2 = tokFrom.nextToken();
                    Patch.log("From2: " + from2);
                }
                StringTokenizer tokTo = new StringTokenizer(toRange, ",");
                String to1 = tokTo.nextToken();
                Patch.log("To1: " + to1);
                String to2 = "0";
                if (tokTo.hasMoreTokens()) {
                    to2 = tokTo.nextToken();
                    Patch.log("To2: " + to2);
                }
                from1buf = Integer.parseInt(from1);
                from2buf = Integer.parseInt(from2);
                to1buf = Integer.parseInt(to1);
                to2buf = Integer.parseInt(to2);
                if (chunks[numChunks] == null) continue;
                Patch.log("--- Chunk Name: " + chunks[numChunks].getName());
                continue;
            }
            if (patchSrc[i].startsWith("<")) {
                line = "";
                if (patchSrc[i].length() > 2) {
                    line = patchSrc[i].substring(2);
                }
                Patch.log("< " + line);
                fromBuf.add(line);
                continue;
            }
            if (patchSrc[i].startsWith(">")) {
                line = "";
                if (patchSrc[i].length() > 2) {
                    line = patchSrc[i].substring(2);
                }
                Patch.log("> " + line);
                toBuf.add(line);
                continue;
            }
            if (patchSrc[i].startsWith("---")) {
                Patch.log("Got separation line: " + patchSrc[i]);
                continue;
            }
            Patch.log("Ignoring: " + patchSrc[i]);
        }
        if (numChunks > -1) {
            chunks[numChunks] = new Chunk((char)opBuf, from1buf, from2buf, to1buf, to2buf, fromBuf.toArray(new String[1]), toBuf.toArray(new String[1]));
        }
        return chunks;
    }

    public static String[] applyChunks(String[] targetSrc, Chunk[] chunks) {
        Patch.log("--- Now applying the Chunks: ---");
        Patch.log("--- Target Text before: ---");
        Patch.log(StringTools.arrayToString(targetSrc));
        int offset = 0;
        for (int i = 0; i < chunks.length; ++i) {
            Chunk c = chunks[i];
            if (c.getOp() == 'a') {
                targetSrc = Patch.add(c.getFrom1(), c.getTarget(), targetSrc, offset);
                offset -= c.getTarget().length;
                Patch.log("--- Applied an ADD Chunk: ---");
                Patch.log(c.getName());
                Patch.log(StringTools.arrayToString(targetSrc));
                continue;
            }
            if (c.getOp() == 'c') {
                targetSrc = Patch.change(c.getFrom1(), c.getFrom2(), c.getTo1(), c.getTo2(), c.getTarget(), targetSrc, offset);
                offset -= c.getTo2() - c.getTo1() - (c.getFrom2() - c.getFrom1());
                Patch.log("--- Applied an CHANGE Chunk: ---");
                Patch.log(c.getName());
                Patch.log(StringTools.arrayToString(targetSrc));
                continue;
            }
            if (c.getOp() != 'd') continue;
            int from1 = c.getFrom1();
            int from2 = c.getFrom2();
            if (from2 == 0) {
                from2 = from1;
            }
            targetSrc = Patch.delete(from1, from2, targetSrc, offset);
            offset += from2 - from1 + 1;
            Patch.log("--- Applied an DELETE Chunk: ---");
            Patch.log(c.getName());
            Patch.log(StringTools.arrayToString(targetSrc));
        }
        Patch.log("--- Done applying the Chunks: ---");
        Patch.log("--- Target Text after: ---");
        Patch.log(StringTools.arrayToString(targetSrc));
        return targetSrc;
    }

    public static String patchNormal(String patchText, String targetText) {
        String[] patchSrc = StringTools.stringToArray(patchText);
        String[] targetSrc = StringTools.stringToArray(targetText);
        Chunk[] chunks = Patch.getChunks(patchSrc);
        return StringTools.arrayToString(Patch.applyChunks(targetSrc, chunks));
    }

    private static String[] delete(int fromLine, int toLine, String[] baseText, int offset) {
        if (fromLine < 0 || toLine < 0 || baseText == null) {
            Patch.log("### delete() - Argument ERROR");
            return baseText;
        }
        Patch.log("--- Offset: " + offset);
        Patch.log("--- Base Text before: ---");
        Patch.log(StringTools.arrayToString(baseText));
        Patch.log("--- fromLine: " + (fromLine -= offset) + ", toLine: " + (toLine -= offset));
        ArrayList<String> buff = new ArrayList<String>();
        for (int i = 0; i < fromLine - 1 && i < baseText.length; ++i) {
            buff.add(baseText[i]);
        }
        for (int j = toLine; j < baseText.length; ++j) {
            buff.add(baseText[j]);
        }
        return buff.toArray(new String[1]);
    }

    private static String[] change(int fromLine, int toLine, int to1, int to2, String[] changeTo, String[] baseText, int offset) {
        int i;
        Patch.log("######### CHANGE #########");
        if (fromLine < 0 || toLine < 0 || baseText == null || changeTo == null) {
            Patch.log("### change() - Argument ERROR");
            return baseText;
        }
        fromLine -= offset;
        toLine -= offset;
        Patch.log("--- Offset: " + offset);
        Patch.log("--- Base Text before: ---");
        Patch.log(StringTools.arrayToString(baseText));
        Patch.log("--- ChangeTo Text before: ---");
        Patch.log(StringTools.arrayToString(changeTo));
        Patch.log("--- fromLine: " + fromLine + ", toLine: " + toLine + ", changeTo.length: " + changeTo.length);
        ArrayList<String> buff = new ArrayList<String>();
        for (i = 0; i < fromLine - 1 && i < baseText.length; ++i) {
            Patch.log("--- change() - Adding(1): " + baseText[i]);
            buff.add(baseText[i]);
        }
        for (int j = 0; j < changeTo.length; ++j) {
            Patch.log("--- change() - Adding(2): " + changeTo[j]);
            buff.add(changeTo[j]);
            ++i;
        }
        int linesRemoved = fromLine;
        if (fromLine > 1) {
            linesRemoved = fromLine - 1;
        }
        if (toLine > 0) {
            linesRemoved = toLine - (fromLine - 1);
        }
        int linesInserted = 1;
        if (to2 > 0) {
            linesInserted = to2 - to1 + 1;
        }
        Patch.log("--- change() - Ajusting i by: " + (linesRemoved - linesInserted));
        for (int j = i += linesRemoved - linesInserted; j < baseText.length; ++j) {
            Patch.log("--- change() - Adding(3): " + baseText[j]);
            buff.add(baseText[j]);
        }
        return buff.toArray(new String[1]);
    }

    private static String[] add(int line, String[] insertion, String[] baseText, int offset) {
        int j;
        if (line < 0 || baseText == null || insertion == null) {
            Patch.log("### add(line: " + line + ", insertion: " + insertion + ", baseText: " + baseText + ") - Argument ERROR");
            return baseText;
        }
        line -= offset;
        Patch.log("--- Offset: " + offset);
        ArrayList<String> buff = new ArrayList<String>();
        for (int i = 0; i < line && i < baseText.length; ++i) {
            buff.add(baseText[i]);
        }
        for (j = 0; j < insertion.length; ++j) {
            buff.add(insertion[j]);
        }
        for (j = i; j < baseText.length; ++j) {
            buff.add(baseText[j]);
        }
        return buff.toArray(new String[1]);
    }

    private static void log(String logLine) {
    }
}

