/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jdiff.DiffHighlight;
import jdiff.DiffMessage;
import jdiff.component.DiffGlobalPhysicalOverview;
import jdiff.component.DiffLineOverview;
import jdiff.component.DiffLocalOverview;
import jdiff.component.DiffOverview;
import jdiff.component.PatchSelectionDialog;
import jdiff.text.FileLine;
import jdiff.util.Diff;
import jdiff.util.DiffNormalOutput;
import jdiff.util.DiffOutput;
import jdiff.util.patch.Patch;
import jdiff.util.patch.PatchUtils;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class DualDiff
implements EBComponent {
    private static boolean ignoreCaseDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false);
    private static boolean trimWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false);
    private static boolean ignoreAmountOfWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false);
    private static boolean ignoreAllWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false);
    private static HashMap<View, DualDiff> dualDiffs = new HashMap();
    private boolean ignoreCase;
    private boolean trimWhitespace;
    private boolean ignoreAmountOfWhitespace;
    private boolean ignoreAllWhitespace;
    private View view;
    private EditPane editPane0;
    private EditPane editPane1;
    private JEditTextArea textArea0;
    private JEditTextArea textArea1;
    private Diff.Change edits;
    private DiffOverview diffOverview0;
    private DiffOverview diffOverview1;
    private final ScrollHandler scrollHandler = new ScrollHandler();
    private DiffLineOverview diffLineOverview;
    private static HashMap<View, String> splitConfigs = new HashMap();
    private static HashMap<View, HashMap<String, Integer>> caretPositions = new HashMap();

    private DualDiff(View view) {
        this(view, ignoreCaseDefault, trimWhitespaceDefault, ignoreAmountOfWhitespaceDefault, ignoreAllWhitespaceDefault);
    }

    private DualDiff(View view, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.ignoreCase = bl;
        this.trimWhitespace = bl2;
        this.ignoreAmountOfWhitespace = bl3;
        this.ignoreAllWhitespace = bl4;
        this.view = view;
        EditPane[] editPaneArray = this.view.getEditPanes();
        this.editPane0 = editPaneArray[0];
        this.editPane1 = editPaneArray[1];
        this.textArea0 = this.editPane0.getTextArea();
        this.textArea1 = this.editPane1.getTextArea();
        this.initOverviews();
        this.addOverviews();
    }

    public View getView() {
        return this.view;
    }

    public Diff.Change getEdits() {
        return this.edits;
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof BufferUpdate) {
            BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
            Buffer buffer = (Buffer)this.textArea0.getBuffer();
            Buffer buffer2 = (Buffer)this.textArea1.getBuffer();
            if (bufferUpdate.getBuffer() != buffer && bufferUpdate.getBuffer() != buffer2) {
                return;
            }
            if (bufferUpdate.getWhat() == BufferUpdate.LOADED || bufferUpdate.getWhat() == BufferUpdate.SAVED || bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED) {
                this.refresh();
            }
        } else if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            EditPane editPane = editPaneUpdate.getEditPane();
            View view = editPane.getView();
            if (!DualDiff.isEnabledFor(view)) {
                return;
            }
            if (editPaneUpdate.getWhat() == EditPaneUpdate.CREATED) {
                DualDiff.editPaneCreated(view);
            } else if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
                DualDiff.editPaneDestroyed(view, editPane);
            } else if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
                DualDiff.editPaneBufferChanged(view);
            }
        }
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void toggleIgnoreCase() {
        this.ignoreCase = !this.ignoreCase;
    }

    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean bl) {
        this.trimWhitespace = bl;
    }

    public void toggleTrimWhitespace() {
        this.trimWhitespace = !this.trimWhitespace;
    }

    public boolean getIgnoreAmountOfWhitespace() {
        return this.ignoreAmountOfWhitespace;
    }

    public void setIgnoreAmountOfWhitespace(boolean bl) {
        this.ignoreAmountOfWhitespace = bl;
    }

    public void toggleIgnoreAmountOfWhitespace() {
        this.ignoreAmountOfWhitespace = !this.ignoreAmountOfWhitespace;
    }

    public boolean getIgnoreAllWhitespace() {
        return this.ignoreAllWhitespace;
    }

    public void setIgnoreAllWhitespace(boolean bl) {
        this.ignoreAllWhitespace = bl;
    }

    public void toggleIgnoreAllWhitespace() {
        this.ignoreAllWhitespace = !this.ignoreAllWhitespace;
    }

    public void setDiffLineOverview(DiffLineOverview diffLineOverview) {
        this.diffLineOverview = diffLineOverview;
    }

    public DiffLineOverview getDiffLineOverview() {
        return this.diffLineOverview;
    }

    private void initOverviews() {
        Buffer buffer = this.editPane0.getBuffer();
        Buffer buffer2 = this.editPane1.getBuffer();
        if (!buffer.isLoaded() || !buffer2.isLoaded()) {
            this.edits = null;
            this.diffOverview0 = new DiffLocalOverview(this);
            this.diffOverview1 = new DiffGlobalPhysicalOverview(this);
        } else {
            Object[] objectArray = this.getFileLines(buffer);
            Object[] objectArray2 = this.getFileLines(buffer2);
            Diff diff = new Diff(objectArray, objectArray2);
            this.edits = diff.diff_2(false);
            this.diffOverview0 = new DiffLocalOverview(this);
            this.diffOverview1 = new DiffGlobalPhysicalOverview(this);
        }
    }

    private void addOverviews() {
        this.textArea0.addLeftOfScrollBar((Component)this.diffOverview0);
        this.textArea1.addLeftOfScrollBar((Component)this.diffOverview1);
    }

    private void removeOverviews() {
        this.textArea0.removeLeftOfScrollBar((Component)this.diffOverview0);
        this.textArea1.removeLeftOfScrollBar((Component)this.diffOverview1);
    }

    private void refresh() {
        this.removeHandlers();
        this.disableHighlighters();
        this.removeOverviews();
        this.initOverviews();
        this.addOverviews();
        this.enableHighlighters();
        this.addHandlers();
        this.diffLineOverview.clear();
        this.diffOverview0.synchroScrollRight();
        this.diffOverview1.repaint();
    }

    private void enableHighlighters() {
        DiffHighlight diffHighlight = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane0);
        if (diffHighlight == null) {
            diffHighlight = (DiffHighlight)DiffHighlight.addHighlightTo(this.editPane0, this.edits, DiffHighlight.LEFT);
            this.textArea0.getPainter().addExtension(-40, (TextAreaExtension)diffHighlight);
        } else {
            diffHighlight.setEdits(this.edits);
            diffHighlight.setPosition(DiffHighlight.LEFT);
        }
        DiffHighlight diffHighlight2 = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane1);
        if (diffHighlight2 == null) {
            diffHighlight2 = (DiffHighlight)DiffHighlight.addHighlightTo(this.editPane1, this.edits, DiffHighlight.RIGHT);
            this.textArea1.getPainter().addExtension(-40, (TextAreaExtension)diffHighlight2);
        } else {
            diffHighlight2.setEdits(this.edits);
            diffHighlight2.setPosition(DiffHighlight.RIGHT);
        }
        diffHighlight.setEnabled(true);
        diffHighlight.updateTextArea();
        diffHighlight2.setEnabled(true);
        diffHighlight2.updateTextArea();
    }

    private void disableHighlighters() {
        DiffHighlight diffHighlight;
        DiffHighlight diffHighlight2 = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane0);
        if (diffHighlight2 != null) {
            diffHighlight2.setEnabled(false);
            diffHighlight2.updateTextArea();
        }
        if ((diffHighlight = (DiffHighlight)DiffHighlight.getHighlightFor(this.editPane1)) != null) {
            diffHighlight.setEnabled(false);
            diffHighlight.updateTextArea();
        }
    }

    private void addHandlers() {
        this.textArea0.addScrollListener((ScrollListener)this.scrollHandler);
        this.textArea0.addFocusListener((FocusListener)this.scrollHandler);
        this.textArea1.addScrollListener((ScrollListener)this.scrollHandler);
        this.textArea1.addFocusListener((FocusListener)this.scrollHandler);
    }

    private void removeHandlers() {
        this.textArea0.removeScrollListener((ScrollListener)this.scrollHandler);
        this.textArea0.removeFocusListener((FocusListener)this.scrollHandler);
        this.textArea1.removeScrollListener((ScrollListener)this.scrollHandler);
        this.textArea1.removeFocusListener((FocusListener)this.scrollHandler);
    }

    private FileLine[] getFileLines(Buffer buffer) {
        FileLine[] fileLineArray = new FileLine[buffer.getLineCount()];
        for (int i = buffer.getLineCount() - 1; i >= 0; --i) {
            int n = buffer.getLineStartOffset(i);
            int n2 = buffer.getLineEndOffset(i);
            int n3 = n2 - 1 - n;
            if (n3 == 0) {
                fileLineArray[i] = new FileLine("", "");
                continue;
            }
            String string = "";
            String string2 = "";
            string2 = string = buffer.getText(n, n3);
            if (this.ignoreCase) {
                string2 = string2.toUpperCase();
            }
            if (this.trimWhitespace && !this.ignoreAllWhitespace) {
                string2 = DualDiff.trimWhitespaces(string2);
            }
            if (this.ignoreAmountOfWhitespace && !this.ignoreAllWhitespace) {
                string2 = DualDiff.squeezeRepeatedWhitespaces(string2);
            }
            if (this.ignoreAllWhitespace) {
                string2 = DualDiff.removeWhitespaces(string2);
            }
            fileLineArray[i] = new FileLine(string, string2);
        }
        return fileLineArray;
    }

    public static String squeezeRepeatedWhitespaces(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[n2];
        char[] cArray2 = new char[n2];
        string.getChars(0, n2, cArray, 0);
        boolean bl = false;
        for (n = 0; n < n2 && Character.isWhitespace(cArray[n]); ++n) {
        }
        while (n < n2) {
            if (Character.isWhitespace(cArray[n])) {
                bl = true;
            } else {
                if (bl) {
                    cArray2[n3++] = 32;
                    bl = false;
                }
                cArray2[n3++] = cArray[n];
            }
            ++n;
        }
        return new String(cArray2, 0, n3);
    }

    public static String removeWhitespaces(String string) {
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            cArray2[n2] = cArray[i];
            ++n2;
        }
        return new String(cArray2, 0, n2);
    }

    public static String trimWhitespaces(String string) {
        int n;
        int n2;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        for (n2 = 0; n2 < n3 && Character.isWhitespace(cArray[n2]); ++n2) {
        }
        for (n = n3 - 1; n >= n2 && Character.isWhitespace(cArray[n]); --n) {
        }
        if (n2 > 0 || n < n3 - 1) {
            return new String(cArray, n2, n - n2 + 1);
        }
        return string;
    }

    public static DualDiff getDualDiffFor(View view) {
        return dualDiffs.get(view);
    }

    public static boolean isEnabledFor(View view) {
        return dualDiffs.get(view) != null;
    }

    private static void editPaneCreated(View view) {
        DualDiff.removeFrom(view);
    }

    private static void editPaneDestroyed(View view, EditPane editPane) {
        DualDiff.removeFrom(view);
        DiffHighlight.removeHighlightFrom(editPane);
    }

    private static void editPaneBufferChanged(View view) {
        DualDiff.refreshFor(view);
    }

    private static void validateConfig(View view, String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(" ");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.startsWith("\"") || !string2.endsWith("\"") || !stringArray[i + 1].equals("buffer") && !stringArray[i + 1].equals("buff") || jEdit.getBuffer((String)(string2 = string2.substring(1, string2.length() - 1))) != null) continue;
            hashSet.add(string2);
        }
        for (String string2 : hashSet) {
            JOptionPane.showMessageDialog((Component)view, "JDiff encountered this problem while restoring perspective:\n\nFile closed during diff:\n" + string2, "JDiff Error", 0);
        }
    }

    public static void toggleFor(final View view) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (DualDiff.isEnabledFor(view)) {
                    Object object;
                    if (jEdit.getBooleanProperty((String)"jdiff.restore-view", (boolean)true)) {
                        object = (String)splitConfigs.get(view);
                        if (object != null) {
                            DualDiff.validateConfig(view, (String)object);
                            splitConfigs.remove(view);
                        } else {
                            view.unsplit();
                        }
                    }
                    if ((object = (HashMap)caretPositions.get(view)) != null) {
                        for (EditPane editPane : view.getEditPanes()) {
                            Integer n = (Integer)((HashMap)object).get(editPane.getBuffer().getPath());
                            if (n == null) continue;
                            editPane.getTextArea().setCaretPosition(n.intValue());
                            editPane.getTextArea().scrollToCaret(true);
                        }
                        object = null;
                        caretPositions.remove(view);
                    }
                    DualDiff.removeFrom(view);
                    view.getDockableWindowManager().hideDockableWindow("jdiff-lines");
                    EditBus.send((EBMessage)new DiffMessage(view, DiffMessage.OFF));
                    view.invalidate();
                    view.validate();
                } else {
                    EditPane[] editPaneArray = view.getEditPanes();
                    String string = null;
                    if (string != null) {
                        splitConfigs.put(view, string);
                    }
                    if (editPaneArray.length != 2 || string != null && !string.endsWith("horizontal")) {
                        view.unsplit();
                        view.splitVertically();
                    }
                    editPaneArray = view.getEditPanes();
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    hashMap.put(editPaneArray[0].getBuffer().getPath(), editPaneArray[0].getTextArea().getCaretPosition());
                    hashMap.put(editPaneArray[1].getBuffer().getPath(), editPaneArray[1].getTextArea().getCaretPosition());
                    caretPositions.put(view, hashMap);
                    DualDiff.addTo(view);
                    DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
                    if (!dockableWindowManager.isDockableWindowVisible("jdiff-lines") && jEdit.getBooleanProperty((String)"jdiff.auto-show-dockable")) {
                        if (dockableWindowManager.getDockableWindow("jdiff-lines") == null) {
                            dockableWindowManager.addDockableWindow("jdiff-lines");
                        }
                        dockableWindowManager.showDockableWindow("jdiff-lines");
                    }
                    EditBus.send((EBMessage)new DiffMessage(view, DiffMessage.ON));
                    view.invalidate();
                    view.validate();
                    DualDiff.refreshFor(view);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JSplitPane jSplitPane = view.getSplitPane();
                            jSplitPane.setDividerLocation(0.5);
                        }
                    });
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static void refreshFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.refresh();
            JSplitPane jSplitPane = view.getSplitPane();
            jSplitPane.setDividerLocation(0.5);
            view.invalidate();
            view.validate();
            if (view.getDockableWindowManager().isDockableWindowVisible("jdiff-lines")) {
                view.getDockableWindowManager().showDockableWindow("jdiff-lines");
            }
        } else if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            view.getToolkit().beep();
        }
    }

    public static boolean getIgnoreCaseFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        JSplitPane jSplitPane = view.getSplitPane();
        jSplitPane.setDividerLocation(0.5);
        return dualDiff.getIgnoreCase();
    }

    public static void toggleIgnoreCaseFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleIgnoreCase();
            dualDiff.refresh();
            JSplitPane jSplitPane = view.getSplitPane();
            jSplitPane.setDividerLocation(0.5);
            view.invalidate();
            view.validate();
        } else if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            view.getToolkit().beep();
        }
    }

    public static boolean getTrimWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        return dualDiff.getTrimWhitespace();
    }

    public static void toggleTrimWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleTrimWhitespace();
            dualDiff.refresh();
            JSplitPane jSplitPane = view.getSplitPane();
            jSplitPane.setDividerLocation(0.5);
            view.invalidate();
            view.validate();
        } else if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            view.getToolkit().beep();
        }
    }

    public static boolean getIgnoreAmountOfWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        return dualDiff.getIgnoreAmountOfWhitespace();
    }

    public static void toggleIgnoreAmountOfWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleIgnoreAmountOfWhitespace();
            dualDiff.refresh();
            JSplitPane jSplitPane = view.getSplitPane();
            jSplitPane.setDividerLocation(0.5);
            view.invalidate();
            view.validate();
        } else if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            view.getToolkit().beep();
        }
    }

    public static boolean getIgnoreAllWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        return dualDiff.getIgnoreAllWhitespace();
    }

    public static void toggleIgnoreAllWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleIgnoreAllWhitespace();
            dualDiff.refresh();
            JSplitPane jSplitPane = view.getSplitPane();
            jSplitPane.setDividerLocation(0.5);
            view.invalidate();
            view.validate();
        } else if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            view.getToolkit().beep();
        }
    }

    public Font getFont() {
        return this.textArea0.getPainter().getFont();
    }

    public Color getBackground() {
        return this.textArea0.getPainter().getBackground();
    }

    public static void nextDiff(EditPane editPane) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                editPane.getToolkit().beep();
            }
            return;
        }
        if (dualDiff.editPane0 == editPane) {
            dualDiff.nextDiff0();
        } else if (dualDiff.editPane1 == editPane) {
            dualDiff.nextDiff1();
        } else if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            editPane.getToolkit().beep();
        }
    }

    public static void prevDiff(EditPane editPane) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                editPane.getToolkit().beep();
            }
            return;
        }
        if (dualDiff.editPane0 == editPane) {
            dualDiff.prevDiff0();
        } else if (dualDiff.editPane1 == editPane) {
            dualDiff.prevDiff1();
        } else if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            editPane.getToolkit().beep();
        }
    }

    public static void moveRight(EditPane editPane) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                editPane.getToolkit().beep();
            }
            return;
        }
        editPane = editPane.getView().getEditPanes()[0];
        dualDiff.diffOverview0.moveRight(editPane.getTextArea().getCaretLine());
    }

    public static void moveLeft(EditPane editPane) {
        DualDiff dualDiff = DualDiff.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            editPane.getToolkit().beep();
            return;
        }
        editPane = editPane.getView().getEditPanes()[1];
        dualDiff.diffOverview0.moveLeft(editPane.getTextArea().getCaretLine());
    }

    public static void diffNormalOutput(View view) {
        View view2;
        Object[] objectArray;
        if (!DualDiff.isEnabledFor(view)) {
            if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                view.getToolkit().beep();
            }
            return;
        }
        DualDiff dualDiff = DualDiff.getDualDiffFor(view);
        Buffer buffer = dualDiff.editPane0.getBuffer();
        Buffer buffer2 = dualDiff.editPane1.getBuffer();
        Object[] objectArray2 = dualDiff.getFileLines(buffer);
        Diff diff = new Diff(objectArray2, objectArray = dualDiff.getFileLines(buffer2));
        Diff.Change change = diff.diff_2(false);
        if (change == null) {
            GUIUtilities.message((Component)view, (String)"jdiff.identical-files", null);
            return;
        }
        StringWriter stringWriter = new StringWriter();
        DiffNormalOutput diffNormalOutput = new DiffNormalOutput(objectArray2, objectArray);
        diffNormalOutput.setOut(new BufferedWriter(stringWriter));
        diffNormalOutput.setLineSeparator("\n");
        try {
            ((DiffOutput)diffNormalOutput).writeScript(change);
        }
        catch (IOException iOException) {
            Log.log((int)1, DualDiff.class, (Object)iOException);
        }
        for (view2 = jEdit.getFirstView(); view2 != null && DualDiff.isEnabledFor(view2); view2 = view2.getNext()) {
        }
        if (view2 == null) {
            view2 = jEdit.newView((View)view, (Buffer)view.getBuffer());
        }
        Buffer buffer3 = jEdit.newFile((View)view2);
        String string = stringWriter.toString();
        buffer3.insert(0, string);
        if (string.endsWith("\n") && buffer3.getLength() > 0) {
            buffer3.remove(buffer3.getLength() - 1, 1);
        }
    }

    void goToLine(JEditTextArea jEditTextArea, int n) {
        int n2 = jEditTextArea.getLineOfOffset(jEditTextArea.getCaretPosition());
        int n3 = n;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= jEditTextArea.getLineCount()) {
            n3 = jEditTextArea.getLineCount() - 1;
        }
        int n4 = n3 + jEditTextArea.getVisibleLines();
        if (n2 < n3 || n2 > n4) {
            jEditTextArea.setCaretPosition(jEditTextArea.getLineStartOffset(n3));
        }
        jEditTextArea.setFirstPhysicalLine(n3);
    }

    public static void applyPatch(View view) {
        try {
            PatchSelectionDialog patchSelectionDialog = new PatchSelectionDialog(view);
            DualDiff.center((Component)view, patchSelectionDialog);
            patchSelectionDialog.setVisible(true);
            String string = patchSelectionDialog.getPatchFile();
            if (string == null || string.length() == 0) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            StringWriter stringWriter = new StringWriter();
            PatchUtils.copyToWriter(bufferedReader, stringWriter);
            String string2 = stringWriter.toString();
            if (string2 == null || string2.length() == 0) {
                JOptionPane.showMessageDialog((Component)view, "Invalid patch file, file has no content.", "Error", 0);
                return;
            }
            Buffer buffer = view.getEditPane().getBuffer();
            String string3 = buffer.getText(0, buffer.getLength());
            String string4 = Patch.patch(string2, string3);
            jEdit.newFile((View)view).insert(0, string4);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)view, exception.getMessage(), "Error", 0);
        }
    }

    private void nextDiff0() {
        Diff.Change change = this.edits;
        int n = this.textArea0.getFirstPhysicalLine();
        while (change != null) {
            if (change.line0 > n + (change.deleted == 0 ? 1 : 0)) {
                int n2 = 0;
                n2 = change.deleted == 0 && change.line0 > 0 ? change.line0 : change.line0;
                this.goToLine(this.textArea0, n2);
                if (this.textArea0.getFirstPhysicalLine() != n2 && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea0.getToolkit().beep();
                }
                return;
            }
            change = change.link;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    private void nextDiff1() {
        Diff.Change change = this.edits;
        int n = this.textArea1.getFirstPhysicalLine();
        while (change != null) {
            if (change.line1 > n + (change.inserted == 0 ? 1 : 0)) {
                int n2 = 0;
                n2 = change.inserted == 0 && change.line1 > 0 ? change.line1 : change.line1;
                this.goToLine(this.textArea1, n2);
                if (this.textArea1.getFirstPhysicalLine() != n2 && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea1.getToolkit().beep();
                }
                return;
            }
            change = change.link;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    private void prevDiff0() {
        Diff.Change change = this.edits;
        int n = this.textArea0.getFirstPhysicalLine();
        while (change != null) {
            if (change.line0 < n && (change.link == null || change.link.line0 >= n)) {
                int n2 = 0;
                n2 = change.deleted == 0 && change.line0 > 0 ? change.line0 : change.line0;
                this.goToLine(this.textArea0, n2);
                if (this.textArea0.getFirstPhysicalLine() != n2 && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea0.getToolkit().beep();
                }
                return;
            }
            change = change.link;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea0.getToolkit().beep();
        }
    }

    private void prevDiff1() {
        Diff.Change change = this.edits;
        int n = this.textArea1.getFirstPhysicalLine();
        while (change != null) {
            if (change.line1 < n && (change.link == null || change.link.line1 >= n)) {
                int n2 = 0;
                n2 = change.inserted == 0 && change.line1 > 0 ? change.line1 : change.line1;
                this.goToLine(this.textArea1, n2);
                if (this.textArea1.getFirstPhysicalLine() != n2 && jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
                    this.textArea1.getToolkit().beep();
                }
                return;
            }
            change = change.link;
        }
        if (jEdit.getBooleanProperty((String)"jdiff.beep-on-error")) {
            this.textArea1.getToolkit().beep();
        }
    }

    private static void addTo(View view) {
        DualDiff dualDiff = new DualDiff(view);
        EditBus.addToBus((EBComponent)dualDiff);
        dualDiff.enableHighlighters();
        dualDiff.addHandlers();
        DiffLineOverview diffLineOverview = new DiffLineOverview(dualDiff, view);
        dualDiff.setDiffLineOverview(diffLineOverview);
        dualDiff.diffOverview0.synchroScrollRight();
        dualDiff.diffOverview1.repaint();
        dualDiffs.put(view, dualDiff);
        diffLineOverview.reset();
    }

    private static void removeFrom(View view) {
        DualDiff dualDiff = dualDiffs.get(view);
        EditBus.removeFromBus((EBComponent)dualDiff);
        if (dualDiff != null) {
            dualDiff.removeHandlers();
            dualDiff.disableHighlighters();
            dualDiff.removeOverviews();
            dualDiffs.remove(view);
            dualDiff.getDiffLineOverview().setModel(null);
        }
    }

    public static void propertiesChanged() {
        boolean bl = jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false);
        boolean bl2 = jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false);
        boolean bl3 = jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false);
        boolean bl4 = jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false);
        if (bl != ignoreCaseDefault || bl2 != trimWhitespaceDefault || bl3 != ignoreAmountOfWhitespaceDefault || bl4 != ignoreAllWhitespaceDefault) {
            ignoreCaseDefault = bl;
            trimWhitespaceDefault = bl2;
            ignoreAmountOfWhitespaceDefault = bl3;
            ignoreAllWhitespaceDefault = bl4;
        }
    }

    public static void center(Component component, Component component2) {
        int n;
        Rectangle rectangle = component.getBounds();
        Dimension dimension = component2.getSize();
        int n2 = rectangle.x + (rectangle.width - dimension.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = rectangle.y + (rectangle.height - dimension.height) / 2) < 0) {
            n = 0;
        }
        component2.setLocation(n2, n);
    }

    private class ScrollHandler
    implements ScrollListener,
    FocusListener,
    MouseListener {
        private Runnable syncWithRightVert = new Runnable(){

            public void run() {
                DualDiff.this.diffOverview0.repaint();
                DualDiff.this.diffOverview0.synchroScrollRight();
                DualDiff.this.diffOverview1.repaint();
            }
        };
        private Runnable syncWithLeftVert = new Runnable(){

            public void run() {
                DualDiff.this.diffOverview1.repaint();
                DualDiff.this.diffOverview1.synchroScrollLeft();
                DualDiff.this.diffOverview0.repaint();
            }
        };
        private Runnable syncWithRightHoriz = new Runnable(){

            public void run() {
                DualDiff.this.textArea1.setHorizontalOffset(DualDiff.this.textArea0.getHorizontalOffset());
            }
        };
        private Runnable syncWithLeftHoriz = new Runnable(){

            public void run() {
                DualDiff.this.textArea0.setHorizontalOffset(DualDiff.this.textArea1.getHorizontalOffset());
            }
        };

        private ScrollHandler() {
        }

        public void scrolledHorizontally(TextArea textArea) {
            if (textArea == DualDiff.this.textArea0) {
                SwingUtilities.invokeLater(this.syncWithRightHoriz);
            } else if (textArea == DualDiff.this.textArea1) {
                SwingUtilities.invokeLater(this.syncWithLeftHoriz);
            }
        }

        public void scrolledVertically(TextArea textArea) {
            if (textArea.isFocusOwner()) {
                if (textArea == DualDiff.this.textArea0) {
                    SwingUtilities.invokeLater(this.syncWithRightVert);
                } else if (textArea == DualDiff.this.textArea1) {
                    SwingUtilities.invokeLater(this.syncWithLeftVert);
                }
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (jEdit.getBooleanProperty((String)"jdiff.auto-show-dockable") && !DualDiff.this.view.getDockableWindowManager().isDockableWindowVisible("jdiff-lines")) {
                DualDiff.this.view.getDockableWindowManager().showDockableWindow("jdiff-lines");
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

