/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import javax.swing.JComponent;
import jdiff.DualDiff;
import jdiff.component.DiffTextAreaModel;
import jdiff.util.Diff;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public abstract class DiffOverview
extends JComponent {
    protected DualDiff dualDiff;
    private DiffTextAreaModel model = null;
    protected Diff.Change edits;
    protected int lineCount0;
    protected int lineCount1;
    protected JEditTextArea textArea0;
    protected JEditTextArea textArea1;

    public DiffOverview() {
        this(null);
    }

    public DiffOverview(DualDiff dualDiff) {
        this.dualDiff = dualDiff;
        this.setModel(new DiffTextAreaModel(dualDiff));
    }

    public void setModel(DiffTextAreaModel diffTextAreaModel) {
        this.model = diffTextAreaModel;
        this.edits = diffTextAreaModel.getEdits();
        this.lineCount0 = diffTextAreaModel.getLeftLineCount();
        this.lineCount1 = diffTextAreaModel.getRightLineCount();
        this.textArea0 = diffTextAreaModel.getLeftTextArea();
        this.textArea1 = diffTextAreaModel.getRightTextArea();
    }

    public DiffTextAreaModel getModel() {
        return this.model;
    }

    public void synchroScrollRight() {
        Diff.Change change = this.edits;
        int n = this.textArea0.getFirstPhysicalLine();
        int n2 = -1;
        if (change == null) {
            this.goToLine(this.textArea1, n2);
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (change != null) {
            n5 = change.line0;
            n6 = change.line1;
            if (n >= n3 && n < n5) {
                n2 = n4 + (n - n3);
                break;
            }
            if (n >= n5 && n < n5 + change.deleted) {
                n2 = n6;
                break;
            }
            n3 = n5 + change.deleted;
            n4 = n6 + change.inserted;
            if (change.link == null) {
                n2 = n4 + (n - n3);
                break;
            }
            change = change.link;
        }
        if (n2 >= 0) {
            this.goToLine(this.textArea1, n2);
        }
    }

    public void synchroScrollLeft() {
        Diff.Change change = this.edits;
        int n = -1;
        int n2 = this.textArea1.getFirstPhysicalLine();
        if (change == null) {
            this.goToLine(this.textArea0, n);
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (change != null) {
            n5 = change.line0;
            n6 = change.line1;
            if (n2 >= n4 && n2 < n6) {
                n = n3 + (n2 - n4);
                break;
            }
            if (n2 >= n6 && n2 < n6 + change.inserted) {
                n = n5;
                break;
            }
            n3 = n5 + change.deleted;
            n4 = n6 + change.inserted;
            if (change.link == null) {
                n = n3 + (n2 - n4);
                break;
            }
            change = change.link;
        }
        if (n >= 0) {
            this.goToLine(this.textArea0, n);
        }
    }

    void goToLine(JEditTextArea jEditTextArea, int n) {
        int n2;
        if (jEdit.getActiveView().getTextArea().equals(jEditTextArea)) {
            return;
        }
        int n3 = n;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= jEditTextArea.getLineCount()) {
            n3 = jEditTextArea.getLineCount() - 1;
        }
        jEditTextArea.setFirstPhysicalLine(n3);
        if ((jEditTextArea.getWidth() != 0 || jEditTextArea.getHeight() != 0 || jEditTextArea.getX() != 0 || jEditTextArea.getY() != 0) && (n2 = jEditTextArea.getScreenLineStartOffset(jEditTextArea.getVisibleLines() / 2)) != -1) {
            jEditTextArea.centerCaret();
        }
    }

    public void moveRight(int n) {
    }

    public void moveLeft(int n) {
    }
}

