/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.util.HashMap;
import jdiff.DualDiff;
import jdiff.text.FileLine;
import jdiff.util.Diff;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffTextAreaModel {
    private DualDiff dualDiff;
    private Diff.Change edits = null;
    private HashMap<Integer, Diff.Change> leftHunkMap = null;
    private HashMap<Integer, Diff.Change> rightHunkMap = null;
    private int leftLineCount;
    private int rightLineCount;
    private JEditTextArea leftTextArea;
    private JEditTextArea rightTextArea;

    public DiffTextAreaModel(DualDiff dualDiff) {
        this.dualDiff = dualDiff;
        this.prepData();
    }

    public Diff.Change getEdits() {
        return this.edits;
    }

    public int getLeftLineCount() {
        return this.leftLineCount;
    }

    public int getRightLineCount() {
        return this.rightLineCount;
    }

    public JEditTextArea getLeftTextArea() {
        return this.leftTextArea;
    }

    public JEditTextArea getRightTextArea() {
        return this.rightTextArea;
    }

    public HashMap<Integer, Diff.Change> getLeftHunkMap() {
        return this.leftHunkMap;
    }

    public HashMap<Integer, Diff.Change> getRightHunkMap() {
        return this.rightHunkMap;
    }

    private void prepData() {
        EditPane[] editPanes = this.dualDiff.getView().getEditPanes();
        Buffer buf0 = editPanes[0].getBuffer();
        Buffer buf1 = editPanes[1].getBuffer();
        this.leftTextArea = editPanes[0].getTextArea();
        this.rightTextArea = editPanes[1].getTextArea();
        if (!buf0.isLoaded() || !buf1.isLoaded()) {
            this.edits = null;
            this.leftLineCount = buf0.isLoaded() ? buf0.getLineCount() : 1;
            this.rightLineCount = buf1.isLoaded() ? buf1.getLineCount() : 1;
        } else {
            Object[] fileLines0 = this.getFileLines(buf0);
            Object[] fileLines1 = this.getFileLines(buf1);
            Diff d = new Diff(fileLines0, fileLines1);
            this.edits = d.diff_2(false);
            this.leftHunkMap = new HashMap();
            this.rightHunkMap = new HashMap();
            Diff.Change hunk = this.edits;
            while (hunk != null) {
                int i;
                for (i = 0; i < Math.max(1, hunk.deleted); ++i) {
                    this.leftHunkMap.put(hunk.line0 + i, hunk);
                }
                for (i = 0; i < Math.max(1, hunk.inserted); ++i) {
                    this.rightHunkMap.put(hunk.line1 + i, hunk);
                }
                hunk = hunk.link;
            }
            this.leftLineCount = fileLines0.length;
            this.rightLineCount = fileLines1.length;
        }
    }

    private FileLine[] getFileLines(Buffer buffer) {
        FileLine[] lines = new FileLine[buffer.getLineCount()];
        for (int i = buffer.getLineCount() - 1; i >= 0; --i) {
            int start = buffer.getLineStartOffset(i);
            int end = buffer.getLineEndOffset(i);
            int len = end - 1 - start;
            if (len == 0) {
                lines[i] = new FileLine("", "");
                continue;
            }
            String text = "";
            String canonical = "";
            canonical = text = buffer.getText(start, len);
            if (DualDiff.getIgnoreCaseFor(this.dualDiff.getView())) {
                canonical = canonical.toUpperCase();
            }
            if (DualDiff.getTrimWhitespaceFor(this.dualDiff.getView()) && !DualDiff.getIgnoreAllWhitespaceFor(this.dualDiff.getView())) {
                canonical = DualDiff.trimWhitespaces(canonical);
            }
            if (DualDiff.getIgnoreAmountOfWhitespaceFor(this.dualDiff.getView()) && !DualDiff.getIgnoreAllWhitespaceFor(this.dualDiff.getView())) {
                canonical = DualDiff.squeezeRepeatedWhitespaces(canonical);
            }
            if (DualDiff.getIgnoreAllWhitespaceFor(this.dualDiff.getView())) {
                canonical = DualDiff.removeWhitespaces(canonical);
            }
            lines[i] = new FileLine(text, canonical);
        }
        return lines;
    }
}

