/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import jdiff.JDiffPlugin;
import jdiff.component.DiffGlobalPhysicalOverview;
import jdiff.component.DiffTextAreaModel;
import jdiff.component.ui.DiffGlobalPhysicalOverviewUI;
import jdiff.util.Diff;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class BasicDiffGlobalPhysicalOverviewUI
extends DiffGlobalPhysicalOverviewUI
implements MouseListener {
    private DiffGlobalPhysicalOverview diffGlobalPhysicalOverview;
    private LocalRendererPane localRendererPane;
    private double pixelsPerLine = 1.0;
    private Rectangle leftRectangle;
    private Rectangle rightRectangle;
    private Image offImage = null;
    private Graphics offGfx = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDiffGlobalPhysicalOverviewUI();
    }

    public void installUI(JComponent jComponent) {
        this.diffGlobalPhysicalOverview = (DiffGlobalPhysicalOverview)jComponent;
        this.diffGlobalPhysicalOverview.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.diffGlobalPhysicalOverview = null;
    }

    public void installDefaults() {
    }

    public void installComponents() {
        this.localRendererPane = new LocalRendererPane();
        this.diffGlobalPhysicalOverview.add((Component)this.localRendererPane, "Center");
    }

    public void installListeners() {
        this.diffGlobalPhysicalOverview.addMouseListener(this);
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
    }

    public void uninstallListeners() {
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DiffTextAreaModel diffTextAreaModel = this.diffGlobalPhysicalOverview.getModel();
        if (diffTextAreaModel == null) {
            return;
        }
        JEditTextArea jEditTextArea = diffTextAreaModel.getLeftTextArea();
        JEditTextArea jEditTextArea2 = diffTextAreaModel.getRightTextArea();
        int n = 0;
        if (this.leftRectangle.contains(mouseEvent.getX(), mouseEvent.getY()) || this.rightRectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            n = (int)((double)mouseEvent.getY() / this.pixelsPerLine);
            jEditTextArea.setFirstPhysicalLine(Math.min(n, jEditTextArea.getLineCount()));
            jEditTextArea2.setFirstPhysicalLine(Math.min(n, jEditTextArea2.getLineCount()));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public class LocalRendererPane
    extends JPanel {
        public LocalRendererPane() {
            Dimension dimension = this.getPreferredSize();
            dimension.width = 36;
            this.setPreferredSize(dimension);
        }

        private boolean createImage() {
            if (this.isVisible() && (BasicDiffGlobalPhysicalOverviewUI.this.offGfx == null || this.getWidth() != BasicDiffGlobalPhysicalOverviewUI.this.offImage.getWidth(null) || this.getHeight() != BasicDiffGlobalPhysicalOverviewUI.this.offImage.getHeight(null))) {
                BasicDiffGlobalPhysicalOverviewUI.this.offImage = this.createImage(this.getWidth(), this.getHeight());
                BasicDiffGlobalPhysicalOverviewUI.this.offGfx = BasicDiffGlobalPhysicalOverviewUI.this.offImage.getGraphics();
                this.paintOffImage(BasicDiffGlobalPhysicalOverviewUI.this.offGfx);
            }
            return BasicDiffGlobalPhysicalOverviewUI.this.offGfx != null;
        }

        private void paintOffImage(Graphics graphics) {
            DiffTextAreaModel diffTextAreaModel = BasicDiffGlobalPhysicalOverviewUI.this.diffGlobalPhysicalOverview.getModel();
            if (diffTextAreaModel == null) {
                return;
            }
            int n = diffTextAreaModel.getLeftLineCount();
            int n2 = diffTextAreaModel.getRightLineCount();
            Rectangle rectangle = this.getBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            Rectangle rectangle2 = new Rectangle(4, 4, rectangle.width - 8, rectangle.height - 8);
            int n3 = Math.max(n, n2);
            BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine = (double)rectangle2.height / (double)n3;
            Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width / 3, Math.max(1, (int)Math.round(BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine * (double)n)));
            Rectangle rectangle4 = new Rectangle(rectangle2.x + (rectangle2.width - rectangle3.width), rectangle2.y, rectangle3.width, Math.max(1, (int)Math.round(BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine * (double)n2)));
            BasicDiffGlobalPhysicalOverviewUI.this.leftRectangle = new Rectangle(rectangle3);
            BasicDiffGlobalPhysicalOverviewUI.this.rightRectangle = new Rectangle(rectangle4);
            Color color = JDiffPlugin.overviewInvalidColor;
            Color color2 = JDiffPlugin.overviewInvalidColor;
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle3.x - 1, rectangle3.y - 1, rectangle3.width + 1, rectangle3.height + 1);
            graphics.drawRect(rectangle4.x - 1, rectangle4.y - 1, rectangle4.width + 1, rectangle4.height + 1);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
            Diff.Change change = diffTextAreaModel.getEdits();
            int n4 = 0;
            int n5 = 0;
            while (change != null) {
                n4 = change.line0;
                n5 = change.line1;
                if (change.inserted == 0 && change.deleted != 0) {
                    color = JDiffPlugin.overviewDeletedColor;
                    color2 = JDiffPlugin.overviewInvalidColor;
                } else if (change.inserted != 0 && change.deleted == 0) {
                    color = JDiffPlugin.overviewInvalidColor;
                    color2 = JDiffPlugin.overviewInsertedColor;
                } else {
                    color = JDiffPlugin.overviewChangedColor;
                    color2 = JDiffPlugin.overviewChangedColor;
                }
                rectangle3.y = rectangle2.y + (int)Math.round((double)n4 * BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine);
                rectangle4.y = rectangle2.y + (int)Math.round((double)n5 * BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine);
                rectangle3.height = Math.max(1, (int)Math.round((double)change.deleted * BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine));
                rectangle4.height = Math.max(1, (int)Math.round((double)change.inserted * BasicDiffGlobalPhysicalOverviewUI.this.pixelsPerLine));
                graphics.setColor(color);
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                graphics.setColor(color2);
                graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                graphics.setColor(Color.black);
                graphics.drawLine(rectangle3.x + rectangle3.width + 1, rectangle3.y, rectangle4.x - 1, rectangle4.y);
                change = change.link;
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            DiffTextAreaModel diffTextAreaModel = BasicDiffGlobalPhysicalOverviewUI.this.diffGlobalPhysicalOverview.getModel();
            if (diffTextAreaModel == null) {
                return;
            }
            if (!this.createImage()) {
                return;
            }
            graphics.drawImage(BasicDiffGlobalPhysicalOverviewUI.this.offImage, 0, 0, this);
            this.paintCursor(graphics, diffTextAreaModel);
        }

        public void paintCursor(Graphics graphics, DiffTextAreaModel diffTextAreaModel) {
            int n = diffTextAreaModel.getLeftLineCount();
            int n2 = diffTextAreaModel.getRightLineCount();
            JEditTextArea jEditTextArea = diffTextAreaModel.getLeftTextArea();
            JEditTextArea jEditTextArea2 = diffTextAreaModel.getRightTextArea();
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = new Rectangle(4, 4, rectangle.width - 8, rectangle.height - 8);
            int n3 = Math.max(n, n2);
            double d = (double)rectangle2.height / (double)n3;
            int n4 = jEditTextArea.getFirstPhysicalLine();
            int n5 = jEditTextArea.getLastPhysicalLine();
            Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y + (int)Math.round(d * (double)n4), rectangle2.width / 3, Math.max(1, (int)Math.round(d * (double)Math.min(n, n5 - n4 + 1))));
            int n6 = jEditTextArea2.getFirstPhysicalLine();
            int n7 = jEditTextArea2.getLastPhysicalLine();
            Rectangle rectangle4 = new Rectangle(rectangle2.x + (rectangle2.width - rectangle3.width), rectangle2.y + (int)Math.round(d * (double)n6), rectangle3.width, Math.max(1, (int)Math.round(d * (double)Math.min(n2, n7 - n6 + 1))));
            graphics.setColor(JDiffPlugin.leftCursorColor);
            graphics.drawRect(rectangle3.x, rectangle3.y, rectangle3.width - 1, rectangle3.height - 1);
            graphics.drawRect(rectangle3.x + 1, rectangle3.y + 1, rectangle3.width - 1 - 2, rectangle3.height - 1 - 2);
            graphics.setColor(JDiffPlugin.rightCursorColor);
            graphics.drawRect(rectangle4.x, rectangle4.y, rectangle4.width - 1, rectangle4.height - 1);
            graphics.drawRect(rectangle4.x + 1, rectangle4.y + 1, rectangle4.width - 1 - 2, rectangle4.height - 1 - 2);
        }
    }
}

