/*
 * Decompiled with CFR 0.152.
 */
package jdiff.options;

import ise.java.awt.KappaLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;

public class JDiffOptionPane
extends AbstractOptionPane {
    private JCheckBox ignoreCase;
    private JCheckBox trimWhitespace;
    private JCheckBox ignoreAmountOfWhitespace;
    private JCheckBox ignoreAllWhitespace;
    private JCheckBox autoShowDockable;
    private JCheckBox beepOnError;
    private JRadioButton horizontal;
    private JRadioButton vertical;
    private JRadioButton compact;
    private JCheckBox showLineDiff;
    private JCheckBox restoreView;

    public JDiffOptionPane() {
        super("jdiff-general");
    }

    public void _init() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel diff_options_label = new JLabel(jEdit.getProperty((String)"options.diff-options.label", (String)"Diff Options:"));
        this.ignoreCase = this.createCheckBox("jdiff.ignore-case", false);
        this.trimWhitespace = this.createCheckBox("jdiff.trim-whitespace", false);
        this.ignoreAmountOfWhitespace = this.createCheckBox("jdiff.ignore-amount-whitespace", false);
        this.ignoreAllWhitespace = this.createCheckBox("jdiff.ignore-all-whitespace", false);
        JLabel ui_options_label = new JLabel(jEdit.getProperty((String)"options.ui-options.label", (String)"UI Options:"));
        this.autoShowDockable = this.createCheckBox("jdiff.auto-show-dockable", false);
        this.showLineDiff = this.createCheckBox("jdiff.show-line-diff", true);
        this.beepOnError = this.createCheckBox("jdiff.beep-on-error", true);
        this.restoreView = this.createCheckBox("jdiff.restore-view", true);
        int orientation = jEdit.getIntegerProperty((String)"jdiff.toolbar-orientation", (int)1);
        this.horizontal = new JRadioButton(jEdit.getProperty((String)"options.jdiff.toolbar-horizontal"));
        this.vertical = new JRadioButton(jEdit.getProperty((String)"options.jdiff.toolbar-vertical"));
        this.compact = new JRadioButton(jEdit.getProperty((String)"options.jdiff.toolbar-compact"));
        ButtonGroup button_group = new ButtonGroup();
        button_group.add(this.horizontal);
        button_group.add(this.vertical);
        button_group.add(this.compact);
        switch (orientation) {
            case 2: {
                this.horizontal.setSelected(false);
                this.vertical.setSelected(true);
                this.compact.setSelected(false);
                break;
            }
            case 3: {
                this.horizontal.setSelected(false);
                this.vertical.setSelected(false);
                this.compact.setSelected(true);
                break;
            }
            default: {
                this.horizontal.setSelected(true);
                this.vertical.setSelected(false);
                this.compact.setSelected(false);
            }
        }
        JLabel orientation_label = new JLabel(jEdit.getProperty((String)"options.toolbar-orientation.label", (String)"Merge Toolbar Orientation:"));
        this.addComponent(diff_options_label);
        this.addComponent(this.ignoreCase);
        this.addComponent(this.trimWhitespace);
        this.addComponent(this.ignoreAmountOfWhitespace);
        this.addComponent(this.ignoreAllWhitespace);
        this.addComponent(KappaLayout.createVerticalStrut((int)11));
        this.addComponent(ui_options_label);
        this.addComponent(this.autoShowDockable);
        this.addComponent(this.showLineDiff);
        this.addComponent(this.beepOnError);
        this.addComponent(this.restoreView);
        this.addComponent(KappaLayout.createVerticalStrut((int)11));
        this.addComponent(orientation_label);
        this.addComponent(this.horizontal);
        this.addComponent(this.vertical);
        this.addComponent(this.compact);
    }

    public void _save() {
        if (this.vertical.isSelected()) {
            jEdit.setIntegerProperty((String)"jdiff.toolbar-orientation", (int)2);
        } else if (this.compact.isSelected()) {
            jEdit.setIntegerProperty((String)"jdiff.toolbar-orientation", (int)3);
        } else {
            jEdit.setIntegerProperty((String)"jdiff.toolbar-orientation", (int)1);
        }
        jEdit.setBooleanProperty((String)"jdiff.ignore-case", (boolean)this.ignoreCase.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.trim-whitespace", (boolean)this.trimWhitespace.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)this.ignoreAmountOfWhitespace.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)this.ignoreAllWhitespace.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.auto-show-dockable", (boolean)this.autoShowDockable.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.show-line-diff", (boolean)this.showLineDiff.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.beep-on-error", (boolean)this.beepOnError.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.restore-view", (boolean)this.restoreView.isSelected());
        jEdit.setBooleanProperty((String)"jdiff.global-virtual-overview", (boolean)false);
    }

    private JCheckBox createCheckBox(String property, boolean defaultValue) {
        JCheckBox cb = new JCheckBox(jEdit.getProperty((String)("options." + property)));
        cb.setSelected(jEdit.getBooleanProperty((String)property, (boolean)defaultValue));
        return cb;
    }
}

