/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import sidekick.ModeOptionPane;

public class ModeOptionPaneController
implements ModeOptionPane {
    private HashMap<String, Object> modeProps = new HashMap();
    private Set<String> useDefaults = new HashSet<String>();
    private Object props;
    private String mode;
    ModeOptionPaneDelegate delegate;

    public ModeOptionPaneController(ModeOptionPaneDelegate modeOptionPaneDelegate) {
        this.delegate = modeOptionPaneDelegate;
    }

    public void modeSelected(String string) {
        if (this.mode != null) {
            this.delegate.updatePropsFromUI(this.props);
        }
        this.mode = string;
        this.props = this.modeProps.get(string);
        if (this.props == null) {
            this.props = this.delegate.createModeProps(string);
            if (string != null && !this.delegate.hasModeProps(string)) {
                this.useDefaults.add(string);
            }
            this.modeProps.put(string, this.props);
        }
        this.delegate.updateUIFromProps(this.props);
        this.setEnabled(this.delegate.getUIComponent(), !this.useDefaults.contains(string));
    }

    public void setUseDefaults(boolean bl) {
        if (bl) {
            this.useDefaults.add(this.mode);
        } else {
            this.useDefaults.remove(this.mode);
        }
        this.setEnabled(this.delegate.getUIComponent(), !bl);
    }

    public void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            this.setEnabled((JComponent)componentArray[i], bl);
        }
    }

    public void save() {
        this.delegate.updatePropsFromUI(this.props);
        for (String string : this.modeProps.keySet()) {
            if (this.useDefaults.contains(string)) {
                this.delegate.resetModeProps(string);
                continue;
            }
            this.delegate.saveModeProps(string, this.modeProps.get(string));
        }
    }

    public void cancel() {
        this.modeProps.clear();
    }

    public boolean getUseDefaults(String string) {
        if (this.modeProps.get(string) != null) {
            return this.useDefaults.contains(string);
        }
        return !this.delegate.hasModeProps(string);
    }

    public static interface ModeOptionPaneDelegate {
        public JComponent getUIComponent();

        public void updatePropsFromUI(Object var1);

        public void updateUIFromProps(Object var1);

        public Object createModeProps(String var1);

        public void saveModeProps(String var1, Object var2);

        public void resetModeProps(String var1);

        public boolean hasModeProps(String var1);
    }
}

