/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.Collections;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;

class MyTableModel
extends AbstractTableModel {
    private Vector modes;

    MyTableModel() {
        Mode[] modeArray = jEdit.getModes();
        this.modes = new Vector(modeArray.length);
        for (int i = 0; i < modeArray.length; ++i) {
            this.modes.addElement(new Entry(modeArray[i].getName()));
        }
        Collections.sort(this.modes);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.modes.size();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    public Object getValueAt(int n, int n2) {
        Entry entry = (Entry)this.modes.elementAt(n);
        switch (n2) {
            case 0: {
                return entry.mode;
            }
            case 1: {
                return entry.parser;
            }
        }
        throw new InternalError();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        Entry entry = (Entry)this.modes.elementAt(n);
        switch (n2) {
            case 1: {
                entry.parser = (String)object;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return jEdit.getProperty((String)"options.sidekick.parser.mode");
            }
            case 1: {
                return jEdit.getProperty((String)"options.sidekick.parser.parser");
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.modes.size(); ++i) {
            ((Entry)this.modes.elementAt(i)).save();
        }
    }

    class Entry
    implements Comparable {
        String mode;
        String parser = null;

        Entry(String string) {
            this.mode = string;
            this.parser = jEdit.getProperty((String)("mode." + this.mode + ".sidekick.parser"));
        }

        void save() {
            if (this.parser == "default parser") {
                jEdit.resetProperty((String)("mode." + this.mode + ".sidekick.parser"));
            } else {
                jEdit.setProperty((String)("mode." + this.mode + ".sidekick.parser"), (String)this.parser);
            }
        }

        public int compareTo(Object object) {
            return this.mode.compareToIgnoreCase(((Entry)object).mode);
        }
    }
}

