/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferChanging;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.EditorExiting;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import sidekick.AbstractModeOptionPane;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickPlugin;
import sidekick.SideKickTree;
import sidekick.SideKickUpdate;

public class SideKick {
    public static final String BUFFER_CHANGE = "sidekick.buffer-change-parse";
    public static final String BUFFER_SAVE = "sidekick.buffer-save-parse";
    public static final String FOLLOW_CARET = "sidekick-tree.follows-caret";
    public static final String AUTO_EXPAND_DEPTH = "sidekick-tree.auto-expand-tree-depth";
    public static final String SHOW_STATUS = "sidekick.showStatusWindow.label";
    public static final String FILTER_VISIBLE = "sidekick.filter-visible-assets";
    public static final String SHOW_FILTER = "sidekick.showFilter";
    private static boolean exiting = false;
    private View view;
    private EditPane editPane;
    private Buffer buffer;
    private SideKickParser parser;
    private DefaultErrorSource errorSource;
    private boolean showParsingMessage;
    private int delay;
    private Timer keystrokeTimer;
    private BufferChangeListener bufferListener;
    private boolean addedBufferListener;

    SideKick(View view) {
        this.view = view;
        this.editPane = view.getEditPane();
        this.bufferListener = new BufferChangeListener();
        this.propertiesChanged();
        this.keystrokeTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SideKick.this.parse(false);
            }
        });
        this.buffer = view.getBuffer();
        EditBus.addToBus((Object)this);
    }

    public static boolean isFollowCaret() {
        try {
            String string = jEdit.getActiveView().getBuffer().getMode().getName();
            return AbstractModeOptionPane.getBooleanProperty(string, FOLLOW_CARET);
        }
        catch (NullPointerException nullPointerException) {
            return jEdit.getBooleanProperty((String)FOLLOW_CARET);
        }
    }

    public static boolean isGlobalFollowCaret() {
        return jEdit.getBooleanProperty((String)FOLLOW_CARET);
    }

    public static void setGlobalFollowCaret(boolean bl) {
        jEdit.setBooleanProperty((String)FOLLOW_CARET, (boolean)bl);
    }

    public static void setParseOnSave(boolean bl) {
        jEdit.setBooleanProperty((String)BUFFER_SAVE, (boolean)bl);
    }

    public static void setParseOnChange(boolean bl) {
        jEdit.setBooleanProperty((String)BUFFER_CHANGE, (boolean)bl);
    }

    public static boolean isParseOnSave() {
        return jEdit.getBooleanProperty((String)BUFFER_SAVE);
    }

    public static boolean isParseOnChange() {
        return jEdit.getBooleanProperty((String)BUFFER_CHANGE);
    }

    void parse(boolean bl) {
        Object object;
        if (this.keystrokeTimer.isRunning()) {
            this.keystrokeTimer.stop();
        }
        if (!this.buffer.isLoaded()) {
            return;
        }
        if (SideKickPlugin.isParsingBuffer(this.buffer)) {
            return;
        }
        SideKickPlugin.startParsingBuffer(this.buffer);
        this.showParsingMessage = bl;
        this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
        if (this.parser == null) {
            Log.log((int)1, (Object)this, (Object)"No parser");
            this.setErrorSource(null);
            this.showNotParsedMessage();
            SideKickPlugin.finishParsingBuffer(this.buffer);
            return;
        }
        if (bl) {
            object = new SideKickParsedData(this.buffer.getName());
            ((SideKickParsedData)object).root.add(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.parsing")));
            SideKickParsedData.setParsedData(this.view, (SideKickParsedData)object);
            this.sendUpdate();
        }
        object = new ParseRequestWorker(this.parser, this.buffer);
        SideKickPlugin.execute(this.view, (SwingWorker<SideKickParsedData, Object>)object);
    }

    void dispose() {
        this.setErrorSource(null);
        EditBus.removeFromBus((Object)this);
        this.removeBufferChangeListener(this.buffer);
    }

    SideKickParser getParser() {
        return this.parser;
    }

    void setParser(Buffer buffer) {
        this.deactivateParser();
        if (buffer != null) {
            this.buffer = buffer;
        }
        this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
        this.activateParser();
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleEditorExiting(EditorExiting editorExiting) {
        exiting = true;
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bufferUpdate) {
        if (bufferUpdate.getWhat() == BufferUpdate.PROPERTIES_CHANGED && this.view.getBuffer() == bufferUpdate.getBuffer()) {
            String string;
            String string2 = this.buffer.getStringProperty("sidekick.parser-mode");
            String string3 = string = this.buffer.getMode() != null ? this.buffer.getMode().getName() : "";
            if (!string.equals(string2)) {
                this.buffer.unsetProperty("sidekick.parser");
                this.setParser(this.view.getBuffer());
            }
        }
        if (bufferUpdate.getView() != this.view && (bufferUpdate.getView() != null || bufferUpdate.getBuffer() != this.view.getBuffer())) {
            return;
        }
        if (bufferUpdate.getWhat() == BufferUpdate.SAVED && SideKick.isParseOnSave()) {
            this.setParser(this.buffer);
        } else if (bufferUpdate.getWhat() == BufferUpdate.LOADED && SideKick.isParseOnChange()) {
            this.parse(true);
        } else if (bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
            this.setErrorSource(null);
        }
    }

    @EditBus.EBHandler
    public void handleBufferChange(BufferChanging bufferChanging) {
        this.buffer = bufferChanging.getBuffer();
        this.buffer.setProperty("sidekick.parser", null);
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        this.editPane = editPaneUpdate.getEditPane();
        View view = this.editPane.getView();
        if (view == null) {
            view = jEdit.getActiveView();
        }
        if (view == null || view != this.view) {
            return;
        }
        if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
            if (this.editPane == view.getEditPane()) {
                this.removeBufferChangeListener(this.buffer);
                this.deactivateParser();
            }
        } else if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
            if (!SideKick.isParseOnChange()) {
                SideKickTree sideKickTree = (SideKickTree)this.view.getDockableWindowManager().getDockable("sidekick");
                if (sideKickTree != null) {
                    sideKickTree.reloadParserCombo();
                }
                return;
            }
            if (this.editPane == this.view.getEditPane()) {
                this.removeBufferChangeListener(this.buffer);
                this.deactivateParser();
                this.buffer = this.editPane.getBuffer();
                if (!this.buffer.isLoaded()) {
                    return;
                }
                this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
                this.activateParser();
                this.parse(true);
            }
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate viewUpdate) {
        if (viewUpdate.getView() == this.view && this.buffer != this.view.getBuffer() && viewUpdate.getWhat() == ViewUpdate.EDIT_PANE_CHANGED) {
            if (!SideKick.isParseOnChange()) {
                return;
            }
            this.removeBufferChangeListener(this.buffer);
            this.deactivateParser();
            this.buffer = this.view.getBuffer();
            this.editPane = this.view.getEditPane();
            this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
            this.activateParser();
            this.parse(true);
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pluginUpdate) {
        if (!(exiting || pluginUpdate.getWhat() != PluginUpdate.UNLOADED && pluginUpdate.getWhat() != PluginUpdate.LOADED)) {
            this.setParser(null);
        }
    }

    private void setErrorSource(DefaultErrorSource defaultErrorSource) {
        int n;
        if (this.errorSource != null) {
            ErrorSource.unregisterErrorSource((ErrorSource)this.errorSource);
            this.errorSource.clear();
        }
        this.errorSource = defaultErrorSource;
        if (defaultErrorSource != null && (n = defaultErrorSource.getErrorCount()) != 0) {
            ErrorSource.registerErrorSource((ErrorSource)defaultErrorSource);
        }
    }

    private void addBufferChangeListener(Buffer buffer) {
        if (!this.addedBufferListener) {
            this.bufferListener = new BufferChangeListener();
            buffer.addBufferListener((BufferListener)this.bufferListener);
            this.addedBufferListener = true;
        }
    }

    private void removeBufferChangeListener(Buffer buffer) {
        if (this.addedBufferListener) {
            buffer.removeBufferListener((BufferListener)this.bufferListener);
            this.addedBufferListener = false;
        }
    }

    @EditBus.EBHandler
    private void propertiesChanged() {
        if (!SideKick.isParseOnChange()) {
            return;
        }
        try {
            this.delay = Integer.parseInt(jEdit.getProperty((String)"sidekick.auto-parse-delay"));
        }
        catch (NumberFormatException numberFormatException) {
            this.delay = 1500;
        }
    }

    private void showNotParsedMessage() {
        this.setErrorSource(null);
        SideKickParsedData sideKickParsedData = new SideKickParsedData(this.buffer.getName());
        sideKickParsedData.root.add(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.not-parsed")));
        SideKickParsedData.setParsedData(this.view, sideKickParsedData);
        this.sendUpdate();
    }

    private void parseWithDelay() {
        if (this.parser != null) {
            this.parser.stop();
            if (this.keystrokeTimer.isRunning()) {
                this.keystrokeTimer.stop();
            }
            this.keystrokeTimer.setInitialDelay(this.delay);
            this.keystrokeTimer.setRepeats(false);
            this.keystrokeTimer.start();
        }
    }

    private void sendUpdate() {
        if (this.view.isClosed()) {
            return;
        }
        EditBus.send((EBMessage)new SideKickUpdate(this.view));
    }

    private void deactivateParser() {
        if (this.parser != null) {
            if (this.editPane == null) {
                Log.log((int)9, (Object)this, (Object)"Null editPane!");
            } else {
                this.parser.deactivate(this.editPane);
            }
            SideKickTree sideKickTree = (SideKickTree)this.view.getDockableWindowManager().getDockable("sidekick-tree");
            if (sideKickTree == null) {
                return;
            }
            sideKickTree.removeParserPanel();
        }
    }

    private void activateParser() {
        EditPane editPane = this.view.getEditPane();
        if (this.parser != null) {
            this.addBufferChangeListener(this.buffer);
            this.editPane = editPane;
            this.parser.activate(editPane);
        } else {
            this.removeBufferChangeListener(this.buffer);
        }
        SideKickTree sideKickTree = (SideKickTree)this.view.getDockableWindowManager().getDockable("sidekick-tree");
        if (sideKickTree == null) {
            return;
        }
        sideKickTree.reloadParserCombo();
        if (this.parser != null) {
            sideKickTree.addParserPanel(this.parser);
        }
        this.parse(true);
    }

    class BufferChangeListener
    extends BufferAdapter {
        BufferChangeListener() {
        }

        private void parseOnKeyStroke(JEditBuffer jEditBuffer) {
            if (jEditBuffer != SideKick.this.buffer) {
                return;
            }
            if (jEditBuffer.getBooleanProperty("sidekick.keystroke-parse")) {
                SideKick.this.parseWithDelay();
            }
        }

        public void contentInserted(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
            this.parseOnKeyStroke(jEditBuffer);
        }

        public void contentRemoved(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
            this.parseOnKeyStroke(jEditBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParseRequestWorker
    extends SwingWorker<SideKickParsedData, Object> {
        SideKickParser parser;
        Buffer buffer;
        DefaultErrorSource errorSource;

        ParseRequestWorker(SideKickParser sideKickParser, Buffer buffer) {
            this.parser = sideKickParser;
            this.buffer = buffer;
            this.errorSource = new DefaultErrorSource("SideKick");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SideKickParsedData doInBackground() {
            SideKickTree sideKickTree = (SideKickTree)SideKick.this.view.getDockableWindowManager().getDockable("sidekick-tree");
            if (sideKickTree != null) {
                sideKickTree.showStopButton(true);
            }
            try {
                SideKickParsedData sideKickParsedData;
                this.buffer.readLock();
                SideKickParsedData sideKickParsedData2 = sideKickParsedData = this.parser.parse(this.buffer, this.errorSource);
                return sideKickParsedData2;
            }
            finally {
                this.buffer.readUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            SideKickPlugin.cleanup(SideKick.this.view);
            try {
                String string;
                if (this.isCancelled()) {
                    this.parser.stop();
                    return;
                }
                SideKickParsedData sideKickParsedData = (SideKickParsedData)this.get();
                SideKick.this.setErrorSource(this.errorSource);
                int n = this.errorSource.getErrorCount();
                if (SideKick.this.showParsingMessage || n != 0) {
                    string = jEdit.getProperty((String)("sidekick.parser." + this.parser.getName() + ".label"));
                    Object[] objectArray = new Object[]{string, n};
                    SideKick.this.view.getStatus().setMessageAndClear(jEdit.getProperty((String)"sidekick.parsing-complete", (Object[])objectArray));
                }
                this.buffer.setProperty("sidekick.parsed-data", (Object)sideKickParsedData);
                if (this.buffer.getProperty((Object)"folding").equals("sidekick")) {
                    this.buffer.invalidateCachedFoldLevels();
                }
                for (string = jEdit.getFirstView(); string != null; string = string.getNext()) {
                    if (string.getBuffer() != this.buffer) continue;
                    SideKickParsedData.setParsedData((View)string, sideKickParsedData);
                }
                SideKick.this.sendUpdate();
            }
            catch (Exception exception) {
                SideKick.this.showNotParsedMessage();
            }
            finally {
                SideKickPlugin.finishParsingBuffer(this.buffer);
                SideKickTree sideKickTree = (SideKickTree)SideKick.this.view.getDockableWindowManager().getDockable("sidekick-tree");
                if (sideKickTree != null) {
                    sideKickTree.showStopButton(false);
                }
            }
        }
    }
}

