/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.CompletionPopup;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import sidekick.SideKickCompletion;
import sidekick.SideKickParser;

public class SideKickCompletionPopup
extends CompletionPopup {
    private View view;
    private SideKickParser parser;
    private SideKickCompletion complete;

    public SideKickCompletionPopup(View view, SideKickParser sideKickParser, int n, SideKickCompletion sideKickCompletion, boolean bl) {
        super(view, SideKickCompletionPopup.getLocation(view.getTextArea(), n, sideKickCompletion));
        this.view = view;
        this.parser = sideKickParser;
        this.complete = sideKickCompletion;
        this.reset(new Candidates(), bl);
    }

    public SideKickCompletionPopup(View view, SideKickParser sideKickParser, int n, SideKickCompletion sideKickCompletion) {
        this(view, sideKickParser, n, sideKickCompletion, false);
    }

    protected void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.keyTyped('\n');
                keyEvent.consume();
                break;
            }
            case 9: {
                this.keyTyped('\t');
                keyEvent.consume();
                break;
            }
            case 32: {
                keyEvent.consume();
                break;
            }
            case 8: {
                if (this.parser.canHandleBackspace()) break;
                this.dispose();
                break;
            }
            case 127: {
                this.dispose();
                break;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\b' && !this.parser.canHandleBackspace()) {
            keyEvent.consume();
            return;
        }
        this.keyTyped(c);
        keyEvent.consume();
    }

    private static Point getLocation(JEditTextArea jEditTextArea, int n, SideKickCompletion sideKickCompletion) {
        Point point = jEditTextArea.offsetToXY(n - sideKickCompletion.getTokenLength());
        point.y += jEditTextArea.getPainter().getFontMetrics().getHeight();
        SwingUtilities.convertPointToScreen(point, (Component)jEditTextArea.getPainter());
        return point;
    }

    private void keyTyped(char c) {
        int n = this.getSelectedIndex();
        if (n == -1) {
            Macros.Recorder recorder = this.view.getMacroRecorder();
            if (recorder != null) {
                recorder.recordInput(1, c, this.view.getTextArea().isOverwriteEnabled());
            }
            this.view.getTextArea().userInput(c);
            this.updateCompletion(false);
        } else if (this.complete.handleKeystroke(n, c)) {
            this.updateCompletion(true);
        } else {
            this.dispose();
        }
    }

    private void updateCompletion(boolean bl) {
        JEditTextArea jEditTextArea;
        int n;
        SideKickCompletion sideKickCompletion = this.complete;
        EditPane editPane = this.view.getEditPane();
        if (!sideKickCompletion.updateInPlace(editPane, n = (jEditTextArea = editPane.getTextArea()).getCaretPosition())) {
            sideKickCompletion = this.parser.complete(editPane, n);
        }
        if (sideKickCompletion == null || sideKickCompletion.size() == 0) {
            this.dispose();
        } else {
            this.complete = sideKickCompletion;
            this.setLocation(SideKickCompletionPopup.getLocation(jEditTextArea, n, this.complete));
            this.reset(new Candidates(), bl);
        }
    }

    private class Candidates
    implements CompletionPopup.Candidates {
        private final ListCellRenderer renderer;

        public Candidates() {
            this.renderer = SideKickCompletionPopup.this.complete.getRenderer();
        }

        public int getSize() {
            return SideKickCompletionPopup.this.complete.size();
        }

        public boolean isValid() {
            return SideKickCompletionPopup.this.complete != null && SideKickCompletionPopup.this.complete.size() > 0;
        }

        public void complete(int n) {
            SideKickCompletionPopup.this.complete.insert(n);
        }

        public Component getCellRenderer(JList jList, int n, boolean bl, boolean bl2) {
            return this.renderer.getListCellRendererComponent(jList, SideKickCompletionPopup.this.complete.get(n), n, bl, bl2);
        }

        public String getDescription(int n) {
            return SideKickCompletionPopup.this.complete.getCompletionDescription(n);
        }
    }
}

