/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.util.Log;
import sidekick.Asset;
import sidekick.IAsset;
import sidekick.enhanced.SourceAsset;

public class SideKickParsedData {
    public DefaultTreeModel tree;
    public DefaultMutableTreeNode root;
    public List<Integer> expansionModel = null;

    public static SideKickParsedData getParsedData(View view) {
        return (SideKickParsedData)view.getRootPane().getClientProperty("sidekick.parsed-data");
    }

    public static void setParsedData(View view, SideKickParsedData sideKickParsedData) {
        Log.log((int)1, SideKickParsedData.class, (Object)("Setting parsed data of " + view + " to " + sideKickParsedData));
        view.getRootPane().putClientProperty("sidekick.parsed-data", sideKickParsedData);
    }

    public SideKickParsedData(String string) {
        SourceAsset sourceAsset = new SourceAsset(string, 0, new Position(){

            public int getOffset() {
                return 0;
            }
        });
        sourceAsset.setEnd(new Position(){

            public int getOffset() {
                return Integer.MAX_VALUE;
            }
        });
        this.root = new DefaultMutableTreeNode(sourceAsset);
        this.tree = new DefaultTreeModel(this.root);
    }

    public TreePath getTreePathForPosition(int n) {
        if (this.root.getChildCount() == 0) {
            return null;
        }
        IAsset iAsset = this.getAsset(this.root);
        if (iAsset != null && !SideKickParsedData.assetContains(iAsset, n)) {
            return null;
        }
        TreeNode treeNode = this.getNodeAt(this.root, n);
        if (treeNode == null) {
            treeNode = this.root;
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(treeNode);
            treeNode = treeNode.getParent();
        }
        Collections.reverse(arrayList);
        return new TreePath(arrayList.toArray());
    }

    protected TreeNode getNodeAt(TreeNode treeNode, int n) {
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            TreeNode treeNode3 = this.getNodeAt(treeNode2, n);
            if (treeNode3 != null) {
                return treeNode3;
            }
            if (!SideKickParsedData.assetContains(this.getAsset(treeNode2), n)) continue;
            return treeNode2;
        }
        return null;
    }

    protected FoldHandler getFoldHandler() {
        return null;
    }

    private static boolean assetContains(IAsset iAsset, int n) {
        if (iAsset == null) {
            return false;
        }
        return n >= iAsset.getStart().getOffset() && n < iAsset.getEnd().getOffset();
    }

    protected boolean canAddToPath(TreeNode treeNode) {
        return true;
    }

    public Asset getAssetAtPosition(int n) {
        return (Asset)this.getAssetAtOffset(n);
    }

    public IAsset getAssetAtOffset(int n) {
        TreePath treePath = this.getTreePathForPosition(n);
        if (treePath == null) {
            return null;
        }
        return (IAsset)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
    }

    public IAsset getAsset(TreeNode treeNode) {
        if (!(treeNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object object = ((DefaultMutableTreeNode)treeNode).getUserObject();
        if (!(object instanceof IAsset)) {
            return null;
        }
        IAsset iAsset = (IAsset)object;
        return iAsset;
    }
}

