/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import errorlist.DefaultErrorSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.util.Log;
import sidekick.SideKickCompletion;
import sidekick.SideKickCompletionPopup;
import sidekick.SideKickParsedData;

public abstract class SideKickParser {
    public static final String SERVICE = "sidekick.SideKickParser";
    protected String name;

    public SideKickParser(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public void stop() {
    }

    public void activate(View view) {
    }

    public void deactivate(View view) {
    }

    public void activate(EditPane editPane) {
        this.activate(editPane.getView());
        Log.log((int)1, (Object)this, (Object)(this.getName() + ": activated for " + editPane.getBuffer()));
    }

    public void deactivate(EditPane editPane) {
        this.deactivate(editPane.getView());
        Log.log((int)1, (Object)this, (Object)(this.getName() + ": deactivated"));
    }

    public abstract SideKickParsedData parse(Buffer var1, DefaultErrorSource var2);

    public boolean supportsCompletion() {
        return true;
    }

    public boolean canHandleBackspace() {
        return false;
    }

    public boolean canCompleteAnywhere() {
        return true;
    }

    public String getInstantCompletionTriggers() {
        return null;
    }

    public String getParseTriggers() {
        return null;
    }

    public SideKickCompletion complete(EditPane editPane, int n) {
        try {
            String string;
            String[] stringArray = editPane.getBuffer().getKeywordMapAtOffset(n).getKeywords();
            if (stringArray.length > 0 && (string = this.getWordAtCaret(editPane, n)) != null && string.length() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (!string2.startsWith(string) || string2.equals(string)) continue;
                    arrayList.add(stringArray[i]);
                }
                Collections.sort(arrayList);
                return new ConcreteSideKickCompletion(editPane.getView(), string, arrayList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public SideKickCompletionPopup getCompletionPopup(View view, int n, SideKickCompletion sideKickCompletion, boolean bl) {
        return new SideKickCompletionPopup(view, this, n, sideKickCompletion, bl);
    }

    public JPanel getPanel() {
        return null;
    }

    private String getWordAtCaret(EditPane editPane, int n) {
        if (n <= 0) {
            return "";
        }
        Buffer buffer = editPane.getBuffer();
        String string = buffer.getText(0, n);
        Mode mode = buffer.getMode();
        String string2 = (String)mode.getProperty("wordBreakChars");
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2 + " \n\r\t";
        int n2 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            int n3 = string.lastIndexOf(string2.charAt(i)) + 1;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return string.substring(n2);
    }

    class ConcreteSideKickCompletion
    extends SideKickCompletion {
        public ConcreteSideKickCompletion(View view, String string, List list) {
            super(view, string, list);
        }
    }
}

