/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.SwingWorker;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import sidekick.SideKick;
import sidekick.SideKickActions;
import sidekick.SideKickBindings;
import sidekick.SideKickMenuProvider;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickToolBar;
import sidekick.SideKickTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SideKickPlugin
extends EditPlugin {
    private static final String MARKER_SETS_PLUGIN = "marker.MarkerSetsPlugin";
    private static final String SHOW_TOOL_BAR = "sidekick.showToolBar";
    public static final String NAME = "sidekick-tree";
    public static final String PARSER_MODE_PROPERTY = "sidekick.parser-mode";
    public static final String PARSER_PROPERTY = "sidekick.parser";
    public static final String PARSED_DATA_PROPERTY = "sidekick.parsed-data";
    public static final String PARSE_COUNT = "sidekick.parse-count";
    public static final String NONE = "None";
    public static final String DEFAULT = "default parser";
    private static final String MACRO_PATH = "/macros";
    private static Map<View, SideKick> sidekicks;
    private static Map<String, SideKickParser> parsers;
    private static Executor executor;
    private static Set<Buffer> parsedBufferSet;
    private static Map<View, SideKickToolBar> toolBars;
    private static boolean toolBarsEnabled;
    private static Map<View, SwingWorker<SideKickParsedData, Object>> workers;
    private static EditPlugin markerSetsPlugin;

    public void start() {
        BeanShell.getNameSpace().addCommandPath(MACRO_PATH, ((Object)((Object)this)).getClass());
        markerSetsPlugin = jEdit.getPlugin((String)MARKER_SETS_PLUGIN, (boolean)false);
        sidekicks = new HashMap<View, SideKick>();
        parsers = new HashMap<String, SideKickParser>();
        workers = new HashMap<View, SwingWorker<SideKickParsedData, Object>>();
        parsedBufferSet = new HashSet<Buffer>();
        toolBars = new HashMap<View, SideKickToolBar>();
        toolBarsEnabled = jEdit.getBooleanProperty((String)SHOW_TOOL_BAR);
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            SideKickPlugin.initView(view);
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                SideKickPlugin.initTextArea(editPaneArray[i].getTextArea());
            }
        }
        jEdit.addActionSet((ActionSet)SideKickMenuProvider.getParserSwitchers());
        SideKickActions.propertiesChanged();
        EditBus.addToBus((Object)((Object)this));
    }

    public void stop() {
        Buffer buffer;
        EditBus.removeFromBus((Object)((Object)this));
        jEdit.removeActionSet((ActionSet)SideKickMenuProvider.getParserSwitchers());
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            SideKickPlugin.uninitView(view);
            SideKickParsedData.setParsedData(view, null);
            buffer = view.getEditPanes();
            for (int i = 0; i < ((Buffer)buffer).length; ++i) {
                SideKickPlugin.uninitTextArea(buffer[i].getTextArea());
            }
        }
        for (buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
            buffer.setProperty(PARSED_DATA_PROPERTY, null);
        }
        sidekicks = null;
        parsers = null;
        parsedBufferSet = null;
        toolBars = null;
        workers = null;
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate viewUpdate) {
        View view = viewUpdate.getView();
        if (viewUpdate.getWhat() == ViewUpdate.CREATED) {
            SideKickPlugin.initView(view);
        } else if (viewUpdate.getWhat() == ViewUpdate.CLOSED) {
            SideKickPlugin.uninitView(view);
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        EditPane editPane = editPaneUpdate.getEditPane();
        if (editPaneUpdate.getWhat() == EditPaneUpdate.CREATED) {
            SideKickPlugin.initTextArea(editPane.getTextArea());
        } else if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
            SideKickPlugin.uninitTextArea(editPane.getTextArea());
        }
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bufferUpdate) {
        if (bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
            SideKickPlugin.finishParsingBuffer(bufferUpdate.getBuffer());
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        SideKickActions.propertiesChanged();
        boolean bl = jEdit.getBooleanProperty((String)SHOW_TOOL_BAR);
        if (bl != toolBarsEnabled) {
            toolBarsEnabled = bl;
            for (View view : jEdit.getViews()) {
                if (toolBarsEnabled) {
                    SideKickPlugin.attachToolBar(view);
                    continue;
                }
                SideKickPlugin.detachToolBar(view);
            }
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pluginUpdate) {
        EditPlugin editPlugin = pluginUpdate.getPluginJAR().getPlugin();
        if (editPlugin == null) {
            return;
        }
        if (editPlugin.getClassName().equals(MARKER_SETS_PLUGIN)) {
            if (pluginUpdate.getWhat() == PluginUpdate.ACTIVATED) {
                markerSetsPlugin = editPlugin;
            } else if (pluginUpdate.getWhat() == PluginUpdate.DEACTIVATED) {
                markerSetsPlugin = null;
            }
        }
    }

    public static EditPlugin getMarkerSetsPlugin() {
        return markerSetsPlugin;
    }

    public static SideKickParser getParserForMode(Mode mode) {
        String string = mode.getName();
        String string2 = "mode." + string + '.' + PARSER_PROPERTY;
        String string3 = jEdit.getProperty((String)string2);
        if (string3 == null) {
            return null;
        }
        SideKickParser sideKickParser = (SideKickParser)ServiceManager.getService((String)"sidekick.SideKickParser", (String)string3);
        return sideKickParser;
    }

    public static SideKickParser getParser(String string) {
        SideKickParser sideKickParser = (SideKickParser)ServiceManager.getService((String)"sidekick.SideKickParser", (String)string);
        if (sideKickParser != null) {
            return sideKickParser;
        }
        return parsers.get(string);
    }

    public static SideKickParser getParserForView(View view) {
        SideKick sideKick = sidekicks.get(view);
        if (sideKick == null) {
            return null;
        }
        return sideKick.getParser();
    }

    public static void setParserForBuffer(Buffer buffer, String string) {
        if (string.equals(NONE)) {
            buffer.setStringProperty(PARSER_PROPERTY, string);
            return;
        }
        if (string.equals(DEFAULT)) {
            buffer.unsetProperty(PARSER_PROPERTY);
            return;
        }
        SideKickParser sideKickParser = SideKickPlugin.getParser(string);
        if (sideKickParser == null) {
            throw new RuntimeException("Unknown parser: " + string);
        }
        buffer.setStringProperty(PARSER_PROPERTY, string);
    }

    public static SideKickParser getParserForBuffer(Buffer buffer) {
        String string = buffer.getStringProperty(PARSER_PROPERTY);
        Mode mode = buffer.getMode();
        String string2 = mode != null ? mode.getName() : "";
        buffer.setStringProperty(PARSER_MODE_PROPERTY, string2);
        if (string == null || string.equals(DEFAULT) || string.length() == 0) {
            if (mode != null) {
                return SideKickPlugin.getParserForMode(mode);
            }
            return null;
        }
        if (string.equals(NONE)) {
            return null;
        }
        return SideKickPlugin.getParser(string);
    }

    public static void parse(View view, boolean bl) {
        SideKick sideKick = sidekicks.get(view);
        if (sideKick == null) {
            return;
        }
        sideKick.setParser(view.getBuffer());
        sideKick.parse(bl);
    }

    public static void execute(Runnable runnable) {
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor();
        }
        executor.execute(runnable);
    }

    public static void execute(View view, SwingWorker<SideKickParsedData, Object> swingWorker) {
        workers.put(view, swingWorker);
        swingWorker.execute();
    }

    public static void cleanup(View view) {
        workers.remove(view);
    }

    public static boolean isParsingBuffer(Buffer buffer) {
        return parsedBufferSet.contains(buffer);
    }

    static void startParsingBuffer(Buffer buffer) {
        parsedBufferSet.add(buffer);
    }

    static void finishParsingBuffer(Buffer buffer) {
        parsedBufferSet.remove(buffer);
    }

    private static void attachToolBar(View view) {
        SideKickToolBar sideKickToolBar = new SideKickToolBar(view);
        view.addToolBar((Component)sideKickToolBar);
        toolBars.put(view, sideKickToolBar);
    }

    private static void detachToolBar(View view) {
        SideKickToolBar sideKickToolBar = toolBars.remove(view);
        if (sideKickToolBar != null) {
            view.removeToolBar((Component)sideKickToolBar);
            sideKickToolBar.dispose();
        }
    }

    private static void initView(View view) {
        SideKick sideKick = new SideKick(view);
        sidekicks.put(view, sideKick);
        sideKick.parse(true);
        if (toolBarsEnabled) {
            SideKickPlugin.attachToolBar(view);
        }
    }

    static SideKick getSideKick(View view) {
        return sidekicks.get(view);
    }

    private static void uninitView(View view) {
        SideKick sideKick = sidekicks.get(view);
        sideKick.dispose();
        sidekicks.remove(view);
        SideKickPlugin.stop(view);
        workers.remove(view);
        SideKickPlugin.detachToolBar(view);
    }

    private static void initTextArea(JEditTextArea jEditTextArea) {
        SideKickBindings sideKickBindings = new SideKickBindings();
        jEditTextArea.putClientProperty(SideKickBindings.class, (Object)sideKickBindings);
        jEditTextArea.addKeyListener((KeyListener)sideKickBindings);
    }

    private static void uninitTextArea(JEditTextArea jEditTextArea) {
        SideKickBindings sideKickBindings = (SideKickBindings)jEditTextArea.getClientProperty(SideKickBindings.class);
        jEditTextArea.putClientProperty(SideKickBindings.class, null);
        jEditTextArea.removeKeyListener((KeyListener)sideKickBindings);
        SideKickTree.CaretHandler caretHandler = (SideKickTree.CaretHandler)jEditTextArea.getClientProperty(SideKickTree.CaretHandler.class);
        if (caretHandler != null) {
            jEditTextArea.putClientProperty(SideKickTree.CaretHandler.class, null);
            jEditTextArea.removeCaretListener((CaretListener)caretHandler);
        }
    }

    public static void stop(View view) {
        SwingWorker<SideKickParsedData, Object> swingWorker = workers.get(view);
        if (swingWorker != null && !swingWorker.isCancelled() && !swingWorker.isDone()) {
            swingWorker.cancel(true);
        }
    }
}

