/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;
import sidekick.AbstractModeOptionPane;
import sidekick.Asset;
import sidekick.FilteredTreeModel;
import sidekick.IAsset;
import sidekick.ModeOptionsDialog;
import sidekick.SideKick;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickPlugin;
import sidekick.SideKickUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SideKickTree
extends JPanel
implements DefaultFocusComponent {
    private RolloverButton parseBtn;
    private Icon parseIcon;
    private Icon stopIcon;
    private JComboBox parserCombo;
    protected JTree tree;
    protected JTextArea status;
    private JPanel topPanel;
    private JSplitPane splitter;
    private boolean statusShowing = false;
    private Buffer lastParsedBuffer = null;
    private JToolBar filterBox;
    protected JPopupMenu configMenu;
    protected JCheckBoxMenuItem onChange;
    protected JCheckBoxMenuItem followCaret;
    protected JCheckBoxMenuItem onSave;
    protected View view;
    private Timer caretTimer;
    protected SideKickParsedData data;
    private int autoExpandTree = 0;
    private JPanel toolBox;
    private JPanel parserPanel = null;
    private JTextField searchField;

    public SideKickTree(View view, boolean bl) {
        super(new BorderLayout());
        this.view = view;
        this.topPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.filterBox = new JToolBar();
        this.filterBox.setLayout(new BorderLayout());
        this.filterBox.setFloatable(false);
        this.parseIcon = GUIUtilities.loadIcon((String)"Parse.png");
        this.stopIcon = GUIUtilities.loadIcon((String)jEdit.getProperty((String)"hypersearch-results.stop.icon"));
        this.parseBtn = new RolloverButton(this.parseIcon);
        this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parse"));
        this.parseBtn.setMargin(new Insets(0, 0, 0, 0));
        this.parseBtn.setRequestFocusEnabled(false);
        this.parseBtn.setEnabled(true);
        ActionHandler actionHandler = new ActionHandler();
        this.parseBtn.addActionListener((ActionListener)actionHandler);
        RolloverButton rolloverButton = new RolloverButton(GUIUtilities.loadIcon((String)"ButtonProperties.png"));
        rolloverButton.setToolTipText(jEdit.getProperty((String)"sidekick-tree.mode-options"));
        rolloverButton.addActionListener((ActionListener)new SideKickProperties());
        this.configMenu = new JPopupMenu("Parse");
        this.followCaret = new JCheckBoxMenuItem("Follow Caret");
        this.configMenu.add(this.followCaret);
        JMenuItem jMenuItem = new JMenuItem("Parse on...");
        jMenuItem.setEnabled(false);
        this.configMenu.add(jMenuItem);
        this.onChange = new JCheckBoxMenuItem("Buffer change");
        this.onChange.setState(SideKick.isParseOnChange());
        this.onSave = new JCheckBoxMenuItem("Buffer save");
        this.onSave.setState(SideKick.isParseOnSave());
        this.configMenu.add(this.onChange);
        this.configMenu.add(this.onSave);
        this.parseBtn.setComponentPopupMenu(this.configMenu);
        this.onChange.addActionListener(actionHandler);
        this.onSave.addActionListener(actionHandler);
        this.followCaret.addActionListener(actionHandler);
        JLabel jLabel = new JLabel(jEdit.getProperty((String)"sidekick-tree.filter.label") + " ");
        this.searchField = new JTextField();
        this.searchField.setToolTipText(jEdit.getProperty((String)"sidekick-tree.filter.tooltip"));
        RolloverButton rolloverButton2 = new RolloverButton(GUIUtilities.loadIcon((String)"22x22/actions/edit-clear.png"));
        rolloverButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SideKickTree.this.searchField.setText("");
                SideKickTree.this.updateFilter();
            }
        });
        rolloverButton2.setToolTipText(jEdit.getProperty((String)"sidekick-tree.clear-filter.tooltip"));
        jToolBar.add((Component)this.parseBtn);
        jToolBar.add((Component)rolloverButton);
        this.filterBox.add((Component)jLabel, "West");
        this.filterBox.add((Component)this.searchField, "Center");
        this.filterBox.add((Component)rolloverButton2, "East");
        jToolBar.add(Box.createGlue());
        this.parserCombo = new JComboBox();
        this.reloadParserCombo();
        this.parserCombo.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parsercombo.tooltip"));
        jToolBar.add(this.parserCombo);
        this.parserCombo.addActionListener(actionHandler);
        this.parserCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SideKickTree.this.searchField.setText("");
                SideKickTree.this.updateFilter();
            }
        });
        this.toolBox = new JPanel(new BorderLayout());
        this.toolBox.add("North", jToolBar);
        this.toolBox.add("South", this.filterBox);
        this.topPanel.add("North", this.toolBox);
        TreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(null));
        treeModel = new FilteredTreeModel((DefaultTreeModel)treeModel, true);
        this.tree = this.buildTree(treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        KeyHandler keyHandler = new KeyHandler();
        this.tree.addKeyListener(keyHandler);
        if (bl) {
            this.tree.addMouseMotionListener(new MouseHandler());
        }
        this.searchField.addKeyListener(keyHandler);
        if (!OperatingSystem.isMacOSLF()) {
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.tree.setVisibleRowCount(10);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new Renderer()));
        this.topPanel.add("Center", new JScrollPane(this.tree));
        this.status = new JTextArea();
        this.status.setEditable(false);
        this.status.setBackground(jEdit.getColorProperty((String)"view.bgColor"));
        this.status.setForeground(jEdit.getColorProperty((String)"view.fgColor"));
        this.status.setFont(view.getEditPane().getTextArea().getPainter().getFont());
        JScrollPane jScrollPane = new JScrollPane(this.status);
        this.splitter = new JSplitPane(0, false, this.topPanel, jScrollPane);
        jScrollPane.setMinimumSize(new Dimension(0, 30));
        this.splitter.setOneTouchExpandable(true);
        this.splitter.setResizeWeight(1.0);
        int n = this.splitter.getSize().height - this.splitter.getInsets().bottom - this.splitter.getDividerSize() - jScrollPane.getMinimumSize().height;
        n = jEdit.getIntegerProperty((String)"sidekick.splitter.location", (int)n);
        this.splitter.setDividerLocation(n);
        this.propertiesChanged();
        CaretHandler caretHandler = new CaretHandler();
        EditPane[] editPaneArray = view.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            JEditTextArea jEditTextArea = editPaneArray[i].getTextArea();
            jEditTextArea.putClientProperty(CaretHandler.class, (Object)caretHandler);
            jEditTextArea.addCaretListener((CaretListener)caretHandler);
        }
        this.update();
    }

    public void showStopButton(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl && SideKickTree.this.parseIcon.equals(SideKickTree.this.parseBtn.getIcon())) {
                    SideKickTree.this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.stop-parsing"));
                    SideKickTree.this.parseBtn.setIcon(SideKickTree.this.stopIcon);
                } else {
                    SideKickTree.this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parse"));
                    SideKickTree.this.parseBtn.setIcon(SideKickTree.this.parseIcon);
                }
            }
        });
    }

    public void focusOnDefaultComponent() {
        this.tree.requestFocusInWindow();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((Object)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((Object)this);
    }

    protected void selectPath(TreePath treePath) {
        this.tree.setSelectionPath(treePath);
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle != null) {
            rectangle.width = 1;
            this.tree.scrollRectToVisible(rectangle);
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        EditPane editPane = editPaneUpdate.getEditPane();
        if (editPaneUpdate.getWhat() == EditPaneUpdate.CREATED) {
            CaretHandler caretHandler = new CaretHandler();
            JEditTextArea jEditTextArea = editPane.getTextArea();
            jEditTextArea.putClientProperty(CaretHandler.class, (Object)caretHandler);
            jEditTextArea.addCaretListener((CaretListener)caretHandler);
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleSideKickUpdate(SideKickUpdate sideKickUpdate) {
        if (sideKickUpdate.getView() == this.view) {
            this.update();
        }
    }

    public void setStatus(String string) {
        this.status.setText(string);
    }

    protected void addData(Object object, Stack<String> stack) {
        if (object instanceof DefaultMutableTreeNode) {
            Enumeration<TreeNode> enumeration;
            FilteredTreeModel filteredTreeModel;
            String string;
            DefaultMutableTreeNode defaultMutableTreeNode;
            block8: {
                defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                string = "";
                filteredTreeModel = (FilteredTreeModel)this.tree.getModel();
                try {
                    enumeration = (Asset)defaultMutableTreeNode.getUserObject();
                    if (enumeration != null) {
                        string = ((Asset)((Object)enumeration)).getName();
                    }
                }
                catch (ClassCastException classCastException) {
                    if (defaultMutableTreeNode.toString() == null) break block8;
                    string = defaultMutableTreeNode.toString();
                }
            }
            stack.push(string);
            if (filteredTreeModel.isLeaf(defaultMutableTreeNode)) {
                for (String string2 : stack) {
                    filteredTreeModel.addSearchKey(defaultMutableTreeNode, string2);
                }
            }
            enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.addData(enumeration.nextElement(), stack);
            }
            stack.pop();
        } else {
            Log.log((int)1, (Object)this, (Object)"addData called on a node that isn't a treenode!!!!!!!!!");
        }
    }

    protected void updateSearchData() {
        FilteredTreeModel filteredTreeModel = (FilteredTreeModel)this.tree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)filteredTreeModel.getRoot();
        this.addData(defaultMutableTreeNode, new Stack<String>());
    }

    protected void update() {
        Object object;
        this.onChange.setState(SideKick.isParseOnChange());
        this.onSave.setState(SideKick.isParseOnSave());
        Buffer buffer = this.view.getBuffer();
        SideKickParser sideKickParser = SideKickPlugin.getParserForBuffer(buffer);
        if (sideKickParser != null && (object = this.parserCombo.getSelectedItem()) != sideKickParser.getName()) {
            this.parserCombo.setSelectedItem(sideKickParser.getName());
        }
        this.data = SideKickParsedData.getParsedData(this.view);
        if (sideKickParser == null || this.data == null) {
            object = new DefaultMutableTreeNode(buffer.getName());
            ((DefaultMutableTreeNode)object).insert(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.not-parsed")), 0);
            this.tree.setModel(new FilteredTreeModel(new DefaultTreeModel((TreeNode)object), true));
            this.lastParsedBuffer = null;
        } else {
            this.tree.setModel(new FilteredTreeModel(this.data.tree, true));
            this.lastParsedBuffer = buffer;
            if (SideKick.isFollowCaret()) {
                this.expandTreeAt(this.view.getTextArea().getCaretPosition());
            }
        }
        this.updateSearchData();
        if (this.data != null && this.data.expansionModel != null) {
            for (int i = this.tree.getRowCount() - 1; i >= 0; --i) {
                this.tree.collapseRow(i);
            }
            for (Integer n : this.data.expansionModel) {
                this.tree.expandRow(n);
            }
        } else if (this.autoExpandTree == -1) {
            this.expandAll(true);
        } else if (this.autoExpandTree == 0) {
            this.expandAll(false);
        } else if (this.autoExpandTree > 0) {
            this.tree.expandRow(0);
            for (int i = 1; i < this.autoExpandTree; ++i) {
                for (int j = this.tree.getRowCount() - 1; j > 0; --j) {
                    this.tree.expandRow(j);
                }
            }
        }
        if (this.searchField.getText().length() != 0) {
            this.updateFilter();
        }
    }

    public void expandAll(boolean bl) {
        TreeNode treeNode = (TreeNode)this.tree.getModel().getRoot();
        this.expandAll(new TreePath(treeNode), bl);
    }

    private void expandAll(final TreePath treePath, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                if (treeNode.getChildCount() >= 0) {
                    Enumeration<? extends TreeNode> enumeration = treeNode.children();
                    while (enumeration.hasMoreElements()) {
                        TreeNode treeNode2 = enumeration.nextElement();
                        TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                        SideKickTree.this.expandAll(treePath2, bl);
                    }
                }
                if (bl) {
                    SideKickTree.this.tree.expandPath(treePath);
                } else {
                    SideKickTree.this.tree.collapsePath(treePath);
                }
            }
        });
    }

    protected JTree buildTree(TreeModel treeModel) {
        return new CustomTree(treeModel);
    }

    protected ActionListener buildActionListener() {
        return new ActionHandler();
    }

    protected void propertiesChanged() {
        this.followCaret.setSelected(SideKick.isFollowCaret());
        Mode mode = this.view.getBuffer().getMode();
        String string = mode != null ? mode.getName() : null;
        this.autoExpandTree = AbstractModeOptionPane.getIntegerProperty(string, "sidekick-tree.auto-expand-tree-depth", 1);
        if (AbstractModeOptionPane.getBooleanProperty(string, "sidekick.showStatusWindow.label")) {
            if (!this.statusShowing) {
                this.remove(this.topPanel);
                this.splitter.setTopComponent(this.topPanel);
                this.add(this.splitter);
            }
            this.statusShowing = true;
        } else {
            this.remove(this.splitter);
            this.splitter.remove(this.topPanel);
            this.add(this.topPanel);
            this.statusShowing = false;
        }
        final boolean bl = jEdit.getBooleanProperty((String)"sidekick.showFilter", (boolean)true);
        if (bl != this.filterBox.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SideKickTree.this.filterBox.setVisible(bl);
                    SideKickTree.this.searchField.setEnabled(bl);
                }
            });
        }
    }

    public static StringList parserList() {
        Object[] objectArray = ServiceManager.getServiceNames((String)"sidekick.SideKickParser");
        Arrays.sort(objectArray, new StandardUtilities.StringCompare(true));
        StringList stringList = new StringList();
        stringList.add((Object)"None");
        stringList.add((Object)"default parser");
        stringList.addAll(objectArray);
        return stringList;
    }

    void reloadParserCombo() {
        this.parserCombo.setModel(new DefaultComboBoxModel<String>(SideKickTree.parserList().toArray()));
        SideKickParser sideKickParser = SideKickPlugin.getParserForBuffer(this.view.getBuffer());
        if (sideKickParser != null) {
            String string = sideKickParser.getName();
            if (string == null) {
                string = "default parser";
            }
            this.parserCombo.setSelectedItem(string);
        } else {
            String string = this.view.getBuffer().getStringProperty("sidekick.parser");
            if (string == "None") {
                this.parserCombo.setSelectedItem("None");
            } else {
                this.parserCombo.setSelectedItem("default parser");
            }
        }
    }

    void addParserPanel(SideKickParser sideKickParser) {
        JPanel jPanel = sideKickParser.getPanel();
        boolean bl = this.searchField.hasFocus();
        if (jPanel != this.parserPanel) {
            if (this.parserPanel != null) {
                this.toolBox.remove(this.parserPanel);
                this.parserPanel = null;
            }
            if (jPanel != null) {
                this.toolBox.add("West", jPanel);
                this.parserPanel = jPanel;
            }
        }
        if (bl) {
            this.focusOnDefaultComponent();
        }
    }

    void removeParserPanel() {
        if (this.parserPanel != null) {
            this.toolBox.remove(this.parserPanel);
            this.parserPanel = null;
        }
    }

    protected void expandTreeWithDelay() {
        if (this.caretTimer != null) {
            this.caretTimer.stop();
        } else {
            this.caretTimer = new Timer(0, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    JEditTextArea jEditTextArea;
                    Selection selection;
                    if (!jEdit.getBooleanProperty((String)"sidekick.persistentFilter") && SideKickTree.this.searchField.getText().length() > 0) {
                        SideKickTree.this.searchField.setText("");
                        SideKickTree.this.updateFilter(false);
                    }
                    SideKickTree.this.expandTreeAt((selection = (jEditTextArea = SideKickTree.this.view.getTextArea()).getSelectionAtOffset(n = jEditTextArea.getCaretPosition())) == null ? n : selection.getStart());
                }
            });
            this.caretTimer.setInitialDelay(500);
            this.caretTimer.setRepeats(false);
        }
        this.caretTimer.start();
    }

    protected void expandTreeAt(int n) {
        if (this.data == null) {
            return;
        }
        TreePath treePath = this.data.getTreePathForPosition(n);
        if (treePath != null) {
            this.tree.expandPath(treePath);
            this.tree.setSelectionPath(treePath);
            if (jEdit.getBooleanProperty((String)"sidekick.scrollToVisible")) {
                Rectangle rectangle = this.tree.getPathBounds(treePath);
                if (rectangle != null) {
                    rectangle.width = 1;
                    this.tree.scrollRectToVisible(rectangle);
                } else {
                    this.tree.scrollPathToVisible(treePath);
                }
            }
        }
    }

    protected void expandCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.tree.expandPath(treePath);
    }

    protected void collapseCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.tree.collapsePath(treePath);
    }

    protected void find_visible_nodes(HashSet<TreePath> hashSet, DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        if (this.tree.isVisible(treePath) && this.tree.isExpanded(treePath)) {
            hashSet.add(new TreePath(defaultMutableTreeNode.getPath()));
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.find_visible_nodes(hashSet, (DefaultMutableTreeNode)enumeration.nextElement());
            }
        }
    }

    protected void filter_visible_nodes(FilteredTreeModel filteredTreeModel, HashSet<TreePath> hashSet, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!jEdit.getBooleanProperty((String)"sidekick.showFilter")) {
            return;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        if (!hashSet.contains(treePath)) {
            return;
        }
        this.tree.expandPath(treePath);
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            this.filter_visible_nodes(filteredTreeModel, hashSet, (DefaultMutableTreeNode)enumeration.nextElement());
        }
    }

    public void updateFilter(boolean bl) {
        if (!jEdit.getBooleanProperty((String)"sidekick.showFilter")) {
            return;
        }
        FilteredTreeModel filteredTreeModel = (FilteredTreeModel)this.tree.getModel();
        if (this.searchField.getText().length() == 0) {
            filteredTreeModel.clearFilter();
            filteredTreeModel.reset();
            if (this.autoExpandTree == -1) {
                this.expandAll(true);
            } else if (this.autoExpandTree == 0) {
                this.expandAll(false);
            } else if (this.autoExpandTree > 0) {
                this.tree.expandRow(0);
                for (int i = 1; i < this.autoExpandTree; ++i) {
                    for (int j = this.tree.getRowCount() - 1; j > 0; --j) {
                        this.tree.expandRow(j);
                    }
                }
            }
            if (SideKick.isFollowCaret() && bl) {
                this.expandTreeWithDelay();
            }
        } else {
            HashSet<TreePath> hashSet = new HashSet<TreePath>();
            this.find_visible_nodes(hashSet, (DefaultMutableTreeNode)filteredTreeModel.getRoot());
            filteredTreeModel.filterByText(this.searchField.getText());
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)filteredTreeModel.getRoot();
            if (jEdit.getBooleanProperty((String)"sidekick.filter-visible-assets")) {
                this.filter_visible_nodes(filteredTreeModel, hashSet, defaultMutableTreeNode);
            } else {
                this.expandAll(true);
            }
        }
    }

    public void updateFilter() {
        this.updateFilter(true);
    }

    public void setSearchFilter(String string) {
        this.searchField.setText(string);
        this.updateFilter();
    }

    public String getSearchFilter() {
        return this.searchField.getText();
    }

    class Renderer
    extends EnhancedTreeCellRenderer {
        Renderer() {
        }

        protected void configureTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof IAsset) {
                IAsset iAsset = (IAsset)defaultMutableTreeNode.getUserObject();
                this.setText(iAsset.getShortString());
                this.setIcon(iAsset.getIcon());
            } else if (defaultMutableTreeNode.getParent() == null) {
                this.setIcon(FileCellRenderer.fileIcon);
            } else {
                this.setIcon(null);
            }
        }

        protected TreeCellRenderer newInstance() {
            return new Renderer();
        }
    }

    class SideKickProperties
    implements ActionListener {
        SideKickProperties() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                new ModeOptionsDialog(SideKickTree.this.view);
            }
            catch (Exception exception) {
                Log.log((int)9, (Object)this, (Object)"dialog create failed", (Throwable)exception);
            }
        }
    }

    class MouseHandler
    extends MouseMotionAdapter {
        MouseHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            TreePath treePath = SideKickTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                SideKickTree.this.view.getStatus().setMessage(null);
            } else {
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (object instanceof IAsset) {
                    String string = ((IAsset)object).getShortString();
                    SideKickTree.this.view.getStatus().setMessage(string);
                }
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        protected void next() {
            Serializable serializable;
            Serializable serializable2 = (DefaultMutableTreeNode)SideKickTree.this.tree.getLastSelectedPathComponent();
            FilteredTreeModel filteredTreeModel = (FilteredTreeModel)SideKickTree.this.tree.getModel();
            if (serializable2 == null) {
                serializable2 = (DefaultMutableTreeNode)filteredTreeModel.getRoot();
            }
            if (serializable2.getChildCount() > 0) {
                serializable = (DefaultMutableTreeNode)serializable2.getFirstChild();
                TreePath treePath = new TreePath(((DefaultMutableTreeNode)serializable).getPath());
                serializable2 = SideKickTree.this.tree.isVisible(treePath) ? serializable : serializable2.getNextSibling();
            } else {
                serializable = serializable2.getNextSibling();
                if (serializable == null) {
                    serializable = ((DefaultMutableTreeNode)serializable2.getParent()).getNextSibling();
                }
                serializable2 = serializable;
            }
            if (serializable2 != null) {
                serializable = new TreePath(serializable2.getPath());
                SideKickTree.this.selectPath((TreePath)serializable);
            }
        }

        protected void nextLeaf() {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SideKickTree.this.tree.getLastSelectedPathComponent();
            FilteredTreeModel filteredTreeModel = (FilteredTreeModel)SideKickTree.this.tree.getModel();
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)filteredTreeModel.getRoot();
            }
            if (filteredTreeModel.isLeaf(defaultMutableTreeNode)) {
                defaultMutableTreeNode = defaultMutableTreeNode.getNextLeaf();
            } else {
                object = defaultMutableTreeNode.depthFirstEnumeration();
                defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
            }
            if (defaultMutableTreeNode != null) {
                while (!(defaultMutableTreeNode == null || filteredTreeModel.isVisible(defaultMutableTreeNode) && SideKickTree.this.tree.isVisible(new TreePath(defaultMutableTreeNode.getPath())))) {
                    defaultMutableTreeNode = defaultMutableTreeNode.getNextLeaf();
                }
                if (defaultMutableTreeNode != null) {
                    object = new TreePath(defaultMutableTreeNode.getPath());
                    SideKickTree.this.selectPath((TreePath)object);
                }
            }
        }

        protected void prev() {
            Serializable serializable;
            TreePath treePath;
            DefaultMutableTreeNode defaultMutableTreeNode;
            Serializable serializable2 = (DefaultMutableTreeNode)SideKickTree.this.tree.getLastSelectedPathComponent();
            FilteredTreeModel filteredTreeModel = (FilteredTreeModel)SideKickTree.this.tree.getModel();
            if (serializable2 == null) {
                serializable2 = (DefaultMutableTreeNode)filteredTreeModel.getRoot();
            }
            serializable2 = (defaultMutableTreeNode = serializable2.getPreviousSibling()) == null ? (DefaultMutableTreeNode)serializable2.getParent() : (defaultMutableTreeNode.getChildCount() > 0 ? (SideKickTree.this.tree.isVisible(treePath = new TreePath(((DefaultMutableTreeNode)(serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild())).getPath())) ? serializable : defaultMutableTreeNode) : defaultMutableTreeNode);
            if (serializable2 != null) {
                serializable = new TreePath(serializable2.getPath());
                SideKickTree.this.selectPath((TreePath)serializable);
            }
        }

        protected void prevLeaf() {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SideKickTree.this.tree.getLastSelectedPathComponent();
            FilteredTreeModel filteredTreeModel = (FilteredTreeModel)SideKickTree.this.tree.getModel();
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)filteredTreeModel.getRoot();
            }
            if (!filteredTreeModel.isLeaf(defaultMutableTreeNode)) {
                object = defaultMutableTreeNode.depthFirstEnumeration();
                defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
            }
            if ((defaultMutableTreeNode = defaultMutableTreeNode.getPreviousLeaf()) != null) {
                while (!(defaultMutableTreeNode == null || filteredTreeModel.isVisible(defaultMutableTreeNode) && SideKickTree.this.tree.isVisible(new TreePath(defaultMutableTreeNode.getPath())))) {
                    defaultMutableTreeNode = defaultMutableTreeNode.getPreviousLeaf();
                }
                if (defaultMutableTreeNode != null) {
                    object = new TreePath(defaultMutableTreeNode.getPath());
                    SideKickTree.this.selectPath((TreePath)object);
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (SideKickTree.this.caretTimer != null) {
                SideKickTree.this.caretTimer.stop();
            }
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    keyEvent.consume();
                    if (SideKickTree.this.searchField.getText().length() == 0) {
                        SideKickTree.this.view.getDockableWindowManager().hideDockableWindow("sidekick-tree");
                        break;
                    }
                    SideKickTree.this.searchField.setText("");
                    SideKickTree.this.updateFilter();
                    break;
                }
                case 10: {
                    Object object;
                    keyEvent.consume();
                    TreePath treePath = SideKickTree.this.tree.getSelectionPath();
                    if (treePath == null || !((object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof IAsset)) break;
                    IAsset iAsset = (IAsset)object;
                    JEditTextArea jEditTextArea = SideKickTree.this.view.getTextArea();
                    if (keyEvent.isShiftDown()) {
                        jEditTextArea.setCaretPosition(iAsset.getEnd().getOffset());
                        jEditTextArea.addToSelection((Selection)new Selection.Range(iAsset.getStart().getOffset(), iAsset.getEnd().getOffset() + 1));
                        break;
                    }
                    if (!jEdit.getBooleanProperty((String)"sidekick.persistentFilter") && SideKickTree.this.searchField.getText().length() > 0) {
                        SideKickTree.this.searchField.setText("");
                        SideKickTree.this.updateFilter();
                    }
                    jEditTextArea.setCaretPosition(iAsset.getStart().getOffset());
                    SideKickTree.this.selectPath(treePath);
                    jEditTextArea.requestFocus();
                    break;
                }
                case 8: {
                    keyEvent.consume();
                    if (SideKickTree.this.searchField.getText().length() <= 1) {
                        SideKickTree.this.searchField.setText("");
                    } else {
                        String string = SideKickTree.this.searchField.getText();
                        string = string.substring(0, string.length() - 1);
                        SideKickTree.this.searchField.setText(string);
                    }
                    SideKickTree.this.updateFilter();
                    break;
                }
                case 40: {
                    keyEvent.consume();
                    if (keyEvent.isControlDown()) {
                        this.nextLeaf();
                        break;
                    }
                    this.next();
                    break;
                }
                case 38: {
                    keyEvent.consume();
                    if (keyEvent.isControlDown()) {
                        this.prevLeaf();
                        break;
                    }
                    this.prev();
                    break;
                }
                case 37: {
                    SideKickTree.this.collapseCurrentNode();
                    break;
                }
                case 39: {
                    SideKickTree.this.expandCurrentNode();
                    break;
                }
                case 33: {
                    keyEvent.consume();
                    int n = SideKickTree.this.tree.getScrollableUnitIncrement(SideKickTree.this.tree.getParent().getBounds(), 1, 0);
                    for (int i = 0; i < n; ++i) {
                        if (keyEvent.isControlDown()) {
                            this.prevLeaf();
                            continue;
                        }
                        this.prev();
                    }
                    break;
                }
                case 34: {
                    keyEvent.consume();
                    int n = SideKickTree.this.tree.getScrollableUnitIncrement(SideKickTree.this.tree.getParent().getBounds(), 1, 0);
                    for (int i = 0; i < n; ++i) {
                        if (keyEvent.isControlDown()) {
                            this.nextLeaf();
                            continue;
                        }
                        this.next();
                    }
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            Character c = Character.valueOf(keyEvent.getKeyChar());
            if (Character.isLetterOrDigit(c.charValue()) || " _!@$%^&*()_+-=[]{};':\",.<>/?\\|".indexOf(c.charValue()) != -1) {
                keyEvent.consume();
                SideKickTree.this.searchField.setText(SideKickTree.this.searchField.getText() + c);
                SideKickTree.this.updateFilter();
            }
        }
    }

    class CaretHandler
    implements CaretListener {
        CaretHandler() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (!SideKickTree.this.view.getBuffer().equals(SideKickTree.this.lastParsedBuffer)) {
                return;
            }
            if (caretEvent.getSource() == SideKickTree.this.view.getTextArea() && SideKick.isFollowCaret()) {
                SideKickTree.this.expandTreeWithDelay();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        int level = 0;

        ActionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            ActionHandler actionHandler = this;
            synchronized (actionHandler) {
                if (actionEvent.getSource() == SideKickTree.this.parseBtn) {
                    this.level = 0;
                }
                ++this.level;
                if (this.level > 1) {
                    --this.level;
                    return;
                }
            }
            actionHandler = SideKickTree.this.view.getBuffer();
            jEdit.setIntegerProperty((String)"sidekick.splitter.location", (int)SideKickTree.this.splitter.getDividerLocation());
            if (actionEvent.getSource() == SideKickTree.this.onSave) {
                SideKick.setParseOnSave(SideKickTree.this.onSave.isSelected());
                SideKickTree.this.propertiesChanged();
            }
            if (actionEvent.getSource() == SideKickTree.this.followCaret) {
                boolean bl = SideKickTree.this.followCaret.isSelected();
                SideKick.setGlobalFollowCaret(SideKickTree.this.followCaret.isSelected());
                if (bl) {
                    SideKickTree.this.onChange.setSelected(true);
                }
                SideKickTree.this.propertiesChanged();
            } else if (actionEvent.getSource() == SideKickTree.this.onChange) {
                boolean bl = SideKickTree.this.onChange.isSelected();
                SideKick.setParseOnChange(bl);
                if (!bl) {
                    SideKickTree.this.followCaret.setSelected(false);
                }
                SideKickTree.this.propertiesChanged();
            } else if (actionEvent.getSource() == SideKickTree.this.parserCombo) {
                Object object2 = SideKickTree.this.parserCombo.getSelectedItem();
                if (object2.toString().equals("None")) {
                    actionHandler.setProperty("usermode", Boolean.TRUE);
                    SideKickPlugin.setParserForBuffer((Buffer)actionHandler, object2.toString());
                } else if (object2.toString().equals("default parser")) {
                    actionHandler = SideKickTree.this.view.getBuffer();
                    actionHandler.setProperty("usermode", Boolean.FALSE);
                    object = actionHandler.getMode();
                    if (object == null) {
                        Log.log((int)9, (Object)this, (Object)("SideKick: can't determine mode of current buffer:" + actionHandler));
                    } else {
                        SideKickParser sideKickParser = SideKickPlugin.getParserForMode(object);
                        if (sideKickParser == null) {
                            SideKickPlugin.setParserForBuffer((Buffer)actionHandler, "None");
                        } else {
                            SideKickPlugin.setParserForBuffer((Buffer)actionHandler, sideKickParser.getName());
                        }
                    }
                } else {
                    SideKickPlugin.setParserForBuffer((Buffer)actionHandler, object2.toString());
                    actionHandler.setProperty("usermode", Boolean.TRUE);
                }
                SideKickTree.this.propertiesChanged();
            } else if (actionEvent.getSource() == SideKickTree.this.parseBtn && SideKickTree.this.stopIcon.equals(SideKickTree.this.parseBtn.getIcon())) {
                SideKickPlugin.stop(SideKickTree.this.view);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SideKickTree.this.parseBtn.setIcon(SideKickTree.this.parseIcon);
                        SideKickTree.this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parse"));
                    }
                });
            }
            if (actionEvent.getSource() == SideKickTree.this.parseBtn || actionEvent.getSource() == SideKickTree.this.parserCombo) {
                if (actionEvent.getSource() == SideKickTree.this.parseBtn) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SideKickTree.this.parseBtn.setIcon(SideKickTree.this.stopIcon);
                            SideKickTree.this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.stop-parsing"));
                        }
                    });
                }
                this.level = 0;
                Object object3 = actionHandler.getProperty("usermode");
                if (object3 == null || object3 == Boolean.FALSE) {
                    object = SideKickPlugin.getParserForBuffer((Buffer)actionHandler);
                    if (object == null) {
                        return;
                    }
                    SideKickTree.this.reloadParserCombo();
                }
                SideKickPlugin.parse(SideKickTree.this.view, true);
            }
            --this.level;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CustomTree
    extends JTree {
        protected CustomTree(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public Enumeration<TreePath> getExpandedDescendants(TreePath treePath) {
            return null;
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 501: {
                    TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                        if (object instanceof IAsset) {
                            IAsset iAsset = (IAsset)object;
                            JEditTextArea jEditTextArea = SideKickTree.this.view.getTextArea();
                            EditPane editPane = SideKickTree.this.view.getEditPane();
                            if (mouseEvent.getClickCount() == 2) {
                                this.doubleClicked(SideKickTree.this.view, iAsset, treePath);
                            } else if (mouseEvent.isShiftDown()) {
                                this.shiftClick(SideKickTree.this.view, iAsset, treePath);
                            } else if (mouseEvent.isControlDown()) {
                                this.controlClick(SideKickTree.this.view, iAsset, treePath);
                            } else {
                                EditBus.send((EBMessage)new PositionChanging(editPane));
                                jEditTextArea.setCaretPosition(iAsset.getStart().getOffset());
                            }
                        }
                        if (!jEdit.getBooleanProperty((String)"sidekick.persistentFilter") && SideKickTree.this.searchField.getText().length() > 0) {
                            SideKickTree.this.searchField.setText("");
                            SideKickTree.this.updateFilter(false);
                        }
                    }
                    super.processMouseEvent(mouseEvent);
                    SideKickTree.this.searchField.requestFocusInWindow();
                    if (treePath == null) break;
                    SideKickTree.this.selectPath(treePath);
                    break;
                }
                case 505: {
                    SideKickTree.this.view.getStatus().setMessage(null);
                    super.processMouseEvent(mouseEvent);
                    break;
                }
                default: {
                    super.processMouseEvent(mouseEvent);
                }
            }
        }

        protected void doubleClicked(View view, IAsset iAsset, TreePath treePath) {
        }

        protected void shiftClick(View view, IAsset iAsset, TreePath treePath) {
            JEditTextArea jEditTextArea = view.getTextArea();
            jEditTextArea.setCaretPosition(iAsset.getEnd().getOffset());
            Selection.Range range = new Selection.Range(iAsset.getStart().getOffset(), iAsset.getEnd().getOffset());
            jEditTextArea.addToSelection((Selection)range);
        }

        protected void controlClick(View view, IAsset iAsset, TreePath treePath) {
            JEditTextArea jEditTextArea = view.getTextArea();
            jEditTextArea.getDisplayManager().narrow(jEditTextArea.getLineOfOffset(iAsset.getStart().getOffset()), jEditTextArea.getLineOfOffset(iAsset.getEnd().getOffset()));
        }
    }
}

