/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser;

import common.gui.itemfinder.ItemFinder;
import common.gui.itemfinder.ItemFinderWindow;
import gatchan.phpparser.methodlist.PHPFunctionList;
import gatchan.phpparser.project.ProjectManager;
import gatchan.phpparser.project.itemfinder.PHPItem;
import gatchan.phpparser.project.itemfinder.PHPItemFinder;
import java.awt.Component;
import net.sourceforge.phpdt.internal.compiler.ast.AstNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.PHPDocument;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class PHPParserPlugin
extends EditPlugin {
    private ProjectManager projectManager;
    private static ItemFinderWindow<PHPItem> itemFinderWindow;
    private static PHPItemFinder itemFinder;
    public static PHPFunctionList phpFunctionList;

    public void start() {
        this.projectManager = ProjectManager.getInstance();
        itemFinder = new PHPItemFinder();
        itemFinderWindow = new ItemFinderWindow((ItemFinder)itemFinder);
        phpFunctionList = new PHPFunctionList();
        phpFunctionList.reload();
    }

    public void stop() {
        Buffer[] bufferArray;
        phpFunctionList = null;
        this.projectManager.dispose();
        this.projectManager = null;
        itemFinderWindow.dispose();
        itemFinderWindow = null;
        itemFinder = null;
        for (Buffer buffer : bufferArray = jEdit.getBuffers()) {
            buffer.unsetProperty("PHPDocument");
        }
    }

    public static void findClass(View view) {
        PHPParserPlugin.findItem(view, 1, 0);
    }

    public static void findInterface(View view) {
        PHPParserPlugin.findItem(view, 8, 0);
    }

    public static void findClassOrInterface(View view) {
        PHPParserPlugin.findItem(view, 9, 0);
    }

    public static void findMethod(View view) {
        PHPParserPlugin.findItem(view, 2, 0);
    }

    public static void findInFile(View view) {
        PHPParserPlugin.findItem(view, 15, 1);
    }

    private static void findItem(View view, int n, int n2) {
        itemFinder.init(view, n, n2);
        itemFinderWindow.setLocationRelativeTo((Component)jEdit.getActiveView());
        itemFinderWindow.setVisible(true);
    }

    public static void debugAtCaret(TextArea textArea, Buffer buffer) {
        int n;
        int n2;
        PHPDocument pHPDocument = (PHPDocument)buffer.getProperty((Object)"PHPDocument");
        if (pHPDocument == null) {
            return;
        }
        int n3 = textArea.getCaretPosition();
        int n4 = textArea.getCaretLine();
        AstNode astNode = pHPDocument.getNodeAt(n4 + 1, n2 = n3 - (n = textArea.getLineStartOffset(n4)));
        if (astNode == null) {
            return;
        }
        Log.log((int)1, PHPParserPlugin.class, (Object)"----------------------------------------------------");
        Log.log((int)1, PHPParserPlugin.class, (Object)astNode);
        for (AstNode astNode2 = astNode.subNodeAt(n4 + 1, n2); astNode2 != null; astNode2 = astNode2.subNodeAt(n4 + 1, n2)) {
            if (astNode2 instanceof Expression) {
                Expression expression = (Expression)astNode2;
                Log.log((int)1, PHPParserPlugin.class, (Object)(expression + " | " + expression.getType()));
                continue;
            }
            Log.log((int)1, PHPParserPlugin.class, (Object)astNode2);
        }
        Log.log((int)1, PHPParserPlugin.class, (Object)"----------------------------------------------------");
    }

    public static void reloadFunctionList() {
        phpFunctionList.reload();
    }
}

