/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.methodlist;

import gatchan.phpparser.methodlist.Argument;
import net.sourceforge.phpdt.internal.compiler.ast.Type;

public class Function {
    private final Type returnType;
    private final String name;
    private final Argument[] arguments;
    private boolean varargs;
    private int minArgumentCount;
    private Function alternative;

    public Function(String string, String string2, Argument[] argumentArray) {
        this.returnType = Type.fromString(string);
        this.name = string2;
        this.arguments = argumentArray;
        for (int i = 0; i < argumentArray.length; ++i) {
            Argument argument = argumentArray[i];
            if (!argument.isOptional()) {
                this.minArgumentCount = i + 1;
            }
            if (!argument.isVarargs()) continue;
            this.varargs = true;
        }
    }

    public Function getAlternative() {
        return this.alternative;
    }

    public void setAlternative(Function function) {
        if (this.alternative != null) {
            this.alternative.setAlternative(function);
        } else {
            this.alternative = function;
        }
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public Argument getArgument(int n) {
        if (n >= this.arguments.length) {
            return null;
        }
        return this.arguments[n];
    }

    public int getArgumentCount() {
        return this.arguments.length;
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public Argument getVarargs() {
        if (this.varargs) {
            return this.arguments[this.arguments.length - 1];
        }
        return null;
    }

    public int getMinArgumentCount() {
        return this.minArgumentCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.returnType).append(' ');
        stringBuilder.append(this.name).append('(');
        for (int i = 0; i < this.arguments.length; ++i) {
            Argument argument = this.arguments[i];
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(argument);
        }
        if (this.varargs) {
            stringBuilder.append("...");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

