/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.project;

import gatchan.phpparser.project.InvalidProjectPropertiesException;
import gatchan.phpparser.project.PHPProjectChangedMessage;
import gatchan.phpparser.project.ProjectManager;
import gatchan.phpparser.project.itemfinder.PHPItem;
import gatchan.phpparser.project.itemfinder.QuickAccessItemFinder;
import gatchan.phpparser.sidekick.PHPSideKickParser;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.phpdt.internal.compiler.ast.ClassHeader;
import net.sourceforge.phpdt.internal.compiler.ast.InterfaceDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.MethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.MethodHeader;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private final File file;
    private boolean needSave;
    private File dataDirectory;
    private File classFile;
    private File interfaceFile;
    private File methodFile;
    private File fileFile;
    private final Properties properties;
    private Map<String, Object> classes;
    private Map<String, Object> interfaces;
    private Map<String, Object> methods;
    private Map<String, List<PHPItem>> files;
    private QuickAccessItemFinder quickAccess;
    private List<String> excludedFolders;
    private volatile boolean loading;
    private volatile boolean cancelLoading;
    private final Object LOCK;
    private Exception exceptionDuringLoading;

    public Project(String string, String string2) {
        this.properties = new Properties();
        this.LOCK = new Object();
        this.properties.setProperty("name", string);
        this.properties.setProperty("version", string2);
        this.reset();
        this.file = Project.getValidFileName(ProjectManager.projectDirectory + File.separator + string);
        this.init();
        this.needSave = true;
    }

    /*
     * Exception decompiling
     */
    public Project(File var1_1) throws FileNotFoundException, InvalidProjectPropertiesException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void reset() {
        this.classes = Collections.synchronizedMap(new HashMap());
        this.interfaces = Collections.synchronizedMap(new HashMap());
        this.methods = Collections.synchronizedMap(new HashMap());
        this.files = Collections.synchronizedMap(new HashMap());
        this.quickAccess = new QuickAccessItemFinder();
    }

    private void init() {
        this.dataDirectory = new File(this.file.getParent(), this.file.getName().substring(0, this.file.getName().length() - 14) + "_datas");
        this.dataDirectory.mkdir();
        this.classFile = new File(this.dataDirectory, "classes.ser");
        this.methodFile = new File(this.dataDirectory, "methods.ser");
        this.fileFile = new File(this.dataDirectory, "files.ser");
        this.interfaceFile = new File(this.dataDirectory, "interfaces.ser");
        this.excludedFolders = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(final ProgressObserver progressObserver) {
        if (this.loading) {
            Log.log((int)9, (Object)this, (Object)"Already loading");
            return;
        }
        long l = System.currentTimeMillis();
        Object object = this.LOCK;
        synchronized (object) {
            progressObserver.setStatus("Loading project");
            try {
                this.loading = true;
                final CountDownLatch countDownLatch = new CountDownLatch(5);
                Task task = new Task(){

                    public void _run() {
                        try {
                            Object object;
                            this.setStatus("Loading properties");
                            String string = Project.this.properties.getProperty("excluded");
                            if (string != null) {
                                object = new StringTokenizer(string, "\n");
                                while (((StringTokenizer)object).hasMoreTokens()) {
                                    Project.this.excludedFolders.add(((StringTokenizer)object).nextToken());
                                }
                            }
                            if (!((String)(object = Project.this.properties.getProperty("version"))).equals(ProjectManager.projectVersion)) {
                                Project.this.properties.setProperty("version", ProjectManager.projectVersion);
                                Log.log((int)7, (Object)((Object)this), (Object)"The project version is obsolete, it cannot be loaded. You should refresh your project");
                                Project.this.reset();
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                            progressObserver.setValue(countDownLatch.getCount());
                        }
                    }
                };
                Task task2 = new Task(){

                    public void _run() {
                        try {
                            Project.this.loadClasses((ProgressObserver)this);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Project.this.exceptionDuringLoading = classNotFoundException;
                        }
                        catch (IOException iOException) {
                            Project.this.exceptionDuringLoading = iOException;
                        }
                        finally {
                            countDownLatch.countDown();
                            progressObserver.setValue(countDownLatch.getCount());
                        }
                    }
                };
                Task task3 = new Task(){

                    public void _run() {
                        try {
                            Project.this.loadInterfaces((ProgressObserver)this);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Project.this.exceptionDuringLoading = classNotFoundException;
                        }
                        catch (IOException iOException) {
                            Project.this.exceptionDuringLoading = iOException;
                        }
                        finally {
                            countDownLatch.countDown();
                            progressObserver.setValue(countDownLatch.getCount());
                        }
                    }
                };
                Task task4 = new Task(){

                    public void _run() {
                        try {
                            Project.this.loadMethods((ProgressObserver)this);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Project.this.exceptionDuringLoading = classNotFoundException;
                        }
                        catch (IOException iOException) {
                            Project.this.exceptionDuringLoading = iOException;
                        }
                        finally {
                            countDownLatch.countDown();
                            progressObserver.setValue(countDownLatch.getCount());
                        }
                    }
                };
                Task task5 = new Task(){

                    public void _run() {
                        try {
                            this.setStatus("Loading files");
                            Project.this.files = Collections.synchronizedMap(Project.readObjects(Project.this.fileFile));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Project.this.exceptionDuringLoading = classNotFoundException;
                        }
                        catch (IOException iOException) {
                            Project.this.exceptionDuringLoading = iOException;
                        }
                        finally {
                            countDownLatch.countDown();
                            progressObserver.setValue(countDownLatch.getCount());
                        }
                    }
                };
                ThreadUtilities.runInBackground((Task)task2);
                ThreadUtilities.runInBackground((Task)task3);
                ThreadUtilities.runInBackground((Task)task4);
                ThreadUtilities.runInBackground((Task)task);
                ThreadUtilities.runInBackground((Task)task5);
                countDownLatch.await();
                if (this.exceptionDuringLoading != null) {
                    throw this.exceptionDuringLoading;
                }
            }
            catch (Exception exception) {
                Log.log((int)9, (Object)this, (Object)exception);
                GUIUtilities.error((Component)jEdit.getActiveView(), (String)"gatchan-phpparser.errordialog.unabletoreadproject", (Object[])new String[]{exception.getMessage()});
                this.reset();
            }
            finally {
                this.loading = false;
                this.cancelLoading = false;
                this.exceptionDuringLoading = null;
            }
            long l2 = System.currentTimeMillis();
            Log.log((int)1, (Object)this, (Object)("Project loaded in " + (l2 - l) + "ms"));
        }
    }

    private boolean loadMethods(ProgressObserver progressObserver) throws ClassNotFoundException, IOException {
        progressObserver.setStatus("Loading interfaces");
        this.methods = Collections.synchronizedMap(Project.readObjects(this.methodFile));
        if (this.cancelLoading) {
            return true;
        }
        Collection<Object> collection = this.methods.values();
        Iterator<Object> iterator = collection.iterator();
        progressObserver.setMaximum((long)this.methods.size());
        int n = 0;
        while (iterator.hasNext()) {
            progressObserver.setValue((long)(++n));
            if (this.cancelLoading) {
                return true;
            }
            Object object = iterator.next();
            if (object instanceof MethodHeader) {
                this.quickAccess.addToIndex((PHPItem)object);
                continue;
            }
            Iterable iterable = (Iterable)object;
            for (PHPItem pHPItem : iterable) {
                this.quickAccess.addToIndex(pHPItem);
            }
        }
        return false;
    }

    private boolean loadInterfaces(ProgressObserver progressObserver) throws ClassNotFoundException, IOException {
        progressObserver.setStatus("Loading interfaces");
        this.interfaces = Collections.synchronizedMap(Project.readObjects(this.interfaceFile));
        if (this.cancelLoading) {
            return true;
        }
        Collection<Object> collection = this.interfaces.values();
        Iterator<Object> iterator = collection.iterator();
        progressObserver.setMaximum((long)this.interfaces.size());
        int n = 0;
        while (iterator.hasNext()) {
            progressObserver.setValue((long)(++n));
            if (this.cancelLoading) {
                return true;
            }
            Object object = iterator.next();
            if (object instanceof InterfaceDeclaration) {
                this.loadInterface((InterfaceDeclaration)object);
                continue;
            }
            Iterable iterable = (Iterable)object;
            for (InterfaceDeclaration interfaceDeclaration : iterable) {
                this.loadInterface(interfaceDeclaration);
            }
        }
        return false;
    }

    private boolean loadClasses(ProgressObserver progressObserver) throws ClassNotFoundException, IOException {
        progressObserver.setStatus("Loading classes");
        this.classes = Collections.synchronizedMap(Project.readObjects(this.classFile));
        if (this.cancelLoading) {
            return true;
        }
        Collection<Object> collection = this.classes.values();
        Iterator<Object> iterator = collection.iterator();
        progressObserver.setMaximum((long)this.classes.size());
        int n = 0;
        while (iterator.hasNext()) {
            progressObserver.setValue((long)(++n));
            if (this.cancelLoading) {
                return true;
            }
            Object object = iterator.next();
            if (object instanceof ClassHeader) {
                this.loadClassHeader((ClassHeader)object);
                continue;
            }
            Iterable iterable = (Iterable)object;
            for (ClassHeader classHeader : iterable) {
                this.loadClassHeader(classHeader);
            }
        }
        return false;
    }

    private void loadInterface(InterfaceDeclaration interfaceDeclaration) {
        this.quickAccess.addToIndex(interfaceDeclaration);
        for (int i = 0; i < interfaceDeclaration.size(); ++i) {
            this.quickAccess.addToIndex(((MethodDeclaration)interfaceDeclaration.get(i)).getMethodHeader());
        }
    }

    private void loadClassHeader(ClassHeader classHeader) {
        this.quickAccess.addToIndex(classHeader);
        List<MethodHeader> list = classHeader.getMethodsHeaders();
        for (MethodHeader methodHeader : list) {
            this.quickAccess.addToIndex(methodHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        if (this.loading) {
            this.cancelLoading = true;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.classes = null;
            this.interfaces = null;
            this.methods = null;
            this.files = null;
            this.excludedFolders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map readObjects(File file) throws ClassNotFoundException, IOException {
        HashMap hashMap;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object object = objectInputStream.readObject();
            Map map = (Map)object;
            HashMap hashMap2 = new HashMap(map.size());
            hashMap2.putAll(map);
            hashMap = hashMap2;
        }
        catch (Throwable throwable) {
            IOUtilities.closeQuietly(objectInputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly((Closeable)objectInputStream);
        return hashMap;
    }

    private static File getValidFileName(String string) {
        File file = new File(string + ".project.props");
        while (file.exists()) {
            file = new File(file.getAbsolutePath() + ".project.props");
        }
        return file;
    }

    private void checkProperties() throws InvalidProjectPropertiesException {
        if (this.properties.getProperty("name") == null) {
            throw new InvalidProjectPropertiesException("Missing project name");
        }
        if (this.properties.getProperty("version") == null) {
            throw new InvalidProjectPropertiesException("Missing project version");
        }
    }

    public void setRoot(String string) {
        this.properties.setProperty("root", string);
    }

    public File getFile() {
        return this.file;
    }

    public String getRoot() {
        return this.properties.getProperty("root");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void save() {
        Object object2;
        long l = System.currentTimeMillis();
        Log.log((int)1, (Object)this, (Object)"Saving the project");
        File file = this.classFile.getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        StringBuilder stringBuilder = new StringBuilder(1000);
        for (Object object2 : this.excludedFolders) {
            stringBuilder.append((String)object2).append('\n');
        }
        this.properties.setProperty("excluded", stringBuilder.toString());
        Object object3 = null;
        object2 = this.LOCK;
        synchronized (object2) {
            block12: {
                try {
                    object3 = new BufferedOutputStream(new FileOutputStream(this.file));
                    this.properties.store((OutputStream)object3, "");
                    Project.writeObjects(this.classFile, this.classes);
                    Project.writeObjects(this.interfaceFile, this.interfaces);
                    Project.writeObjects(this.methodFile, this.methods);
                    Project.writeObjects(this.fileFile, this.files);
                    IOUtilities.closeQuietly((Closeable)object3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.log((int)9, (Object)this, (Object)fileNotFoundException);
                }
                catch (IOException iOException) {
                    Log.log((int)9, (Object)this, (Object)iOException);
                    break block12;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtilities.closeQuietly(object3);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        Log.log((int)1, (Object)this, (Object)("Project saved in " + (l2 - l) + "ms"));
    }

    private static void writeObjects(File file, Object object) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(object);
        }
        catch (Throwable throwable) {
            IOUtilities.closeQuietly(objectOutputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly((Closeable)objectOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(ClassHeader classHeader) {
        Object object = this.LOCK;
        synchronized (object) {
            this.needSave = true;
            if (!this.classes.containsValue(classHeader)) {
                this.insertItem(this.classes, classHeader);
                List<MethodHeader> list = classHeader.getMethodsHeaders();
                for (MethodHeader methodHeader : list) {
                    this.quickAccess.addToIndex(methodHeader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterface(InterfaceDeclaration interfaceDeclaration) {
        Object object = this.LOCK;
        synchronized (object) {
            this.needSave = true;
            if (!this.interfaces.containsValue(interfaceDeclaration)) {
                this.insertItem(this.interfaces, interfaceDeclaration);
                for (int i = 0; i < interfaceDeclaration.size(); ++i) {
                    this.quickAccess.addToIndex(((MethodDeclaration)interfaceDeclaration.get(i)).getMethodHeader());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(PHPItem pHPItem) {
        Object object = this.LOCK;
        synchronized (object) {
            this.needSave = true;
            this.insertItem(this.methods, pHPItem);
        }
    }

    public boolean needSave() {
        return this.needSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Log.log((int)1, (Object)this, (Object)"delete");
        if (this.loading) {
            this.cancelLoading = true;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.file.delete();
            this.classFile.delete();
            this.methodFile.delete();
            this.dataDirectory.delete();
        }
    }

    public boolean acceptFile(String string) {
        String string2 = this.getRoot();
        return string2 != null && string.substring(1).startsWith(string2.substring(1)) && !this.isExcluded(string);
    }

    public boolean isExcluded(String string) {
        for (String string2 : this.excludedFolders) {
            if (!string.substring(1).startsWith(string2.substring(1))) continue;
            return true;
        }
        return false;
    }

    public Object[] getExcludedFolders() {
        return this.excludedFolders.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildProject() {
        if (this.loading) {
            this.cancelLoading = true;
        }
        Object object = this.LOCK;
        synchronized (object) {
            String string = this.getRoot();
            if (string == null || string.length() == 0) {
                Log.log((int)3, (Object)this, (Object)"No root file for that project");
            } else {
                Log.log((int)3, (Object)this, (Object)"Rebuilding project");
                this.classes.clear();
                this.interfaces.clear();
                this.methods.clear();
                this.files.clear();
                this.quickAccess = new QuickAccessItemFinder();
                Rebuilder rebuilder = new Rebuilder(this, string);
                ThreadUtilities.runInBackground((Task)rebuilder);
            }
        }
    }

    public String getName() {
        return this.properties.getProperty("name");
    }

    public String toString() {
        return this.getName();
    }

    private void insertItem(Map<String, Object> map, PHPItem pHPItem) {
        Object object;
        this.quickAccess.addToIndex(pHPItem);
        Object object2 = map.get(pHPItem.getNameLowerCase());
        if (object2 == null) {
            map.put(pHPItem.getNameLowerCase(), pHPItem);
        } else if (object2 instanceof List) {
            ((Collection)object2).add(pHPItem);
        } else {
            object = new ArrayList<PHPItem>();
            object.add((PHPItem)object2);
            object.add(pHPItem);
            map.put(pHPItem.getNameLowerCase(), object);
        }
        object = pHPItem.getPath();
        List<PHPItem> list = this.files.get(object);
        if (list == null) {
            list = new ArrayList<PHPItem>();
            this.files.put((String)object, list);
        }
        list.add(pHPItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSourceFile(String string) {
        Object object = this.LOCK;
        synchronized (object) {
            List<PHPItem> list = this.files.get(string);
            if (list != null) {
                list.clear();
            }
            Project.clearSourceFileFromMap(string, this.classes);
            Project.clearSourceFileFromMap(string, this.methods);
            Project.clearSourceFileFromMap(string, this.interfaces);
            this.quickAccess.purgePath(string);
        }
    }

    private static void clearSourceFileFromMap(String string, Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry<String, Object> entry = iterator.next();
            String string2 = entry.getKey();
            Object object2 = entry.getValue();
            if (object2 instanceof PHPItem) {
                object = (PHPItem)object2;
                if (!string.equals(object.getPath())) continue;
                iterator.remove();
                continue;
            }
            object = (List)object2;
            ListIterator listIterator = object.listIterator();
            while (listIterator.hasNext()) {
                PHPItem pHPItem = (PHPItem)listIterator.next();
                if (!string.equals(pHPItem.getPath())) continue;
                listIterator.remove();
            }
            if (object.isEmpty()) {
                map.remove(string2);
                continue;
            }
            if (object.size() != 1) continue;
            map.put(string2, object.get(0));
        }
    }

    public Map<String, Object> getClasses() {
        return this.classes;
    }

    public Map<String, Object> getMethods() {
        return this.methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassHeader getClass(String string) {
        Object object = this.LOCK;
        synchronized (object) {
            Object object2 = this.classes.get(string.toLowerCase());
            if (object2 instanceof ClassHeader) {
                return (ClassHeader)object2;
            }
            if (object2 == null) {
                return null;
            }
            return (ClassHeader)((List)object2).get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceDeclaration getInterface(String string) {
        Object object = this.LOCK;
        synchronized (object) {
            Object object2 = this.interfaces.get(string.toLowerCase());
            if (object2 instanceof InterfaceDeclaration) {
                return (InterfaceDeclaration)object2;
            }
            if (object2 == null) {
                return null;
            }
            return (InterfaceDeclaration)((List)object2).get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.properties.getProperty("version");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClassCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.classes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMethodCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.methods.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.files.size();
        }
    }

    public QuickAccessItemFinder getQuickAccess() {
        return this.quickAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addExcludedFolder(String string) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.excludedFolders.contains(string)) {
                return false;
            }
            Log.log((int)1, (Object)this, (Object)("Excluding folder " + string));
            this.checkDatas(this.classes);
            this.checkDatas(this.interfaces);
            this.checkDatas(this.methods);
            return this.excludedFolders.add(string);
        }
    }

    private void checkDatas(Map<String, Object> map) {
        Collection<Object> collection = map.values();
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2 = iterator.next();
            if (object2 instanceof PHPItem) {
                object = (PHPItem)object2;
                if (!this.isExcluded(object.getPath())) continue;
                Log.log((int)1, (Object)this, (Object)(object.getName() + " excluded"));
                iterator.remove();
                continue;
            }
            object = (List)object2;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                PHPItem pHPItem = (PHPItem)iterator2.next();
                if (!this.isExcluded(pHPItem.getPath())) continue;
                Log.log((int)1, (Object)this, (Object)(pHPItem.getName() + " excluded"));
                iterator2.remove();
            }
            if (!object.isEmpty()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeExcludedFolder(String string) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.excludedFolders.remove(string);
        }
    }

    private class Rebuilder
    extends Task {
        private final String path;
        private long current;
        private int parsedFileCount;
        private final Project project;

        Rebuilder(Project project2, String string) {
            this.path = string;
            this.project = project2;
            this.setCancellable(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void _run() {
            long l = System.currentTimeMillis();
            VFS vFS = VFSManager.getVFSForPath((String)this.path);
            this.setStatus("Listing files");
            Object object = vFS.createVFSSession(this.path, null);
            Mode mode = jEdit.getMode((String)"php");
            String string = "*";
            if (mode != null && ((string = (String)mode.getProperty("filenameGlob")) == null || string.length() == 0)) {
                string = "*";
            }
            try {
                String[] stringArray = vFS._listDirectory(object, this.path, string, true, null);
                this.setStatus("Parsing");
                this.setMaximum(stringArray.length);
                PHPSideKickParser pHPSideKickParser = new PHPSideKickParser("rebuilder");
                for (String string2 : stringArray) {
                    if (!Project.this.isExcluded(string2)) {
                        this.parseFile(pHPSideKickParser, VFSManager.getVFSForPath((String)string2), string2, object);
                    }
                    this.setValue((int)(++this.current));
                }
            }
            catch (IOException iOException) {
                Log.log((int)7, (Object)((Object)this), (Object)iOException);
            }
            finally {
                try {
                    vFS._endVFSSession(object, (Component)jEdit.getActiveView());
                }
                catch (IOException iOException) {
                    Log.log((int)9, (Object)((Object)this), (Object)iOException);
                }
            }
            long l2 = System.currentTimeMillis();
            Log.log((int)3, (Object)((Object)this), (Object)("Project rebuild in " + (l2 - l) + "ms, " + this.parsedFileCount + " files parsed"));
            EditBus.send((EBMessage)new PHPProjectChangedMessage((Object)this, this.project, PHPProjectChangedMessage.SELECTED));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseFile(PHPSideKickParser pHPSideKickParser, VFS vFS, String string, Object object) {
            BufferedReader bufferedReader = null;
            try {
                try {
                    InputStream inputStream = vFS._createInputStream(object, string, false, null);
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    ++this.parsedFileCount;
                    try {
                        pHPSideKickParser.parse(string, bufferedReader);
                    }
                    catch (Exception exception) {
                        Log.log((int)9, (Object)((Object)this), (Object)("Error while parsing file " + string));
                        Log.log((int)9, (Object)((Object)this), (Object)exception);
                    }
                }
                catch (IOException iOException) {
                    Log.log((int)7, (Object)((Object)this), (Object)iOException.getMessage());
                }
            }
            finally {
                IOUtilities.closeQuietly(bufferedReader);
            }
        }
    }
}

