/*
 * Decompiled with CFR 0.152.
 */
package gatchan.phpparser.project;

import gatchan.phpparser.project.InvalidProjectPropertiesException;
import gatchan.phpparser.project.Project;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class ProjectList
extends AbstractListModel
implements MutableComboBoxModel {
    private final List objects;
    private Object selectedObject;

    ProjectList(List list) {
        this.objects = list;
    }

    public Project getProject(File file) throws FileNotFoundException, InvalidProjectPropertiesException {
        for (int i = 0; i < this.objects.size(); ++i) {
            Project project = (Project)this.objects.get(i);
            if (!project.getFile().equals(file)) continue;
            return project;
        }
        return new Project(file);
    }

    public void setSelectedItem(Object object) {
        if (this.selectedObject != null && !this.selectedObject.equals(object) || this.selectedObject == null && object != null) {
            this.selectedObject = object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public int getSize() {
        return this.objects.size();
    }

    public Object getElementAt(int n) {
        if (n >= 0 && n < this.objects.size()) {
            return this.objects.get(n);
        }
        return null;
    }

    public void addElement(Object object) {
        if (!this.objects.contains(object)) {
            this.objects.add(object);
            this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
            if (this.objects.size() == 1 && this.selectedObject == null && object != null) {
                this.setSelectedItem(object);
            }
        }
    }

    public void insertElementAt(Object object, int n) {
        this.objects.add(n, object);
        this.fireIntervalAdded(this, n, n);
    }

    public void removeElementAt(int n) {
        if (this.getElementAt(n) == this.selectedObject) {
            if (n == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(n + 1));
            } else {
                this.setSelectedItem(this.getElementAt(n - 1));
            }
        }
        this.objects.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void removeElement(Object object) {
        int n = this.objects.indexOf(object);
        if (n != -1) {
            this.removeElementAt(n);
        }
    }
}

